//////////////////////////////////////////////////////////////////////////////////////////////////////////
//
//Petroglyph Confidential Source Code -- Do Not Distribute
//
// (Auto generated by PGSLCodeGenerator)
//Platform: MAX
//////////////////////////////////////////////////////////////////////////////////////////////////////////
#define PGSL_MAX
#define PGSL_DX9
#include"..\common\PGSLAlways.pgh"
#include"..\common\AlamoEngine.pgh"

float g_ShaderFileDummyVariable : SHADER_FILE_ANNOTATION
<
string _ALAMO_RENDER_PHASE = "OpaqueAlphaTest";
string _ALAMO_VERTEX_PROC = "Tree";
string _ALAMO_VERTEX_TYPE = "alD3dVertNU2U3U3C";
bool _ALAMO_TANGENT_SPACE = true;
bool _ALAMO_SHADOW_VOLUME = false;
>;

#define PGSL_PS_INPUT_tree PGSL_VS_OUTPUT_tree



/////////////////////////////////////////////////////////////////////
//VERTEX SHADER INPUTS
/////////////////////////////////////////////////////////////////////
float BendScale
<
string UIName = "BendScale";
>
 = 1.0;

struct PGSL_VS_INPUT_tree
{
	float3 Pos  : PGSL_POSITION;
	float3 Normal  : PGSL_NORMAL;
	float2 BaseTexUV  : PGSL_TEXCOORD0;
	float3 Tangent  : PGSL_TANGENT;
	float3 Bitangent  : PGSL_BITANGENT;
	float4 Color  : PGSL_COLOR0;
};



/////////////////////////////////////////////////////////////////////
//VERTEX SHADER OUTPUTS
/////////////////////////////////////////////////////////////////////
struct PGSL_VS_OUTPUT_tree
{
	float4 Pos  : PGSL_SV_POSITION;
	float2 BaseTexUV  : PGSL_TEXCOORD0;
	float4 LightFieldTexcoords  : PGSL_TEXCOORD1;
	float4 FowCloudTexcoords  : PGSL_TEXCOORD2;
	float4 VertexColor  : PGSL_COLOR0;
	float4 Diffuse  : PGSL_TEXCOORD3;
	float Fog  : PGSL_TEXCOORD4;
};



/////////////////////////////////////////////////////////////////////
//VERTEX SHADER SHARED STRUCT
/////////////////////////////////////////////////////////////////////
struct PGSL_VS_SHARED_tree
{
	float4x4 World;
	float4 Pos;
	float3 Normal;
	float2 BaseTexUV;
	float3 Tangent;
	float3 Bitangent;
	float4 VertexColor;
	float4 SurfaceDiffuse;
	float3 SurfaceSpecular;
	float4 WorldPos;
	float3 LightDiffuse;
	float3 Diffuse;
};



/////////////////////////////////////////////////////////////////////
//VERTEX SHADERS
/////////////////////////////////////////////////////////////////////


void pre_vs_world_PART(inout PGSL_VS_INPUT_tree input, inout PGSL_VS_OUTPUT_tree output, inout PGSL_VS_SHARED_tree shared_vars)
{
	shared_vars.World = g_World;
}



void pre_vs_position_PART(inout PGSL_VS_INPUT_tree input, inout PGSL_VS_OUTPUT_tree output, inout PGSL_VS_SHARED_tree shared_vars)
{
	shared_vars.Pos = float4(input.Pos.xyz, 1.0);
}



void pre_vs_normal_PART(inout PGSL_VS_INPUT_tree input, inout PGSL_VS_OUTPUT_tree output, inout PGSL_VS_SHARED_tree shared_vars)
{
	shared_vars.Normal = input.Normal.xyz;
}



void pre_vs_base_uv_PART(inout PGSL_VS_INPUT_tree input, inout PGSL_VS_OUTPUT_tree output, inout PGSL_VS_SHARED_tree shared_vars)
{
	shared_vars.BaseTexUV = input.BaseTexUV;
}



void pre_vs_tangent_PART(inout PGSL_VS_INPUT_tree input, inout PGSL_VS_OUTPUT_tree output, inout PGSL_VS_SHARED_tree shared_vars)
{
	shared_vars.Tangent = input.Tangent;
}



void pre_vs_bitangent_PART(inout PGSL_VS_INPUT_tree input, inout PGSL_VS_OUTPUT_tree output, inout PGSL_VS_SHARED_tree shared_vars)
{
	shared_vars.Bitangent = input.Bitangent;
}



void pre_vs_vertex_color_PART(inout PGSL_VS_INPUT_tree input, inout PGSL_VS_OUTPUT_tree output, inout PGSL_VS_SHARED_tree shared_vars)
{
	shared_vars.VertexColor = input.Color;
}



void vs_identity_surface_material_PART(in PGSL_VS_INPUT_tree input, inout PGSL_VS_OUTPUT_tree output, inout PGSL_VS_SHARED_tree shared_vars)
{
	shared_vars.SurfaceDiffuse = float4(1, 1, 1, 1);
	shared_vars.SurfaceSpecular = float3(1, 1, 1);
}



void vs_mesh_PART(in PGSL_VS_INPUT_tree input, inout PGSL_VS_OUTPUT_tree output, inout PGSL_VS_SHARED_tree shared_vars)
{
	//xform to projection space
#if defined(PGSL_MAX)
	output.Pos = mul(shared_vars.Pos, g_World);
	output.Pos = mul(output.Pos, g_View);
	output.Pos = mul(output.Pos, g_Proj);
#else
	output.Pos = mul(shared_vars.Pos, g_WorldViewProj);
#endif
	
	//save world pos
	shared_vars.WorldPos = mul(shared_vars.Pos, shared_vars.World);
}



void vs_tree_bend_PART(in PGSL_VS_INPUT_tree input, inout PGSL_VS_OUTPUT_tree output, inout PGSL_VS_SHARED_tree shared_vars)
{
#if !defined(PGSL_MAX)
	shared_vars.WorldPos.xyz += BendScale*g_WindBendVector.xyz*(shared_vars.Pos.z*shared_vars.Pos.z*g_WindBendVector.w);
	output.Pos = mul(shared_vars.WorldPos, g_ViewProj);
#endif
}



void vs_base_uv_PART(in PGSL_VS_INPUT_tree input, inout PGSL_VS_OUTPUT_tree output, inout PGSL_VS_SHARED_tree shared_vars)
{
	output.BaseTexUV = shared_vars.BaseTexUV;
}



void vs_lightfield_uv_PART(in PGSL_VS_INPUT_tree input, inout PGSL_VS_OUTPUT_tree output, inout PGSL_VS_SHARED_tree shared_vars)
{
	output.LightFieldTexcoords.xyz = Compute_LightField_Coords_World_Space(shared_vars.WorldPos);
}



void vs_fow_uv_PART(in PGSL_VS_INPUT_tree input, inout PGSL_VS_OUTPUT_tree output, inout PGSL_VS_SHARED_tree shared_vars)
{
	output.FowCloudTexcoords.x = dot(g_FowTexU, shared_vars.WorldPos);
	output.FowCloudTexcoords.y = dot(g_FowTexV, shared_vars.WorldPos);
}



void vs_vertex_color_PART(in PGSL_VS_INPUT_tree input, inout PGSL_VS_OUTPUT_tree output, inout PGSL_VS_SHARED_tree shared_vars)
{
	output.VertexColor = shared_vars.VertexColor;
}



void vs_sph_lighting_all_PART(in PGSL_VS_INPUT_tree input, inout PGSL_VS_OUTPUT_tree output, inout PGSL_VS_SHARED_tree shared_vars)
{
	float3 world_normal = normalize(mul(shared_vars.Normal, (float3x3)shared_vars.World));
	shared_vars.LightDiffuse.rgb += Sph_Compute_Diffuse_Light_All(world_normal);
}



void vs_sph_lighting_translucent_all_PART(in PGSL_VS_INPUT_tree input, inout PGSL_VS_OUTPUT_tree output, inout PGSL_VS_SHARED_tree shared_vars)
{
	float translucency = (1.0f - shared_vars.VertexColor.a);
	float3 world_normal = normalize(mul(-shared_vars.Normal, (float3x3)shared_vars.World));
	shared_vars.LightDiffuse.rgb += translucency * Sph_Compute_Diffuse_Light_All(world_normal);
}



void vs_compose_lighting_diffuse_PART(in PGSL_VS_INPUT_tree input, inout PGSL_VS_OUTPUT_tree output, inout PGSL_VS_SHARED_tree shared_vars)
{
	//do lighting: diffuse only
	shared_vars.Diffuse = shared_vars.LightDiffuse*shared_vars.SurfaceDiffuse.rgb;
	output.Diffuse.rgb = shared_vars.Diffuse.rgb;
	output.Diffuse.a = shared_vars.SurfaceDiffuse.a;
}



void vs_fog_PART(in PGSL_VS_INPUT_tree input, inout PGSL_VS_OUTPUT_tree output, inout PGSL_VS_SHARED_tree shared_vars)
{
	float fog = length(output.Pos.xyz);
	output.Fog = saturate(g_FogValues.x*fog + g_FogValues.y);
}

PGSL_VS_OUTPUT_tree pass_vs_PGSL_VS_MAIN_tree(PGSL_VS_INPUT_tree meta_shader_in)
{
	PGSL_VS_OUTPUT_tree meta_shader_out = (PGSL_VS_OUTPUT_tree)0;
	PGSL_VS_SHARED_tree meta_shader_shared = (PGSL_VS_SHARED_tree)0;
	pre_vs_world_PART(meta_shader_in, meta_shader_out, meta_shader_shared);
	pre_vs_position_PART(meta_shader_in, meta_shader_out, meta_shader_shared);
	pre_vs_normal_PART(meta_shader_in, meta_shader_out, meta_shader_shared);
	pre_vs_base_uv_PART(meta_shader_in, meta_shader_out, meta_shader_shared);
	pre_vs_tangent_PART(meta_shader_in, meta_shader_out, meta_shader_shared);
	pre_vs_bitangent_PART(meta_shader_in, meta_shader_out, meta_shader_shared);
	pre_vs_vertex_color_PART(meta_shader_in, meta_shader_out, meta_shader_shared);
	vs_identity_surface_material_PART(meta_shader_in, meta_shader_out, meta_shader_shared);
	vs_mesh_PART(meta_shader_in, meta_shader_out, meta_shader_shared);
	vs_tree_bend_PART(meta_shader_in, meta_shader_out, meta_shader_shared);
	vs_base_uv_PART(meta_shader_in, meta_shader_out, meta_shader_shared);
	vs_lightfield_uv_PART(meta_shader_in, meta_shader_out, meta_shader_shared);
	vs_fow_uv_PART(meta_shader_in, meta_shader_out, meta_shader_shared);
	vs_vertex_color_PART(meta_shader_in, meta_shader_out, meta_shader_shared);
	vs_sph_lighting_all_PART(meta_shader_in, meta_shader_out, meta_shader_shared);
	vs_sph_lighting_translucent_all_PART(meta_shader_in, meta_shader_out, meta_shader_shared);
	vs_compose_lighting_diffuse_PART(meta_shader_in, meta_shader_out, meta_shader_shared);
	vs_fog_PART(meta_shader_in, meta_shader_out, meta_shader_shared);
	return meta_shader_out;
}















/////////////////////////////////////////////////////////////////////
//PIXEL SHADER INPUTS
/////////////////////////////////////////////////////////////////////
float4 Diffuse
<
string UIName = "Diffuse";
string UIType = "ColorSwatch";
bool GammaCorrect = true;
>
 = {1.0, 1.0, 1.0, 1.0};

float4 Specular
<
string UIName = "Specular";
string UIType = "ColorSwatch";
bool GammaCorrect = true;
>
 = {1.0, 1.0, 1.0, 1.0};

float4 Emissive
<
string UIName = "Emissive";
string UIType = "ColorSwatch";
bool GammaCorrect = true;
>
 = {0.0, 0.0, 0.0, 0.0};

PGSL_TEXTURE2D BaseTexture  : DIFFUSEMAP
<
string UIName = "BaseTexture";
string UIType = "bitmap";
string SamplerEnum = "AL_SAMPLER_UVWRAP_MIN_MAG_MIP_BILINEAR_SRGB";
bool IsShadowmapAlphaTestTexture = true;
>
;
PGSL_SAMPLER BaseTextureSampler PGSL_SAMPLER_REG(0)
<
string UIName = "BaseTexture";
string UIType = "bitmap";
string SamplerEnum = "AL_SAMPLER_UVWRAP_MIN_MAG_MIP_BILINEAR_SRGB";
bool IsShadowmapAlphaTestTexture = true;
PGSL_BIND_TO_TEXTURE(BaseTexture)
string SamplerRegister = "0";
>
PGSL_SAMPLER_STATE(BaseTexture);

PGSL_TEXTURE2D LightFieldTexture PGSL_TEXTURE_REG(4)
<
string SamplerEnum = "AL_SAMPLER_UVCLAMP_MIN_MAG_MIP_BILINEAR_SRGB";
>
;
PGSL_SAMPLER LightFieldTextureSampler PGSL_SAMPLER_REG(4)
<
string SamplerEnum = "AL_SAMPLER_UVCLAMP_MIN_MAG_MIP_BILINEAR_SRGB";
PGSL_BIND_TO_TEXTURE(LightFieldTexture)
string SamplerRegister = "4";
>
PGSL_SAMPLER_STATE(LightFieldTexture);

PGSL_TEXTURE2D FowTexture
<
string SamplerEnum = "AL_SAMPLER_UVCLAMP_MIN_MAG_MIP_BILINEAR_SRGB";
>
;
PGSL_SAMPLER FowTextureSampler PGSL_SAMPLER_REG(1)
<
string SamplerEnum = "AL_SAMPLER_UVCLAMP_MIN_MAG_MIP_BILINEAR_SRGB";
PGSL_BIND_TO_TEXTURE(FowTexture)
string SamplerRegister = "1";
>
PGSL_SAMPLER_STATE(FowTexture);




/////////////////////////////////////////////////////////////////////
//PIXEL SHADER OUTPUTS
/////////////////////////////////////////////////////////////////////
struct PGSL_PS_OUTPUT_tree
{
	float4 Color0  : PGSL_TARGET0;
};



/////////////////////////////////////////////////////////////////////
//PIXEL SHADER SHARED STRUCT
/////////////////////////////////////////////////////////////////////
struct PGSL_PS_SHARED_tree
{
	float2 BaseTexUV;
	float4 SurfaceDiffuse;
	float3 SurfaceSpecular;
	float3 SurfaceEmissive;
	float4 Albedo;
	float3 LightDiffuse;
	float3 Diffuse;
};



/////////////////////////////////////////////////////////////////////
//PIXEL SHADERS
/////////////////////////////////////////////////////////////////////


void pre_ps_base_uv_PART(inout PGSL_PS_INPUT_tree input, inout PGSL_PS_OUTPUT_tree output, inout PGSL_PS_SHARED_tree shared_vars)
{
	shared_vars.BaseTexUV = input.BaseTexUV;
}



void ps_surface_material_opaque_PART(in PGSL_PS_INPUT_tree input, inout PGSL_PS_OUTPUT_tree output, inout PGSL_PS_SHARED_tree shared_vars)
{
	shared_vars.SurfaceDiffuse = Diffuse;
	shared_vars.SurfaceDiffuse.a = 1;
	
	shared_vars.SurfaceSpecular = Specular.rgb;
}



void ps_surface_emissive_PART(in PGSL_PS_INPUT_tree input, inout PGSL_PS_OUTPUT_tree output, inout PGSL_PS_SHARED_tree shared_vars)
{
	shared_vars.SurfaceEmissive = Emissive.rgb;
}



void ps_base_texture_shadowmap_alpha_test_PART(in PGSL_PS_INPUT_tree input, inout PGSL_PS_OUTPUT_tree output, inout PGSL_PS_SHARED_tree shared_vars)
{
	shared_vars.Albedo = PGSL_TEX2D(BaseTexture, BaseTextureSampler, shared_vars.BaseTexUV);
	shared_vars.SurfaceDiffuse *= shared_vars.Albedo;
}

#undef DYNAMIC_BRIGHTEN_FACTOR
#define DYNAMIC_BRIGHTEN_FACTOR 1.0 


void ps_vertex_color_modulate_PART(in PGSL_PS_INPUT_tree input, inout PGSL_PS_OUTPUT_tree output, inout PGSL_PS_SHARED_tree shared_vars)
{
	shared_vars.SurfaceDiffuse.rgb *= (input.VertexColor.rgb*DYNAMIC_BRIGHTEN_FACTOR);
}



void ps_vertex_diffuse_PART(in PGSL_PS_INPUT_tree input, inout PGSL_PS_OUTPUT_tree output, inout PGSL_PS_SHARED_tree shared_vars)
{
	shared_vars.LightDiffuse.rgb += input.Diffuse.rgb;
}



void ps_lightfield_PART(in PGSL_PS_INPUT_tree input, inout PGSL_PS_OUTPUT_tree output, inout PGSL_PS_SHARED_tree shared_vars)
{
	//Get the lighting in the light field plane
	float4 lf_texel = PGSL_TEX2D(LightFieldTexture, LightFieldTextureSampler, input.LightFieldTexcoords.xy);

	//Capped Cylinder Z-attenuation:
	//"top" of the light is lf_texel.a and the lighting is zero at that point light 
	//intensity grows up to 1.0 over the z attenuation range and then stays at 1.0 all the
	//way to negative infinity.
	//float zdist = lf_texel.a - input.LightFieldTexcoords.z;
	//float atten = saturate(zdist*LF_NORM_Z_ATTEN_INV);

	// GTH - LightField code still assumes LDR rendering, scale up a bit
	// so light sources aren't completely lost in Victory and GOO.  
	// TODO: HDR LightField, probably a 2-3 day task...
	shared_vars.LightDiffuse.rgb += 4.0f * lf_texel.rgb; // += lf_texel.rgb; //*atten; 
}



void ps_lightscale_PART(in PGSL_PS_INPUT_tree input, inout PGSL_PS_OUTPUT_tree output, inout PGSL_PS_SHARED_tree shared_vars)
{
	shared_vars.LightDiffuse.rgb *= g_LightScale.rgb;
	shared_vars.SurfaceDiffuse.a *= g_LightScale.a;
}



void ps_compose_lighting_diffuse_PART(in PGSL_PS_INPUT_tree input, inout PGSL_PS_OUTPUT_tree output, inout PGSL_PS_SHARED_tree shared_vars)
{
  shared_vars.Diffuse = shared_vars.SurfaceDiffuse.rgb*shared_vars.LightDiffuse;
  output.Color0.rgb = shared_vars.Diffuse.rgb;
  output.Color0.a = shared_vars.SurfaceDiffuse.a;
}



void ps_emissive_PART(in PGSL_PS_INPUT_tree input, inout PGSL_PS_OUTPUT_tree output, inout PGSL_PS_SHARED_tree shared_vars)
{
	output.Color0.rgb += (shared_vars.SurfaceEmissive.rgb*shared_vars.Albedo.rgb);
}



void ps_fow_PART(in PGSL_PS_INPUT_tree input, inout PGSL_PS_OUTPUT_tree output, inout PGSL_PS_SHARED_tree shared_vars)
 {
#if !defined(PGSL_MAX)
	
	 float4 fow_texel = PGSL_TEX2D(FowTexture, FowTextureSampler, input.FowCloudTexcoords.xy);
	 float lum = dot(output.Color0.rgb, LumVec);
	 output.Color0.rgb = lerp(fow_texel.rgb*lum.xxx, output.Color0.rgb, fow_texel.a);
	
#endif
 }



void ps_fog_PART(in PGSL_PS_INPUT_tree input, inout PGSL_PS_OUTPUT_tree output, inout PGSL_PS_SHARED_tree shared_vars)
{
	output.Color0.rgb = lerp(g_FogColor.rgb, output.Color0.rgb, input.Fog);
}

#undef DYNAMIC_ALPHA_TEST_REF_VALUE
#define DYNAMIC_ALPHA_TEST_REF_VALUE 128 


void ps_alpha_test_greater_PART(in PGSL_PS_INPUT_tree input, inout PGSL_PS_OUTPUT_tree output, inout PGSL_PS_SHARED_tree shared_vars)
{
	output.Color0 = Do_Alpha_Test(output.Color0, DYNAMIC_ALPHA_TEST_REF_VALUE, ALPHA_TEST_COMP_FUNC_GREATER);
}

PGSL_PS_OUTPUT_tree pass_ps_PGSL_PS_MAIN_tree(PGSL_PS_INPUT_tree meta_shader_in)
{
	PGSL_PS_OUTPUT_tree meta_shader_out = (PGSL_PS_OUTPUT_tree)0;
	PGSL_PS_SHARED_tree meta_shader_shared = (PGSL_PS_SHARED_tree)0;
	pre_ps_base_uv_PART(meta_shader_in, meta_shader_out, meta_shader_shared);
	ps_surface_material_opaque_PART(meta_shader_in, meta_shader_out, meta_shader_shared);
	ps_surface_emissive_PART(meta_shader_in, meta_shader_out, meta_shader_shared);
	ps_base_texture_shadowmap_alpha_test_PART(meta_shader_in, meta_shader_out, meta_shader_shared);
	ps_vertex_color_modulate_PART(meta_shader_in, meta_shader_out, meta_shader_shared);
	ps_vertex_diffuse_PART(meta_shader_in, meta_shader_out, meta_shader_shared);
	ps_lightfield_PART(meta_shader_in, meta_shader_out, meta_shader_shared);
	ps_lightscale_PART(meta_shader_in, meta_shader_out, meta_shader_shared);
	ps_compose_lighting_diffuse_PART(meta_shader_in, meta_shader_out, meta_shader_shared);
	ps_emissive_PART(meta_shader_in, meta_shader_out, meta_shader_shared);
	ps_fow_PART(meta_shader_in, meta_shader_out, meta_shader_shared);
	ps_fog_PART(meta_shader_in, meta_shader_out, meta_shader_shared);
	ps_alpha_test_greater_PART(meta_shader_in, meta_shader_out, meta_shader_shared);
	return meta_shader_out;
}



/////////////////////////////////////////////////////////////////////
//SHADER'S PASSES
/////////////////////////////////////////////////////////////////////
PGSL_TECHNIQUE_BEGIN
	PGSL_PASS_BEGIN(pass_0, 
	<
		string _RasterizeState_ = "ALRS_DEFAULT";string _BlendState_ = "ALBS_ALPHA_BLEND_ALPHA_TEST_GREATER_ALPHA_SCRIPTING";string _AlphaTestRefValue_ = "128";string _DepthStencilState_ = "ALDS_DEPTHLESSEQUALWRITE_STENCILDISABLE";bool EnableAlphaScripting = true;
	>)
		PGSL_PASS_VS(pass_vs_PGSL_VS_MAIN_tree, 0)
		PGSL_PASS_PS(pass_ps_PGSL_PS_MAIN_tree, 0)
	PGSL_PASS_END
PGSL_TECHNIQUE_END



