//////////////////////////////////////////////////////////////////////////////////////////////////////////
//
//Petroglyph Confidential Source Code -- Do Not Distribute
//
// (Auto generated by PGSLCodeGenerator)
//Platform: MAX
//////////////////////////////////////////////////////////////////////////////////////////////////////////
#define PGSL_MAX
#define PGSL_DX9
#include"..\common\PGSLAlways.pgh"
#include"..\common\AlamoEngine.pgh"

float g_ShaderFileDummyVariable : SHADER_FILE_ANNOTATION
<
string _ALAMO_RENDER_PHASE = "Water";
string _ALAMO_VERTEX_TYPE = "alD3dVertNU2C";
bool _ALAMO_TANGENT_SPACE = false;
>;

#define PGSL_PS_INPUT_skydome2 PGSL_VS_OUTPUT_skydome2



/////////////////////////////////////////////////////////////////////
//VERTEX SHADER INPUTS
/////////////////////////////////////////////////////////////////////
float CloudScrollRate
<
string UIName = "CloudScrollRate";
string UIType = "MaxSpinner";
float UIMin = -1.0;
float UIMax = 1.0;
>
 = 0.0025;

float CloudScale
<
string UIName = "CloudScale";
string UIType = "MaxSpinner";
float UIMin = 0;
float UIMax = 32.0;
>
 = 0.0025;

float4 TopColor
<
string UIName = "TopColor";
string UIType = "ColorSwatch";
bool GammaCorrect = true;
>
 = {0.0, 0.0, 0.0, 0.0};

float4 MiddleColor
<
string UIName = "MiddleColor";
string UIType = "ColorSwatch";
bool GammaCorrect = true;
>
 = {0.0, 0.0, 0.5, 0.0};

float4 BottomColor
<
string UIName = "BottomColor";
string UIType = "ColorSwatch";
bool GammaCorrect = true;
>
 = {0.5, 0.5, 0.5, 0.0};

float4 ToSun
<
string UIName = "ToSun";
string UIType = "ColorSwatch";
bool GammaCorrect = true;
>
 = {0.7, 0.7, 1.0, 0.0};

float4 MidSun
<
string UIName = "MidSun";
string UIType = "ColorSwatch";
bool GammaCorrect = true;
>
 = {0.1, 0.1, 0.05, 0.0};

float4 AwaySun
<
string UIName = "AwaySun";
string UIType = "ColorSwatch";
bool GammaCorrect = true;
>
 = {0.0, 0.0, 0.0, 0.0};

float FogStart
<
string UIName = "FogStart";
string UIType = "MaxSpinner";
float UIMin = -1.0;
float UIMax = 1.0;
>
 = 0;

float FogEnd
<
string UIName = "FogEnd";
string UIType = "MaxSpinner";
float UIMin = 0;
float UIMax = 32.0;
>
 = 0.5;

struct PGSL_VS_INPUT_skydome2
{
	float3 Pos  : PGSL_POSITION;
	float3 Normal  : PGSL_NORMAL;
	float2 BaseTexUV  : PGSL_TEXCOORD0;
	float4 Color  : PGSL_COLOR0;
};



/////////////////////////////////////////////////////////////////////
//VERTEX SHADER OUTPUTS
/////////////////////////////////////////////////////////////////////
struct PGSL_VS_OUTPUT_skydome2
{
	float4 Pos  : PGSL_SV_POSITION;
	float2 BaseTexUV  : PGSL_TEXCOORD0;
	float2 CloudTexUV  : PGSL_TEXCOORD1;
	float4 Diffuse  : PGSL_COLOR0;
	float Fog  : PGSL_TEXCOORD2;
};



/////////////////////////////////////////////////////////////////////
//VERTEX SHADER SHARED STRUCT
/////////////////////////////////////////////////////////////////////
struct PGSL_VS_SHARED_skydome2
{
	float4x4 World;
	float4 Pos;
	float3 Normal;
	float2 BaseTexUV;
	float4 VertexColor;
	float4 SurfaceDiffuse;
	float3 SurfaceSpecular;
	float4 WorldPos;
};



/////////////////////////////////////////////////////////////////////
//VERTEX SHADERS
/////////////////////////////////////////////////////////////////////


void pre_vs_world_PART(inout PGSL_VS_INPUT_skydome2 input, inout PGSL_VS_OUTPUT_skydome2 output, inout PGSL_VS_SHARED_skydome2 shared_vars)
{
	shared_vars.World = g_World;
}



void pre_vs_position_PART(inout PGSL_VS_INPUT_skydome2 input, inout PGSL_VS_OUTPUT_skydome2 output, inout PGSL_VS_SHARED_skydome2 shared_vars)
{
	shared_vars.Pos = float4(input.Pos.xyz, 1.0);
}



void pre_vs_normal_PART(inout PGSL_VS_INPUT_skydome2 input, inout PGSL_VS_OUTPUT_skydome2 output, inout PGSL_VS_SHARED_skydome2 shared_vars)
{
	shared_vars.Normal = input.Normal.xyz;
}



void pre_vs_base_uv_PART(inout PGSL_VS_INPUT_skydome2 input, inout PGSL_VS_OUTPUT_skydome2 output, inout PGSL_VS_SHARED_skydome2 shared_vars)
{
	shared_vars.BaseTexUV = input.BaseTexUV;
}



void pre_vs_vertex_color_PART(inout PGSL_VS_INPUT_skydome2 input, inout PGSL_VS_OUTPUT_skydome2 output, inout PGSL_VS_SHARED_skydome2 shared_vars)
{
	shared_vars.VertexColor = input.Color;
}



void vs_identity_surface_material_PART(in PGSL_VS_INPUT_skydome2 input, inout PGSL_VS_OUTPUT_skydome2 output, inout PGSL_VS_SHARED_skydome2 shared_vars)
{
	shared_vars.SurfaceDiffuse = float4(1, 1, 1, 1);
	shared_vars.SurfaceSpecular = float3(1, 1, 1);
}



void vs_mesh_PART(in PGSL_VS_INPUT_skydome2 input, inout PGSL_VS_OUTPUT_skydome2 output, inout PGSL_VS_SHARED_skydome2 shared_vars)
{
	//xform to projection space
#if defined(PGSL_MAX)
	output.Pos = mul(shared_vars.Pos, g_World);
	output.Pos = mul(output.Pos, g_View);
	output.Pos = mul(output.Pos, g_Proj);
#else
	output.Pos = mul(shared_vars.Pos, g_WorldViewProj);
#endif
	
	//save world pos
	shared_vars.WorldPos = mul(shared_vars.Pos, shared_vars.World);
}



void vs_push_to_far_plane_PART(in PGSL_VS_INPUT_skydome2 input, inout PGSL_VS_OUTPUT_skydome2 output, inout PGSL_VS_SHARED_skydome2 shared_vars)
{
	output.Pos.z = output.Pos.w;
}



void vs_base_uv_PART(in PGSL_VS_INPUT_skydome2 input, inout PGSL_VS_OUTPUT_skydome2 output, inout PGSL_VS_SHARED_skydome2 shared_vars)
{
	output.BaseTexUV = shared_vars.BaseTexUV;
}



void vs_skydome_cloud_uv_PART(in PGSL_VS_INPUT_skydome2 input, inout PGSL_VS_OUTPUT_skydome2 output, inout PGSL_VS_SHARED_skydome2 shared_vars)
{
	//cloud uv coords scroll along the u axis
	output.CloudTexUV = shared_vars.BaseTexUV;
	output.CloudTexUV.x += g_ElapsedTime*CloudScrollRate;
	output.CloudTexUV *= CloudScale;
}



void vs_skydome2_PART(in PGSL_VS_INPUT_skydome2 input, inout PGSL_VS_OUTPUT_skydome2 output, inout PGSL_VS_SHARED_skydome2 shared_vars)
{
	//Lighting is applied per-vertex.  This must be computed in
	//world space for spherical harmonics to work.
	//Since this is intended for a sky-dome, we invert the vertex normal
	float3 world_normal = normalize(mul(-shared_vars.Normal, (float3x3)shared_vars.World));	
	
	//The vertical color is a gradient of colors
	//Quadratic interpolation of the colors
	float3 vert_color = TopColor.xyz;	
	if(world_normal.z > 0.0) 
	{
		vert_color = (2*TopColor.xyz + 2*BottomColor.xyz - 4*MiddleColor.xyz)*world_normal.z*world_normal.z
	                 + (4*MiddleColor.xyz - TopColor.xyz - 3*BottomColor.xyz)*world_normal.z
	                 + BottomColor.xyz;
	}
	
	float ndotl = 0.5 + 0.5*dot(world_normal, g_Light0Vec.xyz);
	float3 sun_color = (2*ToSun.xyz + 2*AwaySun.xyz - 4*MidSun.xyz)*ndotl*ndotl
	                   + (4*MidSun.xyz - ToSun.xyz - 3*AwaySun.xyz)*ndotl
	                   + AwaySun.xyz;
	
	//Output final vertex lighting colors:
	output.Diffuse = float4(vert_color + sun_color, 1.0);
	
	output.Fog = saturate((world_normal.z - FogStart)/(FogEnd - FogStart));
}



void vs_skydome_fog_PART(in PGSL_VS_INPUT_skydome2 input, inout PGSL_VS_OUTPUT_skydome2 output, inout PGSL_VS_SHARED_skydome2 shared_vars)
{
	output.Fog = saturate((1.0 - g_FogValues.z));
}

PGSL_VS_OUTPUT_skydome2 pass_vs_PGSL_VS_MAIN_skydome2(PGSL_VS_INPUT_skydome2 meta_shader_in)
{
	PGSL_VS_OUTPUT_skydome2 meta_shader_out = (PGSL_VS_OUTPUT_skydome2)0;
	PGSL_VS_SHARED_skydome2 meta_shader_shared = (PGSL_VS_SHARED_skydome2)0;
	pre_vs_world_PART(meta_shader_in, meta_shader_out, meta_shader_shared);
	pre_vs_position_PART(meta_shader_in, meta_shader_out, meta_shader_shared);
	pre_vs_normal_PART(meta_shader_in, meta_shader_out, meta_shader_shared);
	pre_vs_base_uv_PART(meta_shader_in, meta_shader_out, meta_shader_shared);
	pre_vs_vertex_color_PART(meta_shader_in, meta_shader_out, meta_shader_shared);
	vs_identity_surface_material_PART(meta_shader_in, meta_shader_out, meta_shader_shared);
	vs_mesh_PART(meta_shader_in, meta_shader_out, meta_shader_shared);
	vs_push_to_far_plane_PART(meta_shader_in, meta_shader_out, meta_shader_shared);
	vs_base_uv_PART(meta_shader_in, meta_shader_out, meta_shader_shared);
	vs_skydome_cloud_uv_PART(meta_shader_in, meta_shader_out, meta_shader_shared);
	vs_skydome2_PART(meta_shader_in, meta_shader_out, meta_shader_shared);
	vs_skydome_fog_PART(meta_shader_in, meta_shader_out, meta_shader_shared);
	return meta_shader_out;
}















/////////////////////////////////////////////////////////////////////
//PIXEL SHADER INPUTS
/////////////////////////////////////////////////////////////////////
float CloudAlpha
<
string UIName = "CloudAlpha";
string UIType = "MaxSpinner";
float UIMin = 0;
float UIMax = 1.0;
>
 = 0.5;

PGSL_TEXTURE2D BaseTexture  : DIFFUSEMAP
<
string UIName = "BaseTexture";
string UIType = "bitmap";
string SamplerEnum = "AL_SAMPLER_UVWRAP_MIN_MAG_MIP_BILINEAR_SRGB";
>
;
PGSL_SAMPLER BaseTextureSampler PGSL_SAMPLER_REG(0)
<
string UIName = "BaseTexture";
string UIType = "bitmap";
string SamplerEnum = "AL_SAMPLER_UVWRAP_MIN_MAG_MIP_BILINEAR_SRGB";
PGSL_BIND_TO_TEXTURE(BaseTexture)
string SamplerRegister = "0";
>
PGSL_SAMPLER_STATE(BaseTexture);

PGSL_TEXTURE2D CloudTexture
<
string UIName = "CloudTexture";
string UIType = "bitmap";
string SamplerEnum = "AL_SAMPLER_UVWRAP_MIN_MAG_MIP_BILINEAR_SRGB";
>
;
PGSL_SAMPLER CloudTextureSampler PGSL_SAMPLER_REG(1)
<
string UIName = "CloudTexture";
string UIType = "bitmap";
string SamplerEnum = "AL_SAMPLER_UVWRAP_MIN_MAG_MIP_BILINEAR_SRGB";
PGSL_BIND_TO_TEXTURE(CloudTexture)
string SamplerRegister = "1";
>
PGSL_SAMPLER_STATE(CloudTexture);




/////////////////////////////////////////////////////////////////////
//PIXEL SHADER OUTPUTS
/////////////////////////////////////////////////////////////////////
struct PGSL_PS_OUTPUT_skydome2
{
	float4 Color0  : PGSL_TARGET0;
};



/////////////////////////////////////////////////////////////////////
//PIXEL SHADER SHARED STRUCT
/////////////////////////////////////////////////////////////////////
struct PGSL_PS_SHARED_skydome2
{
};



/////////////////////////////////////////////////////////////////////
//PIXEL SHADERS
/////////////////////////////////////////////////////////////////////


void ps_skydome2_PART(in PGSL_PS_INPUT_skydome2 input, inout PGSL_PS_OUTPUT_skydome2 output, inout PGSL_PS_SHARED_skydome2 shared_vars)
{
	float4 base_texel = PGSL_TEX2D(BaseTexture, BaseTextureSampler, input.BaseTexUV);
	float4 cloud_texel = PGSL_TEX2D(CloudTexture, CloudTextureSampler, input.CloudTexUV);
	cloud_texel.a *= CloudAlpha;	
	
	//Blend the ramp color, the base texture and the cloud texture over each other
	float3 layer1 = lerp(input.Diffuse.rgb, base_texel.rgb, base_texel.a);
	float3 layer2 = lerp(layer1, cloud_texel.rgb, cloud_texel.a);

	output.Color0 = float4(lerp(g_FogColor.rgb, layer2, input.Fog), 1.0);
}



void ps_fog_PART(in PGSL_PS_INPUT_skydome2 input, inout PGSL_PS_OUTPUT_skydome2 output, inout PGSL_PS_SHARED_skydome2 shared_vars)
{
	output.Color0.rgb = lerp(g_FogColor.rgb, output.Color0.rgb, input.Fog);
}

PGSL_PS_OUTPUT_skydome2 pass_ps_PGSL_PS_MAIN_skydome2(PGSL_PS_INPUT_skydome2 meta_shader_in)
{
	PGSL_PS_OUTPUT_skydome2 meta_shader_out = (PGSL_PS_OUTPUT_skydome2)0;
	PGSL_PS_SHARED_skydome2 meta_shader_shared = (PGSL_PS_SHARED_skydome2)0;
	ps_skydome2_PART(meta_shader_in, meta_shader_out, meta_shader_shared);
	ps_fog_PART(meta_shader_in, meta_shader_out, meta_shader_shared);
	return meta_shader_out;
}



/////////////////////////////////////////////////////////////////////
//SHADER'S PASSES
/////////////////////////////////////////////////////////////////////
PGSL_TECHNIQUE_BEGIN
	PGSL_PASS_BEGIN(pass_0, 
	<
		string _RasterizeState_ = "ALRS_DEFAULT";string _BlendState_ = "ALBS_NONE";string _DepthStencilState_ = "ALDS_DEPTHLESSEQUALNOWRITE_STENCILDISABLE";
	>)
		PGSL_PASS_VS(pass_vs_PGSL_VS_MAIN_skydome2, 0)
		PGSL_PASS_PS(pass_ps_PGSL_PS_MAIN_skydome2, 0)
	PGSL_PASS_END
PGSL_TECHNIQUE_END



