//////////////////////////////////////////////////////////////////////////////////////////////////////////
//
//Petroglyph Confidential Source Code -- Do Not Distribute
//
// (Auto generated by PGSLCodeGenerator)
//Platform: MAX
//////////////////////////////////////////////////////////////////////////////////////////////////////////
#define PGSL_MAX
#define PGSL_DX9
#include"..\common\PGSLAlways.pgh"
#include"..\common\AlamoEngine.pgh"
#include"..\common\AlamoEngine_Skinning.pgh"

float g_ShaderFileDummyVariable : SHADER_FILE_ANNOTATION
<
string _ALAMO_RENDER_PHASE = "Transparent";
string _ALAMO_VERTEX_PROC = "RSkin";
string _ALAMO_VERTEX_TYPE = "alD3dVertRSkinNU2";
bool _ALAMO_TANGENT_SPACE = false;
int _ALAMO_BONES_PER_VERTEX = 1;
>;

#define PGSL_PS_INPUT_rskin_hologram PGSL_VS_OUTPUT_rskin_hologram



/////////////////////////////////////////////////////////////////////
//VERTEX SHADER INPUTS
/////////////////////////////////////////////////////////////////////
float4x4 ScreenspaceUVTransform = {
			float4(0.5, 0, 0, 0),
			float4(0, -0.5, 0, 0),
			float4(0, 0, 0.5, 0),
			float4(0.5, 0.5, 0.5, 1.0)
			};

float TextureWidth
<
string UIName = "TextureWidth";
string UIType = "MaxSpinner";
float UIMin = 1.0;
float UIMax = 1024.0;
>
 = 128;

float TextureHeight
<
string UIName = "TextureHeight";
string UIType = "MaxSpinner";
float UIMin = 1.0;
float UIMax = 1024.0;
>
 = 128;

float2 UVScrollRate
<
string UIName = "UVScrollRate";
>
 = {0, 0};

float4 Color
<
string UIName = "Color";
string UIType = "ColorSwatch";
bool GammaCorrect = true;
>
 = {1, 1, 1, 1};

float4 ViewDep_RGBA_Edge
<
string UIName = "ViewDep_RGBA_Edge";
>
 = 1.0;

float4 ViewDep_RGBA_Facing
<
string UIName = "ViewDep_RGBA_Facing";
>
 = 1.0;

float ViewDep_Power
<
string UIName = "ViewDep_Power";
>
 = 1.0;

struct PGSL_VS_INPUT_rskin_hologram
{
	float3 Pos  : PGSL_POSITION;
	PGSL_PACKED_FLOAT4 Normal  : PGSL_NORMAL;
	float2 BaseTexUV  : PGSL_TEXCOORD0;
};



/////////////////////////////////////////////////////////////////////
//VERTEX SHADER OUTPUTS
/////////////////////////////////////////////////////////////////////
struct PGSL_VS_OUTPUT_rskin_hologram
{
	float4 Pos  : PGSL_SV_POSITION;
	float4 ScreenspaceUV  : PGSL_TEXCOORD0;
	float3 VertexColor  : PGSL_COLOR0;
};



/////////////////////////////////////////////////////////////////////
//VERTEX SHADER SHARED STRUCT
/////////////////////////////////////////////////////////////////////
struct PGSL_VS_SHARED_rskin_hologram
{
	float4 Pos;
	float3 Normal;
	PGSL_PACKED_FLOAT RSkinMatrixIndex;
	float2 BaseTexUV;
	float4 WorldPos;
	float4x4 World;
	float4 SurfaceDiffuse;
};



/////////////////////////////////////////////////////////////////////
//VERTEX SHADERS
/////////////////////////////////////////////////////////////////////


void pre_vs_position_PART(inout PGSL_VS_INPUT_rskin_hologram input, inout PGSL_VS_OUTPUT_rskin_hologram output, inout PGSL_VS_SHARED_rskin_hologram shared_vars)
{
	shared_vars.Pos = float4(input.Pos.xyz, 1.0);
}



void pre_vs_unpack_rskin_normal_PART(inout PGSL_VS_INPUT_rskin_hologram input, inout PGSL_VS_OUTPUT_rskin_hologram output, inout PGSL_VS_SHARED_rskin_hologram shared_vars)
{
	shared_vars.Normal = Unpack_Normal(input.Normal.xyz);
	shared_vars.RSkinMatrixIndex = input.Normal.w;
}



void pre_vs_base_uv_PART(inout PGSL_VS_INPUT_rskin_hologram input, inout PGSL_VS_OUTPUT_rskin_hologram output, inout PGSL_VS_SHARED_rskin_hologram shared_vars)
{
	shared_vars.BaseTexUV = input.BaseTexUV;
}



void vs_rskin_PART(in PGSL_VS_INPUT_rskin_hologram input, inout PGSL_VS_OUTPUT_rskin_hologram output, inout PGSL_VS_SHARED_rskin_hologram shared_vars)
{
	//skinning
	float4x3 xform;
#if defined(PGSL_MAX)
	xform = g_World;
	float3 world_pos = mul(shared_vars.Pos, xform);
	output.Pos = mul(float4(world_pos, 1.0), g_View);
	output.Pos = mul(output.Pos, g_Proj);
#else
	xform = SkinMatrixArray[shared_vars.RSkinMatrixIndex];
	float3 world_pos = mul(shared_vars.Pos, xform);
	output.Pos = mul(float4(world_pos, 1.0), g_ViewProj);
#endif

	//save world pos
	shared_vars.WorldPos = float4(world_pos, 1.0);
	//save world xform
	shared_vars.World[0] = float4(xform[0], 0);
	shared_vars.World[1] = float4(xform[1], 0);
	shared_vars.World[2] = float4(xform[2], 0);
	shared_vars.World[3] = float4(xform[3], 1);
}



void vs_hologram_PART(in PGSL_VS_INPUT_rskin_hologram input, inout PGSL_VS_OUTPUT_rskin_hologram output, inout PGSL_VS_SHARED_rskin_hologram shared_vars)
{
	//screenspace uv xform
	output.ScreenspaceUV = mul(output.Pos, ScreenspaceUVTransform);

	//scale to get 1:1 texel/pixel ratio
	float2 scale = float2(g_ResolutionConstants.x/TextureWidth, g_ResolutionConstants.y/TextureHeight);
	output.ScreenspaceUV.xy *= scale.xy;

	//scroll
	//first, xform scrolling value into screenspace
	float2 uv_scroll = UVScrollRate.xy;
	uv_scroll *= output.ScreenspaceUV.w;
	uv_scroll.y = -uv_scroll.y;
	output.ScreenspaceUV.xy += g_ElapsedTime*uv_scroll.xy;

	Offset_Half_Pixel(output.ScreenspaceUV.xy, output.ScreenspaceUV.w);

	//tint color
	output.VertexColor = Color.rgb;
}



void vs_view_dependent_color_modulate_PART(in PGSL_VS_INPUT_rskin_hologram input, inout PGSL_VS_OUTPUT_rskin_hologram output, inout PGSL_VS_SHARED_rskin_hologram shared_vars)
{
    // edge fade
	float3 world_normal = normalize(mul(shared_vars.Normal, (float3x3)shared_vars.World));
	float3 view_norm = normalize(mul(world_normal, (float3x3)g_View));
    
	float t = saturate(view_norm.z);
	t = pow(t,ViewDep_Power);
	float4 rgba = lerp(ViewDep_RGBA_Edge,ViewDep_RGBA_Facing,t);

	shared_vars.SurfaceDiffuse *= rgba;  
}

PGSL_VS_OUTPUT_rskin_hologram pass_vs_PGSL_VS_MAIN_rskin_hologram(PGSL_VS_INPUT_rskin_hologram meta_shader_in)
{
	PGSL_VS_OUTPUT_rskin_hologram meta_shader_out = (PGSL_VS_OUTPUT_rskin_hologram)0;
	PGSL_VS_SHARED_rskin_hologram meta_shader_shared = (PGSL_VS_SHARED_rskin_hologram)0;
	pre_vs_position_PART(meta_shader_in, meta_shader_out, meta_shader_shared);
	pre_vs_unpack_rskin_normal_PART(meta_shader_in, meta_shader_out, meta_shader_shared);
	pre_vs_base_uv_PART(meta_shader_in, meta_shader_out, meta_shader_shared);
	vs_rskin_PART(meta_shader_in, meta_shader_out, meta_shader_shared);
	vs_hologram_PART(meta_shader_in, meta_shader_out, meta_shader_shared);
	vs_view_dependent_color_modulate_PART(meta_shader_in, meta_shader_out, meta_shader_shared);
	return meta_shader_out;
}















/////////////////////////////////////////////////////////////////////
//PIXEL SHADER INPUTS
/////////////////////////////////////////////////////////////////////
PGSL_TEXTURE2D BaseTexture  : DIFFUSEMAP
<
string UIName = "BaseTexture";
string UIType = "bitmap";
string SamplerEnum = "AL_SAMPLER_UVWRAP_MIN_MAG_MIP_BILINEAR_SRGB";
>
;
PGSL_SAMPLER BaseTextureSampler PGSL_SAMPLER_REG(0)
<
string UIName = "BaseTexture";
string UIType = "bitmap";
string SamplerEnum = "AL_SAMPLER_UVWRAP_MIN_MAG_MIP_BILINEAR_SRGB";
PGSL_BIND_TO_TEXTURE(BaseTexture)
string SamplerRegister = "0";
>
PGSL_SAMPLER_STATE(BaseTexture);




/////////////////////////////////////////////////////////////////////
//PIXEL SHADER OUTPUTS
/////////////////////////////////////////////////////////////////////
struct PGSL_PS_OUTPUT_rskin_hologram
{
	float4 Color0  : PGSL_TARGET0;
};



/////////////////////////////////////////////////////////////////////
//PIXEL SHADER SHARED STRUCT
/////////////////////////////////////////////////////////////////////
struct PGSL_PS_SHARED_rskin_hologram
{
	float2 ScreenspaceUV;
	float2 BaseTexUV;
	float4 SurfaceDiffuse;
	float3 SurfaceSpecular;
	float4 Albedo;
	float3 Diffuse;
};



/////////////////////////////////////////////////////////////////////
//PIXEL SHADERS
/////////////////////////////////////////////////////////////////////


void pre_ps_screenspace_uv_PART(inout PGSL_PS_INPUT_rskin_hologram input, inout PGSL_PS_OUTPUT_rskin_hologram output, inout PGSL_PS_SHARED_rskin_hologram shared_vars)
{
	shared_vars.ScreenspaceUV = input.ScreenspaceUV.xy/input.ScreenspaceUV.w;
}



void pre_ps_base_uv_from_screenspace_uv_PART(inout PGSL_PS_INPUT_rskin_hologram input, inout PGSL_PS_OUTPUT_rskin_hologram output, inout PGSL_PS_SHARED_rskin_hologram shared_vars)
{
	shared_vars.BaseTexUV = shared_vars.ScreenspaceUV;
}



void ps_identity_surface_material_PART(in PGSL_PS_INPUT_rskin_hologram input, inout PGSL_PS_OUTPUT_rskin_hologram output, inout PGSL_PS_SHARED_rskin_hologram shared_vars)
{
	shared_vars.SurfaceDiffuse = float4(1, 1, 1, 1);
	shared_vars.SurfaceSpecular = float3(1, 1, 1);
}



void ps_base_texture_PART(in PGSL_PS_INPUT_rskin_hologram input, inout PGSL_PS_OUTPUT_rskin_hologram output, inout PGSL_PS_SHARED_rskin_hologram shared_vars)
{
	shared_vars.Albedo = PGSL_TEX2D(BaseTexture, BaseTextureSampler, shared_vars.BaseTexUV);
	shared_vars.SurfaceDiffuse *= shared_vars.Albedo;
}

#undef DYNAMIC_BRIGHTEN_FACTOR
#define DYNAMIC_BRIGHTEN_FACTOR 1.0 


void ps_vertex_color_modulate_PART(in PGSL_PS_INPUT_rskin_hologram input, inout PGSL_PS_OUTPUT_rskin_hologram output, inout PGSL_PS_SHARED_rskin_hologram shared_vars)
{
	shared_vars.SurfaceDiffuse.rgb *= (input.VertexColor.rgb*DYNAMIC_BRIGHTEN_FACTOR);
}



void ps_compose_surface_diffuse_PART(in PGSL_PS_INPUT_rskin_hologram input, inout PGSL_PS_OUTPUT_rskin_hologram output, inout PGSL_PS_SHARED_rskin_hologram shared_vars)
{
  shared_vars.Diffuse = shared_vars.SurfaceDiffuse.rgb;
  output.Color0 = shared_vars.SurfaceDiffuse;
}

PGSL_PS_OUTPUT_rskin_hologram pass_ps_PGSL_PS_MAIN_rskin_hologram(PGSL_PS_INPUT_rskin_hologram meta_shader_in)
{
	PGSL_PS_OUTPUT_rskin_hologram meta_shader_out = (PGSL_PS_OUTPUT_rskin_hologram)0;
	PGSL_PS_SHARED_rskin_hologram meta_shader_shared = (PGSL_PS_SHARED_rskin_hologram)0;
	pre_ps_screenspace_uv_PART(meta_shader_in, meta_shader_out, meta_shader_shared);
	pre_ps_base_uv_from_screenspace_uv_PART(meta_shader_in, meta_shader_out, meta_shader_shared);
	ps_identity_surface_material_PART(meta_shader_in, meta_shader_out, meta_shader_shared);
	ps_base_texture_PART(meta_shader_in, meta_shader_out, meta_shader_shared);
	ps_vertex_color_modulate_PART(meta_shader_in, meta_shader_out, meta_shader_shared);
	ps_compose_surface_diffuse_PART(meta_shader_in, meta_shader_out, meta_shader_shared);
	return meta_shader_out;
}



/////////////////////////////////////////////////////////////////////
//SHADER'S PASSES
/////////////////////////////////////////////////////////////////////
PGSL_TECHNIQUE_BEGIN
	PGSL_PASS_BEGIN(pass_0, 
	<
		string _RasterizeState_ = "ALRS_DEFAULT";string _BlendState_ = "ALBS_ADDITIVE";string _DepthStencilState_ = "ALDS_DEPTHLESSEQUALWRITE_STENCILDISABLE";
	>)
		PGSL_PASS_VS(pass_vs_PGSL_VS_MAIN_rskin_hologram, 0)
		PGSL_PASS_PS(pass_ps_PGSL_PS_MAIN_rskin_hologram, 0)
	PGSL_PASS_END
PGSL_TECHNIQUE_END



