//////////////////////////////////////////////////////////////////////////////////////////////////////////
//
//Petroglyph Confidential Source Code -- Do Not Distribute
//
// (Auto generated by PGSLCodeGenerator)
//Platform: MAX
//////////////////////////////////////////////////////////////////////////////////////////////////////////
#define PGSL_MAX
#define PGSL_DX9
#include"..\common\PGSLAlways.pgh"
#include"..\common\AlamoEngine.pgh"
#include"..\common\AlamoEngine_Skinning.pgh"

float g_ShaderFileDummyVariable : SHADER_FILE_ANNOTATION
<
string _ALAMO_RENDER_PHASE = "Opaque";
string _ALAMO_VERTEX_PROC = "RSkin";
string _ALAMO_VERTEX_TYPE = "alD3dVertRSkinNU2U3U3";
bool _ALAMO_TANGENT_SPACE = true;
int _ALAMO_BONES_PER_VERTEX = 1;
>;

#define PGSL_PS_INPUT_rskin_bump_colorize PGSL_VS_OUTPUT_rskin_bump_colorize



/////////////////////////////////////////////////////////////////////
//VERTEX SHADER INPUTS
/////////////////////////////////////////////////////////////////////
float4 UVOffset
<
string UIName = "UVOffset";
>
 = {0, 0, 0, 0};

struct PGSL_VS_INPUT_rskin_bump_colorize
{
	float3 Pos  : PGSL_POSITION;
	PGSL_PACKED_FLOAT4 Normal  : PGSL_NORMAL;
	float2 BaseTexUV  : PGSL_TEXCOORD0;
	float3 Tangent  : PGSL_TANGENT;
	float3 Bitangent  : PGSL_BITANGENT;
};



/////////////////////////////////////////////////////////////////////
//VERTEX SHADER OUTPUTS
/////////////////////////////////////////////////////////////////////
struct PGSL_VS_OUTPUT_rskin_bump_colorize
{
	float4 Pos  : PGSL_SV_POSITION;
	float2 BaseTexUV  : PGSL_TEXCOORD0;
	float3 LightVec  : PGSL_TEXCOORD1;
	float3 HalfVec  : PGSL_TEXCOORD2;
	float4 ShadowmapTexcoords  : PGSL_TEXCOORD3;
	float4 LightFieldTexcoords  : PGSL_TEXCOORD4;
	float4 FowCloudTexcoords  : PGSL_TEXCOORD5;
	float4 Diffuse  : PGSL_TEXCOORD6;
	float Fog  : PGSL_TEXCOORD7;
};



/////////////////////////////////////////////////////////////////////
//VERTEX SHADER SHARED STRUCT
/////////////////////////////////////////////////////////////////////
struct PGSL_VS_SHARED_rskin_bump_colorize
{
	float4 Pos;
	float3 Normal;
	PGSL_PACKED_FLOAT RSkinMatrixIndex;
	float2 BaseTexUV;
	float3 Tangent;
	float3 Bitangent;
	float4 SurfaceDiffuse;
	float3 SurfaceSpecular;
	float4 WorldPos;
	float4x4 World;
	float3 LightDiffuse;
	float3 Diffuse;
};



/////////////////////////////////////////////////////////////////////
//VERTEX SHADERS
/////////////////////////////////////////////////////////////////////


void pre_vs_position_PART(inout PGSL_VS_INPUT_rskin_bump_colorize input, inout PGSL_VS_OUTPUT_rskin_bump_colorize output, inout PGSL_VS_SHARED_rskin_bump_colorize shared_vars)
{
	shared_vars.Pos = float4(input.Pos.xyz, 1.0);
}



void pre_vs_unpack_rskin_normal_PART(inout PGSL_VS_INPUT_rskin_bump_colorize input, inout PGSL_VS_OUTPUT_rskin_bump_colorize output, inout PGSL_VS_SHARED_rskin_bump_colorize shared_vars)
{
	shared_vars.Normal = Unpack_Normal(input.Normal.xyz);
	shared_vars.RSkinMatrixIndex = input.Normal.w;
}



void pre_vs_base_uv_PART(inout PGSL_VS_INPUT_rskin_bump_colorize input, inout PGSL_VS_OUTPUT_rskin_bump_colorize output, inout PGSL_VS_SHARED_rskin_bump_colorize shared_vars)
{
	shared_vars.BaseTexUV = input.BaseTexUV;
}



void pre_vs_tangent_PART(inout PGSL_VS_INPUT_rskin_bump_colorize input, inout PGSL_VS_OUTPUT_rskin_bump_colorize output, inout PGSL_VS_SHARED_rskin_bump_colorize shared_vars)
{
	shared_vars.Tangent = input.Tangent;
}



void pre_vs_bitangent_PART(inout PGSL_VS_INPUT_rskin_bump_colorize input, inout PGSL_VS_OUTPUT_rskin_bump_colorize output, inout PGSL_VS_SHARED_rskin_bump_colorize shared_vars)
{
	shared_vars.Bitangent = input.Bitangent;
}



void vs_identity_surface_material_PART(in PGSL_VS_INPUT_rskin_bump_colorize input, inout PGSL_VS_OUTPUT_rskin_bump_colorize output, inout PGSL_VS_SHARED_rskin_bump_colorize shared_vars)
{
	shared_vars.SurfaceDiffuse = float4(1, 1, 1, 1);
	shared_vars.SurfaceSpecular = float3(1, 1, 1);
}



void vs_rskin_PART(in PGSL_VS_INPUT_rskin_bump_colorize input, inout PGSL_VS_OUTPUT_rskin_bump_colorize output, inout PGSL_VS_SHARED_rskin_bump_colorize shared_vars)
{
	//skinning
	float4x3 xform;
#if defined(PGSL_MAX)
	xform = g_World;
	float3 world_pos = mul(shared_vars.Pos, xform);
	output.Pos = mul(float4(world_pos, 1.0), g_View);
	output.Pos = mul(output.Pos, g_Proj);
#else
	xform = SkinMatrixArray[shared_vars.RSkinMatrixIndex];
	float3 world_pos = mul(shared_vars.Pos, xform);
	output.Pos = mul(float4(world_pos, 1.0), g_ViewProj);
#endif

	//save world pos
	shared_vars.WorldPos = float4(world_pos, 1.0);
	//save world xform
	shared_vars.World[0] = float4(xform[0], 0);
	shared_vars.World[1] = float4(xform[1], 0);
	shared_vars.World[2] = float4(xform[2], 0);
	shared_vars.World[3] = float4(xform[3], 1);
}



void vs_base_uv_offset_PART(in PGSL_VS_INPUT_rskin_bump_colorize input, inout PGSL_VS_OUTPUT_rskin_bump_colorize output, inout PGSL_VS_SHARED_rskin_bump_colorize shared_vars)
{
   shared_vars.BaseTexUV.xy += UVOffset.xy;
   output.BaseTexUV = shared_vars.BaseTexUV;
}



void vs_bump_PART(in PGSL_VS_INPUT_rskin_bump_colorize input, inout PGSL_VS_OUTPUT_rskin_bump_colorize output, inout PGSL_VS_SHARED_rskin_bump_colorize shared_vars)
{
	float3x3 xform = (float3x3)shared_vars.World;
	//transform tangent, bitangent and normal into world space
	float3 T = normalize(mul(shared_vars.Tangent, xform));
	float3 B = normalize(mul(shared_vars.Bitangent, xform));
	float3 N = normalize(mul(shared_vars.Normal, xform));

	//compute tangent space light vec and half vec
	float3 light_vec = g_Light0Vec.xyz;
	output.LightVec = Compute_Light_Vector(light_vec, T, B, N);
	output.LightVec = normalize(output.LightVec);
	
	output.HalfVec = Compute_Half_Vector(shared_vars.WorldPos.xyz, g_EyePos.xyz, light_vec, T, B, N);
	output.HalfVec = normalize(output.HalfVec);
}



void vs_shadowmap_uv_PART(in PGSL_VS_INPUT_rskin_bump_colorize input, inout PGSL_VS_OUTPUT_rskin_bump_colorize output, inout PGSL_VS_SHARED_rskin_bump_colorize shared_vars)
{
	output.ShadowmapTexcoords = mul(shared_vars.WorldPos, g_WorldToShadowmap);
	output.ShadowmapTexcoords.z = clamp(output.ShadowmapTexcoords.z, 0, output.ShadowmapTexcoords.w);
}



void vs_lightfield_uv_PART(in PGSL_VS_INPUT_rskin_bump_colorize input, inout PGSL_VS_OUTPUT_rskin_bump_colorize output, inout PGSL_VS_SHARED_rskin_bump_colorize shared_vars)
{
	output.LightFieldTexcoords.xyz = Compute_LightField_Coords_World_Space(shared_vars.WorldPos);
}



void vs_fow_uv_PART(in PGSL_VS_INPUT_rskin_bump_colorize input, inout PGSL_VS_OUTPUT_rskin_bump_colorize output, inout PGSL_VS_SHARED_rskin_bump_colorize shared_vars)
{
	output.FowCloudTexcoords.x = dot(g_FowTexU, shared_vars.WorldPos);
	output.FowCloudTexcoords.y = dot(g_FowTexV, shared_vars.WorldPos);
}



void vs_sph_lighting_fill_PART(in PGSL_VS_INPUT_rskin_bump_colorize input, inout PGSL_VS_OUTPUT_rskin_bump_colorize output, inout PGSL_VS_SHARED_rskin_bump_colorize shared_vars)
{
	float3 world_normal = normalize(mul(shared_vars.Normal, (float3x3)shared_vars.World));
	shared_vars.LightDiffuse.rgb += Sph_Compute_Diffuse_Light_Fill(world_normal);
}



void vs_compose_lighting_diffuse_PART(in PGSL_VS_INPUT_rskin_bump_colorize input, inout PGSL_VS_OUTPUT_rskin_bump_colorize output, inout PGSL_VS_SHARED_rskin_bump_colorize shared_vars)
{
	//do lighting: diffuse only
	shared_vars.Diffuse = shared_vars.LightDiffuse*shared_vars.SurfaceDiffuse.rgb;
	output.Diffuse.rgb = shared_vars.Diffuse.rgb;
	output.Diffuse.a = shared_vars.SurfaceDiffuse.a;
}



void vs_fog_PART(in PGSL_VS_INPUT_rskin_bump_colorize input, inout PGSL_VS_OUTPUT_rskin_bump_colorize output, inout PGSL_VS_SHARED_rskin_bump_colorize shared_vars)
{
	float fog = length(output.Pos.xyz);
	output.Fog = saturate(g_FogValues.x*fog + g_FogValues.y);
}

PGSL_VS_OUTPUT_rskin_bump_colorize pass_vs_PGSL_VS_MAIN_rskin_bump_colorize(PGSL_VS_INPUT_rskin_bump_colorize meta_shader_in)
{
	PGSL_VS_OUTPUT_rskin_bump_colorize meta_shader_out = (PGSL_VS_OUTPUT_rskin_bump_colorize)0;
	PGSL_VS_SHARED_rskin_bump_colorize meta_shader_shared = (PGSL_VS_SHARED_rskin_bump_colorize)0;
	pre_vs_position_PART(meta_shader_in, meta_shader_out, meta_shader_shared);
	pre_vs_unpack_rskin_normal_PART(meta_shader_in, meta_shader_out, meta_shader_shared);
	pre_vs_base_uv_PART(meta_shader_in, meta_shader_out, meta_shader_shared);
	pre_vs_tangent_PART(meta_shader_in, meta_shader_out, meta_shader_shared);
	pre_vs_bitangent_PART(meta_shader_in, meta_shader_out, meta_shader_shared);
	vs_identity_surface_material_PART(meta_shader_in, meta_shader_out, meta_shader_shared);
	vs_rskin_PART(meta_shader_in, meta_shader_out, meta_shader_shared);
	vs_base_uv_offset_PART(meta_shader_in, meta_shader_out, meta_shader_shared);
	vs_bump_PART(meta_shader_in, meta_shader_out, meta_shader_shared);
	vs_shadowmap_uv_PART(meta_shader_in, meta_shader_out, meta_shader_shared);
	vs_lightfield_uv_PART(meta_shader_in, meta_shader_out, meta_shader_shared);
	vs_fow_uv_PART(meta_shader_in, meta_shader_out, meta_shader_shared);
	vs_sph_lighting_fill_PART(meta_shader_in, meta_shader_out, meta_shader_shared);
	vs_compose_lighting_diffuse_PART(meta_shader_in, meta_shader_out, meta_shader_shared);
	vs_fog_PART(meta_shader_in, meta_shader_out, meta_shader_shared);
	return meta_shader_out;
}















/////////////////////////////////////////////////////////////////////
//PIXEL SHADER INPUTS
/////////////////////////////////////////////////////////////////////
float4 Diffuse
<
string UIName = "Diffuse";
string UIType = "ColorSwatch";
bool GammaCorrect = true;
>
 = {1.0, 1.0, 1.0, 1.0};

float4 Specular
<
string UIName = "Specular";
string UIType = "ColorSwatch";
bool GammaCorrect = true;
>
 = {1.0, 1.0, 1.0, 1.0};

float4 Emissive
<
string UIName = "Emissive";
string UIType = "ColorSwatch";
bool GammaCorrect = true;
>
 = {0.0, 0.0, 0.0, 0.0};

float SpecularIntensity
<
string UIName = "SpecularIntensity";
>
 = 1;

float SpecularGloss
<
string UIName = "SpecularGloss";
float UIMin = 0.0f;
float UIMax = 1.0f;
>
 = 0.25;

PGSL_TEXTURE2D BaseTexture  : DIFFUSEMAP
<
string UIName = "BaseTexture";
string UIType = "bitmap";
string SamplerEnum = "AL_SAMPLER_UVWRAP_MIN_MAG_MIP_BILINEAR_SRGB";
>
;
PGSL_SAMPLER BaseTextureSampler PGSL_SAMPLER_REG(0)
<
string UIName = "BaseTexture";
string UIType = "bitmap";
string SamplerEnum = "AL_SAMPLER_UVWRAP_MIN_MAG_MIP_BILINEAR_SRGB";
PGSL_BIND_TO_TEXTURE(BaseTexture)
string SamplerRegister = "0";
>
PGSL_SAMPLER_STATE(BaseTexture);

float4 Colorization
<
string UIName = "Colorization";
string UIType = "ColorSwatch";
bool GammaCorrect = true;
>
 = {0, 1, 0, 1};

PGSL_TEXTURE2D NormalTexture  : NORMALMAP
<
string UIName = "NormalTexture";
string UIType = "bitmap";
string SamplerEnum = "AL_SAMPLER_UVWRAP_MIN_MAG_MIP_BILINEAR";
bool DiscardableBump = true;
>
;
PGSL_SAMPLER NormalTextureSampler PGSL_SAMPLER_REG(1)
<
string UIName = "NormalTexture";
string UIType = "bitmap";
string SamplerEnum = "AL_SAMPLER_UVWRAP_MIN_MAG_MIP_BILINEAR";
bool DiscardableBump = true;
PGSL_BIND_TO_TEXTURE(NormalTexture)
string SamplerRegister = "1";
>
PGSL_SAMPLER_STATE(NormalTexture);

PGSL_TEXTURE2D Shadowmap PGSL_TEXTURE_REG(3)
<
string SamplerEnum = "AL_SAMPLER_UVCLAMP_MIN_MAG_MIP_POINT";
>
;
PGSL_SAMPLER ShadowmapSampler PGSL_SAMPLER_REG(3)
<
string SamplerEnum = "AL_SAMPLER_UVCLAMP_MIN_MAG_MIP_POINT";
PGSL_BIND_TO_TEXTURE(Shadowmap)
string SamplerRegister = "3";
>
PGSL_SAMPLER_STATE(Shadowmap);

PGSL_TEXTURE2D LightFieldTexture PGSL_TEXTURE_REG(4)
<
string SamplerEnum = "AL_SAMPLER_UVCLAMP_MIN_MAG_MIP_BILINEAR_SRGB";
>
;
PGSL_SAMPLER LightFieldTextureSampler PGSL_SAMPLER_REG(4)
<
string SamplerEnum = "AL_SAMPLER_UVCLAMP_MIN_MAG_MIP_BILINEAR_SRGB";
PGSL_BIND_TO_TEXTURE(LightFieldTexture)
string SamplerRegister = "4";
>
PGSL_SAMPLER_STATE(LightFieldTexture);

PGSL_TEXTURE2D FowTexture
<
string SamplerEnum = "AL_SAMPLER_UVCLAMP_MIN_MAG_MIP_BILINEAR_SRGB";
>
;
PGSL_SAMPLER FowTextureSampler PGSL_SAMPLER_REG(2)
<
string SamplerEnum = "AL_SAMPLER_UVCLAMP_MIN_MAG_MIP_BILINEAR_SRGB";
PGSL_BIND_TO_TEXTURE(FowTexture)
string SamplerRegister = "2";
>
PGSL_SAMPLER_STATE(FowTexture);




/////////////////////////////////////////////////////////////////////
//PIXEL SHADER OUTPUTS
/////////////////////////////////////////////////////////////////////
struct PGSL_PS_OUTPUT_rskin_bump_colorize
{
	float4 Color0  : PGSL_TARGET0;
};



/////////////////////////////////////////////////////////////////////
//PIXEL SHADER SHARED STRUCT
/////////////////////////////////////////////////////////////////////
struct PGSL_PS_SHARED_rskin_bump_colorize
{
	float2 BaseTexUV;
	float2 BumpTexUV;
	float4 SurfaceDiffuse;
	float3 SurfaceSpecular;
	float3 SurfaceEmissive;
	float3 SpecColor;
	float SpecGloss;
	float EmissiveMask;
	float4 Albedo;
	float4 Normal;
	float3 HalfVec;
	float3 LightVec;
	float3 LightDiffuse;
	float NDotL;
	float3 LightSpecular;
	float3 Diffuse;
	float3 Specular;
	float3 Emissive;
	float3 Reflection;
};



/////////////////////////////////////////////////////////////////////
//PIXEL SHADERS
/////////////////////////////////////////////////////////////////////


void pre_ps_base_uv_PART(inout PGSL_PS_INPUT_rskin_bump_colorize input, inout PGSL_PS_OUTPUT_rskin_bump_colorize output, inout PGSL_PS_SHARED_rskin_bump_colorize shared_vars)
{
	shared_vars.BaseTexUV = input.BaseTexUV;
}



void pre_ps_bump_uv_from_base_uv_PART(inout PGSL_PS_INPUT_rskin_bump_colorize input, inout PGSL_PS_OUTPUT_rskin_bump_colorize output, inout PGSL_PS_SHARED_rskin_bump_colorize shared_vars)
{
	shared_vars.BumpTexUV = input.BaseTexUV;
}



void ps_surface_material_opaque_PART(in PGSL_PS_INPUT_rskin_bump_colorize input, inout PGSL_PS_OUTPUT_rskin_bump_colorize output, inout PGSL_PS_SHARED_rskin_bump_colorize shared_vars)
{
	shared_vars.SurfaceDiffuse = Diffuse;
	shared_vars.SurfaceDiffuse.a = 1;
	
	shared_vars.SurfaceSpecular = Specular.rgb;
}



void ps_surface_emissive_PART(in PGSL_PS_INPUT_rskin_bump_colorize input, inout PGSL_PS_OUTPUT_rskin_bump_colorize output, inout PGSL_PS_SHARED_rskin_bump_colorize shared_vars)
{
	shared_vars.SurfaceEmissive = Emissive.rgb;
}



void ps_specular_constants_PART(in PGSL_PS_INPUT_rskin_bump_colorize input, inout PGSL_PS_OUTPUT_rskin_bump_colorize output, inout PGSL_PS_SHARED_rskin_bump_colorize shared_vars)
{
	// Set up constants that match the data that we get from the specular texture.
	shared_vars.SpecColor = SpecularIntensity*float3(1,1,1);  // no per-pixel spec color
	shared_vars.SpecGloss = SpecularGloss;
	shared_vars.EmissiveMask = 0.0f;
}



void ps_base_texture_colorization_PART(in PGSL_PS_INPUT_rskin_bump_colorize input, inout PGSL_PS_OUTPUT_rskin_bump_colorize output, inout PGSL_PS_SHARED_rskin_bump_colorize shared_vars)
{
	shared_vars.Albedo = PGSL_TEX2D(BaseTexture, BaseTextureSampler, shared_vars.BaseTexUV);
	shared_vars.SurfaceDiffuse.rgb *= shared_vars.Albedo.rgb;
}



void ps_colorization_PART(in PGSL_PS_INPUT_rskin_bump_colorize input, inout PGSL_PS_OUTPUT_rskin_bump_colorize output, inout PGSL_PS_SHARED_rskin_bump_colorize shared_vars)
{
	//assuming that the Albedo's alpha channel contains the colorization lerp factor
	float3 colorization = Colorization.rgb*shared_vars.SurfaceDiffuse.rgb;
	shared_vars.SurfaceDiffuse.rgb = lerp(shared_vars.SurfaceDiffuse.rgb, colorization, shared_vars.Albedo.a);
}



void ps_bump_specular_map_PART(in PGSL_PS_INPUT_rskin_bump_colorize input, inout PGSL_PS_OUTPUT_rskin_bump_colorize output, inout PGSL_PS_SHARED_rskin_bump_colorize shared_vars)
{
	//Thanh - 02/09/2010 fetching normal map with bi-linear filtering
	//actually implies that we need to re-normalize our normal
	//but we are not seeing notice-able artifacts from not normalizing it
	//so we can dodge the bullet and save us a bit of time here!
	//fetch normal from bump map
	float4 normal_texel = PGSL_TEX2D(NormalTexture, NormalTextureSampler, shared_vars.BumpTexUV);
	//scale to [-1, 1]
	shared_vars.Normal.xyz = (normal_texel.rgb - 0.5)*2.0;

	//alpha channel of normal texel is the specular map factor
	shared_vars.SpecColor *= normal_texel.a;
}



void ps_phong_vectors_bump_PART(in PGSL_PS_INPUT_rskin_bump_colorize input, inout PGSL_PS_OUTPUT_rskin_bump_colorize output, inout PGSL_PS_SHARED_rskin_bump_colorize shared_vars)
{
	shared_vars.LightVec = normalize(input.LightVec);
	shared_vars.HalfVec = normalize(input.HalfVec);
}



void ps_phong_diffuse_PART(in PGSL_PS_INPUT_rskin_bump_colorize input, inout PGSL_PS_OUTPUT_rskin_bump_colorize output, inout PGSL_PS_SHARED_rskin_bump_colorize shared_vars)
{
	shared_vars.NDotL = dot(shared_vars.Normal.xyz, shared_vars.LightVec);
	shared_vars.LightDiffuse.rgb += saturate(shared_vars.NDotL)*g_Light0Diffuse.rgb;
}



void ps_phong_spec_pp_PART(in PGSL_PS_INPUT_rskin_bump_colorize input, inout PGSL_PS_OUTPUT_rskin_bump_colorize output, inout PGSL_PS_SHARED_rskin_bump_colorize shared_vars)
{
	float ndoth = saturate(dot(shared_vars.Normal.xyz, shared_vars.HalfVec));
	float spec_power = pow(256,shared_vars.SpecGloss) + 16;
	float spec_light = pow(ndoth, spec_power);
	
	// Normalization:
	spec_light *= (spec_power + 1) / 8;
	
	// equations from the LPP
	float3 diffuse = g_Light0Diffuse.rgb; //*g_Light0Diffuse.aaa; not used in fwd renderer...
	float3 specular = spec_light*g_Light0Specular.a*diffuse;
	spec_light = dot(LumVec, specular);
				
	float diffuse_lum = dot(LumVec, shared_vars.LightDiffuse.rgb);
	float chromaticity = spec_light / (diffuse_lum + Epsilon);
	
	//shared_vars.LightSpecular.rgb = spec_light * shared_vars.SpecColor; // *spec_light;
	shared_vars.LightSpecular.rgb += shared_vars.SpecColor*chromaticity*shared_vars.LightDiffuse.rgb;
}

//sampling the shadow map from a floating texture using 
//non-hw instruction for depth compare
float Sample_Shadowmap_2x2_Pcf_Non_Hw(in float4 shadow_coords)
{
	float shadow = 0;
	float pixel_depth = shadow_coords.z/shadow_coords.w;
	float2 proj_uv = shadow_coords.xy/shadow_coords.w;
	float2 uv;
	float sm_depth;
	
	uv = proj_uv + float2(0.5, 0.5)*g_ShadowmapInverseResolution.xy;
	sm_depth = PGSL_TEX2D(Shadowmap, ShadowmapSampler, uv).r;
	shadow += (sm_depth PGSL_COMP_GREATER_EQUAL pixel_depth);
	
	uv = proj_uv + float2(0.5, -0.5)*g_ShadowmapInverseResolution.xy;
	sm_depth = PGSL_TEX2D(Shadowmap, ShadowmapSampler, uv).r;
	shadow += (sm_depth PGSL_COMP_GREATER_EQUAL pixel_depth);
	
	uv = proj_uv + float2(-0.5, -0.5)*g_ShadowmapInverseResolution.xy;
	sm_depth = PGSL_TEX2D(Shadowmap, ShadowmapSampler, uv).r;
	shadow += (sm_depth PGSL_COMP_GREATER_EQUAL pixel_depth);
	
	uv = proj_uv + float2(-0.5, 0.5)*g_ShadowmapInverseResolution.xy;
	sm_depth = PGSL_TEX2D(Shadowmap, ShadowmapSampler, uv).r;
	shadow += (sm_depth PGSL_COMP_GREATER_EQUAL pixel_depth);
	
	shadow *= 0.25;
	
	return shadow;
}

//sample the shadow map from a hw depth texture using hw depth compare instruction
//depth/slop biasing is assumed to be done through the depth buffer
float Sample_Shadowmap_2x2_Pcf_Hw_Nvidia(in float4 shadow_coords)
{
	float shadow = 0;
	
	float4 uv;
	uv = shadow_coords + (float4(0.5, 0.5, 0, 0)*g_ShadowmapInverseResolution)*shadow_coords.w;
	shadow += PGSL_TEX2D_PROJ(Shadowmap, ShadowmapSampler, uv).r;
	
	uv = shadow_coords + (float4(0.5, -0.5, 0, 0)*g_ShadowmapInverseResolution)*shadow_coords.w;
	shadow += PGSL_TEX2D_PROJ(Shadowmap, ShadowmapSampler, uv).r;
	
	uv = shadow_coords + (float4(-0.5, -0.5, 0, 0)*g_ShadowmapInverseResolution)*shadow_coords.w;
	shadow += PGSL_TEX2D_PROJ(Shadowmap, ShadowmapSampler, uv).r;
	
	uv = shadow_coords + (float4(-0.5, 0.5, 0, 0)*g_ShadowmapInverseResolution)*shadow_coords.w;
	shadow += PGSL_TEX2D_PROJ(Shadowmap, ShadowmapSampler, uv).r;
	
	shadow *= 0.25;
	
	return shadow;
}

//sample the shadow map from a hw depth texture using fetch4
//depth/slop biasing is assumed to be done through the depth buffer
float Sample_Shadowmap_2x2_Pcf_Hw_Ati(in float4 shadow_coords)
{
	float pixel_depth = shadow_coords.z/shadow_coords.w;
	float4 shadowmap_vals = PGSL_TEX2D_PROJ(Shadowmap, ShadowmapSampler, shadow_coords).rgba;
	  
	float4 shadow = (shadowmap_vals PGSL_COMP_GREATER_EQUAL pixel_depth.xxxx);
	
	return dot(shadow, float4(0.25, 0.25, 0.25, 0.25));
}

float Sample_Shadowmap_2x2_Pcf(in float4 shadow_coords)
{
	float shadow = 0;
	
#if defined(PGSL_DX9)
#if defined(NVIDIA)
	shadow = Sample_Shadowmap_2x2_Pcf_Hw_Nvidia(shadow_coords);
#elif defined(ATI)
	shadow = Sample_Shadowmap_2x2_Pcf_Hw_Ati(shadow_coords);
#else
	shadow = Sample_Shadowmap_2x2_Pcf_Non_Hw(shadow_coords);
#endif
#elif defined(PGSL_DX10)
	shadow = Sample_Shadowmap_2x2_Pcf_Non_Hw(shadow_coords);
#elif defined(PGSL_DX11)
	shadow = Sample_Shadowmap_2x2_Pcf_Non_Hw(shadow_coords);
#elif defined(PGSL_XBOX360)
	shadow = Sample_Shadowmap_2x2_Pcf_Non_Hw(shadow_coords);
#elif defined(PGSL_PS3)
#endif
	
	return lerp(shadow, 1.0, g_ShadowBias);
}

void ps_2x2_pcf_shadow_PART(in PGSL_PS_INPUT_rskin_bump_colorize input, inout PGSL_PS_OUTPUT_rskin_bump_colorize output, inout PGSL_PS_SHARED_rskin_bump_colorize shared_vars)
{
#if defined(PGSL_MAX)
#else
	float shadow = Sample_Shadowmap_2x2_Pcf(input.ShadowmapTexcoords);

	shared_vars.LightDiffuse *= shadow;
	shared_vars.LightSpecular *= shadow;
#endif
}



void ps_vertex_diffuse_PART(in PGSL_PS_INPUT_rskin_bump_colorize input, inout PGSL_PS_OUTPUT_rskin_bump_colorize output, inout PGSL_PS_SHARED_rskin_bump_colorize shared_vars)
{
	shared_vars.LightDiffuse.rgb += input.Diffuse.rgb;
}



void ps_lightfield_PART(in PGSL_PS_INPUT_rskin_bump_colorize input, inout PGSL_PS_OUTPUT_rskin_bump_colorize output, inout PGSL_PS_SHARED_rskin_bump_colorize shared_vars)
{
	//Get the lighting in the light field plane
	float4 lf_texel = PGSL_TEX2D(LightFieldTexture, LightFieldTextureSampler, input.LightFieldTexcoords.xy);

	//Capped Cylinder Z-attenuation:
	//"top" of the light is lf_texel.a and the lighting is zero at that point light 
	//intensity grows up to 1.0 over the z attenuation range and then stays at 1.0 all the
	//way to negative infinity.
	//float zdist = lf_texel.a - input.LightFieldTexcoords.z;
	//float atten = saturate(zdist*LF_NORM_Z_ATTEN_INV);

	// GTH - LightField code still assumes LDR rendering, scale up a bit
	// so light sources aren't completely lost in Victory and GOO.  
	// TODO: HDR LightField, probably a 2-3 day task...
	shared_vars.LightDiffuse.rgb += 4.0f * lf_texel.rgb; // += lf_texel.rgb; //*atten; 
}



void ps_lightscale_PART(in PGSL_PS_INPUT_rskin_bump_colorize input, inout PGSL_PS_OUTPUT_rskin_bump_colorize output, inout PGSL_PS_SHARED_rskin_bump_colorize shared_vars)
{
	shared_vars.LightDiffuse.rgb *= g_LightScale.rgb;
	shared_vars.SurfaceDiffuse.a *= g_LightScale.a;
}



void ps_compose_lighting_PART(in PGSL_PS_INPUT_rskin_bump_colorize input, inout PGSL_PS_OUTPUT_rskin_bump_colorize output, inout PGSL_PS_SHARED_rskin_bump_colorize shared_vars)
{
	shared_vars.Diffuse = shared_vars.SurfaceDiffuse.rgb*shared_vars.LightDiffuse;
	shared_vars.Specular = shared_vars.SurfaceSpecular*shared_vars.LightSpecular;
	output.Color0.rgb = shared_vars.Diffuse.rgb + shared_vars.Specular.rgb + shared_vars.Emissive.rgb + shared_vars.Reflection.rgb;
	output.Color0.a = shared_vars.SurfaceDiffuse.a;

	//output.Color0.rgb = shared_vars.Specular.rgb + shared_vars.Diffuse.rgb;
	//output.Color0.rgb = shared_vars.Diffuse.rgb;
	//output.Color0.rgb = shared_vars.Diffuse.rgb;
	//output.Color0.rgb = shared_vars.LightSpecular.rgb;
	//output.Color0.rgb = shared_vars.Reflection.rgb;
	//output.Color0.rgb = float3(shared_vars.SpecGloss,shared_vars.SpecGloss,shared_vars.SpecGloss);
}



void ps_emissive_PART(in PGSL_PS_INPUT_rskin_bump_colorize input, inout PGSL_PS_OUTPUT_rskin_bump_colorize output, inout PGSL_PS_SHARED_rskin_bump_colorize shared_vars)
{
	output.Color0.rgb += (shared_vars.SurfaceEmissive.rgb*shared_vars.Albedo.rgb);
}



void ps_fow_PART(in PGSL_PS_INPUT_rskin_bump_colorize input, inout PGSL_PS_OUTPUT_rskin_bump_colorize output, inout PGSL_PS_SHARED_rskin_bump_colorize shared_vars)
 {
#if !defined(PGSL_MAX)
	
	 float4 fow_texel = PGSL_TEX2D(FowTexture, FowTextureSampler, input.FowCloudTexcoords.xy);
	 float lum = dot(output.Color0.rgb, LumVec);
	 output.Color0.rgb = lerp(fow_texel.rgb*lum.xxx, output.Color0.rgb, fow_texel.a);
	
#endif
 }



void ps_fog_PART(in PGSL_PS_INPUT_rskin_bump_colorize input, inout PGSL_PS_OUTPUT_rskin_bump_colorize output, inout PGSL_PS_SHARED_rskin_bump_colorize shared_vars)
{
	output.Color0.rgb = lerp(g_FogColor.rgb, output.Color0.rgb, input.Fog);
}

PGSL_PS_OUTPUT_rskin_bump_colorize pass_ps_PGSL_PS_MAIN_rskin_bump_colorize(PGSL_PS_INPUT_rskin_bump_colorize meta_shader_in)
{
	PGSL_PS_OUTPUT_rskin_bump_colorize meta_shader_out = (PGSL_PS_OUTPUT_rskin_bump_colorize)0;
	PGSL_PS_SHARED_rskin_bump_colorize meta_shader_shared = (PGSL_PS_SHARED_rskin_bump_colorize)0;
	pre_ps_base_uv_PART(meta_shader_in, meta_shader_out, meta_shader_shared);
	pre_ps_bump_uv_from_base_uv_PART(meta_shader_in, meta_shader_out, meta_shader_shared);
	ps_surface_material_opaque_PART(meta_shader_in, meta_shader_out, meta_shader_shared);
	ps_surface_emissive_PART(meta_shader_in, meta_shader_out, meta_shader_shared);
	ps_specular_constants_PART(meta_shader_in, meta_shader_out, meta_shader_shared);
	ps_base_texture_colorization_PART(meta_shader_in, meta_shader_out, meta_shader_shared);
	ps_colorization_PART(meta_shader_in, meta_shader_out, meta_shader_shared);
	ps_bump_specular_map_PART(meta_shader_in, meta_shader_out, meta_shader_shared);
	ps_phong_vectors_bump_PART(meta_shader_in, meta_shader_out, meta_shader_shared);
	ps_phong_diffuse_PART(meta_shader_in, meta_shader_out, meta_shader_shared);
	ps_phong_spec_pp_PART(meta_shader_in, meta_shader_out, meta_shader_shared);
	ps_2x2_pcf_shadow_PART(meta_shader_in, meta_shader_out, meta_shader_shared);
	ps_vertex_diffuse_PART(meta_shader_in, meta_shader_out, meta_shader_shared);
	ps_lightfield_PART(meta_shader_in, meta_shader_out, meta_shader_shared);
	ps_lightscale_PART(meta_shader_in, meta_shader_out, meta_shader_shared);
	ps_compose_lighting_PART(meta_shader_in, meta_shader_out, meta_shader_shared);
	ps_emissive_PART(meta_shader_in, meta_shader_out, meta_shader_shared);
	ps_fow_PART(meta_shader_in, meta_shader_out, meta_shader_shared);
	ps_fog_PART(meta_shader_in, meta_shader_out, meta_shader_shared);
	return meta_shader_out;
}



/////////////////////////////////////////////////////////////////////
//SHADER'S PASSES
/////////////////////////////////////////////////////////////////////
PGSL_TECHNIQUE_BEGIN
	PGSL_PASS_BEGIN(pass_0, 
	<
		string _RasterizeState_ = "ALRS_DEFAULT";string _BlendState_ = "ALBS_ALPHA_BLEND_ALPHA_SCRIPTING";string _DepthStencilState_ = "ALDS_DEPTHLESSEQUALWRITE_STENCILDISABLE";bool EnableAlphaScripting = true;
	>)
		PGSL_PASS_VS(pass_vs_PGSL_VS_MAIN_rskin_bump_colorize, 1)
		PGSL_PASS_PS(pass_ps_PGSL_PS_MAIN_rskin_bump_colorize, 1)
	PGSL_PASS_END
PGSL_TECHNIQUE_END



