//////////////////////////////////////////////////////////////////////////////////////////////////////////
//
//Petroglyph Confidential Source Code -- Do Not Distribute
//
// (Auto generated by PGSLCodeGenerator)
//Platform: MAX
//////////////////////////////////////////////////////////////////////////////////////////////////////////
#define PGSL_MAX
#define PGSL_DX9
#include"..\common\PGSLAlways.pgh"
#include"..\common\AlamoEngine.pgh"

float g_ShaderFileDummyVariable : SHADER_FILE_ANNOTATION
<
string _ALAMO_RENDER_PHASE = "Transparent";
string _ALAMO_VERTEX_PROC = "Billboards";
string _ALAMO_VERTEX_TYPE = "alD3dVertBillboard";
bool _ALAMO_TANGENT_SPACE = false;
bool _ALAMO_Z_SORT = false;
bool _ALAMO_BILLBOARDS = true;
>;

#define PGSL_PS_INPUT_billboard_additive PGSL_VS_OUTPUT_billboard_additive



/////////////////////////////////////////////////////////////////////
//VERTEX SHADER INPUTS
/////////////////////////////////////////////////////////////////////
float4 Color
<
string UIName = "Color";
string UIType = "ColorSwatch";
bool GammaCorrect = true;
>
 = {1, 1, 1, 1};

struct PGSL_VS_INPUT_billboard_additive
{
	float3 Pos  : PGSL_POSITION;
	PGSL_PACKED_FLOAT4 Normal  : PGSL_NORMAL;
	PGSL_PACKED_FLOAT2 BaseTexUV  : PGSL_TEXCOORD0;
	float3 BillboardCenter  : PGSL_TEXCOORD1;
};



/////////////////////////////////////////////////////////////////////
//VERTEX SHADER OUTPUTS
/////////////////////////////////////////////////////////////////////
struct PGSL_VS_OUTPUT_billboard_additive
{
	float4 Pos  : PGSL_SV_POSITION;
	float2 BaseTexUV  : PGSL_TEXCOORD0;
	float4 FowCloudTexcoords  : PGSL_TEXCOORD1;
	float4 Diffuse  : PGSL_TEXCOORD2;
};



/////////////////////////////////////////////////////////////////////
//VERTEX SHADER SHARED STRUCT
/////////////////////////////////////////////////////////////////////
struct PGSL_VS_SHARED_billboard_additive
{
	float4x4 World;
	float4 Pos;
	float3 Normal;
	float2 BaseTexUV;
	float4 SurfaceDiffuse;
	float3 SurfaceSpecular;
	float4 WorldPos;
	float3 LightDiffuse;
	float3 Diffuse;
};



/////////////////////////////////////////////////////////////////////
//VERTEX SHADERS
/////////////////////////////////////////////////////////////////////


void pre_vs_world_PART(inout PGSL_VS_INPUT_billboard_additive input, inout PGSL_VS_OUTPUT_billboard_additive output, inout PGSL_VS_SHARED_billboard_additive shared_vars)
{
	shared_vars.World = g_World;
}



void pre_vs_position_PART(inout PGSL_VS_INPUT_billboard_additive input, inout PGSL_VS_OUTPUT_billboard_additive output, inout PGSL_VS_SHARED_billboard_additive shared_vars)
{
	shared_vars.Pos = float4(input.Pos.xyz, 1.0);
}



void pre_vs_unpack_normal_PART(inout PGSL_VS_INPUT_billboard_additive input, inout PGSL_VS_OUTPUT_billboard_additive output, inout PGSL_VS_SHARED_billboard_additive shared_vars)
{
	shared_vars.Normal.xyz = Unpack_Normal(input.Normal.xyz);
}



void pre_vs_unpack_base_uv_PART(inout PGSL_VS_INPUT_billboard_additive input, inout PGSL_VS_OUTPUT_billboard_additive output, inout PGSL_VS_SHARED_billboard_additive shared_vars)
{
	shared_vars.BaseTexUV = Unpack_UV(input.BaseTexUV);
}



void vs_identity_surface_material_PART(in PGSL_VS_INPUT_billboard_additive input, inout PGSL_VS_OUTPUT_billboard_additive output, inout PGSL_VS_SHARED_billboard_additive shared_vars)
{
	shared_vars.SurfaceDiffuse = float4(1, 1, 1, 1);
	shared_vars.SurfaceSpecular = float3(1, 1, 1);
}

#if defined(PGSL_MAX)
#define DO_GEOMETRY_MODS 0
#else
#define DO_GEOMETRY_MODS 1
#endif

void vs_billboard_PART(in PGSL_VS_INPUT_billboard_additive input, inout PGSL_VS_OUTPUT_billboard_additive output, inout PGSL_VS_SHARED_billboard_additive shared_vars)
{
#if DO_GEOMETRY_MODS
	//transform the billboard center to world space
	float3 bb_center_world = mul(float4(input.BillboardCenter, 1), shared_vars.World).xyz;
	
	/////////////////////////////////////////////////////////
	//Compute billboard transform
	//'up' is camera z vector
	//'normal' is camera y vector
	/////////////////////////////////////////////////////////
	//bb_tm, takes points from "billboard space" to "world space" 
	//position = billboard_center, axes aligned to make the -Y axis point at the camera (per Max convention for "forward")
	float4x4 bb_tm = float4x4(g_ViewInv[0], g_ViewInv[2], g_ViewInv[1], float4(bb_center_world, 1));
	
	/////////////////////////////////////////////////////////
	//Billboard and distort the geometry
	//- offset each clump to match the tree shader bending
	//- billboard each clump to face camera
	//- 2d rotate/sway each clump for wind effect
	/////////////////////////////////////////////////////////
	
	float3 bb_vert = shared_vars.Pos.xyz - input.BillboardCenter;
	float4 world_pos = mul(float4(bb_vert, 1), bb_tm);
	output.Pos = mul(world_pos, g_ViewProj);
	
	//save world pos
	shared_vars.WorldPos = world_pos;
	
	//Thanh - 03/04/2009 billboard is a special case of a
	//part that does vertex transformation but doesn't save
	//off the billboard/world transform since subsequent
	//parts actually want the global world transform
	//save world xform
	//shared_vars.World = bb_tm;
#else
	float4 world_pos = mul(shared_vars.Pos, shared_vars.World);
	output.Pos = mul(shared_vars.Pos, g_WorldViewProj);
	
	//save world pos
	shared_vars.WorldPos = world_pos;
#endif
}



void vs_base_uv_PART(in PGSL_VS_INPUT_billboard_additive input, inout PGSL_VS_OUTPUT_billboard_additive output, inout PGSL_VS_SHARED_billboard_additive shared_vars)
{
	output.BaseTexUV = shared_vars.BaseTexUV;
}



void vs_fow_uv_PART(in PGSL_VS_INPUT_billboard_additive input, inout PGSL_VS_OUTPUT_billboard_additive output, inout PGSL_VS_SHARED_billboard_additive shared_vars)
{
	output.FowCloudTexcoords.x = dot(g_FowTexU, shared_vars.WorldPos);
	output.FowCloudTexcoords.y = dot(g_FowTexV, shared_vars.WorldPos);
}



void vs_solid_color_modulate_PART(in PGSL_VS_INPUT_billboard_additive input, inout PGSL_VS_OUTPUT_billboard_additive output, inout PGSL_VS_SHARED_billboard_additive shared_vars)
{
	//compute final vertex color and save it off
	shared_vars.SurfaceDiffuse *= Color;
}



void vs_lightscale_additive_PART(in PGSL_VS_INPUT_billboard_additive input, inout PGSL_VS_OUTPUT_billboard_additive output, inout PGSL_VS_SHARED_billboard_additive shared_vars)
{
  shared_vars.LightDiffuse.rgb *= g_LightScale.rgb;
  shared_vars.SurfaceDiffuse.rgb *= g_LightScale.a;
}



void vs_compose_surface_diffuse_PART(in PGSL_VS_INPUT_billboard_additive input, inout PGSL_VS_OUTPUT_billboard_additive output, inout PGSL_VS_SHARED_billboard_additive shared_vars)
{
	shared_vars.Diffuse = shared_vars.SurfaceDiffuse.rgb;
	output.Diffuse = shared_vars.SurfaceDiffuse;
}

PGSL_VS_OUTPUT_billboard_additive pass_vs_PGSL_VS_MAIN_billboard_additive(PGSL_VS_INPUT_billboard_additive meta_shader_in)
{
	PGSL_VS_OUTPUT_billboard_additive meta_shader_out = (PGSL_VS_OUTPUT_billboard_additive)0;
	PGSL_VS_SHARED_billboard_additive meta_shader_shared = (PGSL_VS_SHARED_billboard_additive)0;
	pre_vs_world_PART(meta_shader_in, meta_shader_out, meta_shader_shared);
	pre_vs_position_PART(meta_shader_in, meta_shader_out, meta_shader_shared);
	pre_vs_unpack_normal_PART(meta_shader_in, meta_shader_out, meta_shader_shared);
	pre_vs_unpack_base_uv_PART(meta_shader_in, meta_shader_out, meta_shader_shared);
	vs_identity_surface_material_PART(meta_shader_in, meta_shader_out, meta_shader_shared);
	vs_billboard_PART(meta_shader_in, meta_shader_out, meta_shader_shared);
	vs_base_uv_PART(meta_shader_in, meta_shader_out, meta_shader_shared);
	vs_fow_uv_PART(meta_shader_in, meta_shader_out, meta_shader_shared);
	vs_solid_color_modulate_PART(meta_shader_in, meta_shader_out, meta_shader_shared);
	vs_lightscale_additive_PART(meta_shader_in, meta_shader_out, meta_shader_shared);
	vs_compose_surface_diffuse_PART(meta_shader_in, meta_shader_out, meta_shader_shared);
	return meta_shader_out;
}















/////////////////////////////////////////////////////////////////////
//PIXEL SHADER INPUTS
/////////////////////////////////////////////////////////////////////
PGSL_TEXTURE2D BaseTexture  : DIFFUSEMAP
<
string UIName = "BaseTexture";
string UIType = "bitmap";
string SamplerEnum = "AL_SAMPLER_UVWRAP_MIN_MAG_MIP_BILINEAR_SRGB";
>
;
PGSL_SAMPLER BaseTextureSampler PGSL_SAMPLER_REG(0)
<
string UIName = "BaseTexture";
string UIType = "bitmap";
string SamplerEnum = "AL_SAMPLER_UVWRAP_MIN_MAG_MIP_BILINEAR_SRGB";
PGSL_BIND_TO_TEXTURE(BaseTexture)
string SamplerRegister = "0";
>
PGSL_SAMPLER_STATE(BaseTexture);

float DayNightEffect
<
string UIName = "DayNightEffect";
string UIMin = "0.0";
string UIMax = "1.0";
>
 = 0.0;

bool IssRGBCorrectBlendingCapable;

PGSL_TEXTURE2D FowTexture
<
string SamplerEnum = "AL_SAMPLER_UVCLAMP_MIN_MAG_MIP_BILINEAR_SRGB";
>
;
PGSL_SAMPLER FowTextureSampler PGSL_SAMPLER_REG(1)
<
string SamplerEnum = "AL_SAMPLER_UVCLAMP_MIN_MAG_MIP_BILINEAR_SRGB";
PGSL_BIND_TO_TEXTURE(FowTexture)
string SamplerRegister = "1";
>
PGSL_SAMPLER_STATE(FowTexture);




/////////////////////////////////////////////////////////////////////
//PIXEL SHADER OUTPUTS
/////////////////////////////////////////////////////////////////////
struct PGSL_PS_OUTPUT_billboard_additive
{
	float4 Color0  : PGSL_TARGET0;
};



/////////////////////////////////////////////////////////////////////
//PIXEL SHADER SHARED STRUCT
/////////////////////////////////////////////////////////////////////
struct PGSL_PS_SHARED_billboard_additive
{
	float2 BaseTexUV;
	float4 SurfaceDiffuse;
	float3 SurfaceSpecular;
	float4 Albedo;
	float3 LightDiffuse;
	float3 Diffuse;
};



/////////////////////////////////////////////////////////////////////
//PIXEL SHADERS
/////////////////////////////////////////////////////////////////////


void pre_ps_base_uv_PART(inout PGSL_PS_INPUT_billboard_additive input, inout PGSL_PS_OUTPUT_billboard_additive output, inout PGSL_PS_SHARED_billboard_additive shared_vars)
{
	shared_vars.BaseTexUV = input.BaseTexUV;
}



void ps_identity_surface_material_PART(in PGSL_PS_INPUT_billboard_additive input, inout PGSL_PS_OUTPUT_billboard_additive output, inout PGSL_PS_SHARED_billboard_additive shared_vars)
{
	shared_vars.SurfaceDiffuse = float4(1, 1, 1, 1);
	shared_vars.SurfaceSpecular = float3(1, 1, 1);
}



void ps_base_texture_PART(in PGSL_PS_INPUT_billboard_additive input, inout PGSL_PS_OUTPUT_billboard_additive output, inout PGSL_PS_SHARED_billboard_additive shared_vars)
{
	shared_vars.Albedo = PGSL_TEX2D(BaseTexture, BaseTextureSampler, shared_vars.BaseTexUV);
	shared_vars.SurfaceDiffuse *= shared_vars.Albedo;
}



void ps_vertex_diffuse_PART(in PGSL_PS_INPUT_billboard_additive input, inout PGSL_PS_OUTPUT_billboard_additive output, inout PGSL_PS_SHARED_billboard_additive shared_vars)
{
	shared_vars.LightDiffuse.rgb += input.Diffuse.rgb;
}



void ps_compose_lighting_diffuse_no_2X_PART(in PGSL_PS_INPUT_billboard_additive input, inout PGSL_PS_OUTPUT_billboard_additive output, inout PGSL_PS_SHARED_billboard_additive shared_vars)
{
  shared_vars.Diffuse = shared_vars.SurfaceDiffuse.rgb*shared_vars.LightDiffuse;
  //output the final diffuse color
  output.Color0.rgb = shared_vars.Diffuse.rgb;
  output.Color0.a = shared_vars.SurfaceDiffuse.a;
}



void ps_daynight_PART(in PGSL_PS_INPUT_billboard_additive input, inout PGSL_PS_OUTPUT_billboard_additive output, inout PGSL_PS_SHARED_billboard_additive shared_vars)
{
  //modulate the daynight effect into the current accum diffuse
  float4 day_night_effect = saturate(g_DayNightFactor + (1.0 - DayNightEffect));
  output.Color0 *= day_night_effect;
}



void ps_srgb_blend_fixup_PART(in PGSL_PS_INPUT_billboard_additive input, inout PGSL_PS_OUTPUT_billboard_additive output, inout PGSL_PS_SHARED_billboard_additive shared_vars)
{
	#if !defined (PGSL_DX11) 
	//if we cannot blend sRGB values correctly (like dx10-class cards or above)
	//need to linearize result to compensate for that!
	if(!IssRGBCorrectBlendingCapable)
	{
		output.Color0.rgb *= output.Color0.rgb;
	}
	#endif
}



void ps_fow_PART(in PGSL_PS_INPUT_billboard_additive input, inout PGSL_PS_OUTPUT_billboard_additive output, inout PGSL_PS_SHARED_billboard_additive shared_vars)
 {
#if !defined(PGSL_MAX)
	
	 float4 fow_texel = PGSL_TEX2D(FowTexture, FowTextureSampler, input.FowCloudTexcoords.xy);
	 float lum = dot(output.Color0.rgb, LumVec);
	 output.Color0.rgb = lerp(fow_texel.rgb*lum.xxx, output.Color0.rgb, fow_texel.a);
	
#endif
 }

PGSL_PS_OUTPUT_billboard_additive pass_ps_PGSL_PS_MAIN_billboard_additive(PGSL_PS_INPUT_billboard_additive meta_shader_in)
{
	PGSL_PS_OUTPUT_billboard_additive meta_shader_out = (PGSL_PS_OUTPUT_billboard_additive)0;
	PGSL_PS_SHARED_billboard_additive meta_shader_shared = (PGSL_PS_SHARED_billboard_additive)0;
	pre_ps_base_uv_PART(meta_shader_in, meta_shader_out, meta_shader_shared);
	ps_identity_surface_material_PART(meta_shader_in, meta_shader_out, meta_shader_shared);
	ps_base_texture_PART(meta_shader_in, meta_shader_out, meta_shader_shared);
	ps_vertex_diffuse_PART(meta_shader_in, meta_shader_out, meta_shader_shared);
	ps_compose_lighting_diffuse_no_2X_PART(meta_shader_in, meta_shader_out, meta_shader_shared);
	ps_daynight_PART(meta_shader_in, meta_shader_out, meta_shader_shared);
	ps_srgb_blend_fixup_PART(meta_shader_in, meta_shader_out, meta_shader_shared);
	ps_fow_PART(meta_shader_in, meta_shader_out, meta_shader_shared);
	return meta_shader_out;
}



/////////////////////////////////////////////////////////////////////
//SHADER'S PASSES
/////////////////////////////////////////////////////////////////////
PGSL_TECHNIQUE_BEGIN
	PGSL_PASS_BEGIN(pass_0, 
	<
		string _RasterizeState_ = "ALRS_DEFAULT";string _BlendState_ = "ALBS_ADDITIVE";string _DepthStencilState_ = "ALDS_DEPTHLESSEQUALNOWRITE_STENCILDISABLE";
	>)
		PGSL_PASS_VS(pass_vs_PGSL_VS_MAIN_billboard_additive, 0)
		PGSL_PASS_PS(pass_ps_PGSL_PS_MAIN_billboard_additive, 0)
	PGSL_PASS_END
PGSL_TECHNIQUE_END



