//////////////////////////////////////////////////////////////////////////////////////////////////////////
//
//Petroglyph Confidential Source Code -- Do Not Distribute
//
// (Auto generated by PGSLCodeGenerator)
//Platform: MAX
//////////////////////////////////////////////////////////////////////////////////////////////////////////
#define PGSL_MAX
#define PGSL_DX9
#include"..\common\PGSLAlways.pgh"
#include"..\common\AlamoEngine.pgh"

float g_ShaderFileDummyVariable : SHADER_FILE_ANNOTATION
<
string _ALAMO_RENDER_PHASE = "Water";
string _ALAMO_VERTEX_TYPE = "alD3dVertNU2C";
bool _ALAMO_TANGENT_SPACE = false;
>;

#define PGSL_PS_INPUT_skydome PGSL_VS_OUTPUT_skydome



/////////////////////////////////////////////////////////////////////
//VERTEX SHADER INPUTS
/////////////////////////////////////////////////////////////////////
float CloudScrollRate
<
string UIName = "CloudScrollRate";
string UIType = "MaxSpinner";
float UIMin = -1.0;
float UIMax = 1.0;
>
 = 0.0025;

float CloudScale
<
string UIName = "CloudScale";
string UIType = "MaxSpinner";
float UIMin = 0;
float UIMax = 32.0;
>
 = 0.0025;

struct PGSL_VS_INPUT_skydome
{
	float3 Pos  : PGSL_POSITION;
	float3 Normal  : PGSL_NORMAL;
	float2 BaseTexUV  : PGSL_TEXCOORD0;
	float4 Color  : PGSL_COLOR0;
};



/////////////////////////////////////////////////////////////////////
//VERTEX SHADER OUTPUTS
/////////////////////////////////////////////////////////////////////
struct PGSL_VS_OUTPUT_skydome
{
	float4 Pos  : PGSL_SV_POSITION;
	float2 BaseTexUV  : PGSL_TEXCOORD0;
	float2 CloudTexUV  : PGSL_TEXCOORD1;
	float4 Diffuse  : PGSL_TEXCOORD2;
	float Fog  : PGSL_TEXCOORD3;
};



/////////////////////////////////////////////////////////////////////
//VERTEX SHADER SHARED STRUCT
/////////////////////////////////////////////////////////////////////
struct PGSL_VS_SHARED_skydome
{
	float4x4 World;
	float4 Pos;
	float3 Normal;
	float2 BaseTexUV;
	float4 VertexColor;
	float4 SurfaceDiffuse;
	float3 SurfaceSpecular;
	float4 WorldPos;
	float3 Diffuse;
};



/////////////////////////////////////////////////////////////////////
//VERTEX SHADERS
/////////////////////////////////////////////////////////////////////


void pre_vs_world_PART(inout PGSL_VS_INPUT_skydome input, inout PGSL_VS_OUTPUT_skydome output, inout PGSL_VS_SHARED_skydome shared_vars)
{
	shared_vars.World = g_World;
}



void pre_vs_position_PART(inout PGSL_VS_INPUT_skydome input, inout PGSL_VS_OUTPUT_skydome output, inout PGSL_VS_SHARED_skydome shared_vars)
{
	shared_vars.Pos = float4(input.Pos.xyz, 1.0);
}



void pre_vs_normal_PART(inout PGSL_VS_INPUT_skydome input, inout PGSL_VS_OUTPUT_skydome output, inout PGSL_VS_SHARED_skydome shared_vars)
{
	shared_vars.Normal = input.Normal.xyz;
}



void pre_vs_base_uv_PART(inout PGSL_VS_INPUT_skydome input, inout PGSL_VS_OUTPUT_skydome output, inout PGSL_VS_SHARED_skydome shared_vars)
{
	shared_vars.BaseTexUV = input.BaseTexUV;
}



void pre_vs_vertex_color_PART(inout PGSL_VS_INPUT_skydome input, inout PGSL_VS_OUTPUT_skydome output, inout PGSL_VS_SHARED_skydome shared_vars)
{
	shared_vars.VertexColor = input.Color;
}



void vs_identity_surface_material_PART(in PGSL_VS_INPUT_skydome input, inout PGSL_VS_OUTPUT_skydome output, inout PGSL_VS_SHARED_skydome shared_vars)
{
	shared_vars.SurfaceDiffuse = float4(1, 1, 1, 1);
	shared_vars.SurfaceSpecular = float3(1, 1, 1);
}



void vs_mesh_PART(in PGSL_VS_INPUT_skydome input, inout PGSL_VS_OUTPUT_skydome output, inout PGSL_VS_SHARED_skydome shared_vars)
{
	//xform to projection space
#if defined(PGSL_MAX)
	output.Pos = mul(shared_vars.Pos, g_World);
	output.Pos = mul(output.Pos, g_View);
	output.Pos = mul(output.Pos, g_Proj);
#else
	output.Pos = mul(shared_vars.Pos, g_WorldViewProj);
#endif
	
	//save world pos
	shared_vars.WorldPos = mul(shared_vars.Pos, shared_vars.World);
}



void vs_push_to_far_plane_PART(in PGSL_VS_INPUT_skydome input, inout PGSL_VS_OUTPUT_skydome output, inout PGSL_VS_SHARED_skydome shared_vars)
{
	output.Pos.z = output.Pos.w;
}



void vs_base_uv_PART(in PGSL_VS_INPUT_skydome input, inout PGSL_VS_OUTPUT_skydome output, inout PGSL_VS_SHARED_skydome shared_vars)
{
	output.BaseTexUV = shared_vars.BaseTexUV;
}



void vs_skydome_cloud_uv_PART(in PGSL_VS_INPUT_skydome input, inout PGSL_VS_OUTPUT_skydome output, inout PGSL_VS_SHARED_skydome shared_vars)
{
	//cloud uv coords scroll along the u axis
	output.CloudTexUV = shared_vars.BaseTexUV;
	output.CloudTexUV.x += g_ElapsedTime*CloudScrollRate;
	output.CloudTexUV *= CloudScale;
}



void vs_vertex_alpha_modulate_PART(in PGSL_VS_INPUT_skydome input, inout PGSL_VS_OUTPUT_skydome output, inout PGSL_VS_SHARED_skydome shared_vars)
{
	shared_vars.SurfaceDiffuse.a *= shared_vars.VertexColor.a;
}



void vs_compose_surface_diffuse_PART(in PGSL_VS_INPUT_skydome input, inout PGSL_VS_OUTPUT_skydome output, inout PGSL_VS_SHARED_skydome shared_vars)
{
	shared_vars.Diffuse = shared_vars.SurfaceDiffuse.rgb;
	output.Diffuse = shared_vars.SurfaceDiffuse;
}



void vs_skydome_fog_PART(in PGSL_VS_INPUT_skydome input, inout PGSL_VS_OUTPUT_skydome output, inout PGSL_VS_SHARED_skydome shared_vars)
{
	output.Fog = saturate((1.0 - g_FogValues.z));
}

PGSL_VS_OUTPUT_skydome pass_vs_PGSL_VS_MAIN_skydome(PGSL_VS_INPUT_skydome meta_shader_in)
{
	PGSL_VS_OUTPUT_skydome meta_shader_out = (PGSL_VS_OUTPUT_skydome)0;
	PGSL_VS_SHARED_skydome meta_shader_shared = (PGSL_VS_SHARED_skydome)0;
	pre_vs_world_PART(meta_shader_in, meta_shader_out, meta_shader_shared);
	pre_vs_position_PART(meta_shader_in, meta_shader_out, meta_shader_shared);
	pre_vs_normal_PART(meta_shader_in, meta_shader_out, meta_shader_shared);
	pre_vs_base_uv_PART(meta_shader_in, meta_shader_out, meta_shader_shared);
	pre_vs_vertex_color_PART(meta_shader_in, meta_shader_out, meta_shader_shared);
	vs_identity_surface_material_PART(meta_shader_in, meta_shader_out, meta_shader_shared);
	vs_mesh_PART(meta_shader_in, meta_shader_out, meta_shader_shared);
	vs_push_to_far_plane_PART(meta_shader_in, meta_shader_out, meta_shader_shared);
	vs_base_uv_PART(meta_shader_in, meta_shader_out, meta_shader_shared);
	vs_skydome_cloud_uv_PART(meta_shader_in, meta_shader_out, meta_shader_shared);
	vs_vertex_alpha_modulate_PART(meta_shader_in, meta_shader_out, meta_shader_shared);
	vs_compose_surface_diffuse_PART(meta_shader_in, meta_shader_out, meta_shader_shared);
	vs_skydome_fog_PART(meta_shader_in, meta_shader_out, meta_shader_shared);
	return meta_shader_out;
}















/////////////////////////////////////////////////////////////////////
//PIXEL SHADER INPUTS
/////////////////////////////////////////////////////////////////////
PGSL_TEXTURE2D BaseTexture  : DIFFUSEMAP
<
string UIName = "BaseTexture";
string UIType = "bitmap";
string SamplerEnum = "AL_SAMPLER_UVWRAP_MIN_MAG_MIP_BILINEAR_SRGB";
>
;
PGSL_SAMPLER BaseTextureSampler PGSL_SAMPLER_REG(0)
<
string UIName = "BaseTexture";
string UIType = "bitmap";
string SamplerEnum = "AL_SAMPLER_UVWRAP_MIN_MAG_MIP_BILINEAR_SRGB";
PGSL_BIND_TO_TEXTURE(BaseTexture)
string SamplerRegister = "0";
>
PGSL_SAMPLER_STATE(BaseTexture);

PGSL_TEXTURE2D CloudTexture
<
string UIName = "CloudTexture";
string UIType = "bitmap";
string SamplerEnum = "AL_SAMPLER_UVWRAP_MIN_MAG_MIP_BILINEAR_SRGB";
>
;
PGSL_SAMPLER CloudTextureSampler PGSL_SAMPLER_REG(1)
<
string UIName = "CloudTexture";
string UIType = "bitmap";
string SamplerEnum = "AL_SAMPLER_UVWRAP_MIN_MAG_MIP_BILINEAR_SRGB";
PGSL_BIND_TO_TEXTURE(CloudTexture)
string SamplerRegister = "1";
>
PGSL_SAMPLER_STATE(CloudTexture);




/////////////////////////////////////////////////////////////////////
//PIXEL SHADER OUTPUTS
/////////////////////////////////////////////////////////////////////
struct PGSL_PS_OUTPUT_skydome
{
	float4 Color0  : PGSL_TARGET0;
};



/////////////////////////////////////////////////////////////////////
//PIXEL SHADER SHARED STRUCT
/////////////////////////////////////////////////////////////////////
struct PGSL_PS_SHARED_skydome
{
};



/////////////////////////////////////////////////////////////////////
//PIXEL SHADERS
/////////////////////////////////////////////////////////////////////


void ps_skydome_PART(in PGSL_PS_INPUT_skydome input, inout PGSL_PS_OUTPUT_skydome output, inout PGSL_PS_SHARED_skydome shared_vars)
{
	float4 base_texel = PGSL_TEX2D(BaseTexture, BaseTextureSampler, input.BaseTexUV);
	float4 cloud_texel = PGSL_TEX2D(CloudTexture, CloudTextureSampler, input.CloudTexUV);
	
	float3 color = lerp(base_texel.rgb, cloud_texel.rgb, cloud_texel.a*input.Diffuse.a);
	output.Color0.rgb = color*input.Diffuse.rgb;
	output.Color0.a = input.Diffuse.a;
}



void ps_fog_PART(in PGSL_PS_INPUT_skydome input, inout PGSL_PS_OUTPUT_skydome output, inout PGSL_PS_SHARED_skydome shared_vars)
{
	output.Color0.rgb = lerp(g_FogColor.rgb, output.Color0.rgb, input.Fog);
}

PGSL_PS_OUTPUT_skydome pass_ps_PGSL_PS_MAIN_skydome(PGSL_PS_INPUT_skydome meta_shader_in)
{
	PGSL_PS_OUTPUT_skydome meta_shader_out = (PGSL_PS_OUTPUT_skydome)0;
	PGSL_PS_SHARED_skydome meta_shader_shared = (PGSL_PS_SHARED_skydome)0;
	ps_skydome_PART(meta_shader_in, meta_shader_out, meta_shader_shared);
	ps_fog_PART(meta_shader_in, meta_shader_out, meta_shader_shared);
	return meta_shader_out;
}



/////////////////////////////////////////////////////////////////////
//SHADER'S PASSES
/////////////////////////////////////////////////////////////////////
PGSL_TECHNIQUE_BEGIN
	PGSL_PASS_BEGIN(pass_0, 
	<
		string _RasterizeState_ = "ALRS_DEFAULT";string _BlendState_ = "ALBS_NONE";string _DepthStencilState_ = "ALDS_DEPTHLESSEQUALNOWRITE_STENCILDISABLE";
	>)
		PGSL_PASS_VS(pass_vs_PGSL_VS_MAIN_skydome, 0)
		PGSL_PASS_PS(pass_ps_PGSL_PS_MAIN_skydome, 0)
	PGSL_PASS_END
PGSL_TECHNIQUE_END



