//////////////////////////////////////////////////////////////////////////////////////////////////////////
//
//Petroglyph Confidential Source Code -- Do Not Distribute
//
// (Auto generated by PGSLCodeGenerator)
//Platform: MAX
//////////////////////////////////////////////////////////////////////////////////////////////////////////
#define PGSL_MAX
#define PGSL_DX9
#include"..\common\PGSLAlways.pgh"
#include"..\common\AlamoEngine.pgh"
#include"..\common\AlamoEngine_Skinning.pgh"

float g_ShaderFileDummyVariable : SHADER_FILE_ANNOTATION
<
string _ALAMO_RENDER_PHASE = "Transparent";
string _ALAMO_VERTEX_PROC = "Skin";
string _ALAMO_VERTEX_TYPE = "alD3dVertB4I4NU2U3U3C";
bool _ALAMO_TANGENT_SPACE = true;
int _ALAMO_BONES_PER_VERTEX = 4;
>;

#define PGSL_PS_INPUT_skin_water PGSL_VS_OUTPUT_skin_water



/////////////////////////////////////////////////////////////////////
//VERTEX SHADER INPUTS
/////////////////////////////////////////////////////////////////////
float4 UVScrollRates
<
string UIName = "UVScrollRates";
>
 = {0, 0, 0, 0};

struct PGSL_VS_INPUT_skin_water
{
	float3 Pos  : PGSL_POSITION;
	float4 BlendWeights  : PGSL_BLENDWEIGHTS;
	PGSL_PACKED_FLOAT4 BlendIndices  : PGSL_BLENDINDICES;
	float3 Normal  : PGSL_NORMAL;
	float2 BaseTexUV  : PGSL_TEXCOORD0;
	float3 Tangent  : PGSL_TANGENT;
	float3 Bitangent  : PGSL_BITANGENT;
	float4 Color  : PGSL_COLOR0;
};



/////////////////////////////////////////////////////////////////////
//VERTEX SHADER OUTPUTS
/////////////////////////////////////////////////////////////////////
struct PGSL_VS_OUTPUT_skin_water
{
	float4 Pos  : PGSL_SV_POSITION;
	float4 BaseTexUV  : PGSL_TEXCOORD0;
	float3 ViewVec  : PGSL_TEXCOORD1;
	float4 LightFieldTexcoords  : PGSL_TEXCOORD2;
	float4 FowCloudTexcoords  : PGSL_TEXCOORD3;
	float3 WorldToTangentXBasis  : PGSL_TEXCOORD4;
	float3 WorldToTangentYBasis  : PGSL_TEXCOORD5;
	float3 WorldToTangentZBasis  : PGSL_TEXCOORD6;
	float4 VertexColor  : PGSL_COLOR0;
	float4 Diffuse  : PGSL_TEXCOORD7;
	float Fog  : PGSL_TEXCOORD8;
};



/////////////////////////////////////////////////////////////////////
//VERTEX SHADER SHARED STRUCT
/////////////////////////////////////////////////////////////////////
struct PGSL_VS_SHARED_skin_water
{
	float4 Pos;
	float4 BlendWeights;
	int4 BlendIndices;
	float3 Normal;
	float2 BaseTexUV;
	float3 Tangent;
	float3 Bitangent;
	float4 VertexColor;
	float4 SurfaceDiffuse;
	float3 SurfaceSpecular;
	float4 WorldPos;
	float4x4 World;
	float3 LightDiffuse;
	float3 LightSpecular;
	float3 Diffuse;
};



/////////////////////////////////////////////////////////////////////
//VERTEX SHADERS
/////////////////////////////////////////////////////////////////////


void pre_vs_position_PART(inout PGSL_VS_INPUT_skin_water input, inout PGSL_VS_OUTPUT_skin_water output, inout PGSL_VS_SHARED_skin_water shared_vars)
{
	shared_vars.Pos = float4(input.Pos.xyz, 1.0);
}



void pre_vs_skin_PART(inout PGSL_VS_INPUT_skin_water input, inout PGSL_VS_OUTPUT_skin_water output, inout PGSL_VS_SHARED_skin_water shared_vars)
{
	shared_vars.BlendWeights = input.BlendWeights;
	shared_vars.BlendIndices = ConvertSkinIndices(input.BlendIndices);
}



void pre_vs_normal_PART(inout PGSL_VS_INPUT_skin_water input, inout PGSL_VS_OUTPUT_skin_water output, inout PGSL_VS_SHARED_skin_water shared_vars)
{
	shared_vars.Normal = input.Normal.xyz;
}



void pre_vs_base_uv_PART(inout PGSL_VS_INPUT_skin_water input, inout PGSL_VS_OUTPUT_skin_water output, inout PGSL_VS_SHARED_skin_water shared_vars)
{
	shared_vars.BaseTexUV = input.BaseTexUV;
}



void pre_vs_tangent_PART(inout PGSL_VS_INPUT_skin_water input, inout PGSL_VS_OUTPUT_skin_water output, inout PGSL_VS_SHARED_skin_water shared_vars)
{
	shared_vars.Tangent = input.Tangent;
}



void pre_vs_bitangent_PART(inout PGSL_VS_INPUT_skin_water input, inout PGSL_VS_OUTPUT_skin_water output, inout PGSL_VS_SHARED_skin_water shared_vars)
{
	shared_vars.Bitangent = input.Bitangent;
}



void pre_vs_vertex_color_PART(inout PGSL_VS_INPUT_skin_water input, inout PGSL_VS_OUTPUT_skin_water output, inout PGSL_VS_SHARED_skin_water shared_vars)
{
	shared_vars.VertexColor = input.Color;
}



void vs_identity_surface_material_PART(in PGSL_VS_INPUT_skin_water input, inout PGSL_VS_OUTPUT_skin_water output, inout PGSL_VS_SHARED_skin_water shared_vars)
{
	shared_vars.SurfaceDiffuse = float4(1, 1, 1, 1);
	shared_vars.SurfaceSpecular = float3(1, 1, 1);
}



void vs_skin_PART(in PGSL_VS_INPUT_skin_water input, inout PGSL_VS_OUTPUT_skin_water output, inout PGSL_VS_SHARED_skin_water shared_vars)
{
	//skinning
	float4x3 weighted_xform;
#if defined(PGSL_MAX)
	weighted_xform = g_World;
	float3 world_pos = mul(shared_vars.Pos, weighted_xform);
	output.Pos = mul(float4(world_pos, 1.0), g_View);
	output.Pos = mul(output.Pos, g_Proj);
#else
	weighted_xform = shared_vars.BlendWeights[0]*SkinMatrixArray[shared_vars.BlendIndices[0]];
	weighted_xform += shared_vars.BlendWeights[1]*SkinMatrixArray[shared_vars.BlendIndices[1]];
	weighted_xform += shared_vars.BlendWeights[2]*SkinMatrixArray[shared_vars.BlendIndices[2]];
	weighted_xform += shared_vars.BlendWeights[3]*SkinMatrixArray[shared_vars.BlendIndices[3]];
	float3 world_pos = mul(shared_vars.Pos, weighted_xform);
	output.Pos = mul(float4(world_pos, 1.0), g_ViewProj);
#endif
	
	//save world pos
	shared_vars.WorldPos = float4(world_pos, 1.0);
	//save world xform
	shared_vars.World[0] = float4(weighted_xform[0], 0);
	shared_vars.World[1] = float4(weighted_xform[1], 0);
	shared_vars.World[2] = float4(weighted_xform[2], 0);
	shared_vars.World[3] = float4(weighted_xform[3], 1);
}



void vs_water_mesh_PART(in PGSL_VS_INPUT_skin_water input, inout PGSL_VS_OUTPUT_skin_water output, inout PGSL_VS_SHARED_skin_water shared_vars)
{
	//compute uv scroll
	output.BaseTexUV.xy = shared_vars.BaseTexUV.xy + g_ElapsedTime*UVScrollRates.xy;
	output.BaseTexUV.zw = shared_vars.BaseTexUV.xy + g_ElapsedTime*UVScrollRates.zw;
	
	//compute world space view vec (for cubemap reflection later on)
	//Thanh - 07/18/2011 note: normalize(lerp(u, v, s)) is not the same as lerp(normalize(u), normalize(v), s)
	//and is also not the same as normalize(lerp(normalize(u), normalize(v), s))
	output.ViewVec = g_EyePos.xyz - shared_vars.WorldPos.xyz;
}



void vs_lightfield_uv_PART(in PGSL_VS_INPUT_skin_water input, inout PGSL_VS_OUTPUT_skin_water output, inout PGSL_VS_SHARED_skin_water shared_vars)
{
	output.LightFieldTexcoords.xyz = Compute_LightField_Coords_World_Space(shared_vars.WorldPos);
}



void vs_fow_uv_PART(in PGSL_VS_INPUT_skin_water input, inout PGSL_VS_OUTPUT_skin_water output, inout PGSL_VS_SHARED_skin_water shared_vars)
{
	output.FowCloudTexcoords.x = dot(g_FowTexU, shared_vars.WorldPos);
	output.FowCloudTexcoords.y = dot(g_FowTexV, shared_vars.WorldPos);
}



void vs_world_to_tangent_xform_PART(in PGSL_VS_INPUT_skin_water input, inout PGSL_VS_OUTPUT_skin_water output, inout PGSL_VS_SHARED_skin_water shared_vars)
{
	float3x3 xform = (float3x3)shared_vars.World;
	//transform tangent, bitangent and normal into world space
	float3 T = normalize(mul(shared_vars.Tangent, xform));
	float3 B = normalize(mul(shared_vars.Bitangent, xform));
	float3 N = normalize(mul(shared_vars.Normal, xform));
	
	output.WorldToTangentXBasis = T;
	output.WorldToTangentYBasis = B;
	output.WorldToTangentZBasis = N;
}



void vs_vertex_color_PART(in PGSL_VS_INPUT_skin_water input, inout PGSL_VS_OUTPUT_skin_water output, inout PGSL_VS_SHARED_skin_water shared_vars)
{
	output.VertexColor = shared_vars.VertexColor;
}



void vs_vertex_alpha_PART(in PGSL_VS_INPUT_skin_water input, inout PGSL_VS_OUTPUT_skin_water output, inout PGSL_VS_SHARED_skin_water shared_vars)
{
	shared_vars.SurfaceDiffuse.a = shared_vars.VertexColor.a;
}



void vs_identity_lighting_PART(in PGSL_VS_INPUT_skin_water input, inout PGSL_VS_OUTPUT_skin_water output, inout PGSL_VS_SHARED_skin_water shared_vars)
{
	shared_vars.LightDiffuse = float3(1, 1, 1);
	shared_vars.LightSpecular = float3(0, 0, 0);
}



void vs_lightscale_PART(in PGSL_VS_INPUT_skin_water input, inout PGSL_VS_OUTPUT_skin_water output, inout PGSL_VS_SHARED_skin_water shared_vars)
{
  shared_vars.LightDiffuse.rgb *= g_LightScale.rgb;
  shared_vars.SurfaceDiffuse.a *= g_LightScale.a;
}



void vs_compose_lighting_diffuse_PART(in PGSL_VS_INPUT_skin_water input, inout PGSL_VS_OUTPUT_skin_water output, inout PGSL_VS_SHARED_skin_water shared_vars)
{
	//do lighting: diffuse only
	shared_vars.Diffuse = shared_vars.LightDiffuse*shared_vars.SurfaceDiffuse.rgb;
	output.Diffuse.rgb = shared_vars.Diffuse.rgb;
	output.Diffuse.a = shared_vars.SurfaceDiffuse.a;
}



void vs_fog_PART(in PGSL_VS_INPUT_skin_water input, inout PGSL_VS_OUTPUT_skin_water output, inout PGSL_VS_SHARED_skin_water shared_vars)
{
	float fog = length(output.Pos.xyz);
	output.Fog = saturate(g_FogValues.x*fog + g_FogValues.y);
}

PGSL_VS_OUTPUT_skin_water pass_vs_PGSL_VS_MAIN_skin_water(PGSL_VS_INPUT_skin_water meta_shader_in)
{
	PGSL_VS_OUTPUT_skin_water meta_shader_out = (PGSL_VS_OUTPUT_skin_water)0;
	PGSL_VS_SHARED_skin_water meta_shader_shared = (PGSL_VS_SHARED_skin_water)0;
	pre_vs_position_PART(meta_shader_in, meta_shader_out, meta_shader_shared);
	pre_vs_skin_PART(meta_shader_in, meta_shader_out, meta_shader_shared);
	pre_vs_normal_PART(meta_shader_in, meta_shader_out, meta_shader_shared);
	pre_vs_base_uv_PART(meta_shader_in, meta_shader_out, meta_shader_shared);
	pre_vs_tangent_PART(meta_shader_in, meta_shader_out, meta_shader_shared);
	pre_vs_bitangent_PART(meta_shader_in, meta_shader_out, meta_shader_shared);
	pre_vs_vertex_color_PART(meta_shader_in, meta_shader_out, meta_shader_shared);
	vs_identity_surface_material_PART(meta_shader_in, meta_shader_out, meta_shader_shared);
	vs_skin_PART(meta_shader_in, meta_shader_out, meta_shader_shared);
	vs_water_mesh_PART(meta_shader_in, meta_shader_out, meta_shader_shared);
	vs_lightfield_uv_PART(meta_shader_in, meta_shader_out, meta_shader_shared);
	vs_fow_uv_PART(meta_shader_in, meta_shader_out, meta_shader_shared);
	vs_world_to_tangent_xform_PART(meta_shader_in, meta_shader_out, meta_shader_shared);
	vs_vertex_color_PART(meta_shader_in, meta_shader_out, meta_shader_shared);
	vs_vertex_alpha_PART(meta_shader_in, meta_shader_out, meta_shader_shared);
	vs_identity_lighting_PART(meta_shader_in, meta_shader_out, meta_shader_shared);
	vs_lightscale_PART(meta_shader_in, meta_shader_out, meta_shader_shared);
	vs_compose_lighting_diffuse_PART(meta_shader_in, meta_shader_out, meta_shader_shared);
	vs_fog_PART(meta_shader_in, meta_shader_out, meta_shader_shared);
	return meta_shader_out;
}















/////////////////////////////////////////////////////////////////////
//PIXEL SHADER INPUTS
/////////////////////////////////////////////////////////////////////
float4 Diffuse
<
string UIName = "Diffuse";
string UIType = "ColorSwatch";
bool GammaCorrect = true;
>
 = {1.0, 1.0, 1.0, 1.0};

float4 Specular
<
string UIName = "Specular";
string UIType = "ColorSwatch";
bool GammaCorrect = true;
>
 = {1.0, 1.0, 1.0, 1.0};

PGSL_TEXTURE2D NormalTexture  : NORMALMAP
<
string UIName = "NormalTexture";
string UIType = "bitmap";
string SamplerEnum = "AL_SAMPLER_UVWRAP_MIN_MAG_MIP_BILINEAR";
>
;
PGSL_SAMPLER NormalTextureSampler PGSL_SAMPLER_REG(0)
<
string UIName = "NormalTexture";
string UIType = "bitmap";
string SamplerEnum = "AL_SAMPLER_UVWRAP_MIN_MAG_MIP_BILINEAR";
PGSL_BIND_TO_TEXTURE(NormalTexture)
string SamplerRegister = "0";
>
PGSL_SAMPLER_STATE(NormalTexture);

PGSL_TEXTURECUBE CubeTexture
<
string SamplerEnum = "AL_SAMPLER_UVWRAP_MIN_MAG_MIP_BILINEAR_SRGB";
>
;
PGSL_SAMPLER CubeTextureSampler PGSL_SAMPLER_REG(1)
<
string SamplerEnum = "AL_SAMPLER_UVWRAP_MIN_MAG_MIP_BILINEAR_SRGB";
PGSL_BIND_TO_TEXTURE(CubeTexture)
string SamplerRegister = "1";
>
PGSL_SAMPLER_STATE(CubeTexture);

PGSL_TEXTURE2D LightFieldTexture PGSL_TEXTURE_REG(4)
<
string SamplerEnum = "AL_SAMPLER_UVCLAMP_MIN_MAG_MIP_BILINEAR_SRGB";
>
;
PGSL_SAMPLER LightFieldTextureSampler PGSL_SAMPLER_REG(4)
<
string SamplerEnum = "AL_SAMPLER_UVCLAMP_MIN_MAG_MIP_BILINEAR_SRGB";
PGSL_BIND_TO_TEXTURE(LightFieldTexture)
string SamplerRegister = "4";
>
PGSL_SAMPLER_STATE(LightFieldTexture);

PGSL_TEXTURE2D FowTexture
<
string SamplerEnum = "AL_SAMPLER_UVCLAMP_MIN_MAG_MIP_BILINEAR_SRGB";
>
;
PGSL_SAMPLER FowTextureSampler PGSL_SAMPLER_REG(2)
<
string SamplerEnum = "AL_SAMPLER_UVCLAMP_MIN_MAG_MIP_BILINEAR_SRGB";
PGSL_BIND_TO_TEXTURE(FowTexture)
string SamplerRegister = "2";
>
PGSL_SAMPLER_STATE(FowTexture);




/////////////////////////////////////////////////////////////////////
//PIXEL SHADER OUTPUTS
/////////////////////////////////////////////////////////////////////
struct PGSL_PS_OUTPUT_skin_water
{
	float4 Color0  : PGSL_TARGET0;
};



/////////////////////////////////////////////////////////////////////
//PIXEL SHADER SHARED STRUCT
/////////////////////////////////////////////////////////////////////
struct PGSL_PS_SHARED_skin_water
{
	float4 SurfaceDiffuse;
	float3 SurfaceSpecular;
	float4 Normal;
	float3 ViewVector;
	float3 ViewVec;
	float3 LightDiffuse;
	float3 Diffuse;
};



/////////////////////////////////////////////////////////////////////
//PIXEL SHADERS
/////////////////////////////////////////////////////////////////////


void ps_surface_material_PART(in PGSL_PS_INPUT_skin_water input, inout PGSL_PS_OUTPUT_skin_water output, inout PGSL_PS_SHARED_skin_water shared_vars)
{
	shared_vars.SurfaceDiffuse = Diffuse;
	shared_vars.SurfaceSpecular = Specular.rgb;
}



void ps_water_mesh_PART(in PGSL_PS_INPUT_skin_water input, inout PGSL_PS_OUTPUT_skin_water output, inout PGSL_PS_SHARED_skin_water shared_vars)
{
	//fetch normal from bump map
	float3 normal0 = PGSL_TEX2D(NormalTexture, NormalTextureSampler, input.BaseTexUV.xy).xyz;
	float3 normal1 = PGSL_TEX2D(NormalTexture, NormalTextureSampler, input.BaseTexUV.zw).xyz;
	//scale to [-1, 1]
	shared_vars.Normal.xyz = 2.0*(normal0 + normal1 - 1);

	//transform normal into world space
	float3x3 tangent_to_world_xform;
	tangent_to_world_xform[0] = input.WorldToTangentXBasis;
	tangent_to_world_xform[1] = input.WorldToTangentYBasis;
	tangent_to_world_xform[2] = input.WorldToTangentZBasis;
	shared_vars.Normal.xyz = normalize(mul(shared_vars.Normal.xyz, tangent_to_world_xform));

	shared_vars.ViewVec = normalize(input.ViewVec);
}

#undef DYNAMIC_BRIGHTEN_FACTOR
#define DYNAMIC_BRIGHTEN_FACTOR 1.0 


void ps_vertex_color_modulate_PART(in PGSL_PS_INPUT_skin_water input, inout PGSL_PS_OUTPUT_skin_water output, inout PGSL_PS_SHARED_skin_water shared_vars)
{
	shared_vars.SurfaceDiffuse.rgb *= (input.VertexColor.rgb*DYNAMIC_BRIGHTEN_FACTOR);
}



void ps_cubemap_PART(in PGSL_PS_INPUT_skin_water input, inout PGSL_PS_OUTPUT_skin_water output, inout PGSL_PS_SHARED_skin_water shared_vars)
{
	float3 normal = shared_vars.Normal.xyz;
	normal.z *= 15.0;
	normal = normalize(normal);
	
	float3 r = -shared_vars.ViewVec + 2.0*dot(shared_vars.ViewVec, normal)*normal;
	shared_vars.SurfaceDiffuse.rgb *= PGSL_TEXCUBE(CubeTexture, CubeTextureSampler, r).rgb;
}



void ps_vertex_alpha_modulate_PART(in PGSL_PS_INPUT_skin_water input, inout PGSL_PS_OUTPUT_skin_water output, inout PGSL_PS_SHARED_skin_water shared_vars)
{
	shared_vars.SurfaceDiffuse.a *= input.Diffuse.a;
}



void ps_vertex_diffuse_PART(in PGSL_PS_INPUT_skin_water input, inout PGSL_PS_OUTPUT_skin_water output, inout PGSL_PS_SHARED_skin_water shared_vars)
{
	shared_vars.LightDiffuse.rgb += input.Diffuse.rgb;
}



void ps_lightfield_PART(in PGSL_PS_INPUT_skin_water input, inout PGSL_PS_OUTPUT_skin_water output, inout PGSL_PS_SHARED_skin_water shared_vars)
{
	//Get the lighting in the light field plane
	float4 lf_texel = PGSL_TEX2D(LightFieldTexture, LightFieldTextureSampler, input.LightFieldTexcoords.xy);

	//Capped Cylinder Z-attenuation:
	//"top" of the light is lf_texel.a and the lighting is zero at that point light 
	//intensity grows up to 1.0 over the z attenuation range and then stays at 1.0 all the
	//way to negative infinity.
	//float zdist = lf_texel.a - input.LightFieldTexcoords.z;
	//float atten = saturate(zdist*LF_NORM_Z_ATTEN_INV);

	// GTH - LightField code still assumes LDR rendering, scale up a bit
	// so light sources aren't completely lost in Victory and GOO.  
	// TODO: HDR LightField, probably a 2-3 day task...
	shared_vars.LightDiffuse.rgb += 4.0f * lf_texel.rgb; // += lf_texel.rgb; //*atten; 
}



void ps_compose_lighting_diffuse_no_2X_PART(in PGSL_PS_INPUT_skin_water input, inout PGSL_PS_OUTPUT_skin_water output, inout PGSL_PS_SHARED_skin_water shared_vars)
{
  shared_vars.Diffuse = shared_vars.SurfaceDiffuse.rgb*shared_vars.LightDiffuse;
  //output the final diffuse color
  output.Color0.rgb = shared_vars.Diffuse.rgb;
  output.Color0.a = shared_vars.SurfaceDiffuse.a;
}



void ps_fow_PART(in PGSL_PS_INPUT_skin_water input, inout PGSL_PS_OUTPUT_skin_water output, inout PGSL_PS_SHARED_skin_water shared_vars)
 {
#if !defined(PGSL_MAX)
	
	 float4 fow_texel = PGSL_TEX2D(FowTexture, FowTextureSampler, input.FowCloudTexcoords.xy);
	 float lum = dot(output.Color0.rgb, LumVec);
	 output.Color0.rgb = lerp(fow_texel.rgb*lum.xxx, output.Color0.rgb, fow_texel.a);
	
#endif
 }



void ps_fog_PART(in PGSL_PS_INPUT_skin_water input, inout PGSL_PS_OUTPUT_skin_water output, inout PGSL_PS_SHARED_skin_water shared_vars)
{
	output.Color0.rgb = lerp(g_FogColor.rgb, output.Color0.rgb, input.Fog);
}

PGSL_PS_OUTPUT_skin_water pass_ps_PGSL_PS_MAIN_skin_water(PGSL_PS_INPUT_skin_water meta_shader_in)
{
	PGSL_PS_OUTPUT_skin_water meta_shader_out = (PGSL_PS_OUTPUT_skin_water)0;
	PGSL_PS_SHARED_skin_water meta_shader_shared = (PGSL_PS_SHARED_skin_water)0;
	ps_surface_material_PART(meta_shader_in, meta_shader_out, meta_shader_shared);
	ps_water_mesh_PART(meta_shader_in, meta_shader_out, meta_shader_shared);
	ps_vertex_color_modulate_PART(meta_shader_in, meta_shader_out, meta_shader_shared);
	ps_cubemap_PART(meta_shader_in, meta_shader_out, meta_shader_shared);
	ps_vertex_alpha_modulate_PART(meta_shader_in, meta_shader_out, meta_shader_shared);
	ps_vertex_diffuse_PART(meta_shader_in, meta_shader_out, meta_shader_shared);
	ps_lightfield_PART(meta_shader_in, meta_shader_out, meta_shader_shared);
	ps_compose_lighting_diffuse_no_2X_PART(meta_shader_in, meta_shader_out, meta_shader_shared);
	ps_fow_PART(meta_shader_in, meta_shader_out, meta_shader_shared);
	ps_fog_PART(meta_shader_in, meta_shader_out, meta_shader_shared);
	return meta_shader_out;
}



/////////////////////////////////////////////////////////////////////
//SHADER'S PASSES
/////////////////////////////////////////////////////////////////////
PGSL_TECHNIQUE_BEGIN
	PGSL_PASS_BEGIN(pass_0, 
	<
		string _RasterizeState_ = "ALRS_DEFAULT";string _BlendState_ = "ALBS_ALPHA_BLEND";string _DepthStencilState_ = "ALDS_DEPTHLESSEQUALNOWRITE_STENCILDISABLE";
	>)
		PGSL_PASS_VS(pass_vs_PGSL_VS_MAIN_skin_water, 0)
		PGSL_PASS_PS(pass_ps_PGSL_PS_MAIN_skin_water, 0)
	PGSL_PASS_END
PGSL_TECHNIQUE_END



