//////////////////////////////////////////////////////////////////////////////////////////////////////////
//
//Petroglyph Confidential Source Code -- Do Not Distribute
//
// (Auto generated by PGSLCodeGenerator)
//Platform: MAX
//////////////////////////////////////////////////////////////////////////////////////////////////////////
#define PGSL_MAX
#define PGSL_DX9
#include"..\common\PGSLAlways.pgh"
#include"..\common\AlamoEngine.pgh"
#include"..\common\AlamoEngine_Skinning.pgh"

float g_ShaderFileDummyVariable : SHADER_FILE_ANNOTATION
<
string _ALAMO_RENDER_PHASE = "Transparent";
string _ALAMO_VERTEX_PROC = "Skin";
string _ALAMO_VERTEX_TYPE = "alD3dVertB4I4NU2";
bool _ALAMO_TANGENT_SPACE = false;
bool _ALAMO_SHADOW_VOLUME = false;
bool _ALAMO_Z_SORT = false;
>;

#define PGSL_PS_INPUT_skin_shield PGSL_VS_OUTPUT_skin_shield



/////////////////////////////////////////////////////////////////////
//VERTEX SHADER INPUTS
/////////////////////////////////////////////////////////////////////
float CodeScaleFactor
<
bool IsArtParam = true;
>
 = 0.0;

float BaseUVScale
<
string UIName = "BaseUVScale";
float UIMin = 0.0;
float UIMax = 100.0;
>
 = 20.0;

float WaveUVScale
<
string UIName = "WaveUVScale";
float UIMin = 0.0;
float UIMax = 100.0;
>
 = 1.0;

float DistortionUVScale
<
string UIName = "DistortionUVScale";
float UIMin = 0.0;
float UIMax = 100.0;
>
 = 1.0;

float2 BaseUVScrollRate
<
string UIName = "BaseUVScrollRate";
>
 = {0.0, 0.0};

float2 WaveUVScrollRate
<
string UIName = "WaveUVScrollRate";
>
 = {0.0, 0.0};

float2 DistortionUVScrollRate
<
string UIName = "DistortionUVScrollRate";
>
 = {0.0, 0.0};

float EdgeBrightness
<
string UIName = "EdgeBrightness";
float UIMin = 0;
float UIMax = 1.0;
>
 = 0.5;

float4 Color
<
string UIName = "Color";
string UIType = "ColorSwatch";
bool GammaCorrect = true;
>
 = {1, 1, 1, 1};

struct PGSL_VS_INPUT_skin_shield
{
	float3 Pos  : PGSL_POSITION;
	float4 BlendWeights  : PGSL_BLENDWEIGHTS;
	PGSL_PACKED_FLOAT4 BlendIndices  : PGSL_BLENDINDICES;
	float3 Normal  : PGSL_NORMAL;
	float2 BaseTexUV  : PGSL_TEXCOORD0;
};



/////////////////////////////////////////////////////////////////////
//VERTEX SHADER OUTPUTS
/////////////////////////////////////////////////////////////////////
struct PGSL_VS_OUTPUT_skin_shield
{
	float4 Pos  : PGSL_SV_POSITION;
	float2 Tex0UV  : PGSL_TEXCOORD0;
	float2 Tex1UV  : PGSL_TEXCOORD1;
	float2 Tex2UV  : PGSL_TEXCOORD2;
	float4 Diffuse  : PGSL_COLOR0;
	float4 FowCloudTexcoords  : PGSL_TEXCOORD3;
};



/////////////////////////////////////////////////////////////////////
//VERTEX SHADER SHARED STRUCT
/////////////////////////////////////////////////////////////////////
struct PGSL_VS_SHARED_skin_shield
{
	float4 Pos;
	float4 BlendWeights;
	int4 BlendIndices;
	float3 Normal;
	float2 BaseTexUV;
	float4 WorldPos;
	float4x4 World;
	float4 VertexColor;
};



/////////////////////////////////////////////////////////////////////
//VERTEX SHADERS
/////////////////////////////////////////////////////////////////////


void pre_vs_position_PART(inout PGSL_VS_INPUT_skin_shield input, inout PGSL_VS_OUTPUT_skin_shield output, inout PGSL_VS_SHARED_skin_shield shared_vars)
{
	shared_vars.Pos = float4(input.Pos.xyz, 1.0);
}



void pre_vs_skin_PART(inout PGSL_VS_INPUT_skin_shield input, inout PGSL_VS_OUTPUT_skin_shield output, inout PGSL_VS_SHARED_skin_shield shared_vars)
{
	shared_vars.BlendWeights = input.BlendWeights;
	shared_vars.BlendIndices = ConvertSkinIndices(input.BlendIndices);
}



void pre_vs_normal_PART(inout PGSL_VS_INPUT_skin_shield input, inout PGSL_VS_OUTPUT_skin_shield output, inout PGSL_VS_SHARED_skin_shield shared_vars)
{
	shared_vars.Normal = input.Normal.xyz;
}



void pre_vs_base_uv_PART(inout PGSL_VS_INPUT_skin_shield input, inout PGSL_VS_OUTPUT_skin_shield output, inout PGSL_VS_SHARED_skin_shield shared_vars)
{
	shared_vars.BaseTexUV = input.BaseTexUV;
}



void vs_skin_scale_PART(in PGSL_VS_INPUT_skin_shield input, inout PGSL_VS_OUTPUT_skin_shield output, inout PGSL_VS_SHARED_skin_shield shared_vars)
{
	//skinning
	float4x3 weighted_xform;
#if defined(PGSL_MAX)
	//we don't do the code-scaling when viewing in MAX
	weighted_xform = g_World;
	float3 world_pos = mul(shared_vars.Pos, weighted_xform);
	output.Pos = mul(float4(world_pos, 1.0), g_View);
	output.Pos = mul(output.Pos, g_Proj);
#else
	weighted_xform = shared_vars.BlendWeights[0]*SkinMatrixArray[shared_vars.BlendIndices[0]];
	weighted_xform += shared_vars.BlendWeights[1]*SkinMatrixArray[shared_vars.BlendIndices[1]];
	weighted_xform += shared_vars.BlendWeights[2]*SkinMatrixArray[shared_vars.BlendIndices[2]];
	weighted_xform += shared_vars.BlendWeights[3]*SkinMatrixArray[shared_vars.BlendIndices[3]];
	//perform expansion along the vertex's normal
	shared_vars.Pos.xyz += shared_vars.Normal.xyz*CodeScaleFactor;
	float3 world_pos = mul(shared_vars.Pos, weighted_xform);
	output.Pos = mul(float4(world_pos, 1.0), g_ViewProj);
#endif
	
	//save world pos
	shared_vars.WorldPos = float4(world_pos, 1.0);
	//save world xform
	shared_vars.World[0] = float4(weighted_xform[0], 0);
	shared_vars.World[1] = float4(weighted_xform[1], 0);
	shared_vars.World[2] = float4(weighted_xform[2], 0);
	shared_vars.World[3] = float4(weighted_xform[3], 1);
}



void vs_shield_PART(in PGSL_VS_INPUT_skin_shield input, inout PGSL_VS_OUTPUT_skin_shield output, inout PGSL_VS_SHARED_skin_shield shared_vars)
{
	output.Tex0UV.xy = shared_vars.BaseTexUV.xy*BaseUVScale;
	output.Tex1UV.xy = shared_vars.BaseTexUV.xy*WaveUVScale;
	output.Tex2UV.xy = shared_vars.BaseTexUV.xy*DistortionUVScale;
	
	output.Tex0UV.xy += g_ElapsedTime*BaseUVScrollRate;
	output.Tex1UV.xy += g_ElapsedTime*WaveUVScrollRate;
	output.Tex2UV.xy += g_ElapsedTime*DistortionUVScrollRate;
	
	//soften vertical edge
	output.Diffuse = saturate(shared_vars.Normal.z + EdgeBrightness);
	output.Diffuse *= Color;
	
	output.Diffuse.rgb *= g_LightScale.rgb;
}



void vs_fow_uv_PART(in PGSL_VS_INPUT_skin_shield input, inout PGSL_VS_OUTPUT_skin_shield output, inout PGSL_VS_SHARED_skin_shield shared_vars)
{
	output.FowCloudTexcoords.x = dot(g_FowTexU, shared_vars.WorldPos);
	output.FowCloudTexcoords.y = dot(g_FowTexV, shared_vars.WorldPos);
}

PGSL_VS_OUTPUT_skin_shield pass_vs_PGSL_VS_MAIN_skin_shield(PGSL_VS_INPUT_skin_shield meta_shader_in)
{
	PGSL_VS_OUTPUT_skin_shield meta_shader_out = (PGSL_VS_OUTPUT_skin_shield)0;
	PGSL_VS_SHARED_skin_shield meta_shader_shared = (PGSL_VS_SHARED_skin_shield)0;
	pre_vs_position_PART(meta_shader_in, meta_shader_out, meta_shader_shared);
	pre_vs_skin_PART(meta_shader_in, meta_shader_out, meta_shader_shared);
	pre_vs_normal_PART(meta_shader_in, meta_shader_out, meta_shader_shared);
	pre_vs_base_uv_PART(meta_shader_in, meta_shader_out, meta_shader_shared);
	vs_skin_scale_PART(meta_shader_in, meta_shader_out, meta_shader_shared);
	vs_shield_PART(meta_shader_in, meta_shader_out, meta_shader_shared);
	vs_fow_uv_PART(meta_shader_in, meta_shader_out, meta_shader_shared);
	return meta_shader_out;
}















/////////////////////////////////////////////////////////////////////
//PIXEL SHADER INPUTS
/////////////////////////////////////////////////////////////////////
float DistortionScale
<
string UIName = "DistortionScale";
>
 = 0.25;

PGSL_TEXTURE2D BaseTexture
<
string UIName = "BaseTexture";
string UIType = "bitmap";
string UIHelp = "Diffuse, Alpha";
string SamplerEnum = "AL_SAMPLER_UVWRAP_MIN_MAG_MIP_BILINEAR_SRGB";
>
;
PGSL_SAMPLER BaseTextureSampler PGSL_SAMPLER_REG(0)
<
string UIName = "BaseTexture";
string UIType = "bitmap";
string UIHelp = "Diffuse, Alpha";
string SamplerEnum = "AL_SAMPLER_UVWRAP_MIN_MAG_MIP_BILINEAR_SRGB";
PGSL_BIND_TO_TEXTURE(BaseTexture)
string SamplerRegister = "0";
>
PGSL_SAMPLER_STATE(BaseTexture);

PGSL_TEXTURE2D WaveTexture
<
string UIName = "WaveTexture";
string UIType = "bitmap";
string SamplerEnum = "AL_SAMPLER_UVWRAP_MIN_MAG_MIP_BILINEAR_SRGB";
>
;
PGSL_SAMPLER WaveTextureSampler PGSL_SAMPLER_REG(1)
<
string UIName = "WaveTexture";
string UIType = "bitmap";
string SamplerEnum = "AL_SAMPLER_UVWRAP_MIN_MAG_MIP_BILINEAR_SRGB";
PGSL_BIND_TO_TEXTURE(WaveTexture)
string SamplerRegister = "1";
>
PGSL_SAMPLER_STATE(WaveTexture);

PGSL_TEXTURE2D DistortionTexture
<
string UIName = "DistortionTexture";
string UIType = "bitmap";
string SamplerEnum = "AL_SAMPLER_UVWRAP_MIN_MAG_MIP_BILINEAR";
>
;
PGSL_SAMPLER DistortionTextureSampler PGSL_SAMPLER_REG(2)
<
string UIName = "DistortionTexture";
string UIType = "bitmap";
string SamplerEnum = "AL_SAMPLER_UVWRAP_MIN_MAG_MIP_BILINEAR";
PGSL_BIND_TO_TEXTURE(DistortionTexture)
string SamplerRegister = "2";
>
PGSL_SAMPLER_STATE(DistortionTexture);

PGSL_TEXTURE2D FowTexture
<
string SamplerEnum = "AL_SAMPLER_UVCLAMP_MIN_MAG_MIP_BILINEAR_SRGB";
>
;
PGSL_SAMPLER FowTextureSampler PGSL_SAMPLER_REG(3)
<
string SamplerEnum = "AL_SAMPLER_UVCLAMP_MIN_MAG_MIP_BILINEAR_SRGB";
PGSL_BIND_TO_TEXTURE(FowTexture)
string SamplerRegister = "3";
>
PGSL_SAMPLER_STATE(FowTexture);




/////////////////////////////////////////////////////////////////////
//PIXEL SHADER OUTPUTS
/////////////////////////////////////////////////////////////////////
struct PGSL_PS_OUTPUT_skin_shield
{
	float4 Color0  : PGSL_TARGET0;
};



/////////////////////////////////////////////////////////////////////
//PIXEL SHADER SHARED STRUCT
/////////////////////////////////////////////////////////////////////
struct PGSL_PS_SHARED_skin_shield
{
	float4 SurfaceDiffuse;
	float3 SurfaceSpecular;
	float3 Diffuse;
};



/////////////////////////////////////////////////////////////////////
//PIXEL SHADERS
/////////////////////////////////////////////////////////////////////


void ps_identity_surface_material_PART(in PGSL_PS_INPUT_skin_shield input, inout PGSL_PS_OUTPUT_skin_shield output, inout PGSL_PS_SHARED_skin_shield shared_vars)
{
	shared_vars.SurfaceDiffuse = float4(1, 1, 1, 1);
	shared_vars.SurfaceSpecular = float3(1, 1, 1);
}



void ps_shield_PART(in PGSL_PS_INPUT_skin_shield input, inout PGSL_PS_OUTPUT_skin_shield output, inout PGSL_PS_SHARED_skin_shield shared_vars)
{	
	//grab the distortion texture
	float4 distortion_texel = PGSL_TEX2D(DistortionTexture, DistortionTextureSampler, input.Tex2UV);
	
	//perturb the uv for the energy texture
	float2 uv = input.Tex0UV + distortion_texel.xy*DistortionScale;
	
	//grab the energy texel
	float4 texel = PGSL_TEX2D(BaseTexture, BaseTextureSampler, uv);
	
	//grab the line texel
	float4 wave_texel = PGSL_TEX2D(WaveTexture, WaveTextureSampler, input.Tex1UV);
	
	shared_vars.SurfaceDiffuse *= texel*wave_texel*input.Diffuse;
}



void ps_compose_surface_diffuse_PART(in PGSL_PS_INPUT_skin_shield input, inout PGSL_PS_OUTPUT_skin_shield output, inout PGSL_PS_SHARED_skin_shield shared_vars)
{
  shared_vars.Diffuse = shared_vars.SurfaceDiffuse.rgb;
  output.Color0 = shared_vars.SurfaceDiffuse;
}



void ps_fow_PART(in PGSL_PS_INPUT_skin_shield input, inout PGSL_PS_OUTPUT_skin_shield output, inout PGSL_PS_SHARED_skin_shield shared_vars)
 {
#if !defined(PGSL_MAX)
	
	 float4 fow_texel = PGSL_TEX2D(FowTexture, FowTextureSampler, input.FowCloudTexcoords.xy);
	 float lum = dot(output.Color0.rgb, LumVec);
	 output.Color0.rgb = lerp(fow_texel.rgb*lum.xxx, output.Color0.rgb, fow_texel.a);
	
#endif
 }

PGSL_PS_OUTPUT_skin_shield pass_ps_PGSL_PS_MAIN_skin_shield(PGSL_PS_INPUT_skin_shield meta_shader_in)
{
	PGSL_PS_OUTPUT_skin_shield meta_shader_out = (PGSL_PS_OUTPUT_skin_shield)0;
	PGSL_PS_SHARED_skin_shield meta_shader_shared = (PGSL_PS_SHARED_skin_shield)0;
	ps_identity_surface_material_PART(meta_shader_in, meta_shader_out, meta_shader_shared);
	ps_shield_PART(meta_shader_in, meta_shader_out, meta_shader_shared);
	ps_compose_surface_diffuse_PART(meta_shader_in, meta_shader_out, meta_shader_shared);
	ps_fow_PART(meta_shader_in, meta_shader_out, meta_shader_shared);
	return meta_shader_out;
}



/////////////////////////////////////////////////////////////////////
//SHADER'S PASSES
/////////////////////////////////////////////////////////////////////
PGSL_TECHNIQUE_BEGIN
	PGSL_PASS_BEGIN(pass_0, 
	<
		string _RasterizeState_ = "ALRS_DEFAULT";string _BlendState_ = "ALBS_ADDITIVE";string _DepthStencilState_ = "ALDS_DEPTHLESSEQUALNOWRITE_STENCILDISABLE";
	>)
		PGSL_PASS_VS(pass_vs_PGSL_VS_MAIN_skin_shield, 0)
		PGSL_PASS_PS(pass_ps_PGSL_PS_MAIN_skin_shield, 0)
	PGSL_PASS_END
PGSL_TECHNIQUE_END



