//////////////////////////////////////////////////////////////////////////////////////////////////////////
//
//Petroglyph Confidential Source Code -- Do Not Distribute
//
// (Auto generated by PGSLCodeGenerator)
//Platform: MAX
//////////////////////////////////////////////////////////////////////////////////////////////////////////
#define PGSL_MAX
#define PGSL_DX9
#include"..\common\PGSLAlways.pgh"
#include"..\common\AlamoEngine.pgh"
#include"..\common\AlamoEngine_Skinning.pgh"

float g_ShaderFileDummyVariable : SHADER_FILE_ANNOTATION
<
string _ALAMO_RENDER_PHASE = "Transparent";
string _ALAMO_VERTEX_PROC = "Skin";
string _ALAMO_VERTEX_TYPE = "alD3dVertB4I4NU2";
bool _ALAMO_TANGENT_SPACE = false;
bool _ALAMO_SHADOW_VOLUME = false;
int _ALAMO_BONES_PER_VERTEX = 4;
>;

#define PGSL_PS_INPUT_skin_mipmaps_visualization PGSL_VS_OUTPUT_skin_mipmaps_visualization



/////////////////////////////////////////////////////////////////////
//VERTEX SHADER INPUTS
/////////////////////////////////////////////////////////////////////
float CodeScaleFactor
<
bool IsArtParam = true;
>
 = 0.0;

float2 BaseTextureDimensions
<
bool IsArtParam = true;
>
 = {1.0, 1.0};

struct PGSL_VS_INPUT_skin_mipmaps_visualization
{
	float3 Pos  : PGSL_POSITION;
	float4 BlendWeights  : PGSL_BLENDWEIGHTS;
	PGSL_PACKED_FLOAT4 BlendIndices  : PGSL_BLENDINDICES;
	float3 Normal  : PGSL_NORMAL;
	float2 BaseTexUV  : PGSL_TEXCOORD0;
};



/////////////////////////////////////////////////////////////////////
//VERTEX SHADER OUTPUTS
/////////////////////////////////////////////////////////////////////
struct PGSL_VS_OUTPUT_skin_mipmaps_visualization
{
	float4 Pos  : PGSL_SV_POSITION;
	float2 BaseTexUV  : PGSL_TEXCOORD0;
};



/////////////////////////////////////////////////////////////////////
//VERTEX SHADER SHARED STRUCT
/////////////////////////////////////////////////////////////////////
struct PGSL_VS_SHARED_skin_mipmaps_visualization
{
	float4 Pos;
	float4 BlendWeights;
	int4 BlendIndices;
	float3 Normal;
	float2 BaseTexUV;
	float4 WorldPos;
	float4x4 World;
};



/////////////////////////////////////////////////////////////////////
//VERTEX SHADERS
/////////////////////////////////////////////////////////////////////


void pre_vs_position_PART(inout PGSL_VS_INPUT_skin_mipmaps_visualization input, inout PGSL_VS_OUTPUT_skin_mipmaps_visualization output, inout PGSL_VS_SHARED_skin_mipmaps_visualization shared_vars)
{
	shared_vars.Pos = float4(input.Pos.xyz, 1.0);
}



void pre_vs_skin_PART(inout PGSL_VS_INPUT_skin_mipmaps_visualization input, inout PGSL_VS_OUTPUT_skin_mipmaps_visualization output, inout PGSL_VS_SHARED_skin_mipmaps_visualization shared_vars)
{
	shared_vars.BlendWeights = input.BlendWeights;
	shared_vars.BlendIndices = ConvertSkinIndices(input.BlendIndices);
}



void pre_vs_normal_PART(inout PGSL_VS_INPUT_skin_mipmaps_visualization input, inout PGSL_VS_OUTPUT_skin_mipmaps_visualization output, inout PGSL_VS_SHARED_skin_mipmaps_visualization shared_vars)
{
	shared_vars.Normal = input.Normal.xyz;
}



void pre_vs_base_uv_PART(inout PGSL_VS_INPUT_skin_mipmaps_visualization input, inout PGSL_VS_OUTPUT_skin_mipmaps_visualization output, inout PGSL_VS_SHARED_skin_mipmaps_visualization shared_vars)
{
	shared_vars.BaseTexUV = input.BaseTexUV;
}



void vs_skin_scale_PART(in PGSL_VS_INPUT_skin_mipmaps_visualization input, inout PGSL_VS_OUTPUT_skin_mipmaps_visualization output, inout PGSL_VS_SHARED_skin_mipmaps_visualization shared_vars)
{
	//skinning
	float4x3 weighted_xform;
#if defined(PGSL_MAX)
	//we don't do the code-scaling when viewing in MAX
	weighted_xform = g_World;
	float3 world_pos = mul(shared_vars.Pos, weighted_xform);
	output.Pos = mul(float4(world_pos, 1.0), g_View);
	output.Pos = mul(output.Pos, g_Proj);
#else
	weighted_xform = shared_vars.BlendWeights[0]*SkinMatrixArray[shared_vars.BlendIndices[0]];
	weighted_xform += shared_vars.BlendWeights[1]*SkinMatrixArray[shared_vars.BlendIndices[1]];
	weighted_xform += shared_vars.BlendWeights[2]*SkinMatrixArray[shared_vars.BlendIndices[2]];
	weighted_xform += shared_vars.BlendWeights[3]*SkinMatrixArray[shared_vars.BlendIndices[3]];
	//perform expansion along the vertex's normal
	shared_vars.Pos.xyz += shared_vars.Normal.xyz*CodeScaleFactor;
	float3 world_pos = mul(shared_vars.Pos, weighted_xform);
	output.Pos = mul(float4(world_pos, 1.0), g_ViewProj);
#endif
	
	//save world pos
	shared_vars.WorldPos = float4(world_pos, 1.0);
	//save world xform
	shared_vars.World[0] = float4(weighted_xform[0], 0);
	shared_vars.World[1] = float4(weighted_xform[1], 0);
	shared_vars.World[2] = float4(weighted_xform[2], 0);
	shared_vars.World[3] = float4(weighted_xform[3], 1);
}



void vs_base_uv_PART(in PGSL_VS_INPUT_skin_mipmaps_visualization input, inout PGSL_VS_OUTPUT_skin_mipmaps_visualization output, inout PGSL_VS_SHARED_skin_mipmaps_visualization shared_vars)
{
	output.BaseTexUV = shared_vars.BaseTexUV;
}



void vs_mipmaps_visualization_PART(in PGSL_VS_INPUT_skin_mipmaps_visualization input, inout PGSL_VS_OUTPUT_skin_mipmaps_visualization output, inout PGSL_VS_SHARED_skin_mipmaps_visualization shared_vars)
{
   //why the weird divided by 8? because our mipmaps color texture is a 32x32 texture.
   //If the original texture was 256 pixels in size and we want to sample a 32 pixels texture
   //exactly the same texel density as the original one then we have to use more dense uv.
   //generic formula is: mipmap_uv = base_uv*base_texture_dimensions/mipmaps_color_texture_dimensions
   //We also want to indicates "not enough texel density" cases, so we push our "perfect texel to pixel"
   //case down 2 mip levels, so that is a divided by 4 -> hence 32/4 = 8
   output.BaseTexUV = output.BaseTexUV*BaseTextureDimensions/8;
}

PGSL_VS_OUTPUT_skin_mipmaps_visualization pass_vs_PGSL_VS_MAIN_skin_mipmaps_visualization(PGSL_VS_INPUT_skin_mipmaps_visualization meta_shader_in)
{
	PGSL_VS_OUTPUT_skin_mipmaps_visualization meta_shader_out = (PGSL_VS_OUTPUT_skin_mipmaps_visualization)0;
	PGSL_VS_SHARED_skin_mipmaps_visualization meta_shader_shared = (PGSL_VS_SHARED_skin_mipmaps_visualization)0;
	pre_vs_position_PART(meta_shader_in, meta_shader_out, meta_shader_shared);
	pre_vs_skin_PART(meta_shader_in, meta_shader_out, meta_shader_shared);
	pre_vs_normal_PART(meta_shader_in, meta_shader_out, meta_shader_shared);
	pre_vs_base_uv_PART(meta_shader_in, meta_shader_out, meta_shader_shared);
	vs_skin_scale_PART(meta_shader_in, meta_shader_out, meta_shader_shared);
	vs_base_uv_PART(meta_shader_in, meta_shader_out, meta_shader_shared);
	vs_mipmaps_visualization_PART(meta_shader_in, meta_shader_out, meta_shader_shared);
	return meta_shader_out;
}















/////////////////////////////////////////////////////////////////////
//PIXEL SHADER INPUTS
/////////////////////////////////////////////////////////////////////
PGSL_TEXTURE2D MipmapsColorTexture  : DIFFUSEMAP
<
bool IsArtParam = true;
string SamplerEnum = "AL_SAMPLER_UVWRAP_MIN_MAG_MIP_BILINEAR_SRGB";
>
;
PGSL_SAMPLER MipmapsColorTextureSampler PGSL_SAMPLER_REG(0)
<
bool IsArtParam = true;
string SamplerEnum = "AL_SAMPLER_UVWRAP_MIN_MAG_MIP_BILINEAR_SRGB";
PGSL_BIND_TO_TEXTURE(MipmapsColorTexture)
string SamplerRegister = "0";
>
PGSL_SAMPLER_STATE(MipmapsColorTexture);




/////////////////////////////////////////////////////////////////////
//PIXEL SHADER OUTPUTS
/////////////////////////////////////////////////////////////////////
struct PGSL_PS_OUTPUT_skin_mipmaps_visualization
{
	float4 Color0  : PGSL_TARGET0;
};



/////////////////////////////////////////////////////////////////////
//PIXEL SHADER SHARED STRUCT
/////////////////////////////////////////////////////////////////////
struct PGSL_PS_SHARED_skin_mipmaps_visualization
{
	float2 BaseTexUV;
};



/////////////////////////////////////////////////////////////////////
//PIXEL SHADERS
/////////////////////////////////////////////////////////////////////


void pre_ps_base_uv_PART(inout PGSL_PS_INPUT_skin_mipmaps_visualization input, inout PGSL_PS_OUTPUT_skin_mipmaps_visualization output, inout PGSL_PS_SHARED_skin_mipmaps_visualization shared_vars)
{
	shared_vars.BaseTexUV = input.BaseTexUV;
}



void ps_mipmaps_visualization_PART(in PGSL_PS_INPUT_skin_mipmaps_visualization input, inout PGSL_PS_OUTPUT_skin_mipmaps_visualization output, inout PGSL_PS_SHARED_skin_mipmaps_visualization shared_vars)
{
	output.Color0 = PGSL_TEX2D(MipmapsColorTexture, MipmapsColorTextureSampler, shared_vars.BaseTexUV);
}

PGSL_PS_OUTPUT_skin_mipmaps_visualization pass_ps_PGSL_PS_MAIN_skin_mipmaps_visualization(PGSL_PS_INPUT_skin_mipmaps_visualization meta_shader_in)
{
	PGSL_PS_OUTPUT_skin_mipmaps_visualization meta_shader_out = (PGSL_PS_OUTPUT_skin_mipmaps_visualization)0;
	PGSL_PS_SHARED_skin_mipmaps_visualization meta_shader_shared = (PGSL_PS_SHARED_skin_mipmaps_visualization)0;
	pre_ps_base_uv_PART(meta_shader_in, meta_shader_out, meta_shader_shared);
	ps_mipmaps_visualization_PART(meta_shader_in, meta_shader_out, meta_shader_shared);
	return meta_shader_out;
}



/////////////////////////////////////////////////////////////////////
//SHADER'S PASSES
/////////////////////////////////////////////////////////////////////
PGSL_TECHNIQUE_BEGIN
	PGSL_PASS_BEGIN(pass_0, 
	<
		string _RasterizeState_ = "ALRS_DEFAULT";string _BlendState_ = "ALBS_ALPHA_BLEND";string _DepthStencilState_ = "ALDS_DEPTHLESSEQUALNOWRITE_STENCILDISABLE";
	>)
		PGSL_PASS_VS(pass_vs_PGSL_VS_MAIN_skin_mipmaps_visualization, 0)
		PGSL_PASS_PS(pass_ps_PGSL_PS_MAIN_skin_mipmaps_visualization, 0)
	PGSL_PASS_END
PGSL_TECHNIQUE_END



