//////////////////////////////////////////////////////////////////////////////////////////////////////////
//
//Petroglyph Confidential Source Code -- Do Not Distribute
//
// (Auto generated by PGSLCodeGenerator)
//Platform: MAX
//////////////////////////////////////////////////////////////////////////////////////////////////////////
#define PGSL_MAX
#define PGSL_DX9
#include"..\common\PGSLAlways.pgh"
#include"..\common\AlamoEngine.pgh"
#include"..\common\AlamoEngine_Skinning.pgh"

float g_ShaderFileDummyVariable : SHADER_FILE_ANNOTATION
<
string _ALAMO_RENDER_PHASE = "Transparent";
string _ALAMO_VERTEX_PROC = "Skin";
string _ALAMO_VERTEX_TYPE = "alD3dVertB4I4NU2C";
bool _ALAMO_TANGENT_SPACE = false;
bool _ALAMO_SHADOW_VOLUME = false;
int _ALAMO_BONES_PER_VERTEX = 4;
>;

#define PGSL_PS_INPUT_skin_additive PGSL_VS_OUTPUT_skin_additive



/////////////////////////////////////////////////////////////////////
//VERTEX SHADER INPUTS
/////////////////////////////////////////////////////////////////////
float2 UVScrollRate
<
string UIName = "UVScrollRate";
>
 = {0, 0};

float4 Color
<
string UIName = "Color";
string UIType = "ColorSwatch";
bool GammaCorrect = true;
>
 = {1, 1, 1, 1};

float4 ViewDep_RGBA_Edge
<
string UIName = "ViewDep_RGBA_Edge";
>
 = 1.0;

float4 ViewDep_RGBA_Facing
<
string UIName = "ViewDep_RGBA_Facing";
>
 = 1.0;

float ViewDep_Power
<
string UIName = "ViewDep_Power";
>
 = 1.0;

struct PGSL_VS_INPUT_skin_additive
{
	float3 Pos  : PGSL_POSITION;
	float4 BlendWeights  : PGSL_BLENDWEIGHTS;
	PGSL_PACKED_FLOAT4 BlendIndices  : PGSL_BLENDINDICES;
	float3 Normal  : PGSL_NORMAL;
	float2 BaseTexUV  : PGSL_TEXCOORD0;
	float4 Color  : PGSL_COLOR0;
};



/////////////////////////////////////////////////////////////////////
//VERTEX SHADER OUTPUTS
/////////////////////////////////////////////////////////////////////
struct PGSL_VS_OUTPUT_skin_additive
{
	float4 Pos  : PGSL_SV_POSITION;
	float2 BaseTexUV  : PGSL_TEXCOORD0;
	float4 FowCloudTexcoords  : PGSL_TEXCOORD1;
	float4 VertexColor  : PGSL_COLOR0;
	float4 Diffuse  : PGSL_TEXCOORD2;
};



/////////////////////////////////////////////////////////////////////
//VERTEX SHADER SHARED STRUCT
/////////////////////////////////////////////////////////////////////
struct PGSL_VS_SHARED_skin_additive
{
	float4 Pos;
	float4 BlendWeights;
	int4 BlendIndices;
	float3 Normal;
	float2 BaseTexUV;
	float4 VertexColor;
	float4 SurfaceDiffuse;
	float3 SurfaceSpecular;
	float4 WorldPos;
	float4x4 World;
	float3 LightDiffuse;
	float3 LightSpecular;
	float3 Diffuse;
};



/////////////////////////////////////////////////////////////////////
//VERTEX SHADERS
/////////////////////////////////////////////////////////////////////


void pre_vs_position_PART(inout PGSL_VS_INPUT_skin_additive input, inout PGSL_VS_OUTPUT_skin_additive output, inout PGSL_VS_SHARED_skin_additive shared_vars)
{
	shared_vars.Pos = float4(input.Pos.xyz, 1.0);
}



void pre_vs_skin_PART(inout PGSL_VS_INPUT_skin_additive input, inout PGSL_VS_OUTPUT_skin_additive output, inout PGSL_VS_SHARED_skin_additive shared_vars)
{
	shared_vars.BlendWeights = input.BlendWeights;
	shared_vars.BlendIndices = ConvertSkinIndices(input.BlendIndices);
}



void pre_vs_normal_PART(inout PGSL_VS_INPUT_skin_additive input, inout PGSL_VS_OUTPUT_skin_additive output, inout PGSL_VS_SHARED_skin_additive shared_vars)
{
	shared_vars.Normal = input.Normal.xyz;
}



void pre_vs_base_uv_PART(inout PGSL_VS_INPUT_skin_additive input, inout PGSL_VS_OUTPUT_skin_additive output, inout PGSL_VS_SHARED_skin_additive shared_vars)
{
	shared_vars.BaseTexUV = input.BaseTexUV;
}



void pre_vs_vertex_color_PART(inout PGSL_VS_INPUT_skin_additive input, inout PGSL_VS_OUTPUT_skin_additive output, inout PGSL_VS_SHARED_skin_additive shared_vars)
{
	shared_vars.VertexColor = input.Color;
}



void vs_identity_surface_material_PART(in PGSL_VS_INPUT_skin_additive input, inout PGSL_VS_OUTPUT_skin_additive output, inout PGSL_VS_SHARED_skin_additive shared_vars)
{
	shared_vars.SurfaceDiffuse = float4(1, 1, 1, 1);
	shared_vars.SurfaceSpecular = float3(1, 1, 1);
}



void vs_skin_PART(in PGSL_VS_INPUT_skin_additive input, inout PGSL_VS_OUTPUT_skin_additive output, inout PGSL_VS_SHARED_skin_additive shared_vars)
{
	//skinning
	float4x3 weighted_xform;
#if defined(PGSL_MAX)
	weighted_xform = g_World;
	float3 world_pos = mul(shared_vars.Pos, weighted_xform);
	output.Pos = mul(float4(world_pos, 1.0), g_View);
	output.Pos = mul(output.Pos, g_Proj);
#else
	weighted_xform = shared_vars.BlendWeights[0]*SkinMatrixArray[shared_vars.BlendIndices[0]];
	weighted_xform += shared_vars.BlendWeights[1]*SkinMatrixArray[shared_vars.BlendIndices[1]];
	weighted_xform += shared_vars.BlendWeights[2]*SkinMatrixArray[shared_vars.BlendIndices[2]];
	weighted_xform += shared_vars.BlendWeights[3]*SkinMatrixArray[shared_vars.BlendIndices[3]];
	float3 world_pos = mul(shared_vars.Pos, weighted_xform);
	output.Pos = mul(float4(world_pos, 1.0), g_ViewProj);
#endif
	
	//save world pos
	shared_vars.WorldPos = float4(world_pos, 1.0);
	//save world xform
	shared_vars.World[0] = float4(weighted_xform[0], 0);
	shared_vars.World[1] = float4(weighted_xform[1], 0);
	shared_vars.World[2] = float4(weighted_xform[2], 0);
	shared_vars.World[3] = float4(weighted_xform[3], 1);
}



void vs_base_uv_scroll_PART(in PGSL_VS_INPUT_skin_additive input, inout PGSL_VS_OUTPUT_skin_additive output, inout PGSL_VS_SHARED_skin_additive shared_vars)
{
	shared_vars.BaseTexUV += g_ElapsedTime*UVScrollRate;
   output.BaseTexUV = shared_vars.BaseTexUV;
}



void vs_fow_uv_PART(in PGSL_VS_INPUT_skin_additive input, inout PGSL_VS_OUTPUT_skin_additive output, inout PGSL_VS_SHARED_skin_additive shared_vars)
{
	output.FowCloudTexcoords.x = dot(g_FowTexU, shared_vars.WorldPos);
	output.FowCloudTexcoords.y = dot(g_FowTexV, shared_vars.WorldPos);
}



void vs_vertex_color_PART(in PGSL_VS_INPUT_skin_additive input, inout PGSL_VS_OUTPUT_skin_additive output, inout PGSL_VS_SHARED_skin_additive shared_vars)
{
	output.VertexColor = shared_vars.VertexColor;
}



void vs_solid_color_modulate_PART(in PGSL_VS_INPUT_skin_additive input, inout PGSL_VS_OUTPUT_skin_additive output, inout PGSL_VS_SHARED_skin_additive shared_vars)
{
	//compute final vertex color and save it off
	shared_vars.SurfaceDiffuse *= Color;
}



void vs_view_dependent_color_modulate_PART(in PGSL_VS_INPUT_skin_additive input, inout PGSL_VS_OUTPUT_skin_additive output, inout PGSL_VS_SHARED_skin_additive shared_vars)
{
    // edge fade
	float3 world_normal = normalize(mul(shared_vars.Normal, (float3x3)shared_vars.World));
	float3 view_norm = normalize(mul(world_normal, (float3x3)g_View));
    
	float t = saturate(view_norm.z);
	t = pow(t,ViewDep_Power);
	float4 rgba = lerp(ViewDep_RGBA_Edge,ViewDep_RGBA_Facing,t);

	shared_vars.SurfaceDiffuse *= rgba;  
}



void vs_identity_lighting_PART(in PGSL_VS_INPUT_skin_additive input, inout PGSL_VS_OUTPUT_skin_additive output, inout PGSL_VS_SHARED_skin_additive shared_vars)
{
	shared_vars.LightDiffuse = float3(1, 1, 1);
	shared_vars.LightSpecular = float3(0, 0, 0);
}



void vs_lightscale_additive_PART(in PGSL_VS_INPUT_skin_additive input, inout PGSL_VS_OUTPUT_skin_additive output, inout PGSL_VS_SHARED_skin_additive shared_vars)
{
  shared_vars.LightDiffuse.rgb *= g_LightScale.rgb;
  shared_vars.SurfaceDiffuse.rgb *= g_LightScale.a;
}



void vs_compose_lighting_diffuse_PART(in PGSL_VS_INPUT_skin_additive input, inout PGSL_VS_OUTPUT_skin_additive output, inout PGSL_VS_SHARED_skin_additive shared_vars)
{
	//do lighting: diffuse only
	shared_vars.Diffuse = shared_vars.LightDiffuse*shared_vars.SurfaceDiffuse.rgb;
	output.Diffuse.rgb = shared_vars.Diffuse.rgb;
	output.Diffuse.a = shared_vars.SurfaceDiffuse.a;
}

PGSL_VS_OUTPUT_skin_additive pass_vs_PGSL_VS_MAIN_skin_additive(PGSL_VS_INPUT_skin_additive meta_shader_in)
{
	PGSL_VS_OUTPUT_skin_additive meta_shader_out = (PGSL_VS_OUTPUT_skin_additive)0;
	PGSL_VS_SHARED_skin_additive meta_shader_shared = (PGSL_VS_SHARED_skin_additive)0;
	pre_vs_position_PART(meta_shader_in, meta_shader_out, meta_shader_shared);
	pre_vs_skin_PART(meta_shader_in, meta_shader_out, meta_shader_shared);
	pre_vs_normal_PART(meta_shader_in, meta_shader_out, meta_shader_shared);
	pre_vs_base_uv_PART(meta_shader_in, meta_shader_out, meta_shader_shared);
	pre_vs_vertex_color_PART(meta_shader_in, meta_shader_out, meta_shader_shared);
	vs_identity_surface_material_PART(meta_shader_in, meta_shader_out, meta_shader_shared);
	vs_skin_PART(meta_shader_in, meta_shader_out, meta_shader_shared);
	vs_base_uv_scroll_PART(meta_shader_in, meta_shader_out, meta_shader_shared);
	vs_fow_uv_PART(meta_shader_in, meta_shader_out, meta_shader_shared);
	vs_vertex_color_PART(meta_shader_in, meta_shader_out, meta_shader_shared);
	vs_solid_color_modulate_PART(meta_shader_in, meta_shader_out, meta_shader_shared);
	vs_view_dependent_color_modulate_PART(meta_shader_in, meta_shader_out, meta_shader_shared);
	vs_identity_lighting_PART(meta_shader_in, meta_shader_out, meta_shader_shared);
	vs_lightscale_additive_PART(meta_shader_in, meta_shader_out, meta_shader_shared);
	vs_compose_lighting_diffuse_PART(meta_shader_in, meta_shader_out, meta_shader_shared);
	return meta_shader_out;
}















/////////////////////////////////////////////////////////////////////
//PIXEL SHADER INPUTS
/////////////////////////////////////////////////////////////////////
PGSL_TEXTURE2D BaseTexture  : DIFFUSEMAP
<
string UIName = "BaseTexture";
string UIType = "bitmap";
string SamplerEnum = "AL_SAMPLER_UVWRAP_MIN_MAG_MIP_BILINEAR_SRGB";
>
;
PGSL_SAMPLER BaseTextureSampler PGSL_SAMPLER_REG(0)
<
string UIName = "BaseTexture";
string UIType = "bitmap";
string SamplerEnum = "AL_SAMPLER_UVWRAP_MIN_MAG_MIP_BILINEAR_SRGB";
PGSL_BIND_TO_TEXTURE(BaseTexture)
string SamplerRegister = "0";
>
PGSL_SAMPLER_STATE(BaseTexture);

float DayNightEffect
<
string UIName = "DayNightEffect";
string UIMin = "0.0";
string UIMax = "1.0";
>
 = 0.0;

PGSL_TEXTURE2D FowTexture
<
string SamplerEnum = "AL_SAMPLER_UVCLAMP_MIN_MAG_MIP_BILINEAR_SRGB";
>
;
PGSL_SAMPLER FowTextureSampler PGSL_SAMPLER_REG(1)
<
string SamplerEnum = "AL_SAMPLER_UVCLAMP_MIN_MAG_MIP_BILINEAR_SRGB";
PGSL_BIND_TO_TEXTURE(FowTexture)
string SamplerRegister = "1";
>
PGSL_SAMPLER_STATE(FowTexture);




/////////////////////////////////////////////////////////////////////
//PIXEL SHADER OUTPUTS
/////////////////////////////////////////////////////////////////////
struct PGSL_PS_OUTPUT_skin_additive
{
	float4 Color0  : PGSL_TARGET0;
};



/////////////////////////////////////////////////////////////////////
//PIXEL SHADER SHARED STRUCT
/////////////////////////////////////////////////////////////////////
struct PGSL_PS_SHARED_skin_additive
{
	float2 BaseTexUV;
	float4 SurfaceDiffuse;
	float3 SurfaceSpecular;
	float4 Albedo;
	float3 LightDiffuse;
	float3 Diffuse;
};



/////////////////////////////////////////////////////////////////////
//PIXEL SHADERS
/////////////////////////////////////////////////////////////////////


void pre_ps_base_uv_PART(inout PGSL_PS_INPUT_skin_additive input, inout PGSL_PS_OUTPUT_skin_additive output, inout PGSL_PS_SHARED_skin_additive shared_vars)
{
	shared_vars.BaseTexUV = input.BaseTexUV;
}



void ps_identity_surface_material_PART(in PGSL_PS_INPUT_skin_additive input, inout PGSL_PS_OUTPUT_skin_additive output, inout PGSL_PS_SHARED_skin_additive shared_vars)
{
	shared_vars.SurfaceDiffuse = float4(1, 1, 1, 1);
	shared_vars.SurfaceSpecular = float3(1, 1, 1);
}



void ps_base_texture_PART(in PGSL_PS_INPUT_skin_additive input, inout PGSL_PS_OUTPUT_skin_additive output, inout PGSL_PS_SHARED_skin_additive shared_vars)
{
	shared_vars.Albedo = PGSL_TEX2D(BaseTexture, BaseTextureSampler, shared_vars.BaseTexUV);
	shared_vars.SurfaceDiffuse *= shared_vars.Albedo;
}

#undef DYNAMIC_BRIGHTEN_FACTOR
#define DYNAMIC_BRIGHTEN_FACTOR 1.0 


void ps_vertex_color_modulate_PART(in PGSL_PS_INPUT_skin_additive input, inout PGSL_PS_OUTPUT_skin_additive output, inout PGSL_PS_SHARED_skin_additive shared_vars)
{
	shared_vars.SurfaceDiffuse.rgb *= (input.VertexColor.rgb*DYNAMIC_BRIGHTEN_FACTOR);
}



void ps_vertex_diffuse_PART(in PGSL_PS_INPUT_skin_additive input, inout PGSL_PS_OUTPUT_skin_additive output, inout PGSL_PS_SHARED_skin_additive shared_vars)
{
	shared_vars.LightDiffuse.rgb += input.Diffuse.rgb;
}



void ps_compose_lighting_diffuse_no_2X_PART(in PGSL_PS_INPUT_skin_additive input, inout PGSL_PS_OUTPUT_skin_additive output, inout PGSL_PS_SHARED_skin_additive shared_vars)
{
  shared_vars.Diffuse = shared_vars.SurfaceDiffuse.rgb*shared_vars.LightDiffuse;
  //output the final diffuse color
  output.Color0.rgb = shared_vars.Diffuse.rgb;
  output.Color0.a = shared_vars.SurfaceDiffuse.a;
}



void ps_daynight_PART(in PGSL_PS_INPUT_skin_additive input, inout PGSL_PS_OUTPUT_skin_additive output, inout PGSL_PS_SHARED_skin_additive shared_vars)
{
  //modulate the daynight effect into the current accum diffuse
  float4 day_night_effect = saturate(g_DayNightFactor + (1.0 - DayNightEffect));
  output.Color0 *= day_night_effect;
}



void ps_fow_PART(in PGSL_PS_INPUT_skin_additive input, inout PGSL_PS_OUTPUT_skin_additive output, inout PGSL_PS_SHARED_skin_additive shared_vars)
 {
#if !defined(PGSL_MAX)
	
	 float4 fow_texel = PGSL_TEX2D(FowTexture, FowTextureSampler, input.FowCloudTexcoords.xy);
	 float lum = dot(output.Color0.rgb, LumVec);
	 output.Color0.rgb = lerp(fow_texel.rgb*lum.xxx, output.Color0.rgb, fow_texel.a);
	
#endif
 }

PGSL_PS_OUTPUT_skin_additive pass_ps_PGSL_PS_MAIN_skin_additive(PGSL_PS_INPUT_skin_additive meta_shader_in)
{
	PGSL_PS_OUTPUT_skin_additive meta_shader_out = (PGSL_PS_OUTPUT_skin_additive)0;
	PGSL_PS_SHARED_skin_additive meta_shader_shared = (PGSL_PS_SHARED_skin_additive)0;
	pre_ps_base_uv_PART(meta_shader_in, meta_shader_out, meta_shader_shared);
	ps_identity_surface_material_PART(meta_shader_in, meta_shader_out, meta_shader_shared);
	ps_base_texture_PART(meta_shader_in, meta_shader_out, meta_shader_shared);
	ps_vertex_color_modulate_PART(meta_shader_in, meta_shader_out, meta_shader_shared);
	ps_vertex_diffuse_PART(meta_shader_in, meta_shader_out, meta_shader_shared);
	ps_compose_lighting_diffuse_no_2X_PART(meta_shader_in, meta_shader_out, meta_shader_shared);
	ps_daynight_PART(meta_shader_in, meta_shader_out, meta_shader_shared);
	ps_fow_PART(meta_shader_in, meta_shader_out, meta_shader_shared);
	return meta_shader_out;
}



/////////////////////////////////////////////////////////////////////
//SHADER'S PASSES
/////////////////////////////////////////////////////////////////////
PGSL_TECHNIQUE_BEGIN
	PGSL_PASS_BEGIN(pass_0, 
	<
		string _RasterizeState_ = "ALRS_DEFAULT";string _BlendState_ = "ALBS_ADDITIVE";string _DepthStencilState_ = "ALDS_DEPTHLESSEQUALNOWRITE_STENCILDISABLE";
	>)
		PGSL_PASS_VS(pass_vs_PGSL_VS_MAIN_skin_additive, 0)
		PGSL_PASS_PS(pass_ps_PGSL_PS_MAIN_skin_additive, 0)
	PGSL_PASS_END
PGSL_TECHNIQUE_END



