//////////////////////////////////////////////////////////////////////////////////////////////////////////
//
//Petroglyph Confidential Source Code -- Do Not Distribute
//
// (Auto generated by PGSLCodeGenerator)
//Platform: MAX
//////////////////////////////////////////////////////////////////////////////////////////////////////////
#define PGSL_MAX
#define PGSL_DX9
#include"..\common\PGSLAlways.pgh"
#include"..\common\AlamoEngine.pgh"
#include"..\common\AlamoEngine_Skinning.pgh"

float g_ShaderFileDummyVariable : SHADER_FILE_ANNOTATION
<
string _ALAMO_RENDER_PHASE = "Transparent";
string _ALAMO_VERTEX_PROC = "RSkin";
string _ALAMO_VERTEX_TYPE = "alD3dVertRSkinNU2";
bool _ALAMO_TANGENT_SPACE = false;
int _ALAMO_BONES_PER_VERTEX = 1;
>;

#define PGSL_PS_INPUT_rskin_hologram2 PGSL_VS_OUTPUT_rskin_hologram2



/////////////////////////////////////////////////////////////////////
//VERTEX SHADER INPUTS
/////////////////////////////////////////////////////////////////////
float4 UVOffset
<
string UIName = "UVOffset";
>
 = {0, 0, 0, 0};

float2 UVScrollRate
<
string UIName = "UVScrollRate";
>
 = {0, 0};

float4x4 ScreenspaceUVTransform = {
			float4(0.5, 0, 0, 0),
			float4(0, -0.5, 0, 0),
			float4(0, 0, 0.5, 0),
			float4(0.5, 0.5, 0.5, 1.0)
			};

float HologramTextureWidth
<
string UIName = "HologramTextureWidth";
string UIType = "MaxSpinner";
float UIMin = 1.0;
float UIMax = 1024.0;
>
 = 128;

float HologramTextureHeight
<
string UIName = "HologramTextureHeight";
string UIType = "MaxSpinner";
float UIMin = 1.0;
float UIMax = 1024.0;
>
 = 128;

float2 HologramUVScrollRate
<
string UIName = "HologramUVScrollRate";
>
 = {0, 0};

float4 RimColor
<
string UIName = "RimColor";
string UIType = "ColorSwatch";
bool GammaCorrect = true;
>
 = {0.0, 0.0, 0.0, 0.0};

struct PGSL_VS_INPUT_rskin_hologram2
{
	float3 Pos  : PGSL_POSITION;
	PGSL_PACKED_FLOAT4 Normal  : PGSL_NORMAL;
	float2 BaseTexUV  : PGSL_TEXCOORD0;
};



/////////////////////////////////////////////////////////////////////
//VERTEX SHADER OUTPUTS
/////////////////////////////////////////////////////////////////////
struct PGSL_VS_OUTPUT_rskin_hologram2
{
	float4 Pos  : PGSL_SV_POSITION;
	float2 BaseTexUV  : PGSL_TEXCOORD0;
	float4 ScreenspaceUV  : PGSL_TEXCOORD1;
	float3 VertexColor  : PGSL_COLOR0;
	float4 FowCloudTexcoords  : PGSL_TEXCOORD2;
	float3 RimLight  : PGSL_TEXCOORD3;
	float Fog  : PGSL_TEXCOORD4;
};



/////////////////////////////////////////////////////////////////////
//VERTEX SHADER SHARED STRUCT
/////////////////////////////////////////////////////////////////////
struct PGSL_VS_SHARED_rskin_hologram2
{
	float4 Pos;
	float3 Normal;
	PGSL_PACKED_FLOAT RSkinMatrixIndex;
	float2 BaseTexUV;
	float4 WorldPos;
	float4x4 World;
};



/////////////////////////////////////////////////////////////////////
//VERTEX SHADERS
/////////////////////////////////////////////////////////////////////


void pre_vs_position_PART(inout PGSL_VS_INPUT_rskin_hologram2 input, inout PGSL_VS_OUTPUT_rskin_hologram2 output, inout PGSL_VS_SHARED_rskin_hologram2 shared_vars)
{
	shared_vars.Pos = float4(input.Pos.xyz, 1.0);
}



void pre_vs_unpack_rskin_normal_PART(inout PGSL_VS_INPUT_rskin_hologram2 input, inout PGSL_VS_OUTPUT_rskin_hologram2 output, inout PGSL_VS_SHARED_rskin_hologram2 shared_vars)
{
	shared_vars.Normal = Unpack_Normal(input.Normal.xyz);
	shared_vars.RSkinMatrixIndex = input.Normal.w;
}



void pre_vs_base_uv_PART(inout PGSL_VS_INPUT_rskin_hologram2 input, inout PGSL_VS_OUTPUT_rskin_hologram2 output, inout PGSL_VS_SHARED_rskin_hologram2 shared_vars)
{
	shared_vars.BaseTexUV = input.BaseTexUV;
}



void vs_rskin_PART(in PGSL_VS_INPUT_rskin_hologram2 input, inout PGSL_VS_OUTPUT_rskin_hologram2 output, inout PGSL_VS_SHARED_rskin_hologram2 shared_vars)
{
	//skinning
	float4x3 xform;
#if defined(PGSL_MAX)
	xform = g_World;
	float3 world_pos = mul(shared_vars.Pos, xform);
	output.Pos = mul(float4(world_pos, 1.0), g_View);
	output.Pos = mul(output.Pos, g_Proj);
#else
	xform = SkinMatrixArray[shared_vars.RSkinMatrixIndex];
	float3 world_pos = mul(shared_vars.Pos, xform);
	output.Pos = mul(float4(world_pos, 1.0), g_ViewProj);
#endif

	//save world pos
	shared_vars.WorldPos = float4(world_pos, 1.0);
	//save world xform
	shared_vars.World[0] = float4(xform[0], 0);
	shared_vars.World[1] = float4(xform[1], 0);
	shared_vars.World[2] = float4(xform[2], 0);
	shared_vars.World[3] = float4(xform[3], 1);
}



void vs_base_uv_offset_PART(in PGSL_VS_INPUT_rskin_hologram2 input, inout PGSL_VS_OUTPUT_rskin_hologram2 output, inout PGSL_VS_SHARED_rskin_hologram2 shared_vars)
{
   shared_vars.BaseTexUV.xy += UVOffset.xy;
   output.BaseTexUV = shared_vars.BaseTexUV;
}



void vs_base_uv_scroll_PART(in PGSL_VS_INPUT_rskin_hologram2 input, inout PGSL_VS_OUTPUT_rskin_hologram2 output, inout PGSL_VS_SHARED_rskin_hologram2 shared_vars)
{
	shared_vars.BaseTexUV += g_ElapsedTime*UVScrollRate;
   output.BaseTexUV = shared_vars.BaseTexUV;
}



void vs_hologram2_PART(in PGSL_VS_INPUT_rskin_hologram2 input, inout PGSL_VS_OUTPUT_rskin_hologram2 output, inout PGSL_VS_SHARED_rskin_hologram2 shared_vars)
{
	//screenspace uv xform
	output.ScreenspaceUV = mul(output.Pos, ScreenspaceUVTransform);

	//scale to get 1:1 texel/pixel ratio
	float2 scale = float2(g_ResolutionConstants.x/HologramTextureWidth, g_ResolutionConstants.y/HologramTextureHeight);
	output.ScreenspaceUV.xy *= scale.xy;

	//scroll
	//first, xform scrolling value into screenspace
	float2 uv_scroll = HologramUVScrollRate.xy*g_ResolutionConstants.zw*2.0;
	uv_scroll *= output.ScreenspaceUV.w;
	uv_scroll.y = -uv_scroll.y;
	output.ScreenspaceUV.xy += g_ElapsedTime*uv_scroll.xy;

	Offset_Half_Pixel(output.ScreenspaceUV.xy, output.ScreenspaceUV.w);
}



void vs_fow_uv_PART(in PGSL_VS_INPUT_rskin_hologram2 input, inout PGSL_VS_OUTPUT_rskin_hologram2 output, inout PGSL_VS_SHARED_rskin_hologram2 shared_vars)
{
	output.FowCloudTexcoords.x = dot(g_FowTexU, shared_vars.WorldPos);
	output.FowCloudTexcoords.y = dot(g_FowTexV, shared_vars.WorldPos);
}



void vs_rim_light_PART(in PGSL_VS_INPUT_rskin_hologram2 input, inout PGSL_VS_OUTPUT_rskin_hologram2 output, inout PGSL_VS_SHARED_rskin_hologram2 shared_vars)
{
	float3 world_normal = mul(shared_vars.Normal, (float3x3)shared_vars.World);
	float3 world_view_vec = normalize(g_EyePos.xyz - shared_vars.WorldPos.xyz);
	float rim_amount = (1.0 - dot(world_normal, world_view_vec));
	
	
	//rim_amount = pow(rim_amount,2.0f + 2.0f*sin(4.0f*g_ElapsedTime));
	rim_amount = rim_amount*rim_amount; //pow(rim_amount,2.0f);
	output.RimLight = rim_amount*RimColor.rgb;
}



void vs_fog_PART(in PGSL_VS_INPUT_rskin_hologram2 input, inout PGSL_VS_OUTPUT_rskin_hologram2 output, inout PGSL_VS_SHARED_rskin_hologram2 shared_vars)
{
	float fog = length(output.Pos.xyz);
	output.Fog = saturate(g_FogValues.x*fog + g_FogValues.y);
}

PGSL_VS_OUTPUT_rskin_hologram2 pass_vs_PGSL_VS_MAIN_rskin_hologram2(PGSL_VS_INPUT_rskin_hologram2 meta_shader_in)
{
	PGSL_VS_OUTPUT_rskin_hologram2 meta_shader_out = (PGSL_VS_OUTPUT_rskin_hologram2)0;
	PGSL_VS_SHARED_rskin_hologram2 meta_shader_shared = (PGSL_VS_SHARED_rskin_hologram2)0;
	pre_vs_position_PART(meta_shader_in, meta_shader_out, meta_shader_shared);
	pre_vs_unpack_rskin_normal_PART(meta_shader_in, meta_shader_out, meta_shader_shared);
	pre_vs_base_uv_PART(meta_shader_in, meta_shader_out, meta_shader_shared);
	vs_rskin_PART(meta_shader_in, meta_shader_out, meta_shader_shared);
	vs_base_uv_offset_PART(meta_shader_in, meta_shader_out, meta_shader_shared);
	vs_base_uv_scroll_PART(meta_shader_in, meta_shader_out, meta_shader_shared);
	vs_hologram2_PART(meta_shader_in, meta_shader_out, meta_shader_shared);
	vs_fow_uv_PART(meta_shader_in, meta_shader_out, meta_shader_shared);
	vs_rim_light_PART(meta_shader_in, meta_shader_out, meta_shader_shared);
	vs_fog_PART(meta_shader_in, meta_shader_out, meta_shader_shared);
	return meta_shader_out;
}















/////////////////////////////////////////////////////////////////////
//PIXEL SHADER INPUTS
/////////////////////////////////////////////////////////////////////
PGSL_TEXTURE2D BaseTexture  : DIFFUSEMAP
<
string UIName = "BaseTexture";
string UIType = "bitmap";
string SamplerEnum = "AL_SAMPLER_UVWRAP_MIN_MAG_MIP_BILINEAR_SRGB";
>
;
PGSL_SAMPLER BaseTextureSampler PGSL_SAMPLER_REG(0)
<
string UIName = "BaseTexture";
string UIType = "bitmap";
string SamplerEnum = "AL_SAMPLER_UVWRAP_MIN_MAG_MIP_BILINEAR_SRGB";
PGSL_BIND_TO_TEXTURE(BaseTexture)
string SamplerRegister = "0";
>
PGSL_SAMPLER_STATE(BaseTexture);

PGSL_TEXTURE2D HologramTexture
<
string UIName = "HologramTexture";
string UIType = "bitmap";
string SamplerEnum = "AL_SAMPLER_UVWRAP_MIN_MAG_MIP_BILINEAR";
>
;
PGSL_SAMPLER HologramTextureSampler PGSL_SAMPLER_REG(1)
<
string UIName = "HologramTexture";
string UIType = "bitmap";
string SamplerEnum = "AL_SAMPLER_UVWRAP_MIN_MAG_MIP_BILINEAR";
PGSL_BIND_TO_TEXTURE(HologramTexture)
string SamplerRegister = "1";
>
PGSL_SAMPLER_STATE(HologramTexture);

float HologramFlickerSpeed
<
string UIName = "HologramFlickerSpeed";
>
 = 0.0;

float4 HologramColor
<
string UIName = "HologramColor";
>
 = {1.0, 1.0, 1.0, 1.0};

PGSL_TEXTURE2D FowTexture
<
string SamplerEnum = "AL_SAMPLER_UVCLAMP_MIN_MAG_MIP_BILINEAR_SRGB";
>
;
PGSL_SAMPLER FowTextureSampler PGSL_SAMPLER_REG(2)
<
string SamplerEnum = "AL_SAMPLER_UVCLAMP_MIN_MAG_MIP_BILINEAR_SRGB";
PGSL_BIND_TO_TEXTURE(FowTexture)
string SamplerRegister = "2";
>
PGSL_SAMPLER_STATE(FowTexture);




/////////////////////////////////////////////////////////////////////
//PIXEL SHADER OUTPUTS
/////////////////////////////////////////////////////////////////////
struct PGSL_PS_OUTPUT_rskin_hologram2
{
	float4 Color0  : PGSL_TARGET0;
};



/////////////////////////////////////////////////////////////////////
//PIXEL SHADER SHARED STRUCT
/////////////////////////////////////////////////////////////////////
struct PGSL_PS_SHARED_rskin_hologram2
{
	float2 BaseTexUV;
	float2 ScreenspaceUV;
};



/////////////////////////////////////////////////////////////////////
//PIXEL SHADERS
/////////////////////////////////////////////////////////////////////


void pre_ps_base_uv_PART(inout PGSL_PS_INPUT_rskin_hologram2 input, inout PGSL_PS_OUTPUT_rskin_hologram2 output, inout PGSL_PS_SHARED_rskin_hologram2 shared_vars)
{
	shared_vars.BaseTexUV = input.BaseTexUV;
}



void pre_ps_screenspace_uv_PART(inout PGSL_PS_INPUT_rskin_hologram2 input, inout PGSL_PS_OUTPUT_rskin_hologram2 output, inout PGSL_PS_SHARED_rskin_hologram2 shared_vars)
{
	shared_vars.ScreenspaceUV = input.ScreenspaceUV.xy/input.ScreenspaceUV.w;
}



void ps_hologram2_PART(in PGSL_PS_INPUT_rskin_hologram2 input, inout PGSL_PS_OUTPUT_rskin_hologram2 output, inout PGSL_PS_SHARED_rskin_hologram2 shared_vars)
{
   //here is the convention for the hologram texel:
   //R: masking information, allow masking off the final pixel completely (per pixel term)
   //G: flickering information, allow the entire hologram mesh to flicker on and off (per frame term)
   //B: hologram pattern (per pixel term)
   //A: unused
	float4 base_texel = PGSL_TEX2D(BaseTexture, BaseTextureSampler, shared_vars.BaseTexUV);
 
   float4 hologram_texel = PGSL_TEX2D(HologramTexture, HologramTextureSampler, shared_vars.ScreenspaceUV);
   
   float2 flicker_uv = float2(0, g_ElapsedTime*HologramFlickerSpeed);
   float flicker = PGSL_TEX2D(HologramTexture, HologramTextureSampler, flicker_uv).g;
  
   float3 pixel = base_texel.rgb + hologram_texel.bbb*HologramColor.rgb;
   
   //alpha needs to account for: masking, flickering and transparency
   float alpha = hologram_texel.r*flicker*HologramColor.a;
   
   output.Color0.rgba = float4(pixel.rgb, alpha) * g_LightScale;   
}



void ps_rim_light_PART(in PGSL_PS_INPUT_rskin_hologram2 input, inout PGSL_PS_OUTPUT_rskin_hologram2 output, inout PGSL_PS_SHARED_rskin_hologram2 shared_vars)
{
	output.Color0.rgb += input.RimLight.rgb;
}



void ps_fow_PART(in PGSL_PS_INPUT_rskin_hologram2 input, inout PGSL_PS_OUTPUT_rskin_hologram2 output, inout PGSL_PS_SHARED_rskin_hologram2 shared_vars)
 {
#if !defined(PGSL_MAX)
	
	 float4 fow_texel = PGSL_TEX2D(FowTexture, FowTextureSampler, input.FowCloudTexcoords.xy);
	 float lum = dot(output.Color0.rgb, LumVec);
	 output.Color0.rgb = lerp(fow_texel.rgb*lum.xxx, output.Color0.rgb, fow_texel.a);
	
#endif
 }



void ps_fog_PART(in PGSL_PS_INPUT_rskin_hologram2 input, inout PGSL_PS_OUTPUT_rskin_hologram2 output, inout PGSL_PS_SHARED_rskin_hologram2 shared_vars)
{
	output.Color0.rgb = lerp(g_FogColor.rgb, output.Color0.rgb, input.Fog);
}

PGSL_PS_OUTPUT_rskin_hologram2 pass_ps_PGSL_PS_MAIN_rskin_hologram2(PGSL_PS_INPUT_rskin_hologram2 meta_shader_in)
{
	PGSL_PS_OUTPUT_rskin_hologram2 meta_shader_out = (PGSL_PS_OUTPUT_rskin_hologram2)0;
	PGSL_PS_SHARED_rskin_hologram2 meta_shader_shared = (PGSL_PS_SHARED_rskin_hologram2)0;
	pre_ps_base_uv_PART(meta_shader_in, meta_shader_out, meta_shader_shared);
	pre_ps_screenspace_uv_PART(meta_shader_in, meta_shader_out, meta_shader_shared);
	ps_hologram2_PART(meta_shader_in, meta_shader_out, meta_shader_shared);
	ps_rim_light_PART(meta_shader_in, meta_shader_out, meta_shader_shared);
	ps_fow_PART(meta_shader_in, meta_shader_out, meta_shader_shared);
	ps_fog_PART(meta_shader_in, meta_shader_out, meta_shader_shared);
	return meta_shader_out;
}



/////////////////////////////////////////////////////////////////////
//SHADER'S PASSES
/////////////////////////////////////////////////////////////////////
PGSL_TECHNIQUE_BEGIN
	PGSL_PASS_BEGIN(pass_0, 
	<
		string _RasterizeState_ = "ALRS_DEFAULT";string _BlendState_ = "ALBS_ALPHA_BLEND";string _DepthStencilState_ = "ALDS_DEPTHLESSEQUALWRITE_STENCILDISABLE";
	>)
		PGSL_PASS_VS(pass_vs_PGSL_VS_MAIN_rskin_hologram2, 0)
		PGSL_PASS_PS(pass_ps_PGSL_PS_MAIN_rskin_hologram2, 0)
	PGSL_PASS_END
PGSL_TECHNIQUE_END



