//////////////////////////////////////////////////////////////////////////////////////////////////////////
//
//Petroglyph Confidential Source Code -- Do Not Distribute
//
// (Auto generated by PGSLCodeGenerator)
//Platform: MAX
//////////////////////////////////////////////////////////////////////////////////////////////////////////
#define PGSL_MAX
#define PGSL_DX9
#include"..\common\PGSLAlways.pgh"
#include"..\common\AlamoEngine.pgh"
#include"..\common\AlamoEngine_Skinning.pgh"

float g_ShaderFileDummyVariable : SHADER_FILE_ANNOTATION
<
string _ALAMO_RENDER_PHASE = "Transparent";
string _ALAMO_VERTEX_PROC = "RSkin";
string _ALAMO_VERTEX_TYPE = "alD3dVertRSkinNU2C";
bool _ALAMO_TANGENT_SPACE = false;
bool _ALAMO_SHADOW_VOLUME = false;
bool _ALAMO_Z_SORT = true;
int _ALAMO_BONES_PER_VERTEX = 1;
>;

#define PGSL_PS_INPUT_rskin_alpha_ui PGSL_VS_OUTPUT_rskin_alpha_ui



/////////////////////////////////////////////////////////////////////
//VERTEX SHADER INPUTS
/////////////////////////////////////////////////////////////////////
float2 UVScrollRate
<
string UIName = "UVScrollRate";
>
 = {0, 0};

struct PGSL_VS_INPUT_rskin_alpha_ui
{
	float3 Pos  : PGSL_POSITION;
	PGSL_PACKED_FLOAT4 Normal  : PGSL_NORMAL;
	float2 BaseTexUV  : PGSL_TEXCOORD0;
	float4 Color  : PGSL_COLOR0;
};



/////////////////////////////////////////////////////////////////////
//VERTEX SHADER OUTPUTS
/////////////////////////////////////////////////////////////////////
struct PGSL_VS_OUTPUT_rskin_alpha_ui
{
	float4 Pos  : PGSL_SV_POSITION;
	float2 BaseTexUV  : PGSL_TEXCOORD0;
	float4 VertexColor  : PGSL_COLOR0;
	float4 Diffuse  : PGSL_TEXCOORD1;
	float Fog  : PGSL_TEXCOORD2;
};



/////////////////////////////////////////////////////////////////////
//VERTEX SHADER SHARED STRUCT
/////////////////////////////////////////////////////////////////////
struct PGSL_VS_SHARED_rskin_alpha_ui
{
	float4 Pos;
	float3 Normal;
	PGSL_PACKED_FLOAT RSkinMatrixIndex;
	float2 BaseTexUV;
	float4 VertexColor;
	float4 SurfaceDiffuse;
	float3 SurfaceSpecular;
	float4 WorldPos;
	float4x4 World;
	float3 LightDiffuse;
	float3 Diffuse;
};



/////////////////////////////////////////////////////////////////////
//VERTEX SHADERS
/////////////////////////////////////////////////////////////////////


void pre_vs_position_PART(inout PGSL_VS_INPUT_rskin_alpha_ui input, inout PGSL_VS_OUTPUT_rskin_alpha_ui output, inout PGSL_VS_SHARED_rskin_alpha_ui shared_vars)
{
	shared_vars.Pos = float4(input.Pos.xyz, 1.0);
}



void pre_vs_unpack_rskin_normal_PART(inout PGSL_VS_INPUT_rskin_alpha_ui input, inout PGSL_VS_OUTPUT_rskin_alpha_ui output, inout PGSL_VS_SHARED_rskin_alpha_ui shared_vars)
{
	shared_vars.Normal = Unpack_Normal(input.Normal.xyz);
	shared_vars.RSkinMatrixIndex = input.Normal.w;
}



void pre_vs_base_uv_PART(inout PGSL_VS_INPUT_rskin_alpha_ui input, inout PGSL_VS_OUTPUT_rskin_alpha_ui output, inout PGSL_VS_SHARED_rskin_alpha_ui shared_vars)
{
	shared_vars.BaseTexUV = input.BaseTexUV;
}



void pre_vs_vertex_color_PART(inout PGSL_VS_INPUT_rskin_alpha_ui input, inout PGSL_VS_OUTPUT_rskin_alpha_ui output, inout PGSL_VS_SHARED_rskin_alpha_ui shared_vars)
{
	shared_vars.VertexColor = input.Color;
}



void vs_identity_surface_material_PART(in PGSL_VS_INPUT_rskin_alpha_ui input, inout PGSL_VS_OUTPUT_rskin_alpha_ui output, inout PGSL_VS_SHARED_rskin_alpha_ui shared_vars)
{
	shared_vars.SurfaceDiffuse = float4(1, 1, 1, 1);
	shared_vars.SurfaceSpecular = float3(1, 1, 1);
}



void vs_rskin_PART(in PGSL_VS_INPUT_rskin_alpha_ui input, inout PGSL_VS_OUTPUT_rskin_alpha_ui output, inout PGSL_VS_SHARED_rskin_alpha_ui shared_vars)
{
	//skinning
	float4x3 xform;
#if defined(PGSL_MAX)
	xform = g_World;
	float3 world_pos = mul(shared_vars.Pos, xform);
	output.Pos = mul(float4(world_pos, 1.0), g_View);
	output.Pos = mul(output.Pos, g_Proj);
#else
	xform = SkinMatrixArray[shared_vars.RSkinMatrixIndex];
	float3 world_pos = mul(shared_vars.Pos, xform);
	output.Pos = mul(float4(world_pos, 1.0), g_ViewProj);
#endif

	//save world pos
	shared_vars.WorldPos = float4(world_pos, 1.0);
	//save world xform
	shared_vars.World[0] = float4(xform[0], 0);
	shared_vars.World[1] = float4(xform[1], 0);
	shared_vars.World[2] = float4(xform[2], 0);
	shared_vars.World[3] = float4(xform[3], 1);
}



void vs_base_uv_scroll_PART(in PGSL_VS_INPUT_rskin_alpha_ui input, inout PGSL_VS_OUTPUT_rskin_alpha_ui output, inout PGSL_VS_SHARED_rskin_alpha_ui shared_vars)
{
	shared_vars.BaseTexUV += g_ElapsedTime*UVScrollRate;
   output.BaseTexUV = shared_vars.BaseTexUV;
}



void vs_sph_lighting_all_PART(in PGSL_VS_INPUT_rskin_alpha_ui input, inout PGSL_VS_OUTPUT_rskin_alpha_ui output, inout PGSL_VS_SHARED_rskin_alpha_ui shared_vars)
{
	float3 world_normal = normalize(mul(shared_vars.Normal, (float3x3)shared_vars.World));
	shared_vars.LightDiffuse.rgb += Sph_Compute_Diffuse_Light_All(world_normal);
}



void vs_vertex_color_PART(in PGSL_VS_INPUT_rskin_alpha_ui input, inout PGSL_VS_OUTPUT_rskin_alpha_ui output, inout PGSL_VS_SHARED_rskin_alpha_ui shared_vars)
{
	output.VertexColor = shared_vars.VertexColor;
}



void vs_vertex_alpha_PART(in PGSL_VS_INPUT_rskin_alpha_ui input, inout PGSL_VS_OUTPUT_rskin_alpha_ui output, inout PGSL_VS_SHARED_rskin_alpha_ui shared_vars)
{
	shared_vars.SurfaceDiffuse.a = shared_vars.VertexColor.a;
}



void vs_compose_lighting_diffuse_PART(in PGSL_VS_INPUT_rskin_alpha_ui input, inout PGSL_VS_OUTPUT_rskin_alpha_ui output, inout PGSL_VS_SHARED_rskin_alpha_ui shared_vars)
{
	//do lighting: diffuse only
	shared_vars.Diffuse = shared_vars.LightDiffuse*shared_vars.SurfaceDiffuse.rgb;
	output.Diffuse.rgb = shared_vars.Diffuse.rgb;
	output.Diffuse.a = shared_vars.SurfaceDiffuse.a;
}



void vs_fog_PART(in PGSL_VS_INPUT_rskin_alpha_ui input, inout PGSL_VS_OUTPUT_rskin_alpha_ui output, inout PGSL_VS_SHARED_rskin_alpha_ui shared_vars)
{
	float fog = length(output.Pos.xyz);
	output.Fog = saturate(g_FogValues.x*fog + g_FogValues.y);
}

PGSL_VS_OUTPUT_rskin_alpha_ui pass_vs_PGSL_VS_MAIN_rskin_alpha_ui(PGSL_VS_INPUT_rskin_alpha_ui meta_shader_in)
{
	PGSL_VS_OUTPUT_rskin_alpha_ui meta_shader_out = (PGSL_VS_OUTPUT_rskin_alpha_ui)0;
	PGSL_VS_SHARED_rskin_alpha_ui meta_shader_shared = (PGSL_VS_SHARED_rskin_alpha_ui)0;
	pre_vs_position_PART(meta_shader_in, meta_shader_out, meta_shader_shared);
	pre_vs_unpack_rskin_normal_PART(meta_shader_in, meta_shader_out, meta_shader_shared);
	pre_vs_base_uv_PART(meta_shader_in, meta_shader_out, meta_shader_shared);
	pre_vs_vertex_color_PART(meta_shader_in, meta_shader_out, meta_shader_shared);
	vs_identity_surface_material_PART(meta_shader_in, meta_shader_out, meta_shader_shared);
	vs_rskin_PART(meta_shader_in, meta_shader_out, meta_shader_shared);
	vs_base_uv_scroll_PART(meta_shader_in, meta_shader_out, meta_shader_shared);
	vs_sph_lighting_all_PART(meta_shader_in, meta_shader_out, meta_shader_shared);
	vs_vertex_color_PART(meta_shader_in, meta_shader_out, meta_shader_shared);
	vs_vertex_alpha_PART(meta_shader_in, meta_shader_out, meta_shader_shared);
	vs_compose_lighting_diffuse_PART(meta_shader_in, meta_shader_out, meta_shader_shared);
	vs_fog_PART(meta_shader_in, meta_shader_out, meta_shader_shared);
	return meta_shader_out;
}















/////////////////////////////////////////////////////////////////////
//PIXEL SHADER INPUTS
/////////////////////////////////////////////////////////////////////
float4 Diffuse
<
string UIName = "Diffuse";
string UIType = "ColorSwatch";
bool GammaCorrect = true;
>
 = {1.0, 1.0, 1.0, 1.0};

float4 Specular
<
string UIName = "Specular";
string UIType = "ColorSwatch";
bool GammaCorrect = true;
>
 = {1.0, 1.0, 1.0, 1.0};

float4 Emissive
<
string UIName = "Emissive";
string UIType = "ColorSwatch";
bool GammaCorrect = true;
>
 = {0.0, 0.0, 0.0, 0.0};

PGSL_TEXTURE2D BaseTexture  : DIFFUSEMAP
<
string UIName = "BaseTexture";
string UIType = "bitmap";
string SamplerEnum = "AL_SAMPLER_UVWRAP_MIN_MAG_MIP_BILINEAR_SRGB";
>
;
PGSL_SAMPLER BaseTextureSampler PGSL_SAMPLER_REG(0)
<
string UIName = "BaseTexture";
string UIType = "bitmap";
string SamplerEnum = "AL_SAMPLER_UVWRAP_MIN_MAG_MIP_BILINEAR_SRGB";
PGSL_BIND_TO_TEXTURE(BaseTexture)
string SamplerRegister = "0";
>
PGSL_SAMPLER_STATE(BaseTexture);




/////////////////////////////////////////////////////////////////////
//PIXEL SHADER OUTPUTS
/////////////////////////////////////////////////////////////////////
struct PGSL_PS_OUTPUT_rskin_alpha_ui
{
	float4 Color0  : PGSL_TARGET0;
};



/////////////////////////////////////////////////////////////////////
//PIXEL SHADER SHARED STRUCT
/////////////////////////////////////////////////////////////////////
struct PGSL_PS_SHARED_rskin_alpha_ui
{
	float2 BaseTexUV;
	float4 SurfaceDiffuse;
	float3 SurfaceSpecular;
	float3 SurfaceEmissive;
	float4 Albedo;
	float3 LightDiffuse;
	float3 Diffuse;
};



/////////////////////////////////////////////////////////////////////
//PIXEL SHADERS
/////////////////////////////////////////////////////////////////////


void pre_ps_base_uv_PART(inout PGSL_PS_INPUT_rskin_alpha_ui input, inout PGSL_PS_OUTPUT_rskin_alpha_ui output, inout PGSL_PS_SHARED_rskin_alpha_ui shared_vars)
{
	shared_vars.BaseTexUV = input.BaseTexUV;
}



void ps_surface_material_PART(in PGSL_PS_INPUT_rskin_alpha_ui input, inout PGSL_PS_OUTPUT_rskin_alpha_ui output, inout PGSL_PS_SHARED_rskin_alpha_ui shared_vars)
{
	shared_vars.SurfaceDiffuse = Diffuse;
	shared_vars.SurfaceSpecular = Specular.rgb;
}



void ps_surface_emissive_PART(in PGSL_PS_INPUT_rskin_alpha_ui input, inout PGSL_PS_OUTPUT_rskin_alpha_ui output, inout PGSL_PS_SHARED_rskin_alpha_ui shared_vars)
{
	shared_vars.SurfaceEmissive = Emissive.rgb;
}



void ps_base_texture_PART(in PGSL_PS_INPUT_rskin_alpha_ui input, inout PGSL_PS_OUTPUT_rskin_alpha_ui output, inout PGSL_PS_SHARED_rskin_alpha_ui shared_vars)
{
	shared_vars.Albedo = PGSL_TEX2D(BaseTexture, BaseTextureSampler, shared_vars.BaseTexUV);
	shared_vars.SurfaceDiffuse *= shared_vars.Albedo;
}

#undef DYNAMIC_BRIGHTEN_FACTOR
#define DYNAMIC_BRIGHTEN_FACTOR 1.0 


void ps_vertex_color_modulate_PART(in PGSL_PS_INPUT_rskin_alpha_ui input, inout PGSL_PS_OUTPUT_rskin_alpha_ui output, inout PGSL_PS_SHARED_rskin_alpha_ui shared_vars)
{
	shared_vars.SurfaceDiffuse.rgb *= (input.VertexColor.rgb*DYNAMIC_BRIGHTEN_FACTOR);
}



void ps_vertex_diffuse_PART(in PGSL_PS_INPUT_rskin_alpha_ui input, inout PGSL_PS_OUTPUT_rskin_alpha_ui output, inout PGSL_PS_SHARED_rskin_alpha_ui shared_vars)
{
	shared_vars.LightDiffuse.rgb += input.Diffuse.rgb;
}



void ps_vertex_alpha_modulate_PART(in PGSL_PS_INPUT_rskin_alpha_ui input, inout PGSL_PS_OUTPUT_rskin_alpha_ui output, inout PGSL_PS_SHARED_rskin_alpha_ui shared_vars)
{
	shared_vars.SurfaceDiffuse.a *= input.Diffuse.a;
}



void ps_lightscale_PART(in PGSL_PS_INPUT_rskin_alpha_ui input, inout PGSL_PS_OUTPUT_rskin_alpha_ui output, inout PGSL_PS_SHARED_rskin_alpha_ui shared_vars)
{
	shared_vars.LightDiffuse.rgb *= g_LightScale.rgb;
	shared_vars.SurfaceDiffuse.a *= g_LightScale.a;
}



void ps_compose_lighting_diffuse_PART(in PGSL_PS_INPUT_rskin_alpha_ui input, inout PGSL_PS_OUTPUT_rskin_alpha_ui output, inout PGSL_PS_SHARED_rskin_alpha_ui shared_vars)
{
  shared_vars.Diffuse = shared_vars.SurfaceDiffuse.rgb*shared_vars.LightDiffuse;
  output.Color0.rgb = shared_vars.Diffuse.rgb;
  output.Color0.a = shared_vars.SurfaceDiffuse.a;
}



void ps_emissive_PART(in PGSL_PS_INPUT_rskin_alpha_ui input, inout PGSL_PS_OUTPUT_rskin_alpha_ui output, inout PGSL_PS_SHARED_rskin_alpha_ui shared_vars)
{
	output.Color0.rgb += (shared_vars.SurfaceEmissive.rgb*shared_vars.Albedo.rgb);
}



void ps_fog_PART(in PGSL_PS_INPUT_rskin_alpha_ui input, inout PGSL_PS_OUTPUT_rskin_alpha_ui output, inout PGSL_PS_SHARED_rskin_alpha_ui shared_vars)
{
	output.Color0.rgb = lerp(g_FogColor.rgb, output.Color0.rgb, input.Fog);
}

PGSL_PS_OUTPUT_rskin_alpha_ui pass_ps_PGSL_PS_MAIN_rskin_alpha_ui(PGSL_PS_INPUT_rskin_alpha_ui meta_shader_in)
{
	PGSL_PS_OUTPUT_rskin_alpha_ui meta_shader_out = (PGSL_PS_OUTPUT_rskin_alpha_ui)0;
	PGSL_PS_SHARED_rskin_alpha_ui meta_shader_shared = (PGSL_PS_SHARED_rskin_alpha_ui)0;
	pre_ps_base_uv_PART(meta_shader_in, meta_shader_out, meta_shader_shared);
	ps_surface_material_PART(meta_shader_in, meta_shader_out, meta_shader_shared);
	ps_surface_emissive_PART(meta_shader_in, meta_shader_out, meta_shader_shared);
	ps_base_texture_PART(meta_shader_in, meta_shader_out, meta_shader_shared);
	ps_vertex_color_modulate_PART(meta_shader_in, meta_shader_out, meta_shader_shared);
	ps_vertex_diffuse_PART(meta_shader_in, meta_shader_out, meta_shader_shared);
	ps_vertex_alpha_modulate_PART(meta_shader_in, meta_shader_out, meta_shader_shared);
	ps_lightscale_PART(meta_shader_in, meta_shader_out, meta_shader_shared);
	ps_compose_lighting_diffuse_PART(meta_shader_in, meta_shader_out, meta_shader_shared);
	ps_emissive_PART(meta_shader_in, meta_shader_out, meta_shader_shared);
	ps_fog_PART(meta_shader_in, meta_shader_out, meta_shader_shared);
	return meta_shader_out;
}



/////////////////////////////////////////////////////////////////////
//SHADER'S PASSES
/////////////////////////////////////////////////////////////////////
PGSL_TECHNIQUE_BEGIN
	PGSL_PASS_BEGIN(pass_0, 
	<
		string _RasterizeState_ = "ALRS_DEFAULT";string _BlendState_ = "ALBS_ALPHA_BLEND";string _DepthStencilState_ = "ALDS_DEPTHALWAYSNOWRITE_STENCILDISABLE";
	>)
		PGSL_PASS_VS(pass_vs_PGSL_VS_MAIN_rskin_alpha_ui, 0)
		PGSL_PASS_PS(pass_ps_PGSL_PS_MAIN_rskin_alpha_ui, 0)
	PGSL_PASS_END
PGSL_TECHNIQUE_END



