//////////////////////////////////////////////////////////////////////////////////////////////////////////
//
//Petroglyph Confidential Source Code -- Do Not Distribute
//
// (Auto generated by PGSLCodeGenerator)
//Platform: MAX
//////////////////////////////////////////////////////////////////////////////////////////////////////////
#define PGSL_MAX
#define PGSL_DX9
#include"..\common\PGSLAlways.pgh"
#include"..\common\AlamoEngine.pgh"

float g_ShaderFileDummyVariable : SHADER_FILE_ANNOTATION
<
string _ALAMO_RENDER_PHASE = "TerrainDecoration";
string _ALAMO_VERTEX_PROC = "Mesh";
string _ALAMO_VERTEX_TYPE = "alD3dVertNU2C";
bool _ALAMO_TANGENT_SPACE = false;
bool _ALAMO_Z_SORT = true;
>;

#define PGSL_PS_INPUT_mesh_resource_field PGSL_VS_OUTPUT_mesh_resource_field



/////////////////////////////////////////////////////////////////////
//VERTEX SHADER INPUTS
/////////////////////////////////////////////////////////////////////
float2 UVScrollRate
<
string UIName = "UVScrollRate";
>
 = {0, 0};

struct PGSL_VS_INPUT_mesh_resource_field
{
	float3 Pos  : PGSL_POSITION;
	float3 Normal  : PGSL_NORMAL;
	float2 BaseTexUV  : PGSL_TEXCOORD0;
	float4 Color  : PGSL_COLOR0;
};



/////////////////////////////////////////////////////////////////////
//VERTEX SHADER OUTPUTS
/////////////////////////////////////////////////////////////////////
struct PGSL_VS_OUTPUT_mesh_resource_field
{
	float4 Pos  : PGSL_SV_POSITION;
	float2 BaseTexUV  : PGSL_TEXCOORD0;
	float4 ShadowmapTexcoords  : PGSL_TEXCOORD1;
	float4 LightFieldTexcoords  : PGSL_TEXCOORD2;
	float4 FowCloudTexcoords  : PGSL_TEXCOORD3;
	float4 VertexColor  : PGSL_COLOR0;
	float4 Diffuse  : PGSL_TEXCOORD4;
	float3 DiffuseShadow  : PGSL_TEXCOORD5;
	float Fog  : PGSL_TEXCOORD6;
};



/////////////////////////////////////////////////////////////////////
//VERTEX SHADER SHARED STRUCT
/////////////////////////////////////////////////////////////////////
struct PGSL_VS_SHARED_mesh_resource_field
{
	float4x4 World;
	float4 Pos;
	float3 Normal;
	float2 BaseTexUV;
	float4 VertexColor;
	float4 SurfaceDiffuse;
	float3 SurfaceSpecular;
	float4 WorldPos;
	float3 LightDiffuse;
	float3 Diffuse;
	float4 LightDiffuseShadow;
	float4 DiffuseShadow;
};



/////////////////////////////////////////////////////////////////////
//VERTEX SHADERS
/////////////////////////////////////////////////////////////////////


void pre_vs_world_PART(inout PGSL_VS_INPUT_mesh_resource_field input, inout PGSL_VS_OUTPUT_mesh_resource_field output, inout PGSL_VS_SHARED_mesh_resource_field shared_vars)
{
	shared_vars.World = g_World;
}



void pre_vs_position_PART(inout PGSL_VS_INPUT_mesh_resource_field input, inout PGSL_VS_OUTPUT_mesh_resource_field output, inout PGSL_VS_SHARED_mesh_resource_field shared_vars)
{
	shared_vars.Pos = float4(input.Pos.xyz, 1.0);
}



void pre_vs_normal_PART(inout PGSL_VS_INPUT_mesh_resource_field input, inout PGSL_VS_OUTPUT_mesh_resource_field output, inout PGSL_VS_SHARED_mesh_resource_field shared_vars)
{
	shared_vars.Normal = input.Normal.xyz;
}



void pre_vs_base_uv_PART(inout PGSL_VS_INPUT_mesh_resource_field input, inout PGSL_VS_OUTPUT_mesh_resource_field output, inout PGSL_VS_SHARED_mesh_resource_field shared_vars)
{
	shared_vars.BaseTexUV = input.BaseTexUV;
}



void pre_vs_vertex_color_PART(inout PGSL_VS_INPUT_mesh_resource_field input, inout PGSL_VS_OUTPUT_mesh_resource_field output, inout PGSL_VS_SHARED_mesh_resource_field shared_vars)
{
	shared_vars.VertexColor = input.Color;
}



void vs_identity_surface_material_PART(in PGSL_VS_INPUT_mesh_resource_field input, inout PGSL_VS_OUTPUT_mesh_resource_field output, inout PGSL_VS_SHARED_mesh_resource_field shared_vars)
{
	shared_vars.SurfaceDiffuse = float4(1, 1, 1, 1);
	shared_vars.SurfaceSpecular = float3(1, 1, 1);
}



void vs_mesh_PART(in PGSL_VS_INPUT_mesh_resource_field input, inout PGSL_VS_OUTPUT_mesh_resource_field output, inout PGSL_VS_SHARED_mesh_resource_field shared_vars)
{
	//xform to projection space
#if defined(PGSL_MAX)
	output.Pos = mul(shared_vars.Pos, g_World);
	output.Pos = mul(output.Pos, g_View);
	output.Pos = mul(output.Pos, g_Proj);
#else
	output.Pos = mul(shared_vars.Pos, g_WorldViewProj);
#endif
	
	//save world pos
	shared_vars.WorldPos = mul(shared_vars.Pos, shared_vars.World);
}



void vs_base_uv_scroll_PART(in PGSL_VS_INPUT_mesh_resource_field input, inout PGSL_VS_OUTPUT_mesh_resource_field output, inout PGSL_VS_SHARED_mesh_resource_field shared_vars)
{
	shared_vars.BaseTexUV += g_ElapsedTime*UVScrollRate;
   output.BaseTexUV = shared_vars.BaseTexUV;
}



void vs_shadowmap_uv_PART(in PGSL_VS_INPUT_mesh_resource_field input, inout PGSL_VS_OUTPUT_mesh_resource_field output, inout PGSL_VS_SHARED_mesh_resource_field shared_vars)
{
	output.ShadowmapTexcoords = mul(shared_vars.WorldPos, g_WorldToShadowmap);
	output.ShadowmapTexcoords.z = clamp(output.ShadowmapTexcoords.z, 0, output.ShadowmapTexcoords.w);
}



void vs_lightfield_uv_PART(in PGSL_VS_INPUT_mesh_resource_field input, inout PGSL_VS_OUTPUT_mesh_resource_field output, inout PGSL_VS_SHARED_mesh_resource_field shared_vars)
{
	output.LightFieldTexcoords.xyz = Compute_LightField_Coords_World_Space(shared_vars.WorldPos);
}



void vs_fow_uv_PART(in PGSL_VS_INPUT_mesh_resource_field input, inout PGSL_VS_OUTPUT_mesh_resource_field output, inout PGSL_VS_SHARED_mesh_resource_field shared_vars)
{
	output.FowCloudTexcoords.x = dot(g_FowTexU, shared_vars.WorldPos);
	output.FowCloudTexcoords.y = dot(g_FowTexV, shared_vars.WorldPos);
}



void vs_sph_lighting_fill_PART(in PGSL_VS_INPUT_mesh_resource_field input, inout PGSL_VS_OUTPUT_mesh_resource_field output, inout PGSL_VS_SHARED_mesh_resource_field shared_vars)
{
	float3 world_normal = normalize(mul(shared_vars.Normal, (float3x3)shared_vars.World));
	shared_vars.LightDiffuse.rgb += Sph_Compute_Diffuse_Light_Fill(world_normal);
}



void vs_vertex_color_PART(in PGSL_VS_INPUT_mesh_resource_field input, inout PGSL_VS_OUTPUT_mesh_resource_field output, inout PGSL_VS_SHARED_mesh_resource_field shared_vars)
{
	output.VertexColor = shared_vars.VertexColor;
}



void vs_vertex_alpha_PART(in PGSL_VS_INPUT_mesh_resource_field input, inout PGSL_VS_OUTPUT_mesh_resource_field output, inout PGSL_VS_SHARED_mesh_resource_field shared_vars)
{
	shared_vars.SurfaceDiffuse.a = shared_vars.VertexColor.a;
}



void vs_compose_lighting_diffuse_PART(in PGSL_VS_INPUT_mesh_resource_field input, inout PGSL_VS_OUTPUT_mesh_resource_field output, inout PGSL_VS_SHARED_mesh_resource_field shared_vars)
{
	//do lighting: diffuse only
	shared_vars.Diffuse = shared_vars.LightDiffuse*shared_vars.SurfaceDiffuse.rgb;
	output.Diffuse.rgb = shared_vars.Diffuse.rgb;
	output.Diffuse.a = shared_vars.SurfaceDiffuse.a;
}



void vs_phong_diffuse_shadow_PART(in PGSL_VS_INPUT_mesh_resource_field input, inout PGSL_VS_OUTPUT_mesh_resource_field output, inout PGSL_VS_SHARED_mesh_resource_field shared_vars)
{
	float3 world_normal = normalize(mul(shared_vars.Normal, (float3x3)shared_vars.World));
	float3 world_light_vec = g_Light0Vec.xyz;
	
	float ndotl = saturate(dot(world_normal, world_light_vec));
	shared_vars.LightDiffuseShadow.rgb += ndotl*g_Light0Diffuse.rgb;
}



void vs_compose_lighting_diffuse_shadow_PART(in PGSL_VS_INPUT_mesh_resource_field input, inout PGSL_VS_OUTPUT_mesh_resource_field output, inout PGSL_VS_SHARED_mesh_resource_field shared_vars)
{
	//do lighting: diffuse only
	shared_vars.DiffuseShadow = shared_vars.LightDiffuseShadow*shared_vars.SurfaceDiffuse;
	output.DiffuseShadow.rgb = shared_vars.DiffuseShadow.rgb;
}



void vs_fog_PART(in PGSL_VS_INPUT_mesh_resource_field input, inout PGSL_VS_OUTPUT_mesh_resource_field output, inout PGSL_VS_SHARED_mesh_resource_field shared_vars)
{
	float fog = length(output.Pos.xyz);
	output.Fog = saturate(g_FogValues.x*fog + g_FogValues.y);
}

PGSL_VS_OUTPUT_mesh_resource_field pass_vs_PGSL_VS_MAIN_mesh_resource_field(PGSL_VS_INPUT_mesh_resource_field meta_shader_in)
{
	PGSL_VS_OUTPUT_mesh_resource_field meta_shader_out = (PGSL_VS_OUTPUT_mesh_resource_field)0;
	PGSL_VS_SHARED_mesh_resource_field meta_shader_shared = (PGSL_VS_SHARED_mesh_resource_field)0;
	pre_vs_world_PART(meta_shader_in, meta_shader_out, meta_shader_shared);
	pre_vs_position_PART(meta_shader_in, meta_shader_out, meta_shader_shared);
	pre_vs_normal_PART(meta_shader_in, meta_shader_out, meta_shader_shared);
	pre_vs_base_uv_PART(meta_shader_in, meta_shader_out, meta_shader_shared);
	pre_vs_vertex_color_PART(meta_shader_in, meta_shader_out, meta_shader_shared);
	vs_identity_surface_material_PART(meta_shader_in, meta_shader_out, meta_shader_shared);
	vs_mesh_PART(meta_shader_in, meta_shader_out, meta_shader_shared);
	vs_base_uv_scroll_PART(meta_shader_in, meta_shader_out, meta_shader_shared);
	vs_shadowmap_uv_PART(meta_shader_in, meta_shader_out, meta_shader_shared);
	vs_lightfield_uv_PART(meta_shader_in, meta_shader_out, meta_shader_shared);
	vs_fow_uv_PART(meta_shader_in, meta_shader_out, meta_shader_shared);
	vs_sph_lighting_fill_PART(meta_shader_in, meta_shader_out, meta_shader_shared);
	vs_vertex_color_PART(meta_shader_in, meta_shader_out, meta_shader_shared);
	vs_vertex_alpha_PART(meta_shader_in, meta_shader_out, meta_shader_shared);
	vs_compose_lighting_diffuse_PART(meta_shader_in, meta_shader_out, meta_shader_shared);
	vs_phong_diffuse_shadow_PART(meta_shader_in, meta_shader_out, meta_shader_shared);
	vs_compose_lighting_diffuse_shadow_PART(meta_shader_in, meta_shader_out, meta_shader_shared);
	vs_fog_PART(meta_shader_in, meta_shader_out, meta_shader_shared);
	return meta_shader_out;
}















/////////////////////////////////////////////////////////////////////
//PIXEL SHADER INPUTS
/////////////////////////////////////////////////////////////////////
float4 Diffuse
<
string UIName = "Diffuse";
string UIType = "ColorSwatch";
bool GammaCorrect = true;
>
 = {1.0, 1.0, 1.0, 1.0};

float4 Specular
<
string UIName = "Specular";
string UIType = "ColorSwatch";
bool GammaCorrect = true;
>
 = {1.0, 1.0, 1.0, 1.0};

float4 Emissive
<
string UIName = "Emissive";
string UIType = "ColorSwatch";
bool GammaCorrect = true;
>
 = {0.0, 0.0, 0.0, 0.0};

PGSL_TEXTURE2D BaseTexture  : DIFFUSEMAP
<
string UIName = "BaseTexture";
string UIType = "bitmap";
string SamplerEnum = "AL_SAMPLER_UVWRAP_MIN_MAG_MIP_BILINEAR_SRGB";
>
;
PGSL_SAMPLER BaseTextureSampler PGSL_SAMPLER_REG(0)
<
string UIName = "BaseTexture";
string UIType = "bitmap";
string SamplerEnum = "AL_SAMPLER_UVWRAP_MIN_MAG_MIP_BILINEAR_SRGB";
PGSL_BIND_TO_TEXTURE(BaseTexture)
string SamplerRegister = "0";
>
PGSL_SAMPLER_STATE(BaseTexture);

PGSL_TEXTURE2D Shadowmap PGSL_TEXTURE_REG(3)
<
string SamplerEnum = "AL_SAMPLER_UVCLAMP_MIN_MAG_MIP_POINT";
>
;
PGSL_SAMPLER ShadowmapSampler PGSL_SAMPLER_REG(3)
<
string SamplerEnum = "AL_SAMPLER_UVCLAMP_MIN_MAG_MIP_POINT";
PGSL_BIND_TO_TEXTURE(Shadowmap)
string SamplerRegister = "3";
>
PGSL_SAMPLER_STATE(Shadowmap);

PGSL_TEXTURE2D LightFieldTexture PGSL_TEXTURE_REG(4)
<
string SamplerEnum = "AL_SAMPLER_UVCLAMP_MIN_MAG_MIP_BILINEAR_SRGB";
>
;
PGSL_SAMPLER LightFieldTextureSampler PGSL_SAMPLER_REG(4)
<
string SamplerEnum = "AL_SAMPLER_UVCLAMP_MIN_MAG_MIP_BILINEAR_SRGB";
PGSL_BIND_TO_TEXTURE(LightFieldTexture)
string SamplerRegister = "4";
>
PGSL_SAMPLER_STATE(LightFieldTexture);

PGSL_TEXTURE2D FowTexture
<
string SamplerEnum = "AL_SAMPLER_UVCLAMP_MIN_MAG_MIP_BILINEAR_SRGB";
>
;
PGSL_SAMPLER FowTextureSampler PGSL_SAMPLER_REG(1)
<
string SamplerEnum = "AL_SAMPLER_UVCLAMP_MIN_MAG_MIP_BILINEAR_SRGB";
PGSL_BIND_TO_TEXTURE(FowTexture)
string SamplerRegister = "1";
>
PGSL_SAMPLER_STATE(FowTexture);




/////////////////////////////////////////////////////////////////////
//PIXEL SHADER OUTPUTS
/////////////////////////////////////////////////////////////////////
struct PGSL_PS_OUTPUT_mesh_resource_field
{
	float4 Color0  : PGSL_TARGET0;
};



/////////////////////////////////////////////////////////////////////
//PIXEL SHADER SHARED STRUCT
/////////////////////////////////////////////////////////////////////
struct PGSL_PS_SHARED_mesh_resource_field
{
	float2 BaseTexUV;
	float4 SurfaceDiffuse;
	float3 SurfaceSpecular;
	float3 SurfaceEmissive;
	float4 Albedo;
	float3 LightDiffuse;
	float3 LightSpecular;
	float3 Diffuse;
};



/////////////////////////////////////////////////////////////////////
//PIXEL SHADERS
/////////////////////////////////////////////////////////////////////


void pre_ps_base_uv_PART(inout PGSL_PS_INPUT_mesh_resource_field input, inout PGSL_PS_OUTPUT_mesh_resource_field output, inout PGSL_PS_SHARED_mesh_resource_field shared_vars)
{
	shared_vars.BaseTexUV = input.BaseTexUV;
}



void ps_surface_material_PART(in PGSL_PS_INPUT_mesh_resource_field input, inout PGSL_PS_OUTPUT_mesh_resource_field output, inout PGSL_PS_SHARED_mesh_resource_field shared_vars)
{
	shared_vars.SurfaceDiffuse = Diffuse;
	shared_vars.SurfaceSpecular = Specular.rgb;
}



void ps_surface_emissive_PART(in PGSL_PS_INPUT_mesh_resource_field input, inout PGSL_PS_OUTPUT_mesh_resource_field output, inout PGSL_PS_SHARED_mesh_resource_field shared_vars)
{
	shared_vars.SurfaceEmissive = Emissive.rgb;
}



void ps_base_texture_PART(in PGSL_PS_INPUT_mesh_resource_field input, inout PGSL_PS_OUTPUT_mesh_resource_field output, inout PGSL_PS_SHARED_mesh_resource_field shared_vars)
{
	shared_vars.Albedo = PGSL_TEX2D(BaseTexture, BaseTextureSampler, shared_vars.BaseTexUV);
	shared_vars.SurfaceDiffuse *= shared_vars.Albedo;
}

#undef DYNAMIC_BRIGHTEN_FACTOR
#define DYNAMIC_BRIGHTEN_FACTOR 1.0 


void ps_vertex_color_modulate_PART(in PGSL_PS_INPUT_mesh_resource_field input, inout PGSL_PS_OUTPUT_mesh_resource_field output, inout PGSL_PS_SHARED_mesh_resource_field shared_vars)
{
	shared_vars.SurfaceDiffuse.rgb *= (input.VertexColor.rgb*DYNAMIC_BRIGHTEN_FACTOR);
}



void ps_vertex_diffuse_shadow_PART(in PGSL_PS_INPUT_mesh_resource_field input, inout PGSL_PS_OUTPUT_mesh_resource_field output, inout PGSL_PS_SHARED_mesh_resource_field shared_vars)
{
	shared_vars.LightDiffuse.rgb += input.DiffuseShadow.rgb;
}

//sampling the shadow map from a floating texture using 
//non-hw instruction for depth compare
float Sample_Shadowmap_2x2_Pcf_Non_Hw(in float4 shadow_coords)
{
	float shadow = 0;
	float pixel_depth = shadow_coords.z/shadow_coords.w;
	float2 proj_uv = shadow_coords.xy/shadow_coords.w;
	float2 uv;
	float sm_depth;
	
	uv = proj_uv + float2(0.5, 0.5)*g_ShadowmapInverseResolution.xy;
	sm_depth = PGSL_TEX2D(Shadowmap, ShadowmapSampler, uv).r;
	shadow += (sm_depth PGSL_COMP_GREATER_EQUAL pixel_depth);
	
	uv = proj_uv + float2(0.5, -0.5)*g_ShadowmapInverseResolution.xy;
	sm_depth = PGSL_TEX2D(Shadowmap, ShadowmapSampler, uv).r;
	shadow += (sm_depth PGSL_COMP_GREATER_EQUAL pixel_depth);
	
	uv = proj_uv + float2(-0.5, -0.5)*g_ShadowmapInverseResolution.xy;
	sm_depth = PGSL_TEX2D(Shadowmap, ShadowmapSampler, uv).r;
	shadow += (sm_depth PGSL_COMP_GREATER_EQUAL pixel_depth);
	
	uv = proj_uv + float2(-0.5, 0.5)*g_ShadowmapInverseResolution.xy;
	sm_depth = PGSL_TEX2D(Shadowmap, ShadowmapSampler, uv).r;
	shadow += (sm_depth PGSL_COMP_GREATER_EQUAL pixel_depth);
	
	shadow *= 0.25;
	
	return shadow;
}

//sample the shadow map from a hw depth texture using hw depth compare instruction
//depth/slop biasing is assumed to be done through the depth buffer
float Sample_Shadowmap_2x2_Pcf_Hw_Nvidia(in float4 shadow_coords)
{
	float shadow = 0;
	
	float4 uv;
	uv = shadow_coords + (float4(0.5, 0.5, 0, 0)*g_ShadowmapInverseResolution)*shadow_coords.w;
	shadow += PGSL_TEX2D_PROJ(Shadowmap, ShadowmapSampler, uv).r;
	
	uv = shadow_coords + (float4(0.5, -0.5, 0, 0)*g_ShadowmapInverseResolution)*shadow_coords.w;
	shadow += PGSL_TEX2D_PROJ(Shadowmap, ShadowmapSampler, uv).r;
	
	uv = shadow_coords + (float4(-0.5, -0.5, 0, 0)*g_ShadowmapInverseResolution)*shadow_coords.w;
	shadow += PGSL_TEX2D_PROJ(Shadowmap, ShadowmapSampler, uv).r;
	
	uv = shadow_coords + (float4(-0.5, 0.5, 0, 0)*g_ShadowmapInverseResolution)*shadow_coords.w;
	shadow += PGSL_TEX2D_PROJ(Shadowmap, ShadowmapSampler, uv).r;
	
	shadow *= 0.25;
	
	return shadow;
}

//sample the shadow map from a hw depth texture using fetch4
//depth/slop biasing is assumed to be done through the depth buffer
float Sample_Shadowmap_2x2_Pcf_Hw_Ati(in float4 shadow_coords)
{
	float pixel_depth = shadow_coords.z/shadow_coords.w;
	float4 shadowmap_vals = PGSL_TEX2D_PROJ(Shadowmap, ShadowmapSampler, shadow_coords).rgba;
	  
	float4 shadow = (shadowmap_vals PGSL_COMP_GREATER_EQUAL pixel_depth.xxxx);
	
	return dot(shadow, float4(0.25, 0.25, 0.25, 0.25));
}

float Sample_Shadowmap_2x2_Pcf(in float4 shadow_coords)
{
	float shadow = 0;
	
#if defined(PGSL_DX9)
#if defined(NVIDIA)
	shadow = Sample_Shadowmap_2x2_Pcf_Hw_Nvidia(shadow_coords);
#elif defined(ATI)
	shadow = Sample_Shadowmap_2x2_Pcf_Hw_Ati(shadow_coords);
#else
	shadow = Sample_Shadowmap_2x2_Pcf_Non_Hw(shadow_coords);
#endif
#elif defined(PGSL_DX10)
	shadow = Sample_Shadowmap_2x2_Pcf_Non_Hw(shadow_coords);
#elif defined(PGSL_DX11)
	shadow = Sample_Shadowmap_2x2_Pcf_Non_Hw(shadow_coords);
#elif defined(PGSL_XBOX360)
	shadow = Sample_Shadowmap_2x2_Pcf_Non_Hw(shadow_coords);
#elif defined(PGSL_PS3)
#endif
	
	return lerp(shadow, 1.0, g_ShadowBias);
}

void ps_2x2_pcf_shadow_PART(in PGSL_PS_INPUT_mesh_resource_field input, inout PGSL_PS_OUTPUT_mesh_resource_field output, inout PGSL_PS_SHARED_mesh_resource_field shared_vars)
{
#if defined(PGSL_MAX)
#else
	float shadow = Sample_Shadowmap_2x2_Pcf(input.ShadowmapTexcoords);

	shared_vars.LightDiffuse *= shadow;
	shared_vars.LightSpecular *= shadow;
#endif
}



void ps_vertex_diffuse_PART(in PGSL_PS_INPUT_mesh_resource_field input, inout PGSL_PS_OUTPUT_mesh_resource_field output, inout PGSL_PS_SHARED_mesh_resource_field shared_vars)
{
	shared_vars.LightDiffuse.rgb += input.Diffuse.rgb;
}



void ps_lightfield_PART(in PGSL_PS_INPUT_mesh_resource_field input, inout PGSL_PS_OUTPUT_mesh_resource_field output, inout PGSL_PS_SHARED_mesh_resource_field shared_vars)
{
	//Get the lighting in the light field plane
	float4 lf_texel = PGSL_TEX2D(LightFieldTexture, LightFieldTextureSampler, input.LightFieldTexcoords.xy);

	//Capped Cylinder Z-attenuation:
	//"top" of the light is lf_texel.a and the lighting is zero at that point light 
	//intensity grows up to 1.0 over the z attenuation range and then stays at 1.0 all the
	//way to negative infinity.
	//float zdist = lf_texel.a - input.LightFieldTexcoords.z;
	//float atten = saturate(zdist*LF_NORM_Z_ATTEN_INV);

	// GTH - LightField code still assumes LDR rendering, scale up a bit
	// so light sources aren't completely lost in Victory and GOO.  
	// TODO: HDR LightField, probably a 2-3 day task...
	shared_vars.LightDiffuse.rgb += 4.0f * lf_texel.rgb; // += lf_texel.rgb; //*atten; 
}



void ps_vertex_alpha_modulate_PART(in PGSL_PS_INPUT_mesh_resource_field input, inout PGSL_PS_OUTPUT_mesh_resource_field output, inout PGSL_PS_SHARED_mesh_resource_field shared_vars)
{
	shared_vars.SurfaceDiffuse.a *= input.Diffuse.a;
}



void ps_lightscale_PART(in PGSL_PS_INPUT_mesh_resource_field input, inout PGSL_PS_OUTPUT_mesh_resource_field output, inout PGSL_PS_SHARED_mesh_resource_field shared_vars)
{
	shared_vars.LightDiffuse.rgb *= g_LightScale.rgb;
	shared_vars.SurfaceDiffuse.a *= g_LightScale.a;
}



void ps_compose_lighting_diffuse_PART(in PGSL_PS_INPUT_mesh_resource_field input, inout PGSL_PS_OUTPUT_mesh_resource_field output, inout PGSL_PS_SHARED_mesh_resource_field shared_vars)
{
  shared_vars.Diffuse = shared_vars.SurfaceDiffuse.rgb*shared_vars.LightDiffuse;
  output.Color0.rgb = shared_vars.Diffuse.rgb;
  output.Color0.a = shared_vars.SurfaceDiffuse.a;
}



void ps_emissive_PART(in PGSL_PS_INPUT_mesh_resource_field input, inout PGSL_PS_OUTPUT_mesh_resource_field output, inout PGSL_PS_SHARED_mesh_resource_field shared_vars)
{
	output.Color0.rgb += (shared_vars.SurfaceEmissive.rgb*shared_vars.Albedo.rgb);
}



void ps_fow_resource_PART(in PGSL_PS_INPUT_mesh_resource_field input, inout PGSL_PS_OUTPUT_mesh_resource_field output, inout PGSL_PS_SHARED_mesh_resource_field shared_vars)
 {
#if !defined(PGSL_MAX)
	float4 fow_texel = PGSL_TEX2D(FowTexture, FowTextureSampler, input.FowCloudTexcoords.xy);
	float lum = dot(output.Color0.rgb, LumVec);
	[flatten] if (fow_texel.a PGSL_COMP_LESS_EQUAL 0.5f*(g_FowRange.x + g_FowRange.y)) output.Color0.a = 0.0;
	output.Color0.rgb = lerp(lum.xxx, output.Color0.rgb, fow_texel.a)*fow_texel.rgb;
	
//output.Color0.rgb = float3(1,0,0);
#endif
 }



void ps_fog_PART(in PGSL_PS_INPUT_mesh_resource_field input, inout PGSL_PS_OUTPUT_mesh_resource_field output, inout PGSL_PS_SHARED_mesh_resource_field shared_vars)
{
	output.Color0.rgb = lerp(g_FogColor.rgb, output.Color0.rgb, input.Fog);
}

PGSL_PS_OUTPUT_mesh_resource_field pass_ps_PGSL_PS_MAIN_mesh_resource_field(PGSL_PS_INPUT_mesh_resource_field meta_shader_in)
{
	PGSL_PS_OUTPUT_mesh_resource_field meta_shader_out = (PGSL_PS_OUTPUT_mesh_resource_field)0;
	PGSL_PS_SHARED_mesh_resource_field meta_shader_shared = (PGSL_PS_SHARED_mesh_resource_field)0;
	pre_ps_base_uv_PART(meta_shader_in, meta_shader_out, meta_shader_shared);
	ps_surface_material_PART(meta_shader_in, meta_shader_out, meta_shader_shared);
	ps_surface_emissive_PART(meta_shader_in, meta_shader_out, meta_shader_shared);
	ps_base_texture_PART(meta_shader_in, meta_shader_out, meta_shader_shared);
	ps_vertex_color_modulate_PART(meta_shader_in, meta_shader_out, meta_shader_shared);
	ps_vertex_diffuse_shadow_PART(meta_shader_in, meta_shader_out, meta_shader_shared);
	ps_2x2_pcf_shadow_PART(meta_shader_in, meta_shader_out, meta_shader_shared);
	ps_vertex_diffuse_PART(meta_shader_in, meta_shader_out, meta_shader_shared);
	ps_lightfield_PART(meta_shader_in, meta_shader_out, meta_shader_shared);
	ps_vertex_alpha_modulate_PART(meta_shader_in, meta_shader_out, meta_shader_shared);
	ps_lightscale_PART(meta_shader_in, meta_shader_out, meta_shader_shared);
	ps_compose_lighting_diffuse_PART(meta_shader_in, meta_shader_out, meta_shader_shared);
	ps_emissive_PART(meta_shader_in, meta_shader_out, meta_shader_shared);
	ps_fow_resource_PART(meta_shader_in, meta_shader_out, meta_shader_shared);
	ps_fog_PART(meta_shader_in, meta_shader_out, meta_shader_shared);
	return meta_shader_out;
}



/////////////////////////////////////////////////////////////////////
//SHADER'S PASSES
/////////////////////////////////////////////////////////////////////
PGSL_TECHNIQUE_BEGIN
	PGSL_PASS_BEGIN(pass_0, 
	<
		string _RasterizeState_ = "ALRS_DEFAULT";string _BlendState_ = "ALBS_ALPHA_BLEND";string _DepthStencilState_ = "ALDS_DEPTHLESSEQUALNOWRITE_STENCILDISABLE";
	>)
		PGSL_PASS_VS(pass_vs_PGSL_VS_MAIN_mesh_resource_field, 1)
		PGSL_PASS_PS(pass_ps_PGSL_PS_MAIN_mesh_resource_field, 1)
	PGSL_PASS_END
PGSL_TECHNIQUE_END



