//////////////////////////////////////////////////////////////////////////////////////////////////////////
//
//Petroglyph Confidential Source Code -- Do Not Distribute
//
// (Auto generated by PGSLCodeGenerator)
//Platform: MAX
//////////////////////////////////////////////////////////////////////////////////////////////////////////
#define PGSL_MAX
#define PGSL_DX9
#include"..\common\PGSLAlways.pgh"
#include"..\common\AlamoEngine.pgh"

float g_ShaderFileDummyVariable : SHADER_FILE_ANNOTATION
<
string _ALAMO_RENDER_PHASE = "Transparent";
string _ALAMO_VERTEX_PROC = "Mesh";
string _ALAMO_VERTEX_TYPE = "alD3dVertNU2C";
bool _ALAMO_TANGENT_SPACE = false;
bool _ALAMO_Z_SORT = true;
>;

#define PGSL_PS_INPUT_mesh_alpha_nodepth PGSL_VS_OUTPUT_mesh_alpha_nodepth



/////////////////////////////////////////////////////////////////////
//VERTEX SHADER INPUTS
/////////////////////////////////////////////////////////////////////
float2 UVScrollRate
<
string UIName = "UVScrollRate";
>
 = {0, 0};

float4 ViewDep_RGBA_Edge
<
string UIName = "ViewDep_RGBA_Edge";
>
 = 1.0;

float4 ViewDep_RGBA_Facing
<
string UIName = "ViewDep_RGBA_Facing";
>
 = 1.0;

float ViewDep_Power
<
string UIName = "ViewDep_Power";
>
 = 1.0;

struct PGSL_VS_INPUT_mesh_alpha_nodepth
{
	float3 Pos  : PGSL_POSITION;
	float3 Normal  : PGSL_NORMAL;
	float2 BaseTexUV  : PGSL_TEXCOORD0;
	float4 Color  : PGSL_COLOR0;
};



/////////////////////////////////////////////////////////////////////
//VERTEX SHADER OUTPUTS
/////////////////////////////////////////////////////////////////////
struct PGSL_VS_OUTPUT_mesh_alpha_nodepth
{
	float4 Pos  : PGSL_SV_POSITION;
	float2 BaseTexUV  : PGSL_TEXCOORD0;
	float4 FowCloudTexcoords  : PGSL_TEXCOORD1;
	float4 VertexColor  : PGSL_COLOR0;
	float4 Diffuse  : PGSL_TEXCOORD2;
	float Fog  : PGSL_TEXCOORD3;
};



/////////////////////////////////////////////////////////////////////
//VERTEX SHADER SHARED STRUCT
/////////////////////////////////////////////////////////////////////
struct PGSL_VS_SHARED_mesh_alpha_nodepth
{
	float4x4 World;
	float4 Pos;
	float3 Normal;
	float2 BaseTexUV;
	float4 VertexColor;
	float4 SurfaceDiffuse;
	float3 SurfaceSpecular;
	float4 WorldPos;
	float3 LightDiffuse;
	float3 Diffuse;
};



/////////////////////////////////////////////////////////////////////
//VERTEX SHADERS
/////////////////////////////////////////////////////////////////////


void pre_vs_world_PART(inout PGSL_VS_INPUT_mesh_alpha_nodepth input, inout PGSL_VS_OUTPUT_mesh_alpha_nodepth output, inout PGSL_VS_SHARED_mesh_alpha_nodepth shared_vars)
{
	shared_vars.World = g_World;
}



void pre_vs_position_PART(inout PGSL_VS_INPUT_mesh_alpha_nodepth input, inout PGSL_VS_OUTPUT_mesh_alpha_nodepth output, inout PGSL_VS_SHARED_mesh_alpha_nodepth shared_vars)
{
	shared_vars.Pos = float4(input.Pos.xyz, 1.0);
}



void pre_vs_normal_PART(inout PGSL_VS_INPUT_mesh_alpha_nodepth input, inout PGSL_VS_OUTPUT_mesh_alpha_nodepth output, inout PGSL_VS_SHARED_mesh_alpha_nodepth shared_vars)
{
	shared_vars.Normal = input.Normal.xyz;
}



void pre_vs_base_uv_PART(inout PGSL_VS_INPUT_mesh_alpha_nodepth input, inout PGSL_VS_OUTPUT_mesh_alpha_nodepth output, inout PGSL_VS_SHARED_mesh_alpha_nodepth shared_vars)
{
	shared_vars.BaseTexUV = input.BaseTexUV;
}



void pre_vs_vertex_color_PART(inout PGSL_VS_INPUT_mesh_alpha_nodepth input, inout PGSL_VS_OUTPUT_mesh_alpha_nodepth output, inout PGSL_VS_SHARED_mesh_alpha_nodepth shared_vars)
{
	shared_vars.VertexColor = input.Color;
}



void vs_identity_surface_material_PART(in PGSL_VS_INPUT_mesh_alpha_nodepth input, inout PGSL_VS_OUTPUT_mesh_alpha_nodepth output, inout PGSL_VS_SHARED_mesh_alpha_nodepth shared_vars)
{
	shared_vars.SurfaceDiffuse = float4(1, 1, 1, 1);
	shared_vars.SurfaceSpecular = float3(1, 1, 1);
}



void vs_mesh_PART(in PGSL_VS_INPUT_mesh_alpha_nodepth input, inout PGSL_VS_OUTPUT_mesh_alpha_nodepth output, inout PGSL_VS_SHARED_mesh_alpha_nodepth shared_vars)
{
	//xform to projection space
#if defined(PGSL_MAX)
	output.Pos = mul(shared_vars.Pos, g_World);
	output.Pos = mul(output.Pos, g_View);
	output.Pos = mul(output.Pos, g_Proj);
#else
	output.Pos = mul(shared_vars.Pos, g_WorldViewProj);
#endif
	
	//save world pos
	shared_vars.WorldPos = mul(shared_vars.Pos, shared_vars.World);
}



void vs_base_uv_scroll_PART(in PGSL_VS_INPUT_mesh_alpha_nodepth input, inout PGSL_VS_OUTPUT_mesh_alpha_nodepth output, inout PGSL_VS_SHARED_mesh_alpha_nodepth shared_vars)
{
	shared_vars.BaseTexUV += g_ElapsedTime*UVScrollRate;
   output.BaseTexUV = shared_vars.BaseTexUV;
}



void vs_fow_uv_PART(in PGSL_VS_INPUT_mesh_alpha_nodepth input, inout PGSL_VS_OUTPUT_mesh_alpha_nodepth output, inout PGSL_VS_SHARED_mesh_alpha_nodepth shared_vars)
{
	output.FowCloudTexcoords.x = dot(g_FowTexU, shared_vars.WorldPos);
	output.FowCloudTexcoords.y = dot(g_FowTexV, shared_vars.WorldPos);
}



void vs_sph_lighting_all_PART(in PGSL_VS_INPUT_mesh_alpha_nodepth input, inout PGSL_VS_OUTPUT_mesh_alpha_nodepth output, inout PGSL_VS_SHARED_mesh_alpha_nodepth shared_vars)
{
	float3 world_normal = normalize(mul(shared_vars.Normal, (float3x3)shared_vars.World));
	shared_vars.LightDiffuse.rgb += Sph_Compute_Diffuse_Light_All(world_normal);
}



void vs_vertex_color_PART(in PGSL_VS_INPUT_mesh_alpha_nodepth input, inout PGSL_VS_OUTPUT_mesh_alpha_nodepth output, inout PGSL_VS_SHARED_mesh_alpha_nodepth shared_vars)
{
	output.VertexColor = shared_vars.VertexColor;
}



void vs_vertex_alpha_PART(in PGSL_VS_INPUT_mesh_alpha_nodepth input, inout PGSL_VS_OUTPUT_mesh_alpha_nodepth output, inout PGSL_VS_SHARED_mesh_alpha_nodepth shared_vars)
{
	shared_vars.SurfaceDiffuse.a = shared_vars.VertexColor.a;
}



void vs_view_dependent_color_modulate_PART(in PGSL_VS_INPUT_mesh_alpha_nodepth input, inout PGSL_VS_OUTPUT_mesh_alpha_nodepth output, inout PGSL_VS_SHARED_mesh_alpha_nodepth shared_vars)
{
    // edge fade
	float3 world_normal = normalize(mul(shared_vars.Normal, (float3x3)shared_vars.World));
	float3 view_norm = normalize(mul(world_normal, (float3x3)g_View));
    
	float t = saturate(view_norm.z);
	t = pow(t,ViewDep_Power);
	float4 rgba = lerp(ViewDep_RGBA_Edge,ViewDep_RGBA_Facing,t);

	shared_vars.SurfaceDiffuse *= rgba;  
}



void vs_compose_lighting_diffuse_PART(in PGSL_VS_INPUT_mesh_alpha_nodepth input, inout PGSL_VS_OUTPUT_mesh_alpha_nodepth output, inout PGSL_VS_SHARED_mesh_alpha_nodepth shared_vars)
{
	//do lighting: diffuse only
	shared_vars.Diffuse = shared_vars.LightDiffuse*shared_vars.SurfaceDiffuse.rgb;
	output.Diffuse.rgb = shared_vars.Diffuse.rgb;
	output.Diffuse.a = shared_vars.SurfaceDiffuse.a;
}



void vs_fog_PART(in PGSL_VS_INPUT_mesh_alpha_nodepth input, inout PGSL_VS_OUTPUT_mesh_alpha_nodepth output, inout PGSL_VS_SHARED_mesh_alpha_nodepth shared_vars)
{
	float fog = length(output.Pos.xyz);
	output.Fog = saturate(g_FogValues.x*fog + g_FogValues.y);
}

PGSL_VS_OUTPUT_mesh_alpha_nodepth pass_vs_PGSL_VS_MAIN_mesh_alpha_nodepth(PGSL_VS_INPUT_mesh_alpha_nodepth meta_shader_in)
{
	PGSL_VS_OUTPUT_mesh_alpha_nodepth meta_shader_out = (PGSL_VS_OUTPUT_mesh_alpha_nodepth)0;
	PGSL_VS_SHARED_mesh_alpha_nodepth meta_shader_shared = (PGSL_VS_SHARED_mesh_alpha_nodepth)0;
	pre_vs_world_PART(meta_shader_in, meta_shader_out, meta_shader_shared);
	pre_vs_position_PART(meta_shader_in, meta_shader_out, meta_shader_shared);
	pre_vs_normal_PART(meta_shader_in, meta_shader_out, meta_shader_shared);
	pre_vs_base_uv_PART(meta_shader_in, meta_shader_out, meta_shader_shared);
	pre_vs_vertex_color_PART(meta_shader_in, meta_shader_out, meta_shader_shared);
	vs_identity_surface_material_PART(meta_shader_in, meta_shader_out, meta_shader_shared);
	vs_mesh_PART(meta_shader_in, meta_shader_out, meta_shader_shared);
	vs_base_uv_scroll_PART(meta_shader_in, meta_shader_out, meta_shader_shared);
	vs_fow_uv_PART(meta_shader_in, meta_shader_out, meta_shader_shared);
	vs_sph_lighting_all_PART(meta_shader_in, meta_shader_out, meta_shader_shared);
	vs_vertex_color_PART(meta_shader_in, meta_shader_out, meta_shader_shared);
	vs_vertex_alpha_PART(meta_shader_in, meta_shader_out, meta_shader_shared);
	vs_view_dependent_color_modulate_PART(meta_shader_in, meta_shader_out, meta_shader_shared);
	vs_compose_lighting_diffuse_PART(meta_shader_in, meta_shader_out, meta_shader_shared);
	vs_fog_PART(meta_shader_in, meta_shader_out, meta_shader_shared);
	return meta_shader_out;
}















/////////////////////////////////////////////////////////////////////
//PIXEL SHADER INPUTS
/////////////////////////////////////////////////////////////////////
float4 Diffuse
<
string UIName = "Diffuse";
string UIType = "ColorSwatch";
bool GammaCorrect = true;
>
 = {1.0, 1.0, 1.0, 1.0};

float4 Specular
<
string UIName = "Specular";
string UIType = "ColorSwatch";
bool GammaCorrect = true;
>
 = {1.0, 1.0, 1.0, 1.0};

float4 Emissive
<
string UIName = "Emissive";
string UIType = "ColorSwatch";
bool GammaCorrect = true;
>
 = {0.0, 0.0, 0.0, 0.0};

PGSL_TEXTURE2D BaseTexture  : DIFFUSEMAP
<
string UIName = "BaseTexture";
string UIType = "bitmap";
string SamplerEnum = "AL_SAMPLER_UVWRAP_MIN_MAG_MIP_BILINEAR_SRGB";
>
;
PGSL_SAMPLER BaseTextureSampler PGSL_SAMPLER_REG(0)
<
string UIName = "BaseTexture";
string UIType = "bitmap";
string SamplerEnum = "AL_SAMPLER_UVWRAP_MIN_MAG_MIP_BILINEAR_SRGB";
PGSL_BIND_TO_TEXTURE(BaseTexture)
string SamplerRegister = "0";
>
PGSL_SAMPLER_STATE(BaseTexture);

PGSL_TEXTURE2D FowTexture
<
string SamplerEnum = "AL_SAMPLER_UVCLAMP_MIN_MAG_MIP_BILINEAR_SRGB";
>
;
PGSL_SAMPLER FowTextureSampler PGSL_SAMPLER_REG(1)
<
string SamplerEnum = "AL_SAMPLER_UVCLAMP_MIN_MAG_MIP_BILINEAR_SRGB";
PGSL_BIND_TO_TEXTURE(FowTexture)
string SamplerRegister = "1";
>
PGSL_SAMPLER_STATE(FowTexture);




/////////////////////////////////////////////////////////////////////
//PIXEL SHADER OUTPUTS
/////////////////////////////////////////////////////////////////////
struct PGSL_PS_OUTPUT_mesh_alpha_nodepth
{
	float4 Color0  : PGSL_TARGET0;
};



/////////////////////////////////////////////////////////////////////
//PIXEL SHADER SHARED STRUCT
/////////////////////////////////////////////////////////////////////
struct PGSL_PS_SHARED_mesh_alpha_nodepth
{
	float2 BaseTexUV;
	float4 SurfaceDiffuse;
	float3 SurfaceSpecular;
	float3 SurfaceEmissive;
	float4 Albedo;
	float3 LightDiffuse;
	float3 Diffuse;
};



/////////////////////////////////////////////////////////////////////
//PIXEL SHADERS
/////////////////////////////////////////////////////////////////////


void pre_ps_base_uv_PART(inout PGSL_PS_INPUT_mesh_alpha_nodepth input, inout PGSL_PS_OUTPUT_mesh_alpha_nodepth output, inout PGSL_PS_SHARED_mesh_alpha_nodepth shared_vars)
{
	shared_vars.BaseTexUV = input.BaseTexUV;
}



void ps_surface_material_PART(in PGSL_PS_INPUT_mesh_alpha_nodepth input, inout PGSL_PS_OUTPUT_mesh_alpha_nodepth output, inout PGSL_PS_SHARED_mesh_alpha_nodepth shared_vars)
{
	shared_vars.SurfaceDiffuse = Diffuse;
	shared_vars.SurfaceSpecular = Specular.rgb;
}



void ps_surface_emissive_PART(in PGSL_PS_INPUT_mesh_alpha_nodepth input, inout PGSL_PS_OUTPUT_mesh_alpha_nodepth output, inout PGSL_PS_SHARED_mesh_alpha_nodepth shared_vars)
{
	shared_vars.SurfaceEmissive = Emissive.rgb;
}



void ps_base_texture_PART(in PGSL_PS_INPUT_mesh_alpha_nodepth input, inout PGSL_PS_OUTPUT_mesh_alpha_nodepth output, inout PGSL_PS_SHARED_mesh_alpha_nodepth shared_vars)
{
	shared_vars.Albedo = PGSL_TEX2D(BaseTexture, BaseTextureSampler, shared_vars.BaseTexUV);
	shared_vars.SurfaceDiffuse *= shared_vars.Albedo;
}

#undef DYNAMIC_BRIGHTEN_FACTOR
#define DYNAMIC_BRIGHTEN_FACTOR 1.0 


void ps_vertex_color_modulate_PART(in PGSL_PS_INPUT_mesh_alpha_nodepth input, inout PGSL_PS_OUTPUT_mesh_alpha_nodepth output, inout PGSL_PS_SHARED_mesh_alpha_nodepth shared_vars)
{
	shared_vars.SurfaceDiffuse.rgb *= (input.VertexColor.rgb*DYNAMIC_BRIGHTEN_FACTOR);
}



void ps_vertex_diffuse_PART(in PGSL_PS_INPUT_mesh_alpha_nodepth input, inout PGSL_PS_OUTPUT_mesh_alpha_nodepth output, inout PGSL_PS_SHARED_mesh_alpha_nodepth shared_vars)
{
	shared_vars.LightDiffuse.rgb += input.Diffuse.rgb;
}



void ps_vertex_alpha_modulate_PART(in PGSL_PS_INPUT_mesh_alpha_nodepth input, inout PGSL_PS_OUTPUT_mesh_alpha_nodepth output, inout PGSL_PS_SHARED_mesh_alpha_nodepth shared_vars)
{
	shared_vars.SurfaceDiffuse.a *= input.Diffuse.a;
}



void ps_lightscale_PART(in PGSL_PS_INPUT_mesh_alpha_nodepth input, inout PGSL_PS_OUTPUT_mesh_alpha_nodepth output, inout PGSL_PS_SHARED_mesh_alpha_nodepth shared_vars)
{
	shared_vars.LightDiffuse.rgb *= g_LightScale.rgb;
	shared_vars.SurfaceDiffuse.a *= g_LightScale.a;
}



void ps_compose_lighting_diffuse_PART(in PGSL_PS_INPUT_mesh_alpha_nodepth input, inout PGSL_PS_OUTPUT_mesh_alpha_nodepth output, inout PGSL_PS_SHARED_mesh_alpha_nodepth shared_vars)
{
  shared_vars.Diffuse = shared_vars.SurfaceDiffuse.rgb*shared_vars.LightDiffuse;
  output.Color0.rgb = shared_vars.Diffuse.rgb;
  output.Color0.a = shared_vars.SurfaceDiffuse.a;
}



void ps_emissive_PART(in PGSL_PS_INPUT_mesh_alpha_nodepth input, inout PGSL_PS_OUTPUT_mesh_alpha_nodepth output, inout PGSL_PS_SHARED_mesh_alpha_nodepth shared_vars)
{
	output.Color0.rgb += (shared_vars.SurfaceEmissive.rgb*shared_vars.Albedo.rgb);
}



void ps_fow_PART(in PGSL_PS_INPUT_mesh_alpha_nodepth input, inout PGSL_PS_OUTPUT_mesh_alpha_nodepth output, inout PGSL_PS_SHARED_mesh_alpha_nodepth shared_vars)
 {
#if !defined(PGSL_MAX)
	
	 float4 fow_texel = PGSL_TEX2D(FowTexture, FowTextureSampler, input.FowCloudTexcoords.xy);
	 float lum = dot(output.Color0.rgb, LumVec);
	 output.Color0.rgb = lerp(fow_texel.rgb*lum.xxx, output.Color0.rgb, fow_texel.a);
	
#endif
 }



void ps_fog_PART(in PGSL_PS_INPUT_mesh_alpha_nodepth input, inout PGSL_PS_OUTPUT_mesh_alpha_nodepth output, inout PGSL_PS_SHARED_mesh_alpha_nodepth shared_vars)
{
	output.Color0.rgb = lerp(g_FogColor.rgb, output.Color0.rgb, input.Fog);
}

PGSL_PS_OUTPUT_mesh_alpha_nodepth pass_ps_PGSL_PS_MAIN_mesh_alpha_nodepth(PGSL_PS_INPUT_mesh_alpha_nodepth meta_shader_in)
{
	PGSL_PS_OUTPUT_mesh_alpha_nodepth meta_shader_out = (PGSL_PS_OUTPUT_mesh_alpha_nodepth)0;
	PGSL_PS_SHARED_mesh_alpha_nodepth meta_shader_shared = (PGSL_PS_SHARED_mesh_alpha_nodepth)0;
	pre_ps_base_uv_PART(meta_shader_in, meta_shader_out, meta_shader_shared);
	ps_surface_material_PART(meta_shader_in, meta_shader_out, meta_shader_shared);
	ps_surface_emissive_PART(meta_shader_in, meta_shader_out, meta_shader_shared);
	ps_base_texture_PART(meta_shader_in, meta_shader_out, meta_shader_shared);
	ps_vertex_color_modulate_PART(meta_shader_in, meta_shader_out, meta_shader_shared);
	ps_vertex_diffuse_PART(meta_shader_in, meta_shader_out, meta_shader_shared);
	ps_vertex_alpha_modulate_PART(meta_shader_in, meta_shader_out, meta_shader_shared);
	ps_lightscale_PART(meta_shader_in, meta_shader_out, meta_shader_shared);
	ps_compose_lighting_diffuse_PART(meta_shader_in, meta_shader_out, meta_shader_shared);
	ps_emissive_PART(meta_shader_in, meta_shader_out, meta_shader_shared);
	ps_fow_PART(meta_shader_in, meta_shader_out, meta_shader_shared);
	ps_fog_PART(meta_shader_in, meta_shader_out, meta_shader_shared);
	return meta_shader_out;
}



/////////////////////////////////////////////////////////////////////
//SHADER'S PASSES
/////////////////////////////////////////////////////////////////////
PGSL_TECHNIQUE_BEGIN
	PGSL_PASS_BEGIN(pass_0, 
	<
		string _RasterizeState_ = "ALRS_DEFAULT";string _BlendState_ = "ALBS_ALPHA_BLEND";string _DepthStencilState_ = "ALDS_DEPTHALWAYSNOWRITE_STENCILDISABLE";
	>)
		PGSL_PASS_VS(pass_vs_PGSL_VS_MAIN_mesh_alpha_nodepth, 0)
		PGSL_PASS_PS(pass_ps_PGSL_PS_MAIN_mesh_alpha_nodepth, 0)
	PGSL_PASS_END
PGSL_TECHNIQUE_END



