//////////////////////////////////////////////////////////////////////////////////////////////////////////
//
//Petroglyph Confidential Source Code -- Do Not Distribute
//
// (Auto generated by PGSLCodeGenerator)
//Platform: MAX
//////////////////////////////////////////////////////////////////////////////////////////////////////////
#define PGSL_MAX
#define PGSL_DX9
#include"..\common\PGSLAlways.pgh"
#include"..\common\AlamoEngine.pgh"
#include"..\common\AlamoEngine_Skinning.pgh"

float g_ShaderFileDummyVariable : SHADER_FILE_ANNOTATION
<
string _ALAMO_RENDER_PHASE = "Opaque";
string _ALAMO_VERTEX_PROC = "RSkin";
string _ALAMO_VERTEX_TYPE = "alD3dVertRSkinNU2U3U3U2C";
bool _ALAMO_TANGENT_SPACE = true;
bool _ALAMO_BONES_PER_VERTEX = 1;
>;

#define PGSL_PS_INPUT_hdr_rskin_standard PGSL_VS_OUTPUT_hdr_rskin_standard



/////////////////////////////////////////////////////////////////////
//VERTEX SHADER INPUTS
/////////////////////////////////////////////////////////////////////
float4 UVOffset
<
string UIName = "UVOffset";
>
 = {0, 0, 0, 0};

float2 UV2Offset
<
string UIName = "UV2Offset";
>
 = {0, 0};

float2 UV2ScrollRate
<
string UIName = "UV2ScrollRate";
>
 = {0, 0};

struct PGSL_VS_INPUT_hdr_rskin_standard
{
	float3 Pos  : PGSL_POSITION;
	PGSL_PACKED_FLOAT4 Normal  : PGSL_NORMAL;
	float2 BaseTexUV  : PGSL_TEXCOORD0;
	float2 BaseTexUV2  : PGSL_TEXCOORD1;
	float3 Tangent  : PGSL_TANGENT;
	float3 Bitangent  : PGSL_BITANGENT;
	float4 Color  : PGSL_COLOR0;
};



/////////////////////////////////////////////////////////////////////
//VERTEX SHADER OUTPUTS
/////////////////////////////////////////////////////////////////////
struct PGSL_VS_OUTPUT_hdr_rskin_standard
{
	float4 Pos  : PGSL_SV_POSITION;
	float2 BaseTexUV  : PGSL_TEXCOORD0;
	float2 BaseTexUV2  : PGSL_TEXCOORD1;
	float3 TangentToWorldXBasis  : PGSL_TEXCOORD2;
	float3 TangentToWorldYBasis  : PGSL_TEXCOORD3;
	float3 TangentToWorldZBasis  : PGSL_TEXCOORD4;
	float3 ViewVec  : PGSL_TEXCOORD5;
	float4 LightFieldTexcoords  : PGSL_TEXCOORD6;
	float4 VertexColor  : PGSL_COLOR0;
	float4 Diffuse  : PGSL_TEXCOORD7;
};



/////////////////////////////////////////////////////////////////////
//VERTEX SHADER SHARED STRUCT
/////////////////////////////////////////////////////////////////////
struct PGSL_VS_SHARED_hdr_rskin_standard
{
	float4x4 World;
	float4 Pos;
	float3 Normal;
	PGSL_PACKED_FLOAT RSkinMatrixIndex;
	float2 BaseTexUV;
	float2 BaseTexUV2;
	float3 Tangent;
	float3 Bitangent;
	float4 VertexColor;
	float4 SurfaceDiffuse;
	float3 SurfaceSpecular;
	float4 WorldPos;
	float3 LightDiffuse;
	float3 Diffuse;
};



/////////////////////////////////////////////////////////////////////
//VERTEX SHADERS
/////////////////////////////////////////////////////////////////////


void pre_vs_world_PART(inout PGSL_VS_INPUT_hdr_rskin_standard input, inout PGSL_VS_OUTPUT_hdr_rskin_standard output, inout PGSL_VS_SHARED_hdr_rskin_standard shared_vars)
{
	shared_vars.World = g_World;
}



void pre_vs_position_PART(inout PGSL_VS_INPUT_hdr_rskin_standard input, inout PGSL_VS_OUTPUT_hdr_rskin_standard output, inout PGSL_VS_SHARED_hdr_rskin_standard shared_vars)
{
	shared_vars.Pos = float4(input.Pos.xyz, 1.0);
}



void pre_vs_unpack_rskin_normal_PART(inout PGSL_VS_INPUT_hdr_rskin_standard input, inout PGSL_VS_OUTPUT_hdr_rskin_standard output, inout PGSL_VS_SHARED_hdr_rskin_standard shared_vars)
{
	shared_vars.Normal = Unpack_Normal(input.Normal.xyz);
	shared_vars.RSkinMatrixIndex = input.Normal.w;
}



void pre_vs_normal_PART(inout PGSL_VS_INPUT_hdr_rskin_standard input, inout PGSL_VS_OUTPUT_hdr_rskin_standard output, inout PGSL_VS_SHARED_hdr_rskin_standard shared_vars)
{
	shared_vars.Normal = input.Normal.xyz;
}



void pre_vs_base_uv_PART(inout PGSL_VS_INPUT_hdr_rskin_standard input, inout PGSL_VS_OUTPUT_hdr_rskin_standard output, inout PGSL_VS_SHARED_hdr_rskin_standard shared_vars)
{
	shared_vars.BaseTexUV = input.BaseTexUV;
}



void pre_vs_base_uv2_PART(inout PGSL_VS_INPUT_hdr_rskin_standard input, inout PGSL_VS_OUTPUT_hdr_rskin_standard output, inout PGSL_VS_SHARED_hdr_rskin_standard shared_vars)
{
	shared_vars.BaseTexUV2 = input.BaseTexUV2;
}



void pre_vs_tangent_PART(inout PGSL_VS_INPUT_hdr_rskin_standard input, inout PGSL_VS_OUTPUT_hdr_rskin_standard output, inout PGSL_VS_SHARED_hdr_rskin_standard shared_vars)
{
	shared_vars.Tangent = input.Tangent;
}



void pre_vs_bitangent_PART(inout PGSL_VS_INPUT_hdr_rskin_standard input, inout PGSL_VS_OUTPUT_hdr_rskin_standard output, inout PGSL_VS_SHARED_hdr_rskin_standard shared_vars)
{
	shared_vars.Bitangent = input.Bitangent;
}



void pre_vs_vertex_color_PART(inout PGSL_VS_INPUT_hdr_rskin_standard input, inout PGSL_VS_OUTPUT_hdr_rskin_standard output, inout PGSL_VS_SHARED_hdr_rskin_standard shared_vars)
{
	shared_vars.VertexColor = input.Color;
}



void vs_identity_surface_material_PART(in PGSL_VS_INPUT_hdr_rskin_standard input, inout PGSL_VS_OUTPUT_hdr_rskin_standard output, inout PGSL_VS_SHARED_hdr_rskin_standard shared_vars)
{
	shared_vars.SurfaceDiffuse = float4(1, 1, 1, 1);
	shared_vars.SurfaceSpecular = float3(1, 1, 1);
}



void vs_rskin_PART(in PGSL_VS_INPUT_hdr_rskin_standard input, inout PGSL_VS_OUTPUT_hdr_rskin_standard output, inout PGSL_VS_SHARED_hdr_rskin_standard shared_vars)
{
	//skinning
	float4x3 xform;
#if defined(PGSL_MAX)
	xform = g_World;
	float3 world_pos = mul(shared_vars.Pos, xform);
	output.Pos = mul(float4(world_pos, 1.0), g_View);
	output.Pos = mul(output.Pos, g_Proj);
#else
	xform = SkinMatrixArray[shared_vars.RSkinMatrixIndex];
	float3 world_pos = mul(shared_vars.Pos, xform);
	output.Pos = mul(float4(world_pos, 1.0), g_ViewProj);
#endif

	//save world pos
	shared_vars.WorldPos = float4(world_pos, 1.0);
	//save world xform
	shared_vars.World[0] = float4(xform[0], 0);
	shared_vars.World[1] = float4(xform[1], 0);
	shared_vars.World[2] = float4(xform[2], 0);
	shared_vars.World[3] = float4(xform[3], 1);
}



void vs_base_uv_offset_PART(in PGSL_VS_INPUT_hdr_rskin_standard input, inout PGSL_VS_OUTPUT_hdr_rskin_standard output, inout PGSL_VS_SHARED_hdr_rskin_standard shared_vars)
{
   shared_vars.BaseTexUV.xy += UVOffset.xy;
   output.BaseTexUV = shared_vars.BaseTexUV;
}



void vs_base_uv2_scroll_PART(in PGSL_VS_INPUT_hdr_rskin_standard input, inout PGSL_VS_OUTPUT_hdr_rskin_standard output, inout PGSL_VS_SHARED_hdr_rskin_standard shared_vars)
{
	shared_vars.BaseTexUV2 += g_ElapsedTime*UV2ScrollRate;
	shared_vars.BaseTexUV2 += UV2Offset;
   output.BaseTexUV2 = shared_vars.BaseTexUV2;
}



void vs_tangent_to_world_xform_PART(in PGSL_VS_INPUT_hdr_rskin_standard input, inout PGSL_VS_OUTPUT_hdr_rskin_standard output, inout PGSL_VS_SHARED_hdr_rskin_standard shared_vars)
{
	float3x3 xform = (float3x3)shared_vars.World;
	//transform tangent, bitangent and normal into world space
	float3 T = normalize(mul(shared_vars.Tangent, xform));
	float3 B = normalize(mul(shared_vars.Bitangent, xform));
	float3 N = normalize(mul(shared_vars.Normal, xform));
	
	output.TangentToWorldXBasis = float3(T.x, B.x, N.x);
	output.TangentToWorldYBasis = float3(T.y, B.y, N.y);
	output.TangentToWorldZBasis = float3(T.z, B.z, N.z);
}



void vs_chrome_PART(in PGSL_VS_INPUT_hdr_rskin_standard input, inout PGSL_VS_OUTPUT_hdr_rskin_standard output, inout PGSL_VS_SHARED_hdr_rskin_standard shared_vars)
{
	//Thanh - 07/18/2011 note: normalize(lerp(u, v, s)) is not the same as lerp(normalize(u), normalize(v), s)
	//and is also not the same as normalize(lerp(normalize(u), normalize(v), s))
	output.ViewVec = g_EyePos.xyz - shared_vars.WorldPos.xyz;
}



void vs_lightfield_uv_PART(in PGSL_VS_INPUT_hdr_rskin_standard input, inout PGSL_VS_OUTPUT_hdr_rskin_standard output, inout PGSL_VS_SHARED_hdr_rskin_standard shared_vars)
{
	output.LightFieldTexcoords.xyz = Compute_LightField_Coords_World_Space(shared_vars.WorldPos);
}



void vs_vertex_color_PART(in PGSL_VS_INPUT_hdr_rskin_standard input, inout PGSL_VS_OUTPUT_hdr_rskin_standard output, inout PGSL_VS_SHARED_hdr_rskin_standard shared_vars)
{
	output.VertexColor = shared_vars.VertexColor;
}



void vs_sph_lighting_fill_PART(in PGSL_VS_INPUT_hdr_rskin_standard input, inout PGSL_VS_OUTPUT_hdr_rskin_standard output, inout PGSL_VS_SHARED_hdr_rskin_standard shared_vars)
{
	float3 world_normal = normalize(mul(shared_vars.Normal, (float3x3)shared_vars.World));
	shared_vars.LightDiffuse.rgb += Sph_Compute_Diffuse_Light_Fill(world_normal);
}



void vs_compose_lighting_diffuse_PART(in PGSL_VS_INPUT_hdr_rskin_standard input, inout PGSL_VS_OUTPUT_hdr_rskin_standard output, inout PGSL_VS_SHARED_hdr_rskin_standard shared_vars)
{
	//do lighting: diffuse only
	shared_vars.Diffuse = shared_vars.LightDiffuse*shared_vars.SurfaceDiffuse.rgb;
	output.Diffuse.rgb = shared_vars.Diffuse.rgb;
	output.Diffuse.a = shared_vars.SurfaceDiffuse.a;
}

PGSL_VS_OUTPUT_hdr_rskin_standard pass_vs_PGSL_VS_MAIN_hdr_rskin_standard(PGSL_VS_INPUT_hdr_rskin_standard meta_shader_in)
{
	PGSL_VS_OUTPUT_hdr_rskin_standard meta_shader_out = (PGSL_VS_OUTPUT_hdr_rskin_standard)0;
	PGSL_VS_SHARED_hdr_rskin_standard meta_shader_shared = (PGSL_VS_SHARED_hdr_rskin_standard)0;
	pre_vs_world_PART(meta_shader_in, meta_shader_out, meta_shader_shared);
	pre_vs_position_PART(meta_shader_in, meta_shader_out, meta_shader_shared);
	pre_vs_unpack_rskin_normal_PART(meta_shader_in, meta_shader_out, meta_shader_shared);
	pre_vs_normal_PART(meta_shader_in, meta_shader_out, meta_shader_shared);
	pre_vs_base_uv_PART(meta_shader_in, meta_shader_out, meta_shader_shared);
	pre_vs_base_uv2_PART(meta_shader_in, meta_shader_out, meta_shader_shared);
	pre_vs_tangent_PART(meta_shader_in, meta_shader_out, meta_shader_shared);
	pre_vs_bitangent_PART(meta_shader_in, meta_shader_out, meta_shader_shared);
	pre_vs_vertex_color_PART(meta_shader_in, meta_shader_out, meta_shader_shared);
	vs_identity_surface_material_PART(meta_shader_in, meta_shader_out, meta_shader_shared);
	vs_rskin_PART(meta_shader_in, meta_shader_out, meta_shader_shared);
	vs_base_uv_offset_PART(meta_shader_in, meta_shader_out, meta_shader_shared);
	vs_base_uv2_scroll_PART(meta_shader_in, meta_shader_out, meta_shader_shared);
	vs_tangent_to_world_xform_PART(meta_shader_in, meta_shader_out, meta_shader_shared);
	vs_chrome_PART(meta_shader_in, meta_shader_out, meta_shader_shared);
	vs_lightfield_uv_PART(meta_shader_in, meta_shader_out, meta_shader_shared);
	vs_vertex_color_PART(meta_shader_in, meta_shader_out, meta_shader_shared);
	vs_sph_lighting_fill_PART(meta_shader_in, meta_shader_out, meta_shader_shared);
	vs_compose_lighting_diffuse_PART(meta_shader_in, meta_shader_out, meta_shader_shared);
	return meta_shader_out;
}















/////////////////////////////////////////////////////////////////////
//PIXEL SHADER INPUTS
/////////////////////////////////////////////////////////////////////
float4 Diffuse
<
string UIName = "Diffuse";
string UIType = "ColorSwatch";
bool GammaCorrect = true;
>
 = {1.0, 1.0, 1.0, 1.0};

float4 Specular
<
string UIName = "Specular";
string UIType = "ColorSwatch";
bool GammaCorrect = true;
>
 = {1.0, 1.0, 1.0, 1.0};

PGSL_TEXTURE2D BaseTexture  : DIFFUSEMAP
<
string UIName = "BaseTexture";
string UIType = "bitmap";
string SamplerEnum = "AL_SAMPLER_UVWRAP_MIN_MAG_MIP_BILINEAR_SRGB";
>
;
PGSL_SAMPLER BaseTextureSampler PGSL_SAMPLER_REG(0)
<
string UIName = "BaseTexture";
string UIType = "bitmap";
string SamplerEnum = "AL_SAMPLER_UVWRAP_MIN_MAG_MIP_BILINEAR_SRGB";
PGSL_BIND_TO_TEXTURE(BaseTexture)
string SamplerRegister = "0";
>
PGSL_SAMPLER_STATE(BaseTexture);

float SpecularIntensity
<
string UIName = "SpecularIntensity";
>
 = 1;

PGSL_TEXTURE2D SpecularTexture
<
string UIName = "SpecularTexture";
string UIType = "bitmap";
string SamplerEnum = "AL_SAMPLER_UVWRAP_MIN_MAG_MIP_BILINEAR";
>
;
PGSL_SAMPLER SpecularTextureSampler PGSL_SAMPLER_REG(1)
<
string UIName = "SpecularTexture";
string UIType = "bitmap";
string SamplerEnum = "AL_SAMPLER_UVWRAP_MIN_MAG_MIP_BILINEAR";
PGSL_BIND_TO_TEXTURE(SpecularTexture)
string SamplerRegister = "1";
>
PGSL_SAMPLER_STATE(SpecularTexture);

PGSL_TEXTURE2D EmissiveTexture
<
string UIName = "EmissiveTexture";
string UIType = "bitmap";
string SamplerEnum = "AL_SAMPLER_UVWRAP_MIN_MAG_MIP_BILINEAR";
>
;
PGSL_SAMPLER EmissiveTextureSampler PGSL_SAMPLER_REG(2)
<
string UIName = "EmissiveTexture";
string UIType = "bitmap";
string SamplerEnum = "AL_SAMPLER_UVWRAP_MIN_MAG_MIP_BILINEAR";
PGSL_BIND_TO_TEXTURE(EmissiveTexture)
string SamplerRegister = "2";
>
PGSL_SAMPLER_STATE(EmissiveTexture);

float4 EmissiveTint
<
string UIName = "EmissiveTint";
string UIType = "ColorSwatch";
bool GammaCorrect = true;
>
 = {1.0, 1.0, 1.0, 1.0};

float EmissiveBrightness
<
string UIName = "EmissiveBrightness";
>
 = 1.0;

float EmissiveOverrideDiffuse
<
string UIName = "EmissiveOverrideDiffuse";
>
 = 0.0;

PGSL_TEXTURE2D NormalTexture  : NORMALMAP
<
string UIName = "NormalTexture";
string UIType = "bitmap";
string SamplerEnum = "AL_SAMPLER_UVWRAP_MIN_MAG_MIP_BILINEAR";
bool DiscardableBump = true;
>
;
PGSL_SAMPLER NormalTextureSampler PGSL_SAMPLER_REG(5)
<
string UIName = "NormalTexture";
string UIType = "bitmap";
string SamplerEnum = "AL_SAMPLER_UVWRAP_MIN_MAG_MIP_BILINEAR";
bool DiscardableBump = true;
PGSL_BIND_TO_TEXTURE(NormalTexture)
string SamplerRegister = "5";
>
PGSL_SAMPLER_STATE(NormalTexture);

float ReflectionAmount
<
string UIName = "ReflectionAmount";
>
;

PGSL_TEXTURECUBE CubemapLightingFillTexture
<
string SamplerEnum = "AL_SAMPLER_UVWRAP_MIN_MAG_MIP_BILINEAR_SRGB";
>
;
PGSL_SAMPLER CubemapLightingFillTextureSampler PGSL_SAMPLER_REG(6)
<
string SamplerEnum = "AL_SAMPLER_UVWRAP_MIN_MAG_MIP_BILINEAR_SRGB";
PGSL_BIND_TO_TEXTURE(CubemapLightingFillTexture)
string SamplerRegister = "6";
>
PGSL_SAMPLER_STATE(CubemapLightingFillTexture);

float CubemapLightingIntensity = 1.0;

float FresnelMin
<
string UIName = "FresnelMin";
float UIMin = 0.0f;
float UIMax = 1.0f;
>
 = 0.0;

float FresnelMax
<
string UIName = "FresnelMax";
float UIMin = 0.0f;
float UIMax = 1.0f;
>
 = 1.0;

float FresnelPower
<
string UIName = "FresnelPower";
>
 = 5.0;

PGSL_TEXTURE2D Shadowmap PGSL_TEXTURE_REG(3)
<
string SamplerEnum = "AL_SAMPLER_UVCLAMP_MIN_MAG_MIP_POINT";
>
;
PGSL_SAMPLER ShadowmapSampler
<
string SamplerEnum = "AL_SAMPLER_UVCLAMP_MIN_MAG_MIP_POINT";
PGSL_BIND_TO_TEXTURE(Shadowmap)
>
PGSL_SAMPLER_STATE(Shadowmap);

PGSL_TEXTURE2D LightFieldTexture PGSL_TEXTURE_REG(4)
<
string SamplerEnum = "AL_SAMPLER_UVCLAMP_MIN_MAG_MIP_BILINEAR_SRGB";
>
;
PGSL_SAMPLER LightFieldTextureSampler PGSL_SAMPLER_REG(4)
<
string SamplerEnum = "AL_SAMPLER_UVCLAMP_MIN_MAG_MIP_BILINEAR_SRGB";
PGSL_BIND_TO_TEXTURE(LightFieldTexture)
string SamplerRegister = "4";
>
PGSL_SAMPLER_STATE(LightFieldTexture);

PGSL_TEXTURE2D FowTexture
<
string SamplerEnum = "AL_SAMPLER_UVCLAMP_MIN_MAG_MIP_BILINEAR_SRGB";
>
;
PGSL_SAMPLER FowTextureSampler
<
string SamplerEnum = "AL_SAMPLER_UVCLAMP_MIN_MAG_MIP_BILINEAR_SRGB";
PGSL_BIND_TO_TEXTURE(FowTexture)
>
PGSL_SAMPLER_STATE(FowTexture);




/////////////////////////////////////////////////////////////////////
//PIXEL SHADER OUTPUTS
/////////////////////////////////////////////////////////////////////
struct PGSL_PS_OUTPUT_hdr_rskin_standard
{
	float4 Color0  : PGSL_TARGET0;
};



/////////////////////////////////////////////////////////////////////
//PIXEL SHADER SHARED STRUCT
/////////////////////////////////////////////////////////////////////
struct PGSL_PS_SHARED_hdr_rskin_standard
{
	float2 BaseTexUV;
	float2 BumpTexUV;
	float2 BaseTexUV2;
	float4 SurfaceDiffuse;
	float3 SurfaceSpecular;
	float4 Albedo;
	float3 SpecColor;
	float EmissiveMask;
	float4 Emissive;
	float4 Normal;
	float SpecGloss;
	float3 LightVec;
	float3 ViewVec;
	float3 HalfVec;
	float4 Reflection;
	float3 LightDiffuse;
	float NDotL;
	float3 LightSpecular;
	float3 Diffuse;
	float3 Specular;
};



/////////////////////////////////////////////////////////////////////
//PIXEL SHADERS
/////////////////////////////////////////////////////////////////////


void pre_ps_base_uv_PART(inout PGSL_PS_INPUT_hdr_rskin_standard input, inout PGSL_PS_OUTPUT_hdr_rskin_standard output, inout PGSL_PS_SHARED_hdr_rskin_standard shared_vars)
{
	shared_vars.BaseTexUV = input.BaseTexUV;
}



void pre_ps_bump_uv_from_base_uv_PART(inout PGSL_PS_INPUT_hdr_rskin_standard input, inout PGSL_PS_OUTPUT_hdr_rskin_standard output, inout PGSL_PS_SHARED_hdr_rskin_standard shared_vars)
{
	shared_vars.BumpTexUV = input.BaseTexUV;
}



void pre_ps_base_uv2_PART(inout PGSL_PS_INPUT_hdr_rskin_standard input, inout PGSL_PS_OUTPUT_hdr_rskin_standard output, inout PGSL_PS_SHARED_hdr_rskin_standard shared_vars)
{
	shared_vars.BaseTexUV2 = input.BaseTexUV2;
}



void ps_surface_material_opaque_PART(in PGSL_PS_INPUT_hdr_rskin_standard input, inout PGSL_PS_OUTPUT_hdr_rskin_standard output, inout PGSL_PS_SHARED_hdr_rskin_standard shared_vars)
{
	shared_vars.SurfaceDiffuse = Diffuse;
	shared_vars.SurfaceDiffuse.a = 1;
	
	shared_vars.SurfaceSpecular = Specular.rgb;
}



void ps_base_texture_rgb_PART(in PGSL_PS_INPUT_hdr_rskin_standard input, inout PGSL_PS_OUTPUT_hdr_rskin_standard output, inout PGSL_PS_SHARED_hdr_rskin_standard shared_vars)
{
	shared_vars.Albedo = PGSL_TEX2D(BaseTexture, BaseTextureSampler, shared_vars.BaseTexUV);
	shared_vars.SurfaceDiffuse.rgb *= shared_vars.Albedo.rgb;
}



void ps_specular_texture_PART(in PGSL_PS_INPUT_hdr_rskin_standard input, inout PGSL_PS_OUTPUT_hdr_rskin_standard output, inout PGSL_PS_SHARED_hdr_rskin_standard shared_vars)
{
	// read the specular texture
	float4 spec_texel = PGSL_TEX2D(SpecularTexture, SpecularTextureSampler, shared_vars.BaseTexUV);
	shared_vars.SpecColor = spec_texel.rgb * SpecularIntensity;
	shared_vars.EmissiveMask = spec_texel.a;
}



void ps_masked_emissive_texture_PART(in PGSL_PS_INPUT_hdr_rskin_standard input, inout PGSL_PS_OUTPUT_hdr_rskin_standard output, inout PGSL_PS_SHARED_hdr_rskin_standard shared_vars)
{
	// read the emissive texture, mask it, tint it, and brighten/dim it (HDR emissive)
	float2 emissive_uv = shared_vars.BaseTexUV2;
	float emissive_mask = shared_vars.EmissiveMask;
	shared_vars.Emissive.rgb = emissive_mask * PGSL_TEX2D(EmissiveTexture, EmissiveTextureSampler, emissive_uv).rgb;
	shared_vars.Emissive.rgb *= EmissiveTint.rgb;
	shared_vars.Emissive *= EmissiveBrightness;
	shared_vars.Emissive.rgb *= saturate(shared_vars.Albedo.rgb+EmissiveOverrideDiffuse.xxx);
	shared_vars.Emissive.a = 1.0;
}



void ps_bump_gloss_texture_PART(in PGSL_PS_INPUT_hdr_rskin_standard input, inout PGSL_PS_OUTPUT_hdr_rskin_standard output, inout PGSL_PS_SHARED_hdr_rskin_standard shared_vars)
{
	//Thanh - 02/09/2010 fetching normal map with bi-linear filtering
	//actually implies that we need to re-normalize our normal
	//but we are not seeing notice-able artifacts from not normalizing it
	//so we can dodge the bullet and save us a bit of time here!
	//fetch normal from bump map
	float4 normal_texel = PGSL_TEX2D(NormalTexture, NormalTextureSampler, shared_vars.BumpTexUV);
	//scale to [-1, 1]
	shared_vars.Normal.xyz = (normal_texel.rgb - 0.5)*2.0;
	shared_vars.Normal.w = 0.0f;
	
	//alpha channel of normal texel is the specular gloss
	shared_vars.SpecGloss = normal_texel.a;
}



void ps_tangent_to_world_normal_PART(in PGSL_PS_INPUT_hdr_rskin_standard input, inout PGSL_PS_OUTPUT_hdr_rskin_standard output, inout PGSL_PS_SHARED_hdr_rskin_standard shared_vars)
{
	float3 world_normal;
	world_normal.x = dot(input.TangentToWorldXBasis, shared_vars.Normal.xyz);
	world_normal.y = dot(input.TangentToWorldYBasis, shared_vars.Normal.xyz);
	world_normal.z = dot(input.TangentToWorldZBasis, shared_vars.Normal.xyz);
	world_normal = normalize(world_normal);
	
	shared_vars.Normal.xyz = world_normal.xyz;
}



void ps_chrome_bump_pp_PART(in PGSL_PS_INPUT_hdr_rskin_standard input, inout PGSL_PS_OUTPUT_hdr_rskin_standard output, inout PGSL_PS_SHARED_hdr_rskin_standard shared_vars)
{
	//set up world space light vec and half vec
	shared_vars.ViewVec = normalize(input.ViewVec);
	shared_vars.LightVec = g_Light0Vec.xyz;
	shared_vars.HalfVec = normalize(shared_vars.LightVec + shared_vars.ViewVec);
	
	//sample the reflection from the cube map
	float3 r = -shared_vars.ViewVec + 2.0*dot(shared_vars.ViewVec, shared_vars.Normal.xyz)*shared_vars.Normal.xyz;
	float4 uv_with_bias = float4(r,8.0f*(1.0f-shared_vars.SpecGloss));
	float3 cube_texel = shared_vars.SpecColor * PGSL_TEXCUBE_BIAS(CubemapLightingFillTexture, CubemapLightingFillTextureSampler, uv_with_bias).rgb;
	cube_texel *= CubemapLightingIntensity;	
	cube_texel *= ReflectionAmount;

	shared_vars.Reflection.rgb += cube_texel;	
}



void ps_phong_diffuse_PART(in PGSL_PS_INPUT_hdr_rskin_standard input, inout PGSL_PS_OUTPUT_hdr_rskin_standard output, inout PGSL_PS_SHARED_hdr_rskin_standard shared_vars)
{
	shared_vars.NDotL = dot(shared_vars.Normal.xyz, shared_vars.LightVec);
	shared_vars.LightDiffuse.rgb += saturate(shared_vars.NDotL)*g_Light0Diffuse.rgb;
}



void ps_phong_spec_pp_PART(in PGSL_PS_INPUT_hdr_rskin_standard input, inout PGSL_PS_OUTPUT_hdr_rskin_standard output, inout PGSL_PS_SHARED_hdr_rskin_standard shared_vars)
{
	float ndoth = saturate(dot(shared_vars.Normal.xyz, shared_vars.HalfVec));
	float spec_power = pow(256,shared_vars.SpecGloss) + 16;
	float spec_light = pow(ndoth, spec_power);
	
	// Normalization:
	spec_light *= (spec_power + 1) / 8;
	
	// equations from the LPP
	float3 diffuse = g_Light0Diffuse.rgb; //*g_Light0Diffuse.aaa; not used in fwd renderer...
	float3 specular = spec_light*g_Light0Specular.a*diffuse;
	spec_light = dot(LumVec, specular);
				
	float diffuse_lum = dot(LumVec, shared_vars.LightDiffuse.rgb);
	float chromaticity = spec_light / (diffuse_lum + Epsilon);
	
	//shared_vars.LightSpecular.rgb = spec_light * shared_vars.SpecColor; // *spec_light;
	shared_vars.LightSpecular.rgb += shared_vars.SpecColor*chromaticity*shared_vars.LightDiffuse.rgb;
}



void ps_fresnel_simple_PART(in PGSL_PS_INPUT_hdr_rskin_standard input, inout PGSL_PS_OUTPUT_hdr_rskin_standard output, inout PGSL_PS_SHARED_hdr_rskin_standard shared_vars)
{
	float ndotv = saturate(dot(shared_vars.Normal.xyz, shared_vars.ViewVec));
	float fresnel_factor = pow((1.0 - ndotv),FresnelPower);
	fresnel_factor = FresnelMin + (FresnelMax - FresnelMin)*fresnel_factor;
	shared_vars.LightSpecular *= fresnel_factor;
	shared_vars.Reflection *= fresnel_factor;
}



void ps_vertex_diffuse_PART(in PGSL_PS_INPUT_hdr_rskin_standard input, inout PGSL_PS_OUTPUT_hdr_rskin_standard output, inout PGSL_PS_SHARED_hdr_rskin_standard shared_vars)
{
	shared_vars.LightDiffuse.rgb += input.Diffuse.rgb;
}



void ps_lightfield_PART(in PGSL_PS_INPUT_hdr_rskin_standard input, inout PGSL_PS_OUTPUT_hdr_rskin_standard output, inout PGSL_PS_SHARED_hdr_rskin_standard shared_vars)
{
	//Get the lighting in the light field plane
	float4 lf_texel = PGSL_TEX2D(LightFieldTexture, LightFieldTextureSampler, input.LightFieldTexcoords.xy);

	//Capped Cylinder Z-attenuation:
	//"top" of the light is lf_texel.a and the lighting is zero at that point light 
	//intensity grows up to 1.0 over the z attenuation range and then stays at 1.0 all the
	//way to negative infinity.
	//float zdist = lf_texel.a - input.LightFieldTexcoords.z;
	//float atten = saturate(zdist*LF_NORM_Z_ATTEN_INV);

	// GTH - LightField code still assumes LDR rendering, scale up a bit
	// so light sources aren't completely lost in Victory and GOO.  
	// TODO: HDR LightField, probably a 2-3 day task...
	shared_vars.LightDiffuse.rgb += 4.0f * lf_texel.rgb; // += lf_texel.rgb; //*atten; 
}



void ps_lightscale_PART(in PGSL_PS_INPUT_hdr_rskin_standard input, inout PGSL_PS_OUTPUT_hdr_rskin_standard output, inout PGSL_PS_SHARED_hdr_rskin_standard shared_vars)
{
	shared_vars.LightDiffuse.rgb *= g_LightScale.rgb;
	shared_vars.SurfaceDiffuse.a *= g_LightScale.a;
}



void ps_compose_lighting_PART(in PGSL_PS_INPUT_hdr_rskin_standard input, inout PGSL_PS_OUTPUT_hdr_rskin_standard output, inout PGSL_PS_SHARED_hdr_rskin_standard shared_vars)
{
	shared_vars.Diffuse = shared_vars.SurfaceDiffuse.rgb*shared_vars.LightDiffuse;
	shared_vars.Specular = shared_vars.SurfaceSpecular*shared_vars.LightSpecular;
	output.Color0.rgb = shared_vars.Diffuse.rgb + shared_vars.Specular.rgb + shared_vars.Emissive.rgb + shared_vars.Reflection.rgb;
	output.Color0.a = shared_vars.SurfaceDiffuse.a;

	//output.Color0.rgb = shared_vars.Specular.rgb + shared_vars.Diffuse.rgb;
	//output.Color0.rgb = shared_vars.Diffuse.rgb;
	//output.Color0.rgb = shared_vars.Diffuse.rgb;
	//output.Color0.rgb = shared_vars.LightSpecular.rgb;
	//output.Color0.rgb = shared_vars.Reflection.rgb;
	//output.Color0.rgb = float3(shared_vars.SpecGloss,shared_vars.SpecGloss,shared_vars.SpecGloss);
}

PGSL_PS_OUTPUT_hdr_rskin_standard pass_ps_PGSL_PS_MAIN_hdr_rskin_standard(PGSL_PS_INPUT_hdr_rskin_standard meta_shader_in)
{
	PGSL_PS_OUTPUT_hdr_rskin_standard meta_shader_out = (PGSL_PS_OUTPUT_hdr_rskin_standard)0;
	PGSL_PS_SHARED_hdr_rskin_standard meta_shader_shared = (PGSL_PS_SHARED_hdr_rskin_standard)0;
	pre_ps_base_uv_PART(meta_shader_in, meta_shader_out, meta_shader_shared);
	pre_ps_bump_uv_from_base_uv_PART(meta_shader_in, meta_shader_out, meta_shader_shared);
	pre_ps_base_uv2_PART(meta_shader_in, meta_shader_out, meta_shader_shared);
	ps_surface_material_opaque_PART(meta_shader_in, meta_shader_out, meta_shader_shared);
	ps_base_texture_rgb_PART(meta_shader_in, meta_shader_out, meta_shader_shared);
	ps_specular_texture_PART(meta_shader_in, meta_shader_out, meta_shader_shared);
	ps_masked_emissive_texture_PART(meta_shader_in, meta_shader_out, meta_shader_shared);
	ps_bump_gloss_texture_PART(meta_shader_in, meta_shader_out, meta_shader_shared);
	ps_tangent_to_world_normal_PART(meta_shader_in, meta_shader_out, meta_shader_shared);
	ps_chrome_bump_pp_PART(meta_shader_in, meta_shader_out, meta_shader_shared);
	ps_phong_diffuse_PART(meta_shader_in, meta_shader_out, meta_shader_shared);
	ps_phong_spec_pp_PART(meta_shader_in, meta_shader_out, meta_shader_shared);
	ps_fresnel_simple_PART(meta_shader_in, meta_shader_out, meta_shader_shared);
	ps_vertex_diffuse_PART(meta_shader_in, meta_shader_out, meta_shader_shared);
	ps_lightfield_PART(meta_shader_in, meta_shader_out, meta_shader_shared);
	ps_lightscale_PART(meta_shader_in, meta_shader_out, meta_shader_shared);
	ps_compose_lighting_PART(meta_shader_in, meta_shader_out, meta_shader_shared);
	return meta_shader_out;
}



/////////////////////////////////////////////////////////////////////
//SHADER'S PASSES
/////////////////////////////////////////////////////////////////////
PGSL_TECHNIQUE_BEGIN
	PGSL_PASS_BEGIN(pass_0, 
	<
		string _RasterizeState_ = "ALRS_DEFAULT";string _BlendState_ = "ALBS_ALPHA_BLEND_ALPHA_SCRIPTING";string _DepthStencilState_ = "ALDS_DEPTHLESSEQUALWRITE_STENCILDISABLE";bool EnableAlphaScripting = true;
	>)
		PGSL_PASS_VS(pass_vs_PGSL_VS_MAIN_hdr_rskin_standard, 1)
		PGSL_PASS_PS(pass_ps_PGSL_PS_MAIN_hdr_rskin_standard, 1)
	PGSL_PASS_END
PGSL_TECHNIQUE_END



