//////////////////////////////////////////////////////////////////////////////////////////////////////////
//
//Petroglyph Confidential Source Code -- Do Not Distribute
//
// (Auto generated by PGSLCodeGenerator)
//Platform: MAX
//////////////////////////////////////////////////////////////////////////////////////////////////////////
#define PGSL_MAX
#define PGSL_DX9
#include"..\common\PGSLAlways.pgh"
#include"..\common\AlamoEngine.pgh"

float g_ShaderFileDummyVariable : SHADER_FILE_ANNOTATION
<
string _ALAMO_RENDER_PHASE = "Opaque";
string _ALAMO_VERTEX_PROC = "Mesh";
string _ALAMO_VERTEX_TYPE = "alD3dVertNU2";
bool _ALAMO_TANGENT_SPACE = false;
>;

#define PGSL_PS_INPUT_hdr_mesh_simple PGSL_VS_OUTPUT_hdr_mesh_simple



/////////////////////////////////////////////////////////////////////
//VERTEX SHADER INPUTS
/////////////////////////////////////////////////////////////////////
struct PGSL_VS_INPUT_hdr_mesh_simple
{
	float3 Pos  : PGSL_POSITION;
	float3 Normal  : PGSL_NORMAL;
	float2 BaseTexUV  : PGSL_TEXCOORD0;
};



/////////////////////////////////////////////////////////////////////
//VERTEX SHADER OUTPUTS
/////////////////////////////////////////////////////////////////////
struct PGSL_VS_OUTPUT_hdr_mesh_simple
{
	float2 BaseTexUV  : PGSL_TEXCOORD0;
	float4 Pos  : PGSL_SV_POSITION;
	float4 ShadowmapTexcoords  : PGSL_TEXCOORD1;
	float4 Diffuse  : PGSL_TEXCOORD2;
	float3 Normal  : PGSL_TEXCOORD3;
	float3 LightVec  : PGSL_TEXCOORD4;
	float3 HalfVec  : PGSL_TEXCOORD5;
};



/////////////////////////////////////////////////////////////////////
//VERTEX SHADER SHARED STRUCT
/////////////////////////////////////////////////////////////////////
struct PGSL_VS_SHARED_hdr_mesh_simple
{
	float4x4 World;
	float4 Pos;
	float3 Normal;
	float2 BaseTexUV;
	float4 SurfaceDiffuse;
	float3 SurfaceSpecular;
	float4 WorldPos;
	float3 LightDiffuse;
	float3 Diffuse;
	float3 LightVec;
	float3 HalfVec;
};



/////////////////////////////////////////////////////////////////////
//VERTEX SHADERS
/////////////////////////////////////////////////////////////////////


void pre_vs_world_PART(inout PGSL_VS_INPUT_hdr_mesh_simple input, inout PGSL_VS_OUTPUT_hdr_mesh_simple output, inout PGSL_VS_SHARED_hdr_mesh_simple shared_vars)
{
	shared_vars.World = g_World;
}



void pre_vs_position_PART(inout PGSL_VS_INPUT_hdr_mesh_simple input, inout PGSL_VS_OUTPUT_hdr_mesh_simple output, inout PGSL_VS_SHARED_hdr_mesh_simple shared_vars)
{
	shared_vars.Pos = float4(input.Pos.xyz, 1.0);
}



void pre_vs_normal_PART(inout PGSL_VS_INPUT_hdr_mesh_simple input, inout PGSL_VS_OUTPUT_hdr_mesh_simple output, inout PGSL_VS_SHARED_hdr_mesh_simple shared_vars)
{
	shared_vars.Normal = input.Normal.xyz;
}



void pre_vs_base_uv_PART(inout PGSL_VS_INPUT_hdr_mesh_simple input, inout PGSL_VS_OUTPUT_hdr_mesh_simple output, inout PGSL_VS_SHARED_hdr_mesh_simple shared_vars)
{
	shared_vars.BaseTexUV = input.BaseTexUV;
}



void vs_base_uv_PART(in PGSL_VS_INPUT_hdr_mesh_simple input, inout PGSL_VS_OUTPUT_hdr_mesh_simple output, inout PGSL_VS_SHARED_hdr_mesh_simple shared_vars)
{
	output.BaseTexUV = shared_vars.BaseTexUV;
}



void vs_identity_surface_material_PART(in PGSL_VS_INPUT_hdr_mesh_simple input, inout PGSL_VS_OUTPUT_hdr_mesh_simple output, inout PGSL_VS_SHARED_hdr_mesh_simple shared_vars)
{
	shared_vars.SurfaceDiffuse = float4(1, 1, 1, 1);
	shared_vars.SurfaceSpecular = float3(1, 1, 1);
}



void vs_mesh_PART(in PGSL_VS_INPUT_hdr_mesh_simple input, inout PGSL_VS_OUTPUT_hdr_mesh_simple output, inout PGSL_VS_SHARED_hdr_mesh_simple shared_vars)
{
	//xform to projection space
#if defined(PGSL_MAX)
	output.Pos = mul(shared_vars.Pos, g_World);
	output.Pos = mul(output.Pos, g_View);
	output.Pos = mul(output.Pos, g_Proj);
#else
	output.Pos = mul(shared_vars.Pos, g_WorldViewProj);
#endif
	
	//save world pos
	shared_vars.WorldPos = mul(shared_vars.Pos, shared_vars.World);
}



void vs_shadowmap_uv_PART(in PGSL_VS_INPUT_hdr_mesh_simple input, inout PGSL_VS_OUTPUT_hdr_mesh_simple output, inout PGSL_VS_SHARED_hdr_mesh_simple shared_vars)
{
	output.ShadowmapTexcoords = mul(shared_vars.WorldPos, g_WorldToShadowmap);
	output.ShadowmapTexcoords.z = clamp(output.ShadowmapTexcoords.z, 0, output.ShadowmapTexcoords.w);
}



void vs_sph_lighting_fill_PART(in PGSL_VS_INPUT_hdr_mesh_simple input, inout PGSL_VS_OUTPUT_hdr_mesh_simple output, inout PGSL_VS_SHARED_hdr_mesh_simple shared_vars)
{
	float3 world_normal = normalize(mul(shared_vars.Normal, (float3x3)shared_vars.World));
	shared_vars.LightDiffuse.rgb += Sph_Compute_Diffuse_Light_Fill(world_normal);
}



void vs_compose_lighting_diffuse_PART(in PGSL_VS_INPUT_hdr_mesh_simple input, inout PGSL_VS_OUTPUT_hdr_mesh_simple output, inout PGSL_VS_SHARED_hdr_mesh_simple shared_vars)
{
	//do lighting: diffuse only
	shared_vars.Diffuse = shared_vars.LightDiffuse*shared_vars.SurfaceDiffuse.rgb;
	output.Diffuse.rgb = shared_vars.Diffuse.rgb;
	output.Diffuse.a = shared_vars.SurfaceDiffuse.a;
}



void vs_object_to_view_normal_PART(in PGSL_VS_INPUT_hdr_mesh_simple input, inout PGSL_VS_OUTPUT_hdr_mesh_simple output, inout PGSL_VS_SHARED_hdr_mesh_simple shared_vars)
{	
	float3 world_normal = mul(shared_vars.Normal, (float3x3)shared_vars.World);
	shared_vars.Normal = normalize(mul(world_normal, (float3x3)g_View));
}



void vs_vertex_normal_PART(in PGSL_VS_INPUT_hdr_mesh_simple input, inout PGSL_VS_OUTPUT_hdr_mesh_simple output, inout PGSL_VS_SHARED_hdr_mesh_simple shared_vars)
{
	output.Normal = shared_vars.Normal;
}



void vs_vertex_half_vector_view_space_PART(in PGSL_VS_INPUT_hdr_mesh_simple input, inout PGSL_VS_OUTPUT_hdr_mesh_simple output, inout PGSL_VS_SHARED_hdr_mesh_simple shared_vars)
{
	// view space vertex position
	float3 view_pos = mul(shared_vars.WorldPos, g_View).xyz;

	// viewspace light vector
	float3 view_space_light = normalize(mul(g_Light0Vec.xyz, (float3x3)g_View));
	shared_vars.LightVec = view_space_light;
	output.LightVec = shared_vars.LightVec;
	
	// viewspace half vector
	float3 view_eye_vec = normalize(view_pos);
	shared_vars.HalfVec = normalize(view_eye_vec + view_space_light);
	
	output.HalfVec = shared_vars.HalfVec;
}

PGSL_VS_OUTPUT_hdr_mesh_simple pass_vs_PGSL_VS_MAIN_hdr_mesh_simple(PGSL_VS_INPUT_hdr_mesh_simple meta_shader_in)
{
	PGSL_VS_OUTPUT_hdr_mesh_simple meta_shader_out = (PGSL_VS_OUTPUT_hdr_mesh_simple)0;
	PGSL_VS_SHARED_hdr_mesh_simple meta_shader_shared = (PGSL_VS_SHARED_hdr_mesh_simple)0;
	pre_vs_world_PART(meta_shader_in, meta_shader_out, meta_shader_shared);
	pre_vs_position_PART(meta_shader_in, meta_shader_out, meta_shader_shared);
	pre_vs_normal_PART(meta_shader_in, meta_shader_out, meta_shader_shared);
	pre_vs_base_uv_PART(meta_shader_in, meta_shader_out, meta_shader_shared);
	vs_base_uv_PART(meta_shader_in, meta_shader_out, meta_shader_shared);
	vs_identity_surface_material_PART(meta_shader_in, meta_shader_out, meta_shader_shared);
	vs_mesh_PART(meta_shader_in, meta_shader_out, meta_shader_shared);
	vs_shadowmap_uv_PART(meta_shader_in, meta_shader_out, meta_shader_shared);
	vs_sph_lighting_fill_PART(meta_shader_in, meta_shader_out, meta_shader_shared);
	vs_compose_lighting_diffuse_PART(meta_shader_in, meta_shader_out, meta_shader_shared);
	vs_object_to_view_normal_PART(meta_shader_in, meta_shader_out, meta_shader_shared);
	vs_vertex_normal_PART(meta_shader_in, meta_shader_out, meta_shader_shared);
	vs_vertex_half_vector_view_space_PART(meta_shader_in, meta_shader_out, meta_shader_shared);
	return meta_shader_out;
}















/////////////////////////////////////////////////////////////////////
//PIXEL SHADER INPUTS
/////////////////////////////////////////////////////////////////////
float4 Diffuse
<
string UIName = "Diffuse";
string UIType = "ColorSwatch";
bool GammaCorrect = true;
>
 = {1.0, 1.0, 1.0, 1.0};

float4 Specular
<
string UIName = "Specular";
string UIType = "ColorSwatch";
bool GammaCorrect = true;
>
 = {1.0, 1.0, 1.0, 1.0};

PGSL_TEXTURE2D BaseTexture  : DIFFUSEMAP
<
string UIName = "BaseTexture";
string UIType = "bitmap";
string SamplerEnum = "AL_SAMPLER_UVWRAP_MIN_MAG_MIP_BILINEAR_SRGB";
>
;
PGSL_SAMPLER BaseTextureSampler PGSL_SAMPLER_REG(0)
<
string UIName = "BaseTexture";
string UIType = "bitmap";
string SamplerEnum = "AL_SAMPLER_UVWRAP_MIN_MAG_MIP_BILINEAR_SRGB";
PGSL_BIND_TO_TEXTURE(BaseTexture)
string SamplerRegister = "0";
>
PGSL_SAMPLER_STATE(BaseTexture);

float SpecularIntensity
<
string UIName = "SpecularIntensity";
>
 = 1;

float SpecularGloss
<
string UIName = "SpecularGloss";
float UIMin = 0.0f;
float UIMax = 1.0f;
>
 = 0.25;

float FresnelMin
<
string UIName = "FresnelMin";
float UIMin = 0.0f;
float UIMax = 1.0f;
>
 = 0.0;

float FresnelMax
<
string UIName = "FresnelMax";
float UIMin = 0.0f;
float UIMax = 1.0f;
>
 = 1.0;

float FresnelPower
<
string UIName = "FresnelPower";
>
 = 5.0;

PGSL_TEXTURE2D Shadowmap PGSL_TEXTURE_REG(3)
<
string SamplerEnum = "AL_SAMPLER_UVCLAMP_MIN_MAG_MIP_POINT";
>
;
PGSL_SAMPLER ShadowmapSampler PGSL_SAMPLER_REG(3)
<
string SamplerEnum = "AL_SAMPLER_UVCLAMP_MIN_MAG_MIP_POINT";
PGSL_BIND_TO_TEXTURE(Shadowmap)
string SamplerRegister = "3";
>
PGSL_SAMPLER_STATE(Shadowmap);

PGSL_TEXTURE2D LightFieldTexture PGSL_TEXTURE_REG(4)
<
string SamplerEnum = "AL_SAMPLER_UVCLAMP_MIN_MAG_MIP_BILINEAR_SRGB";
>
;
PGSL_SAMPLER LightFieldTextureSampler
<
string SamplerEnum = "AL_SAMPLER_UVCLAMP_MIN_MAG_MIP_BILINEAR_SRGB";
PGSL_BIND_TO_TEXTURE(LightFieldTexture)
>
PGSL_SAMPLER_STATE(LightFieldTexture);




/////////////////////////////////////////////////////////////////////
//PIXEL SHADER OUTPUTS
/////////////////////////////////////////////////////////////////////
struct PGSL_PS_OUTPUT_hdr_mesh_simple
{
	float4 Color0  : PGSL_TARGET0;
};



/////////////////////////////////////////////////////////////////////
//PIXEL SHADER SHARED STRUCT
/////////////////////////////////////////////////////////////////////
struct PGSL_PS_SHARED_hdr_mesh_simple
{
	float2 BaseTexUV;
	float4 SurfaceDiffuse;
	float3 SurfaceSpecular;
	float4 Albedo;
	float3 SpecColor;
	float SpecGloss;
	float EmissiveMask;
	float3 Normal;
	float3 HalfVec;
	float3 LightVec;
	float3 LightDiffuse;
	float NDotL;
	float3 LightSpecular;
	float3 ViewVec;
	float3 Reflection;
	float3 Diffuse;
	float3 Specular;
	float3 Emissive;
};



/////////////////////////////////////////////////////////////////////
//PIXEL SHADERS
/////////////////////////////////////////////////////////////////////


void pre_ps_base_uv_PART(inout PGSL_PS_INPUT_hdr_mesh_simple input, inout PGSL_PS_OUTPUT_hdr_mesh_simple output, inout PGSL_PS_SHARED_hdr_mesh_simple shared_vars)
{
	shared_vars.BaseTexUV = input.BaseTexUV;
}



void ps_surface_material_opaque_PART(in PGSL_PS_INPUT_hdr_mesh_simple input, inout PGSL_PS_OUTPUT_hdr_mesh_simple output, inout PGSL_PS_SHARED_hdr_mesh_simple shared_vars)
{
	shared_vars.SurfaceDiffuse = Diffuse;
	shared_vars.SurfaceDiffuse.a = 1;
	
	shared_vars.SurfaceSpecular = Specular.rgb;
}



void ps_base_texture_rgb_PART(in PGSL_PS_INPUT_hdr_mesh_simple input, inout PGSL_PS_OUTPUT_hdr_mesh_simple output, inout PGSL_PS_SHARED_hdr_mesh_simple shared_vars)
{
	shared_vars.Albedo = PGSL_TEX2D(BaseTexture, BaseTextureSampler, shared_vars.BaseTexUV);
	shared_vars.SurfaceDiffuse.rgb *= shared_vars.Albedo.rgb;
}



void ps_specular_constants_PART(in PGSL_PS_INPUT_hdr_mesh_simple input, inout PGSL_PS_OUTPUT_hdr_mesh_simple output, inout PGSL_PS_SHARED_hdr_mesh_simple shared_vars)
{
	// Set up constants that match the data that we get from the specular texture.
	shared_vars.SpecColor = SpecularIntensity*float3(1,1,1);  // no per-pixel spec color
	shared_vars.SpecGloss = SpecularGloss;
	shared_vars.EmissiveMask = 0.0f;
}



void ps_phong_vectors_PART(in PGSL_PS_INPUT_hdr_mesh_simple input, inout PGSL_PS_OUTPUT_hdr_mesh_simple output, inout PGSL_PS_SHARED_hdr_mesh_simple shared_vars)
{
	shared_vars.Normal = normalize(input.Normal);
	shared_vars.HalfVec = normalize(input.HalfVec);
	shared_vars.LightVec = normalize(input.LightVec);
}



void ps_phong_diffuse_PART(in PGSL_PS_INPUT_hdr_mesh_simple input, inout PGSL_PS_OUTPUT_hdr_mesh_simple output, inout PGSL_PS_SHARED_hdr_mesh_simple shared_vars)
{
	shared_vars.NDotL = dot(shared_vars.Normal.xyz, shared_vars.LightVec);
	shared_vars.LightDiffuse.rgb += saturate(shared_vars.NDotL)*g_Light0Diffuse.rgb;
}



void ps_phong_spec_pp_PART(in PGSL_PS_INPUT_hdr_mesh_simple input, inout PGSL_PS_OUTPUT_hdr_mesh_simple output, inout PGSL_PS_SHARED_hdr_mesh_simple shared_vars)
{
	float ndoth = saturate(dot(shared_vars.Normal.xyz, shared_vars.HalfVec));
	float spec_power = pow(256,shared_vars.SpecGloss) + 16;
	float spec_light = pow(ndoth, spec_power);
	
	// Normalization:
	spec_light *= (spec_power + 1) / 8;
	
	// equations from the LPP
	float3 diffuse = g_Light0Diffuse.rgb; //*g_Light0Diffuse.aaa; not used in fwd renderer...
	float3 specular = spec_light*g_Light0Specular.a*diffuse;
	spec_light = dot(LumVec, specular);
				
	float diffuse_lum = dot(LumVec, shared_vars.LightDiffuse.rgb);
	float chromaticity = spec_light / (diffuse_lum + Epsilon);
	
	//shared_vars.LightSpecular.rgb = spec_light * shared_vars.SpecColor; // *spec_light;
	shared_vars.LightSpecular.rgb += shared_vars.SpecColor*chromaticity*shared_vars.LightDiffuse.rgb;
}



void ps_fresnel_simple_PART(in PGSL_PS_INPUT_hdr_mesh_simple input, inout PGSL_PS_OUTPUT_hdr_mesh_simple output, inout PGSL_PS_SHARED_hdr_mesh_simple shared_vars)
{
	float ndotv = saturate(dot(shared_vars.Normal.xyz, shared_vars.ViewVec));
	float fresnel_factor = pow((1.0 - ndotv),FresnelPower);
	fresnel_factor = FresnelMin + (FresnelMax - FresnelMin)*fresnel_factor;
	shared_vars.LightSpecular *= fresnel_factor;
	shared_vars.Reflection *= fresnel_factor;
}

//sampling the shadow map from a floating texture using 
//non-hw instruction for depth compare
float Sample_Shadowmap_2x2_Pcf_Non_Hw(in float4 shadow_coords)
{
	float shadow = 0;
	float pixel_depth = shadow_coords.z/shadow_coords.w;
	float2 proj_uv = shadow_coords.xy/shadow_coords.w;
	float2 uv;
	float sm_depth;
	
	uv = proj_uv + float2(0.5, 0.5)*g_ShadowmapInverseResolution.xy;
	sm_depth = PGSL_TEX2D(Shadowmap, ShadowmapSampler, uv).r;
	shadow += (sm_depth PGSL_COMP_GREATER_EQUAL pixel_depth);
	
	uv = proj_uv + float2(0.5, -0.5)*g_ShadowmapInverseResolution.xy;
	sm_depth = PGSL_TEX2D(Shadowmap, ShadowmapSampler, uv).r;
	shadow += (sm_depth PGSL_COMP_GREATER_EQUAL pixel_depth);
	
	uv = proj_uv + float2(-0.5, -0.5)*g_ShadowmapInverseResolution.xy;
	sm_depth = PGSL_TEX2D(Shadowmap, ShadowmapSampler, uv).r;
	shadow += (sm_depth PGSL_COMP_GREATER_EQUAL pixel_depth);
	
	uv = proj_uv + float2(-0.5, 0.5)*g_ShadowmapInverseResolution.xy;
	sm_depth = PGSL_TEX2D(Shadowmap, ShadowmapSampler, uv).r;
	shadow += (sm_depth PGSL_COMP_GREATER_EQUAL pixel_depth);
	
	shadow *= 0.25;
	
	return shadow;
}

//sample the shadow map from a hw depth texture using hw depth compare instruction
//depth/slop biasing is assumed to be done through the depth buffer
float Sample_Shadowmap_2x2_Pcf_Hw_Nvidia(in float4 shadow_coords)
{
	float shadow = 0;
	
	float4 uv;
	uv = shadow_coords + (float4(0.5, 0.5, 0, 0)*g_ShadowmapInverseResolution)*shadow_coords.w;
	shadow += PGSL_TEX2D_PROJ(Shadowmap, ShadowmapSampler, uv).r;
	
	uv = shadow_coords + (float4(0.5, -0.5, 0, 0)*g_ShadowmapInverseResolution)*shadow_coords.w;
	shadow += PGSL_TEX2D_PROJ(Shadowmap, ShadowmapSampler, uv).r;
	
	uv = shadow_coords + (float4(-0.5, -0.5, 0, 0)*g_ShadowmapInverseResolution)*shadow_coords.w;
	shadow += PGSL_TEX2D_PROJ(Shadowmap, ShadowmapSampler, uv).r;
	
	uv = shadow_coords + (float4(-0.5, 0.5, 0, 0)*g_ShadowmapInverseResolution)*shadow_coords.w;
	shadow += PGSL_TEX2D_PROJ(Shadowmap, ShadowmapSampler, uv).r;
	
	shadow *= 0.25;
	
	return shadow;
}

//sample the shadow map from a hw depth texture using fetch4
//depth/slop biasing is assumed to be done through the depth buffer
float Sample_Shadowmap_2x2_Pcf_Hw_Ati(in float4 shadow_coords)
{
	float pixel_depth = shadow_coords.z/shadow_coords.w;
	float4 shadowmap_vals = PGSL_TEX2D_PROJ(Shadowmap, ShadowmapSampler, shadow_coords).rgba;
	  
	float4 shadow = (shadowmap_vals PGSL_COMP_GREATER_EQUAL pixel_depth.xxxx);
	
	return dot(shadow, float4(0.25, 0.25, 0.25, 0.25));
}

float Sample_Shadowmap_2x2_Pcf(in float4 shadow_coords)
{
	float shadow = 0;
	
#if defined(PGSL_DX9)
#if defined(NVIDIA)
	shadow = Sample_Shadowmap_2x2_Pcf_Hw_Nvidia(shadow_coords);
#elif defined(ATI)
	shadow = Sample_Shadowmap_2x2_Pcf_Hw_Ati(shadow_coords);
#else
	shadow = Sample_Shadowmap_2x2_Pcf_Non_Hw(shadow_coords);
#endif
#elif defined(PGSL_DX10)
	shadow = Sample_Shadowmap_2x2_Pcf_Non_Hw(shadow_coords);
#elif defined(PGSL_DX11)
	shadow = Sample_Shadowmap_2x2_Pcf_Non_Hw(shadow_coords);
#elif defined(PGSL_XBOX360)
	shadow = Sample_Shadowmap_2x2_Pcf_Non_Hw(shadow_coords);
#elif defined(PGSL_PS3)
#endif
	
	return lerp(shadow, 1.0, g_ShadowBias);
}

void ps_2x2_pcf_shadow_PART(in PGSL_PS_INPUT_hdr_mesh_simple input, inout PGSL_PS_OUTPUT_hdr_mesh_simple output, inout PGSL_PS_SHARED_hdr_mesh_simple shared_vars)
{
#if defined(PGSL_MAX)
#else
	float shadow = Sample_Shadowmap_2x2_Pcf(input.ShadowmapTexcoords);

	shared_vars.LightDiffuse *= shadow;
	shared_vars.LightSpecular *= shadow;
#endif
}



void ps_vertex_diffuse_PART(in PGSL_PS_INPUT_hdr_mesh_simple input, inout PGSL_PS_OUTPUT_hdr_mesh_simple output, inout PGSL_PS_SHARED_hdr_mesh_simple shared_vars)
{
	shared_vars.LightDiffuse.rgb += input.Diffuse.rgb;
}



void ps_lightscale_PART(in PGSL_PS_INPUT_hdr_mesh_simple input, inout PGSL_PS_OUTPUT_hdr_mesh_simple output, inout PGSL_PS_SHARED_hdr_mesh_simple shared_vars)
{
	shared_vars.LightDiffuse.rgb *= g_LightScale.rgb;
	shared_vars.SurfaceDiffuse.a *= g_LightScale.a;
}



void ps_compose_lighting_PART(in PGSL_PS_INPUT_hdr_mesh_simple input, inout PGSL_PS_OUTPUT_hdr_mesh_simple output, inout PGSL_PS_SHARED_hdr_mesh_simple shared_vars)
{
	shared_vars.Diffuse = shared_vars.SurfaceDiffuse.rgb*shared_vars.LightDiffuse;
	shared_vars.Specular = shared_vars.SurfaceSpecular*shared_vars.LightSpecular;
	output.Color0.rgb = shared_vars.Diffuse.rgb + shared_vars.Specular.rgb + shared_vars.Emissive.rgb + shared_vars.Reflection.rgb;
	output.Color0.a = shared_vars.SurfaceDiffuse.a;

	//output.Color0.rgb = shared_vars.Specular.rgb + shared_vars.Diffuse.rgb;
	//output.Color0.rgb = shared_vars.Diffuse.rgb;
	//output.Color0.rgb = shared_vars.Diffuse.rgb;
	//output.Color0.rgb = shared_vars.LightSpecular.rgb;
	//output.Color0.rgb = shared_vars.Reflection.rgb;
	//output.Color0.rgb = float3(shared_vars.SpecGloss,shared_vars.SpecGloss,shared_vars.SpecGloss);
}

PGSL_PS_OUTPUT_hdr_mesh_simple pass_ps_PGSL_PS_MAIN_hdr_mesh_simple(PGSL_PS_INPUT_hdr_mesh_simple meta_shader_in)
{
	PGSL_PS_OUTPUT_hdr_mesh_simple meta_shader_out = (PGSL_PS_OUTPUT_hdr_mesh_simple)0;
	PGSL_PS_SHARED_hdr_mesh_simple meta_shader_shared = (PGSL_PS_SHARED_hdr_mesh_simple)0;
	pre_ps_base_uv_PART(meta_shader_in, meta_shader_out, meta_shader_shared);
	ps_surface_material_opaque_PART(meta_shader_in, meta_shader_out, meta_shader_shared);
	ps_base_texture_rgb_PART(meta_shader_in, meta_shader_out, meta_shader_shared);
	ps_specular_constants_PART(meta_shader_in, meta_shader_out, meta_shader_shared);
	ps_phong_vectors_PART(meta_shader_in, meta_shader_out, meta_shader_shared);
	ps_phong_diffuse_PART(meta_shader_in, meta_shader_out, meta_shader_shared);
	ps_phong_spec_pp_PART(meta_shader_in, meta_shader_out, meta_shader_shared);
	ps_fresnel_simple_PART(meta_shader_in, meta_shader_out, meta_shader_shared);
	ps_2x2_pcf_shadow_PART(meta_shader_in, meta_shader_out, meta_shader_shared);
	ps_vertex_diffuse_PART(meta_shader_in, meta_shader_out, meta_shader_shared);
	ps_lightscale_PART(meta_shader_in, meta_shader_out, meta_shader_shared);
	ps_compose_lighting_PART(meta_shader_in, meta_shader_out, meta_shader_shared);
	return meta_shader_out;
}



/////////////////////////////////////////////////////////////////////
//SHADER'S PASSES
/////////////////////////////////////////////////////////////////////
PGSL_TECHNIQUE_BEGIN
	PGSL_PASS_BEGIN(pass_0, 
	<
		string _RasterizeState_ = "ALRS_DEFAULT";string _BlendState_ = "ALBS_ALPHA_BLEND_ALPHA_SCRIPTING";string _DepthStencilState_ = "ALDS_DEPTHLESSEQUALWRITE_STENCILDISABLE";bool EnableAlphaScripting = true;
	>)
		PGSL_PASS_VS(pass_vs_PGSL_VS_MAIN_hdr_mesh_simple, 1)
		PGSL_PASS_PS(pass_ps_PGSL_PS_MAIN_hdr_mesh_simple, 1)
	PGSL_PASS_END
PGSL_TECHNIQUE_END



