//////////////////////////////////////////////////////////////////////////////////////////////////////////
//
//Petroglyph Confidential Source Code -- Do Not Distribute
//
// (Auto generated by PGSLCodeGenerator)
//Platform: MAX
//////////////////////////////////////////////////////////////////////////////////////////////////////////
#define PGSL_MAX
#define PGSL_DX9
#include"..\common\PGSLAlways.pgh"
#include"..\common\AlamoEngine.pgh"
#include"..\common\AlamoEngine_Skinning.pgh"

float g_ShaderFileDummyVariable : SHADER_FILE_ANNOTATION
<
string _ALAMO_RENDER_PHASE = "Opaque";
string _ALAMO_VERTEX_PROC = "Skin";
string _ALAMO_VERTEX_TYPE = "alD3dVertB4I4NU2C";
bool _ALAMO_TANGENT_SPACE = false;
bool _ALAMO_BONES_PER_VERTEX = 4;
>;

#define PGSL_PS_INPUT_hdr_goo_skin PGSL_VS_OUTPUT_hdr_goo_skin



/////////////////////////////////////////////////////////////////////
//VERTEX SHADER INPUTS
/////////////////////////////////////////////////////////////////////
float4 DiffuseTexU
<
string UIName = "DiffuseTexU";
>
 = {0.01, 0, 0, 0};

float4 DiffuseTexV
<
string UIName = "DiffuseTexV";
>
 = {0, 0.01, 0, 0};

float DiffuseTexTile
<
string UIName = "DiffuseTexTile";
>
 = 1.0;

float4 Goo_Color_Edge
<
string UIName = "Goo_Color_Edge";
>
 = {0.5,0.4,0.05,1.0};

float4 Goo_Color_Forward
<
string UIName = "Goo_Color_Forward";
>
 = {0.01,0.01,0.0,1.0};

float Goo_Color_Power
<
string UIName = "Goo_Color_Power";
>
 = 0.05f;

float4 Mask01_PanAmount
<
string UIName = "Mask01_PanAmount";
>
 = {0.1,0.65,0.0,0.0};

float Mask01_Tile
<
string UIName = "Mask01_Tile";
>
 = 1.0f;

float4 Mask02_PanAmount
<
string UIName = "Mask02_PanAmount";
>
 = {0.65,0.1,0.0,0.0};

float Mask02_Tile
<
string UIName = "Mask02_Tile";
>
 = 1.0f;

struct PGSL_VS_INPUT_hdr_goo_skin
{
	float3 Pos  : PGSL_POSITION;
	float4 BlendWeights  : PGSL_BLENDWEIGHTS;
	PGSL_PACKED_FLOAT4 BlendIndices  : PGSL_BLENDINDICES;
	float3 Normal  : PGSL_NORMAL;
	float2 BaseTexUV  : PGSL_TEXCOORD0;
};



/////////////////////////////////////////////////////////////////////
//VERTEX SHADER OUTPUTS
/////////////////////////////////////////////////////////////////////
struct PGSL_VS_OUTPUT_hdr_goo_skin
{
	float4 Pos  : PGSL_SV_POSITION;
	float2 BaseTexUV  : PGSL_TEXCOORD0;
	float3 TangentToWorldXBasis  : PGSL_TEXCOORD1;
	float3 TangentToWorldYBasis  : PGSL_TEXCOORD2;
	float3 TangentToWorldZBasis  : PGSL_TEXCOORD3;
	float4 VertexColor  : PGSL_COLOR0;
	float4 MaskUV  : PGSL_TEXCOORD4;
	float3 ParallaxViewVec  : PGSL_TEXCOORD5;
	float3 ViewVec  : PGSL_TEXCOORD6;
	float4 Diffuse  : PGSL_TEXCOORD7;
};



/////////////////////////////////////////////////////////////////////
//VERTEX SHADER SHARED STRUCT
/////////////////////////////////////////////////////////////////////
struct PGSL_VS_SHARED_hdr_goo_skin
{
	float4x4 World;
	float4 Pos;
	float4 BlendWeights;
	int4 BlendIndices;
	float3 Normal;
	float2 BaseTexUV;
	float4 SurfaceDiffuse;
	float3 SurfaceSpecular;
	float4 WorldPos;
	float4 DiffuseTexU;
	float4 DiffuseTexV;
	float3 Tangent;
	float3 Bitangent;
	float4 VertexColor;
	float3 LightDiffuse;
	float3 Diffuse;
};



/////////////////////////////////////////////////////////////////////
//VERTEX SHADERS
/////////////////////////////////////////////////////////////////////


void pre_vs_world_PART(inout PGSL_VS_INPUT_hdr_goo_skin input, inout PGSL_VS_OUTPUT_hdr_goo_skin output, inout PGSL_VS_SHARED_hdr_goo_skin shared_vars)
{
	shared_vars.World = g_World;
}



void pre_vs_position_PART(inout PGSL_VS_INPUT_hdr_goo_skin input, inout PGSL_VS_OUTPUT_hdr_goo_skin output, inout PGSL_VS_SHARED_hdr_goo_skin shared_vars)
{
	shared_vars.Pos = float4(input.Pos.xyz, 1.0);
}



void pre_vs_skin_PART(inout PGSL_VS_INPUT_hdr_goo_skin input, inout PGSL_VS_OUTPUT_hdr_goo_skin output, inout PGSL_VS_SHARED_hdr_goo_skin shared_vars)
{
	shared_vars.BlendWeights = input.BlendWeights;
	shared_vars.BlendIndices = ConvertSkinIndices(input.BlendIndices);
}



void pre_vs_normal_PART(inout PGSL_VS_INPUT_hdr_goo_skin input, inout PGSL_VS_OUTPUT_hdr_goo_skin output, inout PGSL_VS_SHARED_hdr_goo_skin shared_vars)
{
	shared_vars.Normal = input.Normal.xyz;
}



void pre_vs_base_uv_PART(inout PGSL_VS_INPUT_hdr_goo_skin input, inout PGSL_VS_OUTPUT_hdr_goo_skin output, inout PGSL_VS_SHARED_hdr_goo_skin shared_vars)
{
	shared_vars.BaseTexUV = input.BaseTexUV;
}



void vs_identity_surface_material_PART(in PGSL_VS_INPUT_hdr_goo_skin input, inout PGSL_VS_OUTPUT_hdr_goo_skin output, inout PGSL_VS_SHARED_hdr_goo_skin shared_vars)
{
	shared_vars.SurfaceDiffuse = float4(1, 1, 1, 1);
	shared_vars.SurfaceSpecular = float3(1, 1, 1);
}



void vs_skin_PART(in PGSL_VS_INPUT_hdr_goo_skin input, inout PGSL_VS_OUTPUT_hdr_goo_skin output, inout PGSL_VS_SHARED_hdr_goo_skin shared_vars)
{
	//skinning
	float4x3 weighted_xform;
#if defined(PGSL_MAX)
	weighted_xform = g_World;
	float3 world_pos = mul(shared_vars.Pos, weighted_xform);
	output.Pos = mul(float4(world_pos, 1.0), g_View);
	output.Pos = mul(output.Pos, g_Proj);
#else
	weighted_xform = shared_vars.BlendWeights[0]*SkinMatrixArray[shared_vars.BlendIndices[0]];
	weighted_xform += shared_vars.BlendWeights[1]*SkinMatrixArray[shared_vars.BlendIndices[1]];
	weighted_xform += shared_vars.BlendWeights[2]*SkinMatrixArray[shared_vars.BlendIndices[2]];
	weighted_xform += shared_vars.BlendWeights[3]*SkinMatrixArray[shared_vars.BlendIndices[3]];
	float3 world_pos = mul(shared_vars.Pos, weighted_xform);
	output.Pos = mul(float4(world_pos, 1.0), g_ViewProj);
#endif
	
	//save world pos
	shared_vars.WorldPos = float4(world_pos, 1.0);
	//save world xform
	shared_vars.World[0] = float4(weighted_xform[0], 0);
	shared_vars.World[1] = float4(weighted_xform[1], 0);
	shared_vars.World[2] = float4(weighted_xform[2], 0);
	shared_vars.World[3] = float4(weighted_xform[3], 1);
}



void vs_base_uv_from_world_basis_PART(in PGSL_VS_INPUT_hdr_goo_skin input, inout PGSL_VS_OUTPUT_hdr_goo_skin output, inout PGSL_VS_SHARED_hdr_goo_skin shared_vars)
{
	float4 object_origin = float4(g_World._m30,g_World._m31,g_World._m32,0.0f);
	
	shared_vars.BaseTexUV.x = DiffuseTexTile * dot(DiffuseTexU, (shared_vars.WorldPos - object_origin));
	shared_vars.BaseTexUV.y = DiffuseTexTile * dot(DiffuseTexV, (shared_vars.WorldPos - object_origin));
	output.BaseTexUV = shared_vars.BaseTexUV;

	// certain other shader parts such as 'vs_tangent_vectors_from_world_basis' can use
	// the uv projection vectors so copy them into shared variables.
	shared_vars.DiffuseTexU = DiffuseTexU;
	shared_vars.DiffuseTexV = DiffuseTexV;
}



void vs_tangent_vectors_from_world_basis_PART(in PGSL_VS_INPUT_hdr_goo_skin input, inout PGSL_VS_OUTPUT_hdr_goo_skin output, inout PGSL_VS_SHARED_hdr_goo_skin shared_vars)
{
	//tangent space xform generation
	float3 N = shared_vars.Normal;
	float ooNz = (1.0f / N.z);
	if (isinf(ooNz))
	{
		ooNz = 100.0f;
	}
	float3 Nxy = float3(N.x, N.y, 0);
	float3 T = float3(DiffuseTexU.x, DiffuseTexU.y, 0);
	T.z = -dot(Nxy, T)*ooNz;
	T = normalize(T);
	float3 B = float3(DiffuseTexV.x, DiffuseTexV.y, 0);
	B.z = -dot(Nxy, B)*ooNz;
	B = normalize(B);
	
	shared_vars.Tangent = T;
	shared_vars.Bitangent = -B;
	shared_vars.Normal = N;
}



void vs_tangent_to_world_xform_PART(in PGSL_VS_INPUT_hdr_goo_skin input, inout PGSL_VS_OUTPUT_hdr_goo_skin output, inout PGSL_VS_SHARED_hdr_goo_skin shared_vars)
{
	float3x3 xform = (float3x3)shared_vars.World;
	//transform tangent, bitangent and normal into world space
	float3 T = normalize(mul(shared_vars.Tangent, xform));
	float3 B = normalize(mul(shared_vars.Bitangent, xform));
	float3 N = normalize(mul(shared_vars.Normal, xform));
	
	output.TangentToWorldXBasis = float3(T.x, B.x, N.x);
	output.TangentToWorldYBasis = float3(T.y, B.y, N.y);
	output.TangentToWorldZBasis = float3(T.z, B.z, N.z);
}



void vs_goo_base_color_PART(in PGSL_VS_INPUT_hdr_goo_skin input, inout PGSL_VS_OUTPUT_hdr_goo_skin output, inout PGSL_VS_SHARED_hdr_goo_skin shared_vars)
{
    // edge fade
	float3 world_normal = normalize(mul(shared_vars.Normal, (float3x3)shared_vars.World));
	float3 view_norm = normalize(mul(world_normal, (float3x3)g_View));
    
	float t = saturate(view_norm.z);
	t = pow(t,Goo_Color_Power);
	float4 rgba = lerp(Goo_Color_Edge,Goo_Color_Forward,t);

	shared_vars.VertexColor = rgba;  
	output.VertexColor = rgba;
}



void vs_goo_glows_PART(in PGSL_VS_INPUT_hdr_goo_skin input, inout PGSL_VS_OUTPUT_hdr_goo_skin output, inout PGSL_VS_SHARED_hdr_goo_skin shared_vars)
{
	//compute uv scroll
	output.MaskUV.xy = shared_vars.BaseTexUV * Mask01_Tile + g_ElapsedTime * Mask01_PanAmount.xy;
	output.MaskUV.zw = shared_vars.BaseTexUV * Mask02_Tile + g_ElapsedTime * Mask02_PanAmount.xy;
	
	// tangent space view vector, used to parallax the glow layers
	output.ParallaxViewVec = Compute_View_Vector(shared_vars.WorldPos.xyz, g_EyePos.xyz, shared_vars.Tangent, shared_vars.Bitangent, shared_vars.Normal).xyz;
}



void vs_chrome_PART(in PGSL_VS_INPUT_hdr_goo_skin input, inout PGSL_VS_OUTPUT_hdr_goo_skin output, inout PGSL_VS_SHARED_hdr_goo_skin shared_vars)
{
	//Thanh - 07/18/2011 note: normalize(lerp(u, v, s)) is not the same as lerp(normalize(u), normalize(v), s)
	//and is also not the same as normalize(lerp(normalize(u), normalize(v), s))
	output.ViewVec = g_EyePos.xyz - shared_vars.WorldPos.xyz;
}



void vs_sph_lighting_fill_PART(in PGSL_VS_INPUT_hdr_goo_skin input, inout PGSL_VS_OUTPUT_hdr_goo_skin output, inout PGSL_VS_SHARED_hdr_goo_skin shared_vars)
{
	float3 world_normal = normalize(mul(shared_vars.Normal, (float3x3)shared_vars.World));
	shared_vars.LightDiffuse.rgb += Sph_Compute_Diffuse_Light_Fill(world_normal);
}



void vs_compose_lighting_diffuse_PART(in PGSL_VS_INPUT_hdr_goo_skin input, inout PGSL_VS_OUTPUT_hdr_goo_skin output, inout PGSL_VS_SHARED_hdr_goo_skin shared_vars)
{
	//do lighting: diffuse only
	shared_vars.Diffuse = shared_vars.LightDiffuse*shared_vars.SurfaceDiffuse.rgb;
	output.Diffuse.rgb = shared_vars.Diffuse.rgb;
	output.Diffuse.a = shared_vars.SurfaceDiffuse.a;
}

PGSL_VS_OUTPUT_hdr_goo_skin pass_vs_PGSL_VS_MAIN_hdr_goo_skin(PGSL_VS_INPUT_hdr_goo_skin meta_shader_in)
{
	PGSL_VS_OUTPUT_hdr_goo_skin meta_shader_out = (PGSL_VS_OUTPUT_hdr_goo_skin)0;
	PGSL_VS_SHARED_hdr_goo_skin meta_shader_shared = (PGSL_VS_SHARED_hdr_goo_skin)0;
	pre_vs_world_PART(meta_shader_in, meta_shader_out, meta_shader_shared);
	pre_vs_position_PART(meta_shader_in, meta_shader_out, meta_shader_shared);
	pre_vs_skin_PART(meta_shader_in, meta_shader_out, meta_shader_shared);
	pre_vs_normal_PART(meta_shader_in, meta_shader_out, meta_shader_shared);
	pre_vs_base_uv_PART(meta_shader_in, meta_shader_out, meta_shader_shared);
	vs_identity_surface_material_PART(meta_shader_in, meta_shader_out, meta_shader_shared);
	vs_skin_PART(meta_shader_in, meta_shader_out, meta_shader_shared);
	vs_base_uv_from_world_basis_PART(meta_shader_in, meta_shader_out, meta_shader_shared);
	vs_tangent_vectors_from_world_basis_PART(meta_shader_in, meta_shader_out, meta_shader_shared);
	vs_tangent_to_world_xform_PART(meta_shader_in, meta_shader_out, meta_shader_shared);
	vs_goo_base_color_PART(meta_shader_in, meta_shader_out, meta_shader_shared);
	vs_goo_glows_PART(meta_shader_in, meta_shader_out, meta_shader_shared);
	vs_chrome_PART(meta_shader_in, meta_shader_out, meta_shader_shared);
	vs_sph_lighting_fill_PART(meta_shader_in, meta_shader_out, meta_shader_shared);
	vs_compose_lighting_diffuse_PART(meta_shader_in, meta_shader_out, meta_shader_shared);
	return meta_shader_out;
}















/////////////////////////////////////////////////////////////////////
//PIXEL SHADER INPUTS
/////////////////////////////////////////////////////////////////////
float4 Diffuse
<
string UIName = "Diffuse";
string UIType = "ColorSwatch";
bool GammaCorrect = true;
>
 = {1.0, 1.0, 1.0, 1.0};

float4 Specular
<
string UIName = "Specular";
string UIType = "ColorSwatch";
bool GammaCorrect = true;
>
 = {1.0, 1.0, 1.0, 1.0};

float SpecularIntensity
<
string UIName = "SpecularIntensity";
>
 = 1;

PGSL_TEXTURE2D SpecularTexture
<
string UIName = "SpecularTexture";
string UIType = "bitmap";
string SamplerEnum = "AL_SAMPLER_UVWRAP_MIN_MAG_MIP_BILINEAR";
>
;
PGSL_SAMPLER SpecularTextureSampler PGSL_SAMPLER_REG(0)
<
string UIName = "SpecularTexture";
string UIType = "bitmap";
string SamplerEnum = "AL_SAMPLER_UVWRAP_MIN_MAG_MIP_BILINEAR";
PGSL_BIND_TO_TEXTURE(SpecularTexture)
string SamplerRegister = "0";
>
PGSL_SAMPLER_STATE(SpecularTexture);

PGSL_TEXTURE2D NormalTexture  : NORMALMAP
<
string UIName = "NormalTexture";
string UIType = "bitmap";
string SamplerEnum = "AL_SAMPLER_UVWRAP_MIN_MAG_MIP_BILINEAR";
bool DiscardableBump = true;
>
;
PGSL_SAMPLER NormalTextureSampler PGSL_SAMPLER_REG(1)
<
string UIName = "NormalTexture";
string UIType = "bitmap";
string SamplerEnum = "AL_SAMPLER_UVWRAP_MIN_MAG_MIP_BILINEAR";
bool DiscardableBump = true;
PGSL_BIND_TO_TEXTURE(NormalTexture)
string SamplerRegister = "1";
>
PGSL_SAMPLER_STATE(NormalTexture);

float ReflectionAmount
<
string UIName = "ReflectionAmount";
>
;

PGSL_TEXTURECUBE CubemapLightingFillTexture
<
string SamplerEnum = "AL_SAMPLER_UVWRAP_MIN_MAG_MIP_BILINEAR_SRGB";
>
;
PGSL_SAMPLER CubemapLightingFillTextureSampler PGSL_SAMPLER_REG(2)
<
string SamplerEnum = "AL_SAMPLER_UVWRAP_MIN_MAG_MIP_BILINEAR_SRGB";
PGSL_BIND_TO_TEXTURE(CubemapLightingFillTexture)
string SamplerRegister = "2";
>
PGSL_SAMPLER_STATE(CubemapLightingFillTexture);

float CubemapLightingIntensity = 1.0;

float FresnelMin
<
string UIName = "FresnelMin";
float UIMin = 0.0f;
float UIMax = 1.0f;
>
 = 0.0;

float FresnelMax
<
string UIName = "FresnelMax";
float UIMin = 0.0f;
float UIMax = 1.0f;
>
 = 1.0;

float FresnelPower
<
string UIName = "FresnelPower";
>
 = 5.0;

float Goo_Neurons_Tile
<
string UIName = "Goo_Neurons_Tile";
>
 = 1.0;

PGSL_TEXTURE2D Goo_Neurons
<
string UIName = "Goo_Neurons";
string UIType = "bitmap";
string SamplerEnum = "AL_SAMPLER_UVWRAP_MIN_MAG_MIP_BILINEAR";
>
;
PGSL_SAMPLER Goo_NeuronsSampler PGSL_SAMPLER_REG(5)
<
string UIName = "Goo_Neurons";
string UIType = "bitmap";
string SamplerEnum = "AL_SAMPLER_UVWRAP_MIN_MAG_MIP_BILINEAR";
PGSL_BIND_TO_TEXTURE(Goo_Neurons)
string SamplerRegister = "5";
>
PGSL_SAMPLER_STATE(Goo_Neurons);

float Goo_Mask_01_Boost
<
string UIName = "Goo_Mask_01_Boost";
>
 = 0.0f;

PGSL_TEXTURE2D Goo_Mask_01
<
string UIName = "Goo_Mask_01";
string UIType = "bitmap";
string SamplerEnum = "AL_SAMPLER_UVWRAP_MIN_MAG_MIP_BILINEAR_SRGB";
>
;
PGSL_SAMPLER Goo_Mask_01Sampler PGSL_SAMPLER_REG(6)
<
string UIName = "Goo_Mask_01";
string UIType = "bitmap";
string SamplerEnum = "AL_SAMPLER_UVWRAP_MIN_MAG_MIP_BILINEAR_SRGB";
PGSL_BIND_TO_TEXTURE(Goo_Mask_01)
string SamplerRegister = "6";
>
PGSL_SAMPLER_STATE(Goo_Mask_01);

PGSL_TEXTURE2D Goo_Mask_02
<
string UIName = "Goo_Mask_02";
string UIType = "bitmap";
string SamplerEnum = "AL_SAMPLER_UVWRAP_MIN_MAG_MIP_BILINEAR_SRGB";
>
;
PGSL_SAMPLER Goo_Mask_02Sampler PGSL_SAMPLER_REG(7)
<
string UIName = "Goo_Mask_02";
string UIType = "bitmap";
string SamplerEnum = "AL_SAMPLER_UVWRAP_MIN_MAG_MIP_BILINEAR_SRGB";
PGSL_BIND_TO_TEXTURE(Goo_Mask_02)
string SamplerRegister = "7";
>
PGSL_SAMPLER_STATE(Goo_Mask_02);

float4 Neurons_01_Color
<
string UIName = "Neurons_01_Color01";
string UIType = "ColorSwatch";
bool GammaCorrect = true;
>
 = {1.0, 1.0, 1.0, 1.0};

float Neurons_01_Intensity
<
string UIName = "Neurons_01_Intensity";
>
 = 1.0f;

float4 Neurons_02_Color
<
string UIName = "Neurons_02_Color";
string UIType = "ColorSwatch";
bool GammaCorrect = true;
>
 = {1.0, 1.0, 1.0, 1.0};

float Neurons_02_Intensity
<
string UIName = "Neurons_02_Intensity";
>
 = 1.0f;

float4 Neurons_03_Color
<
string UIName = "Neurons_03_Color";
string UIType = "ColorSwatch";
bool GammaCorrect = true;
>
 = {1.0, 1.0, 1.0, 1.0};

float Neurons_03_Intensity
<
string UIName = "Neurons_03_Intensity";
>
 = 1.0f;

float4 Neurons_Underbelly_Color
<
string UIName = "Neurons_Underbelly_Color";
string UIType = "ColorSwatch";
bool GammaCorrect = true;
>
 = {1.0, 1.0, 1.0, 1.0};

float Neurons_Underbelly_Intensity
<
string UIName = "Neurons_Underbelly_Intensity";
>
 = 1.0f;

PGSL_TEXTURE2D Shadowmap PGSL_TEXTURE_REG(3)
<
string SamplerEnum = "AL_SAMPLER_UVCLAMP_MIN_MAG_MIP_POINT";
>
;
PGSL_SAMPLER ShadowmapSampler
<
string SamplerEnum = "AL_SAMPLER_UVCLAMP_MIN_MAG_MIP_POINT";
PGSL_BIND_TO_TEXTURE(Shadowmap)
>
PGSL_SAMPLER_STATE(Shadowmap);

PGSL_TEXTURE2D LightFieldTexture PGSL_TEXTURE_REG(4)
<
string SamplerEnum = "AL_SAMPLER_UVCLAMP_MIN_MAG_MIP_BILINEAR_SRGB";
>
;
PGSL_SAMPLER LightFieldTextureSampler
<
string SamplerEnum = "AL_SAMPLER_UVCLAMP_MIN_MAG_MIP_BILINEAR_SRGB";
PGSL_BIND_TO_TEXTURE(LightFieldTexture)
>
PGSL_SAMPLER_STATE(LightFieldTexture);

PGSL_TEXTURE2D FowTexture
<
string SamplerEnum = "AL_SAMPLER_UVCLAMP_MIN_MAG_MIP_BILINEAR_SRGB";
>
;
PGSL_SAMPLER FowTextureSampler
<
string SamplerEnum = "AL_SAMPLER_UVCLAMP_MIN_MAG_MIP_BILINEAR_SRGB";
PGSL_BIND_TO_TEXTURE(FowTexture)
>
PGSL_SAMPLER_STATE(FowTexture);

float DisplacementScale
<
string UIName = "DisplacementScale";
>
 = 1.0;

float4 DisplacementTexU
<
string UIName = "DisplacementTexU";
>
 = {0.01, 0, 0, 0};

float4 DisplacementTexV
<
string UIName = "DisplacementTexV";
>
 = {0, 0.01, 0, 0};

float3 DisplacementProjectionDir
<
string UIName = "DisplacementProjectionDir";
>
 = {0,0,1};

PGSL_TEXTURE2D ProjectedDisplacementMap  : DISPLACMENTMAP
<
string UIName = "ProjectedDisplacementMap";
string UIType = "bitmap";
string SamplerEnum = "AL_SAMPLER_UVWRAP_MIN_MAG_MIP_BILINEAR_SRGB";
string SamplerStage = "DS";
>
;
PGSL_SAMPLER ProjectedDisplacementMapSampler PGSL_SAMPLER_REG(8)
<
string UIName = "ProjectedDisplacementMap";
string UIType = "bitmap";
string SamplerEnum = "AL_SAMPLER_UVWRAP_MIN_MAG_MIP_BILINEAR_SRGB";
string SamplerStage = "DS";
PGSL_BIND_TO_TEXTURE(ProjectedDisplacementMap)
string SamplerRegister = "8";
>
PGSL_SAMPLER_STATE(ProjectedDisplacementMap);

float TessellationTriSize
<
string UIName = "TessellationTriSize";
>
 = 5.0;




/////////////////////////////////////////////////////////////////////
//PIXEL SHADER OUTPUTS
/////////////////////////////////////////////////////////////////////
struct PGSL_PS_OUTPUT_hdr_goo_skin
{
	float4 Color0  : PGSL_TARGET0;
};



/////////////////////////////////////////////////////////////////////
//PIXEL SHADER SHARED STRUCT
/////////////////////////////////////////////////////////////////////
struct PGSL_PS_SHARED_hdr_goo_skin
{
	float2 BaseTexUV;
	float2 BumpTexUV;
	float4 SurfaceDiffuse;
	float3 SurfaceSpecular;
	float3 Emissive;
	float3 SpecColor;
	float EmissiveMask;
	float4 Normal;
	float SpecGloss;
	float3 LightVec;
	float3 ViewVec;
	float3 HalfVec;
	float4 Reflection;
	float3 LightDiffuse;
	float NDotL;
	float3 LightSpecular;
	float3 Diffuse;
	float3 Specular;
	float4 Albedo;
};



/////////////////////////////////////////////////////////////////////
//PIXEL SHADERS
/////////////////////////////////////////////////////////////////////


void pre_ps_base_uv_PART(inout PGSL_PS_INPUT_hdr_goo_skin input, inout PGSL_PS_OUTPUT_hdr_goo_skin output, inout PGSL_PS_SHARED_hdr_goo_skin shared_vars)
{
	shared_vars.BaseTexUV = input.BaseTexUV;
}



void pre_ps_bump_uv_from_base_uv_PART(inout PGSL_PS_INPUT_hdr_goo_skin input, inout PGSL_PS_OUTPUT_hdr_goo_skin output, inout PGSL_PS_SHARED_hdr_goo_skin shared_vars)
{
	shared_vars.BumpTexUV = input.BaseTexUV;
}



void ps_surface_material_opaque_PART(in PGSL_PS_INPUT_hdr_goo_skin input, inout PGSL_PS_OUTPUT_hdr_goo_skin output, inout PGSL_PS_SHARED_hdr_goo_skin shared_vars)
{
	shared_vars.SurfaceDiffuse = Diffuse;
	shared_vars.SurfaceDiffuse.a = 1;
	
	shared_vars.SurfaceSpecular = Specular.rgb;
}



void ps_goo_base_color_PART(in PGSL_PS_INPUT_hdr_goo_skin input, inout PGSL_PS_OUTPUT_hdr_goo_skin output, inout PGSL_PS_SHARED_hdr_goo_skin shared_vars)
{
	shared_vars.Emissive.rgb = (input.VertexColor.rgb);
}



void ps_specular_texture_PART(in PGSL_PS_INPUT_hdr_goo_skin input, inout PGSL_PS_OUTPUT_hdr_goo_skin output, inout PGSL_PS_SHARED_hdr_goo_skin shared_vars)
{
	// read the specular texture
	float4 spec_texel = PGSL_TEX2D(SpecularTexture, SpecularTextureSampler, shared_vars.BaseTexUV);
	shared_vars.SpecColor = spec_texel.rgb * SpecularIntensity;
	shared_vars.EmissiveMask = spec_texel.a;
}



void ps_bump_gloss_texture_PART(in PGSL_PS_INPUT_hdr_goo_skin input, inout PGSL_PS_OUTPUT_hdr_goo_skin output, inout PGSL_PS_SHARED_hdr_goo_skin shared_vars)
{
	//Thanh - 02/09/2010 fetching normal map with bi-linear filtering
	//actually implies that we need to re-normalize our normal
	//but we are not seeing notice-able artifacts from not normalizing it
	//so we can dodge the bullet and save us a bit of time here!
	//fetch normal from bump map
	float4 normal_texel = PGSL_TEX2D(NormalTexture, NormalTextureSampler, shared_vars.BumpTexUV);
	//scale to [-1, 1]
	shared_vars.Normal.xyz = (normal_texel.rgb - 0.5)*2.0;
	shared_vars.Normal.w = 0.0f;
	
	//alpha channel of normal texel is the specular gloss
	shared_vars.SpecGloss = normal_texel.a;
}



void ps_tangent_to_world_normal_PART(in PGSL_PS_INPUT_hdr_goo_skin input, inout PGSL_PS_OUTPUT_hdr_goo_skin output, inout PGSL_PS_SHARED_hdr_goo_skin shared_vars)
{
	float3 world_normal;
	world_normal.x = dot(input.TangentToWorldXBasis, shared_vars.Normal.xyz);
	world_normal.y = dot(input.TangentToWorldYBasis, shared_vars.Normal.xyz);
	world_normal.z = dot(input.TangentToWorldZBasis, shared_vars.Normal.xyz);
	world_normal = normalize(world_normal);
	
	shared_vars.Normal.xyz = world_normal.xyz;
}



void ps_chrome_bump_pp_PART(in PGSL_PS_INPUT_hdr_goo_skin input, inout PGSL_PS_OUTPUT_hdr_goo_skin output, inout PGSL_PS_SHARED_hdr_goo_skin shared_vars)
{
	//set up world space light vec and half vec
	shared_vars.ViewVec = normalize(input.ViewVec);
	shared_vars.LightVec = g_Light0Vec.xyz;
	shared_vars.HalfVec = normalize(shared_vars.LightVec + shared_vars.ViewVec);
	
	//sample the reflection from the cube map
	float3 r = -shared_vars.ViewVec + 2.0*dot(shared_vars.ViewVec, shared_vars.Normal.xyz)*shared_vars.Normal.xyz;
	float4 uv_with_bias = float4(r,8.0f*(1.0f-shared_vars.SpecGloss));
	float3 cube_texel = shared_vars.SpecColor * PGSL_TEXCUBE_BIAS(CubemapLightingFillTexture, CubemapLightingFillTextureSampler, uv_with_bias).rgb;
	cube_texel *= CubemapLightingIntensity;	
	cube_texel *= ReflectionAmount;

	shared_vars.Reflection.rgb += cube_texel;	
}



void ps_phong_diffuse_PART(in PGSL_PS_INPUT_hdr_goo_skin input, inout PGSL_PS_OUTPUT_hdr_goo_skin output, inout PGSL_PS_SHARED_hdr_goo_skin shared_vars)
{
	shared_vars.NDotL = dot(shared_vars.Normal.xyz, shared_vars.LightVec);
	shared_vars.LightDiffuse.rgb += saturate(shared_vars.NDotL)*g_Light0Diffuse.rgb;
}



void ps_phong_spec_pp_PART(in PGSL_PS_INPUT_hdr_goo_skin input, inout PGSL_PS_OUTPUT_hdr_goo_skin output, inout PGSL_PS_SHARED_hdr_goo_skin shared_vars)
{
	float ndoth = saturate(dot(shared_vars.Normal.xyz, shared_vars.HalfVec));
	float spec_power = pow(256,shared_vars.SpecGloss) + 16;
	float spec_light = pow(ndoth, spec_power);
	
	// Normalization:
	spec_light *= (spec_power + 1) / 8;
	
	// equations from the LPP
	float3 diffuse = g_Light0Diffuse.rgb; //*g_Light0Diffuse.aaa; not used in fwd renderer...
	float3 specular = spec_light*g_Light0Specular.a*diffuse;
	spec_light = dot(LumVec, specular);
				
	float diffuse_lum = dot(LumVec, shared_vars.LightDiffuse.rgb);
	float chromaticity = spec_light / (diffuse_lum + Epsilon);
	
	//shared_vars.LightSpecular.rgb = spec_light * shared_vars.SpecColor; // *spec_light;
	shared_vars.LightSpecular.rgb += shared_vars.SpecColor*chromaticity*shared_vars.LightDiffuse.rgb;
}



void ps_fresnel_simple_PART(in PGSL_PS_INPUT_hdr_goo_skin input, inout PGSL_PS_OUTPUT_hdr_goo_skin output, inout PGSL_PS_SHARED_hdr_goo_skin shared_vars)
{
	float ndotv = saturate(dot(shared_vars.Normal.xyz, shared_vars.ViewVec));
	float fresnel_factor = pow((1.0 - ndotv),FresnelPower);
	fresnel_factor = FresnelMin + (FresnelMax - FresnelMin)*fresnel_factor;
	shared_vars.LightSpecular *= fresnel_factor;
	shared_vars.Reflection *= fresnel_factor;
}



void ps_goo_glows_PART(in PGSL_PS_INPUT_hdr_goo_skin input, inout PGSL_PS_OUTPUT_hdr_goo_skin output, inout PGSL_PS_SHARED_hdr_goo_skin shared_vars)
{
	// Goo "circuitry"
	float2 hexuv = Goo_Neurons_Tile * shared_vars.BaseTexUV;

	// prepare for parallax offsetting
	float2 parallax = normalize(input.ParallaxViewVec).xy;
	parallax.y = -parallax.y;
	
	// Three parallaxing layers for the hex texture
	float pscale0 = 0.f;
	float pscale1 = 0.f;
	float pscale2 = 0.f; 
	float2 hex_uv_0 = hexuv + parallax*pscale0;		///(gth) removing all parallax since it causes stretching.
	float2 hex_uv_1 = hexuv + parallax*pscale1;
	float2 hex_uv_2 = hexuv + parallax*pscale2;
	
	float hex_layer_0 = PGSL_TEX2D(Goo_Neurons, Goo_NeuronsSampler, hex_uv_0).r;
	float hex_layer_1 = PGSL_TEX2D(Goo_Neurons, Goo_NeuronsSampler, hex_uv_1).g;
	float hex_layer_2 = PGSL_TEX2D(Goo_Neurons, Goo_NeuronsSampler, hex_uv_2).b;

	// Sample the "neurons" textures (fill noise that gets masked by the hex values)
	float4 neuron0_0 = PGSL_TEX2D(Goo_Mask_01,Goo_Mask_01Sampler,input.MaskUV.xy);
	float4 neuron0_1 = PGSL_TEX2D(Goo_Mask_01,Goo_Mask_01Sampler,input.MaskUV.zw);
	float4 neuron1_0 = PGSL_TEX2D(Goo_Mask_02,Goo_Mask_02Sampler,input.MaskUV.xy);
	float4 neuron1_1 = PGSL_TEX2D(Goo_Mask_02,Goo_Mask_02Sampler,input.MaskUV.zw);
	
	// apply the overbright/boost 
	float val = Goo_Mask_01_Boost;
	neuron0_0 += 0.5*val;			// low-res-fast-scrolling
	neuron0_1 += val; 				// detailed slow-scrolling energy pattern
	
	float4 neuron0 = neuron0_0 * neuron0_1;
	float4 neuron1 = neuron1_0 * neuron1_1;
		
	float4 glow0 = hex_layer_0 * Neurons_01_Intensity * Neurons_01_Color * neuron0; 
	float4 glow1 = hex_layer_1 * Neurons_02_Intensity * Neurons_02_Color * neuron1;
	float4 glow2 = hex_layer_2 * Neurons_03_Intensity * Neurons_03_Color * neuron1;
	float3 glow = (glow0 + glow1 + glow2).rgb;
	
	shared_vars.Emissive += glow * shared_vars.Normal.z*shared_vars.Normal.z;

	// add glow to the underbelly
	float underbelly_amount = saturate(-shared_vars.Normal.z);
	underbelly_amount = pow(underbelly_amount,3.0);
	shared_vars.Emissive += (underbelly_amount * neuron1 * Neurons_Underbelly_Color * Neurons_Underbelly_Intensity).rgb;
}



void ps_lightscale_PART(in PGSL_PS_INPUT_hdr_goo_skin input, inout PGSL_PS_OUTPUT_hdr_goo_skin output, inout PGSL_PS_SHARED_hdr_goo_skin shared_vars)
{
	shared_vars.LightDiffuse.rgb *= g_LightScale.rgb;
	shared_vars.SurfaceDiffuse.a *= g_LightScale.a;
}



void ps_compose_lighting_PART(in PGSL_PS_INPUT_hdr_goo_skin input, inout PGSL_PS_OUTPUT_hdr_goo_skin output, inout PGSL_PS_SHARED_hdr_goo_skin shared_vars)
{
	shared_vars.Diffuse = shared_vars.SurfaceDiffuse.rgb*shared_vars.LightDiffuse;
	shared_vars.Specular = shared_vars.SurfaceSpecular*shared_vars.LightSpecular;
	output.Color0.rgb = shared_vars.Diffuse.rgb + shared_vars.Specular.rgb + shared_vars.Emissive.rgb + shared_vars.Reflection.rgb;
	output.Color0.a = shared_vars.SurfaceDiffuse.a;

	//output.Color0.rgb = shared_vars.Specular.rgb + shared_vars.Diffuse.rgb;
	//output.Color0.rgb = shared_vars.Diffuse.rgb;
	//output.Color0.rgb = shared_vars.Diffuse.rgb;
	//output.Color0.rgb = shared_vars.LightSpecular.rgb;
	//output.Color0.rgb = shared_vars.Reflection.rgb;
	//output.Color0.rgb = float3(shared_vars.SpecGloss,shared_vars.SpecGloss,shared_vars.SpecGloss);
}



void ps_3dsmax_stub_projected_displacement_map_PART(in PGSL_PS_INPUT_hdr_goo_skin input, inout PGSL_PS_OUTPUT_hdr_goo_skin output, inout PGSL_PS_SHARED_hdr_goo_skin shared_vars)
{
/*	shared_vars.Albedo.r += 0.0001f*DisplacementScale;
	shared_vars.Albedo += 0.0001f*DisplacementTexU;
	shared_vars.Albedo += 0.0001f*DisplacementTexV;
	shared_vars.Albedo.rgb += 0.0001f*DisplacementProjectionDir;

	shared_vars.Albedo += 0.0001f*PGSL_TEX2D(ProjectedDisplacementMap, ProjectedDisplacementMapSampler, DisplacementTexU.xy);*/
}



void ps_3dsmax_stub_edge_length_lod_PART(in PGSL_PS_INPUT_hdr_goo_skin input, inout PGSL_PS_OUTPUT_hdr_goo_skin output, inout PGSL_PS_SHARED_hdr_goo_skin shared_vars)
{
/*	shared_vars.Albedo.r += 0.0001f*TessellationTriSize;
*/
}

PGSL_PS_OUTPUT_hdr_goo_skin pass_ps_PGSL_PS_MAIN_hdr_goo_skin(PGSL_PS_INPUT_hdr_goo_skin meta_shader_in)
{
	PGSL_PS_OUTPUT_hdr_goo_skin meta_shader_out = (PGSL_PS_OUTPUT_hdr_goo_skin)0;
	PGSL_PS_SHARED_hdr_goo_skin meta_shader_shared = (PGSL_PS_SHARED_hdr_goo_skin)0;
	pre_ps_base_uv_PART(meta_shader_in, meta_shader_out, meta_shader_shared);
	pre_ps_bump_uv_from_base_uv_PART(meta_shader_in, meta_shader_out, meta_shader_shared);
	ps_surface_material_opaque_PART(meta_shader_in, meta_shader_out, meta_shader_shared);
	ps_goo_base_color_PART(meta_shader_in, meta_shader_out, meta_shader_shared);
	ps_specular_texture_PART(meta_shader_in, meta_shader_out, meta_shader_shared);
	ps_bump_gloss_texture_PART(meta_shader_in, meta_shader_out, meta_shader_shared);
	ps_tangent_to_world_normal_PART(meta_shader_in, meta_shader_out, meta_shader_shared);
	ps_chrome_bump_pp_PART(meta_shader_in, meta_shader_out, meta_shader_shared);
	ps_phong_diffuse_PART(meta_shader_in, meta_shader_out, meta_shader_shared);
	ps_phong_spec_pp_PART(meta_shader_in, meta_shader_out, meta_shader_shared);
	ps_fresnel_simple_PART(meta_shader_in, meta_shader_out, meta_shader_shared);
	ps_goo_glows_PART(meta_shader_in, meta_shader_out, meta_shader_shared);
	ps_lightscale_PART(meta_shader_in, meta_shader_out, meta_shader_shared);
	ps_compose_lighting_PART(meta_shader_in, meta_shader_out, meta_shader_shared);
	ps_3dsmax_stub_projected_displacement_map_PART(meta_shader_in, meta_shader_out, meta_shader_shared);
	ps_3dsmax_stub_edge_length_lod_PART(meta_shader_in, meta_shader_out, meta_shader_shared);
	return meta_shader_out;
}



/////////////////////////////////////////////////////////////////////
//SHADER'S PASSES
/////////////////////////////////////////////////////////////////////
PGSL_TECHNIQUE_BEGIN
	PGSL_PASS_BEGIN(pass_0, 
	<
		string _RasterizeState_ = "ALRS_DEFAULT";string _BlendState_ = "ALBS_ALPHA_BLEND_ALPHA_SCRIPTING";string _DepthStencilState_ = "ALDS_DEPTHLESSEQUALWRITE_STENCILDISABLE";bool EnableAlphaScripting = true;
	>)
		PGSL_PASS_VS(pass_vs_PGSL_VS_MAIN_hdr_goo_skin, 1)
		PGSL_PASS_PS(pass_ps_PGSL_PS_MAIN_hdr_goo_skin, 1)
	PGSL_PASS_END
PGSL_TECHNIQUE_END



