//////////////////////////////////////////////////////////////////////////////////////////////////////////
//
//Petroglyph Confidential Source Code -- Do Not Distribute
//
// (Auto generated by PGSLCodeGenerator)
//Platform: MAX
//////////////////////////////////////////////////////////////////////////////////////////////////////////
#define PGSL_MAX
#define PGSL_DX9
#include"..\common\PGSLAlways.pgh"
#include"..\common\AlamoEngine.pgh"

float g_ShaderFileDummyVariable : SHADER_FILE_ANNOTATION
<
string _ALAMO_RENDER_PHASE = "Transparent";
string _ALAMO_VERTEX_PROC = "Billboards";
string _ALAMO_VERTEX_TYPE = "alD3dVertBillboard";
bool _ALAMO_TANGENT_SPACE = false;
bool _ALAMO_Z_SORT = false;
bool _ALAMO_BILLBOARDS = true;
>;

#define PGSL_PS_INPUT_billboard_bump PGSL_VS_OUTPUT_billboard_bump



/////////////////////////////////////////////////////////////////////
//VERTEX SHADER INPUTS
/////////////////////////////////////////////////////////////////////
struct PGSL_VS_INPUT_billboard_bump
{
	float3 Pos  : PGSL_POSITION;
	PGSL_PACKED_FLOAT4 Normal  : PGSL_NORMAL;
	PGSL_PACKED_FLOAT2 BaseTexUV  : PGSL_TEXCOORD0;
	float3 BillboardCenter  : PGSL_TEXCOORD1;
};



/////////////////////////////////////////////////////////////////////
//VERTEX SHADER OUTPUTS
/////////////////////////////////////////////////////////////////////
struct PGSL_VS_OUTPUT_billboard_bump
{
	float4 Pos  : PGSL_SV_POSITION;
	float2 BaseTexUV  : PGSL_TEXCOORD0;
	float4 FowCloudTexcoords  : PGSL_TEXCOORD1;
	float4 Diffuse  : PGSL_TEXCOORD2;
	float3 LightVec  : PGSL_TEXCOORD3;
	float3 HalfVec  : PGSL_TEXCOORD4;
	float Fog  : PGSL_TEXCOORD5;
};



/////////////////////////////////////////////////////////////////////
//VERTEX SHADER SHARED STRUCT
/////////////////////////////////////////////////////////////////////
struct PGSL_VS_SHARED_billboard_bump
{
	float4x4 World;
	float4 Pos;
	float3 Normal;
	float2 BaseTexUV;
	float4 SurfaceDiffuse;
	float3 SurfaceSpecular;
	float4 WorldPos;
	float3 LightDiffuse;
	float3 Diffuse;
	float3 Tangent;
	float3 Bitangent;
};



/////////////////////////////////////////////////////////////////////
//VERTEX SHADERS
/////////////////////////////////////////////////////////////////////


void pre_vs_world_PART(inout PGSL_VS_INPUT_billboard_bump input, inout PGSL_VS_OUTPUT_billboard_bump output, inout PGSL_VS_SHARED_billboard_bump shared_vars)
{
	shared_vars.World = g_World;
}



void pre_vs_position_PART(inout PGSL_VS_INPUT_billboard_bump input, inout PGSL_VS_OUTPUT_billboard_bump output, inout PGSL_VS_SHARED_billboard_bump shared_vars)
{
	shared_vars.Pos = float4(input.Pos.xyz, 1.0);
}



void pre_vs_unpack_normal_PART(inout PGSL_VS_INPUT_billboard_bump input, inout PGSL_VS_OUTPUT_billboard_bump output, inout PGSL_VS_SHARED_billboard_bump shared_vars)
{
	shared_vars.Normal.xyz = Unpack_Normal(input.Normal.xyz);
}



void pre_vs_unpack_base_uv_PART(inout PGSL_VS_INPUT_billboard_bump input, inout PGSL_VS_OUTPUT_billboard_bump output, inout PGSL_VS_SHARED_billboard_bump shared_vars)
{
	shared_vars.BaseTexUV = Unpack_UV(input.BaseTexUV);
}



void vs_identity_surface_material_PART(in PGSL_VS_INPUT_billboard_bump input, inout PGSL_VS_OUTPUT_billboard_bump output, inout PGSL_VS_SHARED_billboard_bump shared_vars)
{
	shared_vars.SurfaceDiffuse = float4(1, 1, 1, 1);
	shared_vars.SurfaceSpecular = float3(1, 1, 1);
}

#if defined(PGSL_MAX)
#define DO_GEOMETRY_MODS 0
#else
#define DO_GEOMETRY_MODS 1
#endif

void vs_billboard_PART(in PGSL_VS_INPUT_billboard_bump input, inout PGSL_VS_OUTPUT_billboard_bump output, inout PGSL_VS_SHARED_billboard_bump shared_vars)
{
#if DO_GEOMETRY_MODS
	//transform the billboard center to world space
	float3 bb_center_world = mul(float4(input.BillboardCenter, 1), shared_vars.World).xyz;
	
	/////////////////////////////////////////////////////////
	//Compute billboard transform
	//'up' is camera z vector
	//'normal' is camera y vector
	/////////////////////////////////////////////////////////
	//bb_tm, takes points from "billboard space" to "world space" 
	//position = billboard_center, axes aligned to make the -Y axis point at the camera (per Max convention for "forward")
	float4x4 bb_tm = float4x4(g_ViewInv[0], g_ViewInv[2], g_ViewInv[1], float4(bb_center_world, 1));
	
	/////////////////////////////////////////////////////////
	//Billboard and distort the geometry
	//- offset each clump to match the tree shader bending
	//- billboard each clump to face camera
	//- 2d rotate/sway each clump for wind effect
	/////////////////////////////////////////////////////////
	
	float3 bb_vert = shared_vars.Pos.xyz - input.BillboardCenter;
	float4 world_pos = mul(float4(bb_vert, 1), bb_tm);
	output.Pos = mul(world_pos, g_ViewProj);
	
	//save world pos
	shared_vars.WorldPos = world_pos;
	
	//Thanh - 03/04/2009 billboard is a special case of a
	//part that does vertex transformation but doesn't save
	//off the billboard/world transform since subsequent
	//parts actually want the global world transform
	//save world xform
	//shared_vars.World = bb_tm;
#else
	float4 world_pos = mul(shared_vars.Pos, shared_vars.World);
	output.Pos = mul(shared_vars.Pos, g_WorldViewProj);
	
	//save world pos
	shared_vars.WorldPos = world_pos;
#endif
}



void vs_base_uv_PART(in PGSL_VS_INPUT_billboard_bump input, inout PGSL_VS_OUTPUT_billboard_bump output, inout PGSL_VS_SHARED_billboard_bump shared_vars)
{
	output.BaseTexUV = shared_vars.BaseTexUV;
}



void vs_fow_uv_PART(in PGSL_VS_INPUT_billboard_bump input, inout PGSL_VS_OUTPUT_billboard_bump output, inout PGSL_VS_SHARED_billboard_bump shared_vars)
{
	output.FowCloudTexcoords.x = dot(g_FowTexU, shared_vars.WorldPos);
	output.FowCloudTexcoords.y = dot(g_FowTexV, shared_vars.WorldPos);
}



void vs_sph_lighting_fill_PART(in PGSL_VS_INPUT_billboard_bump input, inout PGSL_VS_OUTPUT_billboard_bump output, inout PGSL_VS_SHARED_billboard_bump shared_vars)
{
	float3 world_normal = normalize(mul(shared_vars.Normal, (float3x3)shared_vars.World));
	shared_vars.LightDiffuse.rgb += Sph_Compute_Diffuse_Light_Fill(world_normal);
}



void vs_compose_lighting_diffuse_PART(in PGSL_VS_INPUT_billboard_bump input, inout PGSL_VS_OUTPUT_billboard_bump output, inout PGSL_VS_SHARED_billboard_bump shared_vars)
{
	//do lighting: diffuse only
	shared_vars.Diffuse = shared_vars.LightDiffuse*shared_vars.SurfaceDiffuse.rgb;
	output.Diffuse.rgb = shared_vars.Diffuse.rgb;
	output.Diffuse.a = shared_vars.SurfaceDiffuse.a;
}



void vs_billboard_tangent_space_PART(in PGSL_VS_INPUT_billboard_bump input, inout PGSL_VS_OUTPUT_billboard_bump output, inout PGSL_VS_SHARED_billboard_bump shared_vars)
{
	shared_vars.Tangent = g_ViewInv[0].xyz;
	shared_vars.Bitangent = g_ViewInv[1].xyz;
	shared_vars.Normal = g_ViewInv[2].xyz;
}



void vs_bump_PART(in PGSL_VS_INPUT_billboard_bump input, inout PGSL_VS_OUTPUT_billboard_bump output, inout PGSL_VS_SHARED_billboard_bump shared_vars)
{
	float3x3 xform = (float3x3)shared_vars.World;
	//transform tangent, bitangent and normal into world space
	float3 T = normalize(mul(shared_vars.Tangent, xform));
	float3 B = normalize(mul(shared_vars.Bitangent, xform));
	float3 N = normalize(mul(shared_vars.Normal, xform));

	//compute tangent space light vec and half vec
	float3 light_vec = g_Light0Vec.xyz;
	output.LightVec = Compute_Light_Vector(light_vec, T, B, N);
	output.LightVec = normalize(output.LightVec);
	
	output.HalfVec = Compute_Half_Vector(shared_vars.WorldPos.xyz, g_EyePos.xyz, light_vec, T, B, N);
	output.HalfVec = normalize(output.HalfVec);
}



void vs_fog_PART(in PGSL_VS_INPUT_billboard_bump input, inout PGSL_VS_OUTPUT_billboard_bump output, inout PGSL_VS_SHARED_billboard_bump shared_vars)
{
	float fog = length(output.Pos.xyz);
	output.Fog = saturate(g_FogValues.x*fog + g_FogValues.y);
}

PGSL_VS_OUTPUT_billboard_bump pass_vs_PGSL_VS_MAIN_billboard_bump(PGSL_VS_INPUT_billboard_bump meta_shader_in)
{
	PGSL_VS_OUTPUT_billboard_bump meta_shader_out = (PGSL_VS_OUTPUT_billboard_bump)0;
	PGSL_VS_SHARED_billboard_bump meta_shader_shared = (PGSL_VS_SHARED_billboard_bump)0;
	pre_vs_world_PART(meta_shader_in, meta_shader_out, meta_shader_shared);
	pre_vs_position_PART(meta_shader_in, meta_shader_out, meta_shader_shared);
	pre_vs_unpack_normal_PART(meta_shader_in, meta_shader_out, meta_shader_shared);
	pre_vs_unpack_base_uv_PART(meta_shader_in, meta_shader_out, meta_shader_shared);
	vs_identity_surface_material_PART(meta_shader_in, meta_shader_out, meta_shader_shared);
	vs_billboard_PART(meta_shader_in, meta_shader_out, meta_shader_shared);
	vs_base_uv_PART(meta_shader_in, meta_shader_out, meta_shader_shared);
	vs_fow_uv_PART(meta_shader_in, meta_shader_out, meta_shader_shared);
	vs_sph_lighting_fill_PART(meta_shader_in, meta_shader_out, meta_shader_shared);
	vs_compose_lighting_diffuse_PART(meta_shader_in, meta_shader_out, meta_shader_shared);
	vs_billboard_tangent_space_PART(meta_shader_in, meta_shader_out, meta_shader_shared);
	vs_bump_PART(meta_shader_in, meta_shader_out, meta_shader_shared);
	vs_fog_PART(meta_shader_in, meta_shader_out, meta_shader_shared);
	return meta_shader_out;
}















/////////////////////////////////////////////////////////////////////
//PIXEL SHADER INPUTS
/////////////////////////////////////////////////////////////////////
float4 Diffuse
<
string UIName = "Diffuse";
string UIType = "ColorSwatch";
bool GammaCorrect = true;
>
 = {1.0, 1.0, 1.0, 1.0};

float4 Specular
<
string UIName = "Specular";
string UIType = "ColorSwatch";
bool GammaCorrect = true;
>
 = {1.0, 1.0, 1.0, 1.0};

PGSL_TEXTURE2D BaseTexture  : DIFFUSEMAP
<
string UIName = "BaseTexture";
string UIType = "bitmap";
string SamplerEnum = "AL_SAMPLER_UVWRAP_MIN_MAG_MIP_BILINEAR_SRGB";
>
;
PGSL_SAMPLER BaseTextureSampler PGSL_SAMPLER_REG(0)
<
string UIName = "BaseTexture";
string UIType = "bitmap";
string SamplerEnum = "AL_SAMPLER_UVWRAP_MIN_MAG_MIP_BILINEAR_SRGB";
PGSL_BIND_TO_TEXTURE(BaseTexture)
string SamplerRegister = "0";
>
PGSL_SAMPLER_STATE(BaseTexture);

PGSL_TEXTURE2D NormalTexture  : NORMALMAP
<
string UIName = "NormalTexture";
string UIType = "bitmap";
string SamplerEnum = "AL_SAMPLER_UVWRAP_MIN_MAG_MIP_BILINEAR";
bool DiscardableBump = true;
>
;
PGSL_SAMPLER NormalTextureSampler PGSL_SAMPLER_REG(1)
<
string UIName = "NormalTexture";
string UIType = "bitmap";
string SamplerEnum = "AL_SAMPLER_UVWRAP_MIN_MAG_MIP_BILINEAR";
bool DiscardableBump = true;
PGSL_BIND_TO_TEXTURE(NormalTexture)
string SamplerRegister = "1";
>
PGSL_SAMPLER_STATE(NormalTexture);

PGSL_TEXTURE2D FowTexture
<
string SamplerEnum = "AL_SAMPLER_UVCLAMP_MIN_MAG_MIP_BILINEAR_SRGB";
>
;
PGSL_SAMPLER FowTextureSampler PGSL_SAMPLER_REG(2)
<
string SamplerEnum = "AL_SAMPLER_UVCLAMP_MIN_MAG_MIP_BILINEAR_SRGB";
PGSL_BIND_TO_TEXTURE(FowTexture)
string SamplerRegister = "2";
>
PGSL_SAMPLER_STATE(FowTexture);




/////////////////////////////////////////////////////////////////////
//PIXEL SHADER OUTPUTS
/////////////////////////////////////////////////////////////////////
struct PGSL_PS_OUTPUT_billboard_bump
{
	float4 Color0  : PGSL_TARGET0;
};



/////////////////////////////////////////////////////////////////////
//PIXEL SHADER SHARED STRUCT
/////////////////////////////////////////////////////////////////////
struct PGSL_PS_SHARED_billboard_bump
{
	float2 BaseTexUV;
	float2 BumpTexUV;
	float4 SurfaceDiffuse;
	float3 SurfaceSpecular;
	float4 Albedo;
	float4 Normal;
	float SpecColor;
	float3 HalfVec;
	float3 LightVec;
	float3 LightDiffuse;
	float NDotL;
	float3 LightSpecular;
	float3 Diffuse;
	float3 Specular;
	float3 Emissive;
	float3 Reflection;
};



/////////////////////////////////////////////////////////////////////
//PIXEL SHADERS
/////////////////////////////////////////////////////////////////////


void pre_ps_base_uv_PART(inout PGSL_PS_INPUT_billboard_bump input, inout PGSL_PS_OUTPUT_billboard_bump output, inout PGSL_PS_SHARED_billboard_bump shared_vars)
{
	shared_vars.BaseTexUV = input.BaseTexUV;
}



void pre_ps_bump_uv_from_base_uv_PART(inout PGSL_PS_INPUT_billboard_bump input, inout PGSL_PS_OUTPUT_billboard_bump output, inout PGSL_PS_SHARED_billboard_bump shared_vars)
{
	shared_vars.BumpTexUV = input.BaseTexUV;
}



void ps_surface_material_PART(in PGSL_PS_INPUT_billboard_bump input, inout PGSL_PS_OUTPUT_billboard_bump output, inout PGSL_PS_SHARED_billboard_bump shared_vars)
{
	shared_vars.SurfaceDiffuse = Diffuse;
	shared_vars.SurfaceSpecular = Specular.rgb;
}



void ps_base_texture_PART(in PGSL_PS_INPUT_billboard_bump input, inout PGSL_PS_OUTPUT_billboard_bump output, inout PGSL_PS_SHARED_billboard_bump shared_vars)
{
	shared_vars.Albedo = PGSL_TEX2D(BaseTexture, BaseTextureSampler, shared_vars.BaseTexUV);
	shared_vars.SurfaceDiffuse *= shared_vars.Albedo;
}



void ps_bump_specular_map_PART(in PGSL_PS_INPUT_billboard_bump input, inout PGSL_PS_OUTPUT_billboard_bump output, inout PGSL_PS_SHARED_billboard_bump shared_vars)
{
	//Thanh - 02/09/2010 fetching normal map with bi-linear filtering
	//actually implies that we need to re-normalize our normal
	//but we are not seeing notice-able artifacts from not normalizing it
	//so we can dodge the bullet and save us a bit of time here!
	//fetch normal from bump map
	float4 normal_texel = PGSL_TEX2D(NormalTexture, NormalTextureSampler, shared_vars.BumpTexUV);
	//scale to [-1, 1]
	shared_vars.Normal.xyz = (normal_texel.rgb - 0.5)*2.0;

	//alpha channel of normal texel is the specular map factor
	shared_vars.SpecColor *= normal_texel.a;
}



void ps_phong_vectors_bump_PART(in PGSL_PS_INPUT_billboard_bump input, inout PGSL_PS_OUTPUT_billboard_bump output, inout PGSL_PS_SHARED_billboard_bump shared_vars)
{
	shared_vars.LightVec = normalize(input.LightVec);
	shared_vars.HalfVec = normalize(input.HalfVec);
}



void ps_phong_diffuse_PART(in PGSL_PS_INPUT_billboard_bump input, inout PGSL_PS_OUTPUT_billboard_bump output, inout PGSL_PS_SHARED_billboard_bump shared_vars)
{
	shared_vars.NDotL = dot(shared_vars.Normal.xyz, shared_vars.LightVec);
	shared_vars.LightDiffuse.rgb += saturate(shared_vars.NDotL)*g_Light0Diffuse.rgb;
}



void ps_vertex_diffuse_PART(in PGSL_PS_INPUT_billboard_bump input, inout PGSL_PS_OUTPUT_billboard_bump output, inout PGSL_PS_SHARED_billboard_bump shared_vars)
{
	shared_vars.LightDiffuse.rgb += input.Diffuse.rgb;
}



void ps_phong_specular_PART(in PGSL_PS_INPUT_billboard_bump input, inout PGSL_PS_OUTPUT_billboard_bump output, inout PGSL_PS_SHARED_billboard_bump shared_vars)
{
	float ndoth = saturate(dot(shared_vars.Normal.xyz, shared_vars.HalfVec));
	shared_vars.LightSpecular += g_Light0Specular.rgb*pow(ndoth, SpecularPower);
}



void ps_lightscale_PART(in PGSL_PS_INPUT_billboard_bump input, inout PGSL_PS_OUTPUT_billboard_bump output, inout PGSL_PS_SHARED_billboard_bump shared_vars)
{
	shared_vars.LightDiffuse.rgb *= g_LightScale.rgb;
	shared_vars.SurfaceDiffuse.a *= g_LightScale.a;
}



void ps_compose_lighting_PART(in PGSL_PS_INPUT_billboard_bump input, inout PGSL_PS_OUTPUT_billboard_bump output, inout PGSL_PS_SHARED_billboard_bump shared_vars)
{
	shared_vars.Diffuse = shared_vars.SurfaceDiffuse.rgb*shared_vars.LightDiffuse;
	shared_vars.Specular = shared_vars.SurfaceSpecular*shared_vars.LightSpecular;
	output.Color0.rgb = shared_vars.Diffuse.rgb + shared_vars.Specular.rgb + shared_vars.Emissive.rgb + shared_vars.Reflection.rgb;
	output.Color0.a = shared_vars.SurfaceDiffuse.a;

	//output.Color0.rgb = shared_vars.Specular.rgb + shared_vars.Diffuse.rgb;
	//output.Color0.rgb = shared_vars.Diffuse.rgb;
	//output.Color0.rgb = shared_vars.Diffuse.rgb;
	//output.Color0.rgb = shared_vars.LightSpecular.rgb;
	//output.Color0.rgb = shared_vars.Reflection.rgb;
	//output.Color0.rgb = float3(shared_vars.SpecGloss,shared_vars.SpecGloss,shared_vars.SpecGloss);
}



void ps_fow_PART(in PGSL_PS_INPUT_billboard_bump input, inout PGSL_PS_OUTPUT_billboard_bump output, inout PGSL_PS_SHARED_billboard_bump shared_vars)
 {
#if !defined(PGSL_MAX)
	
	 float4 fow_texel = PGSL_TEX2D(FowTexture, FowTextureSampler, input.FowCloudTexcoords.xy);
	 float lum = dot(output.Color0.rgb, LumVec);
	 output.Color0.rgb = lerp(fow_texel.rgb*lum.xxx, output.Color0.rgb, fow_texel.a);
	
#endif
 }



void ps_fow_cheap_PART(in PGSL_PS_INPUT_billboard_bump input, inout PGSL_PS_OUTPUT_billboard_bump output, inout PGSL_PS_SHARED_billboard_bump shared_vars)
 {
#if !defined(PGSL_MAX)
	 float4 fow_texel = PGSL_TEX2D(FowTexture, FowTextureSampler, input.FowCloudTexcoords.xy);
	 output.Color0.rgb *= fow_texel.rgb;
#endif
 }



void ps_fog_PART(in PGSL_PS_INPUT_billboard_bump input, inout PGSL_PS_OUTPUT_billboard_bump output, inout PGSL_PS_SHARED_billboard_bump shared_vars)
{
	output.Color0.rgb = lerp(g_FogColor.rgb, output.Color0.rgb, input.Fog);
}

#undef DYNAMIC_ALPHA_TEST_REF_VALUE
#define DYNAMIC_ALPHA_TEST_REF_VALUE 160 


void ps_alpha_test_greater_PART(in PGSL_PS_INPUT_billboard_bump input, inout PGSL_PS_OUTPUT_billboard_bump output, inout PGSL_PS_SHARED_billboard_bump shared_vars)
{
	output.Color0 = Do_Alpha_Test(output.Color0, DYNAMIC_ALPHA_TEST_REF_VALUE, ALPHA_TEST_COMP_FUNC_GREATER);
}

PGSL_PS_OUTPUT_billboard_bump pass_ps_PGSL_PS_MAIN_billboard_bump(PGSL_PS_INPUT_billboard_bump meta_shader_in)
{
	PGSL_PS_OUTPUT_billboard_bump meta_shader_out = (PGSL_PS_OUTPUT_billboard_bump)0;
	PGSL_PS_SHARED_billboard_bump meta_shader_shared = (PGSL_PS_SHARED_billboard_bump)0;
	pre_ps_base_uv_PART(meta_shader_in, meta_shader_out, meta_shader_shared);
	pre_ps_bump_uv_from_base_uv_PART(meta_shader_in, meta_shader_out, meta_shader_shared);
	ps_surface_material_PART(meta_shader_in, meta_shader_out, meta_shader_shared);
	ps_base_texture_PART(meta_shader_in, meta_shader_out, meta_shader_shared);
	ps_bump_specular_map_PART(meta_shader_in, meta_shader_out, meta_shader_shared);
	ps_phong_vectors_bump_PART(meta_shader_in, meta_shader_out, meta_shader_shared);
	ps_phong_diffuse_PART(meta_shader_in, meta_shader_out, meta_shader_shared);
	ps_vertex_diffuse_PART(meta_shader_in, meta_shader_out, meta_shader_shared);
	ps_phong_specular_PART(meta_shader_in, meta_shader_out, meta_shader_shared);
	ps_lightscale_PART(meta_shader_in, meta_shader_out, meta_shader_shared);
	ps_compose_lighting_PART(meta_shader_in, meta_shader_out, meta_shader_shared);
	ps_fow_PART(meta_shader_in, meta_shader_out, meta_shader_shared);
	ps_fow_cheap_PART(meta_shader_in, meta_shader_out, meta_shader_shared);
	ps_fog_PART(meta_shader_in, meta_shader_out, meta_shader_shared);
	ps_alpha_test_greater_PART(meta_shader_in, meta_shader_out, meta_shader_shared);
	return meta_shader_out;
}



/////////////////////////////////////////////////////////////////////
//SHADER'S PASSES
/////////////////////////////////////////////////////////////////////
PGSL_TECHNIQUE_BEGIN
	PGSL_PASS_BEGIN(pass_0, 
	<
		string _RasterizeState_ = "ALRS_DEFAULT";string _BlendState_ = "ALBS_ALPHA_TEST_GREATER";string _AlphaTestRefValue_ = "160";string _DepthStencilState_ = "ALDS_DEPTHLESSEQUALWRITE_STENCILDISABLE";
	>)
		PGSL_PASS_VS(pass_vs_PGSL_VS_MAIN_billboard_bump, 0)
		PGSL_PASS_PS(pass_ps_PGSL_PS_MAIN_billboard_bump, 0)
	PGSL_PASS_END
PGSL_TECHNIQUE_END



