if (LuaGlobalCommandLinks) == nil then
	LuaGlobalCommandLinks = {}
end
LuaGlobalCommandLinks[117] = true
LUA_PREP = true

--/////////////////////////////////////////////////////////////////////////////////////////////////
--
-- (C) Petroglyph Games, Inc.
--
--
--  *****           **                          *                   *
--  *   **          *                           *                   *
--  *    *          *                           *                   *
--  *    *          *     *                 *   *          *        *
--  *   *     *** ******  * **  ****      ***   * *      * *****    * ***
--  *  **    *  *   *     **   *   **   **  *   *  *    * **   **   **   *
--  ***     *****   *     *   *     *  *    *   *  *   **  *    *   *    *
--  *       *       *     *   *     *  *    *   *   *  *   *    *   *    *
--  *       *       *     *   *     *  *    *   *   * **   *   *    *    *
--  *       **       *    *   **   *   **   *   *    **    *  *     *   *
-- **        ****     **  *    ****     *****   *    **    ***      *   *
--                                          *        *     *
--                                          *        *     *
--                                          *       *      *
--                                      *  *        *      *
--                                      ****       *       *
--
--/////////////////////////////////////////////////////////////////////////////////////////////////
-- C O N F I D E N T I A L   S O U R C E   C O D E -- D O   N O T   D I S T R I B U T E
--/////////////////////////////////////////////////////////////////////////////////////////////////
--
--              File: //depot/Projects/Invasion_360/Run/Data/Scripts/GUI/Gamepad_Radial_Control_Groups.lua
--
--    Original Author: Maria Teruel
--
--          Date: 2007/08/29
--
--/////////////////////////////////////////////////////////////////////////////////////////////////

require("PGBase")
require("PGUICommands")

-- ----------------------------------------------------------------------------------------------------------
-- On_Init
-- NOTE: this is register on Component initialized (from the Editor)
-- ----------------------------------------------------------------------------------------------------------
function On_Init()
	
	ControlGroupIconSourceList = {}
	ControlGrouUsedList = {}
	
	ButtonsList = {}
	ButtonsList = Find_GUI_Components(this, "button_")
	
	-- Each button needs to know its index!.
	for index = 1, #ButtonsList do
		local button = ButtonsList[index]
		if TestValid(button) then 
			this.Register_Event_Handler("Animation_Finished", button, On_Animation_Finished)
			if index == 1 then 
				MainButton = button
			end
		end
	end
	
	-- the scene is set so that initially button_1 is in the front.
	-- RECALL: the Spin animation spins to the left, hence, 1->2->3 .... 11->1
	FrontButtonIndex = 1
	
	-- Hide the scene (this is shown only on demand)
	this.Set_Hidden(true)
	
	Visible = false
	
	-- this is used to keep track of the icons design wants to flash for the tutorials.
	ControlGroupIconsToFlash = {}
	
	IsAnimating = false
	AnimationsQueue = {}
	HighlightedIndex = -1

	CGIndexToTexture = {}
	CGIndexList = nil
	
	UpdateButtons = true
	
	CG_TRAVERSE_NONE = Declare_Enum(-1)
	CG_TRAVERSE_LEFT = Declare_Enum(0)
	CG_TRAVERSE_RIGHT = Declare_Enum(1)
end



-- ---------------------------------------------------------------------------
-- On_Animation_Finished
-- ---------------------------------------------------------------------------
function On_Animation_Finished(_, source)
	
	-- NOTE: the button can be flashing independently and
	-- that will trigger a whole lot of Animation Finished events 
	-- (in fact, it is a looping animation).
	-- Hence we only care about the event if it is generated by
	-- the spin animation.
	if not IsAnimating then
		return
	end
	
	if not CurrMoveFlags then
		return
	end
	
	IsAnimating = false
	this.Stop_Animation()
	if CurrMoveFlags.Right then
		-- Play animation -> Swap texture (on anim finished)
		Swap_Textures()
	end
	
	-- If necessay, start the next animation.
	Update_Animations()	
end


-- ---------------------------------------------------------------------------
-- Set_Quad_Texture_Source
-- For this DEMO we know we will have all 11 automated control
-- groups from the beginning and all throughout the game!
-- so this implementation is temporary and for demo purposes
-- only.
-- ---------------------------------------------------------------------------
function Set_Quad_Texture_Source(quad_textures)

	--if TexturesList then
	if CGIndexList then
		return
	end
	
	CGIndexList = {}
	CGIndexToTexture = {}
	local button_idx = 1
	for i = 1, #quad_textures do
		local texture = quad_textures[i]
		
		if texture ~= "" then
			local button = ButtonsList[button_idx]
			if TestValid(button) then
				-- 0 based (code) to 1 based (lua) arrays 
				local cg_idx = (i-1)
				button.Set_User_Data(cg_idx)
				button.Set_Texture(texture)
				-- Update the list of textures!.
				-- RECALL: the index is the control group index
				-- and for it to match code it has to be decreased by one!.
				table.insert(CGIndexList, cg_idx)
			
				if button_idx == 1 then 
					HighlightedIndex = cg_idx
				end
				
				CGIndexToTexture[cg_idx] = texture
				
				-- advance the button index.
				button_idx = button_idx + 1
			end
		end
	end	
end

-- ---------------------------------------------------------------------------
-- Set_Control_Group_Selected
-- ---------------------------------------------------------------------------
function Set_Control_Group_Selected(highlighted_num, min_ctrlgrp_idx, selected_num, reset_flash_state, traversal_dir, lead_object)
	
	local move_flags = {}
	if RefreshTextures then
		-- if the highlighted value coming in is different from the highlighted value in the first button, 
		-- we have to reset the ordering of the control groups so that they match the input state.
		if HighlightedIndex ~= highlighted_num then
			Reset_CG_Ordering(highlighted_num)
		end
		RefreshTextures = false
	end

	-- set the traversal direction
	if traversal_dir == CG_TRAVERSE_LEFT then
		move_flags.Left = true
	elseif  traversal_dir == CG_TRAVERSE_RIGHT then
		move_flags.Right = true
	end
	
	LeadObject = lead_object
	
	-- queue this animation only if the order comes from a traverse command and not
	-- because we have just selected a control group
	if traversal_dir ~=  CG_TRAVERSE_NONE then
		-- since we remove from the tail, always add at the front of the list.
		table.insert(AnimationsQueue, 1, move_flags)
	elseif TestValid(MainButton) then
		MainButton.Display_A_Button_Layer(true)
	end
	
	Update_Animations(reset_flash_state, highlighted_num)	
end


-- ---------------------------------------------------------------------------
-- Update_Animations
-- ---------------------------------------------------------------------------
function Update_Animations(reset_flash_state, highlighted_num)
	if not IsAnimating then
		-- do we have something to play?
		local num_anims = #AnimationsQueue
		if AnimationsQueue and num_anims > 0 then
			-- get the next animation to play (which is the last one)
			local move_flags = AnimationsQueue[num_anims]
			if move_flags then
				CurrMoveFlags = move_flags
				if CurrMoveFlags.Left then
					-- Swap textures -> play animation
					if Swap_Textures() == true then
						-- there may be independent animations playing, so let's make sure we stop them all
						this.Stop_Animation()
						this.Play_Animation_Backwards("spin", false)	
						IsAnimating = true
						-- remove it from the list
						table.remove(AnimationsQueue, num_anims)
					end					
				elseif CurrMoveFlags.Right then
					-- there may be independent animations playing, so let's make sure we stop them all
					this.Stop_Animation()
					
					-- Play animation -> Swap texture (on anim finished)					
					this.Play_Animation("spin", false)	
					IsAnimating = true
					-- remove it from the list!
					table.remove(AnimationsQueue, num_anims)
				end	
			end
		end		
	end
	
	if TestValid(MainButton) then
		MainButton.Display_A_Button_Layer(not IsAnimating)
	end
	
	if not IsAnimating then
		if TestValid(LeadObject) then 
			local tooltip_data = {'object', {LeadObject}}
			Get_Game_Mode_GUI_Scene().Raise_Event_Immediate("Controller_Display_Tooltip_From_UI", nil, {tooltip_data})
		end
		
		Refresh_Display(reset_flash_state, highlighted_num)
	else
		Get_Game_Mode_GUI_Scene().Raise_Event_Immediate("End_Tooltip", nil, {})
	end
end


-- ---------------------------------------------------------------------------
-- Swap_Textures
-- ---------------------------------------------------------------------------
function Swap_Textures()
	-- From the data in CurrMoveFlags we know whether to swap 
	-- them to the righ or to the left.
	if not CurrMoveFlags then
		return false
	end
	
	if CurrMoveFlags.Left then
		return Swap_Left()
	elseif CurrMoveFlags.Right then
		return Swap_Right()
	else
		return false
	end	
end


-- ---------------------------------------------------------------------------
-- Swap_Left
-- ---------------------------------------------------------------------------
function Swap_Left()
	-- We need to take the end of the array and put it 
	-- at the front (this will automatically shift all the 
	-- elements
	--if not TexturesList then
	if not CGIndexList then 
		return false
	end
	
	local num_cgs = #CGIndexList	
	local last_cg = CGIndexList[num_cgs]
	-- remove it from the tail
	table.remove(CGIndexList, num_cgs)
	-- add it to the front
	table.insert(CGIndexList, 1, last_cg)
	
	if num_cgs > #ButtonsList then 
		MessageBox("Not enough buttons for all the control group textures!!!!")
	end
	
	Refresh_Buttons()
	
	-- we are done!
	return true
end

-- ---------------------------------------------------------------------------
-- Swap_Right
-- ---------------------------------------------------------------------------
function Swap_Right(stop_at)
	-- Remove the head and add it to the tail!
	--if not TexturesList then
	if not CGIndexList then
		return false
	end
	
	local num_cgs = #CGIndexList	
	if num_cgs <= 1 then
		-- nothing to do
		return true
	end
	
	local first_cg = CGIndexList[1]
	
	if not stop_at or stop_at ~= first_cg then
		-- remove it from the head
		table.remove(CGIndexList, 1)
		-- add it to the tail
		table.insert(CGIndexList, first_cg)
	else
		return false
	end
	
	if not stop_at then
		Refresh_Buttons()
	end
	
	-- we are done!
	return true
end

-- ---------------------------------------------------------------------------
-- Reset_CG_Ordering
-- ---------------------------------------------------------------------------
function Reset_CG_Ordering(highlighted_num)
	-- we have to move the CG in the list until the specified CG index
	-- is at the front.
	-- NOTE: We should do this in a more efficient way by determining
	-- which way to swap in order to get to it faster, however, since this is
	-- only a mock up we just swap in one direction only.
	local continue_swapping = true
	while(continue_swapping) do
		continue_swapping = Swap_Right(highlighted_num)	
	end
	
	Refresh_Buttons()
end

-- ---------------------------------------------------------------------------
-- Refresh_Buttons
-- ---------------------------------------------------------------------------
function Refresh_Buttons()

	--if not TexturesList then
	if not CGIndexList then
		return
	end
	
	local num_cgs = #CGIndexList	
	
	if num_cgs > #ButtonsList then 
		MessageBox("Not enough buttons for all the control group textures!!!!")
	end

	-- Now refresh the buttons data.
	local bttn_idx = 1
	for idx = 1, num_cgs do
		local cg_idx = CGIndexList[idx]
		local texture = CGIndexToTexture[cg_idx]
		if texture and texture ~= "" then
			local button = ButtonsList[bttn_idx]
			if TestValid(button) then
				button.Set_Hidden(false)
				button.Set_Texture(texture)
				button.Set_User_Data(cg_idx)
				if bttn_idx == 1 then
					HighlightedIndex = cg_idx
				end
				-- advance the button index.
				bttn_idx = bttn_idx + 1
			end
		end
	end
	
	for i = bttn_idx, #ButtonsList do
		local button = ButtonsList[i]
		if TestValid(button) then
			button.Set_Hidden(true)
			button.Set_User_Data(-1)
		end
	end	
end

-- ---------------------------------------------------------------------------
-- Set_Visible
-- ---------------------------------------------------------------------------
function Set_Visible(on_off)
	if Visible == on_off then
		return
	end
	
	this.Set_Hidden(not on_off)
	Visible = on_off
	
	if not Visible then
		Get_Game_Mode_GUI_Scene().Raise_Event_Immediate("End_Tooltip", nil, {})
	else
		RefreshTextures = true
	end
end

-- ---------------------------------------------------------------------------
-- Flash_Control_Group_Icon
-- ---------------------------------------------------------------------------
function Flash_Control_Group_Icon(cg_index)
	ControlGroupIconsToFlash[cg_index] = true
	
	if Visible then
		-- Refresh the scene.
		Refresh_Display(false)
	end
end

-- ---------------------------------------------------------------------------
-- Refresh_Display
-- ---------------------------------------------------------------------------
function Refresh_Display(reset_flash_state, highlighted_num)
	if not highlighted_num then 
		highlighted_num = -1
	end
	
	for _, button in pairs(ButtonsList) do
		if TestValid(button) then
			local cg_idx = button.Get_User_Data()
			if cg_idx ~= -1 then
				-- update the flash state of the buttons.
				if ControlGroupIconsToFlash[cg_idx] then
					if reset_flash_state and highlighted_num == cg_idx then 
						ControlGroupIconsToFlash[cg_idx] = nil
						Stop_Flash(button)
					elseif Visible and not Is_Flashing(button) then
						Start_Flash(button)
					end
				elseif Visible then
					Stop_Flash(button)
				end
			else
				break
			end
		end
	end	
end


-- ---------------------------------------------------------------------------
-- Interface
-- ---------------------------------------------------------------------------
Interface = {}
Interface.Transverse_Gamepad_Control_Group = Transverse_Gamepad_Control_Group
Interface.Set_Quad_Texture_Source = Set_Quad_Texture_Source
Interface.Set_Control_Group_Selected = Set_Control_Group_Selected
Interface.Flash_Control_Group_Icon = Flash_Control_Group_Icon
Interface.Set_Visible = Set_Visible


function Kill_Unused_Global_Functions()
	-- Automated kill list.
	Abs = nil
	BlockOnCommand = nil
	Clamp = nil
	DebugBreak = nil
	DebugPrintTable = nil
	DesignerMessage = nil
	Dialog_Box_Common_Init = nil
	Dirty_Floor = nil
	Disable_UI_Element_Event = nil
	Enable_UI_Element_Event = nil
	Find_All_Parent_Units = nil
	GUI_Dialog_Raise_Parent = nil
	GUI_Does_Object_Have_Lua_Behavior = nil
	GUI_Pool_Free = nil
	Get_GUI_Variable = nil
	Is_Player_Of_Faction = nil
	Max = nil
	Min = nil
	OutputDebug = nil
	Raise_Event_All_Parents = nil
	Raise_Event_Immediate_All_Parents = nil
	Remove_Invalid_Objects = nil
	Safe_Set_Hidden = nil
	Show_Object_Attached_UI = nil
	Simple_Mod = nil
	Simple_Round = nil
	Sleep = nil
	Sort_Array_Of_Maps = nil
	Spawn_Dialog_Box = nil
	String_Split = nil
	SyncMessage = nil
	SyncMessageNoStack = nil
	TestCommand = nil
	Update_SA_Button_Text_Button = nil
	WaitForAnyBlock = nil
	Kill_Unused_Global_Functions = nil
end
